/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserConstant;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class FileUtil {
    public static final String FILETYPE_EXCEL = "xlsx";
    public static final String FILETYPE_ZIP = "zip";
    private static final transient Log log = FELogFactory.getInstance((String)"ui");
    private static final String DATE_FORMAT_PATTERN = "yyyyMMddHHmmss";
    private static final String DOT = ".";
    private AbstractRestService abstractRestService;
    private List<List<String>> formatDataList;
    private String title;
    private List<String> colTitle;
    private String writeFileName;
    private String strExtend;
    private String strUsrName;
    private String strChar = "UTF-8";
    private String downFileName = "ExportResult";
    private Object dataList;

    public abstract void writeFile(FileOutputStream var1) throws IOException;

    public void fileSet(String strTitle, List<String> lstColTitle, String strWriteFileName, Object datas, List<List<String>> formatDatas, AbstractRestService restService) {
        this.setTitle(strTitle);
        this.setColTitle(lstColTitle);
        this.setWriteFileName(strWriteFileName);
        this.dataList = datas;
        this.formatDataList = formatDatas;
        this.abstractRestService = restService;
    }

    public static String createFilePath(HttpServletRequest request, String filePrefix, String suffix) {
        boolean ret;
        if (VerifyUtil.isEmpty((Object)request)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_PATTERN);
        String exportExcelName = filePrefix + df.format(new Date()) + UUIDGenerator.getUUID() + DOT + suffix;
        String downloadPath = request.getSession().getServletContext().getRealPath("") + File.separator + UserConstant.FILEPATH_EXPORT_DIR;
        File file = new File(downloadPath);
        if (!file.exists() && !(ret = file.mkdir())) {
            throw new LegoCheckedException(1077951770L);
        }
        downloadPath = downloadPath + File.separator + exportExcelName;
        return downloadPath;
    }

    public void downloadNameFile(HttpServletResponse response, String fileName) {
        this.setDownFileName(fileName);
        this.downloadFile(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(HttpServletResponse response) {
        FileOutputStream outputStream = null;
        try {
            if (null == this.getWriteFileName()) {
                return;
            }
            outputStream = new FileOutputStream(this.getWriteFileName());
            this.writeFile(outputStream);
            CommonUtil.close((Closeable)outputStream);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Exception)e, (String)"downloadFileerror", (long)-1L, null);
        }
        finally {
            CommonUtil.close(outputStream);
        }
        String downloadFileName = this.getWriteFileName();
        String displayName = downloadFileName.substring(downloadFileName.lastIndexOf(File.separator) + 1, downloadFileName.length());
        this.setResponse(response, displayName);
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        File delFile = new File(downloadFileName);
        FileInputStream fileInput = null;
        try {
            int bytesRead;
            fileInput = new FileInputStream(downloadFileName);
            bis = new BufferedInputStream(fileInput);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[bis.available()];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            try {
                ExceptionUtil.rethrowException((Throwable)e, (String)"downloadFileerror", (long)-1L, null, (Log)log);
            }
            catch (Throwable throwable) {
                CommonUtil.close(fileInput);
                CommonUtil.close(bis);
                CommonUtil.close(bos);
                FileUtil.deleteFile(delFile);
                throw throwable;
            }
            CommonUtil.close((Closeable)fileInput);
            CommonUtil.close((Closeable)bis);
            CommonUtil.close(bos);
            FileUtil.deleteFile(delFile);
        }
        CommonUtil.close((Closeable)fileInput);
        CommonUtil.close((Closeable)bis);
        CommonUtil.close((Closeable)bos);
        FileUtil.deleteFile(delFile);
    }

    private void setResponse(HttpServletResponse response, String displayName) {
        response.setContentType("application/x-download");
        response.setCharacterEncoding("windows-1251");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-store, must-revalidate");
        response.addHeader("Content-Disposition", "attachment;filename=" + displayName);
    }

    public static void deleteFile(File file) {
        if (file != null && file.exists()) {
            if (file.isFile()) {
                boolean result = file.delete();
                if (!result) {
                    log.error((Object)"Delete file(%s) failed", new Object[]{file.getName()});
                }
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (File value : files = Optional.ofNullable(files).orElseGet(() -> new File[0])) {
                    FileUtil.deleteFile(value);
                }
                boolean result = file.delete();
                if (!result) {
                    log.error((Object)"Delete file(%s) error", new Object[]{file.getName()});
                }
            }
        } else {
            log.error((Object)"File is not exist");
        }
    }

    public static String getNowTime() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(date);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getColTitle() {
        if (this.colTitle == null) {
            this.colTitle = this.getColumnTitle();
        }
        return this.colTitle;
    }

    protected List<String> getColumnTitle() {
        return null;
    }

    public void setColTitle(List<String> colTitle) {
        this.colTitle = colTitle;
    }

    public String getWriteFileName() {
        return this.writeFileName;
    }

    public void setWriteFileName(String writeFileName) {
        this.writeFileName = writeFileName;
    }

    public String getStrExtend() {
        return this.strExtend;
    }

    public void setStrExtend(String strExtend) {
        this.strExtend = strExtend;
    }

    public String getStrUsrName() {
        return this.strUsrName;
    }

    public void setStrUsrName(String strUsrName) {
        this.strUsrName = strUsrName;
    }

    public String getStrChar() {
        return this.strChar;
    }

    public void setStrChar(String strChar) {
        this.strChar = strChar;
    }

    public String getDownFileName() {
        return this.downFileName;
    }

    public void setDownFileName(String downFileName) {
        this.downFileName = downFileName;
    }

    public Object getDataList() {
        return this.dataList;
    }

    public void setDataList(Object dataList) {
        this.dataList = dataList;
    }

    protected List<List<String>> getFormatDataList() {
        return this.formatDataList;
    }

    protected void setFormatDataList(List<List<String>> formatDataList) {
        this.formatDataList = formatDataList;
    }

    public AbstractRestService getAbstractRestService() {
        return this.abstractRestService;
    }

    public void setAbstractRestService(AbstractRestService abstractRestService) {
        this.abstractRestService = abstractRestService;
    }
}

