/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.cbb.util.DiscParamValidator;
import com.huawei.ism.cbb.util.StringEscapeUtil;

public final class HtmlStringConverter {
    private HtmlStringConverter() {
    }

    public static String decode(String encodedChar) {
        return StringEscapeUtil.decode((String)encodedChar);
    }

    public static String encode(String encodeChar) {
        if (null == encodeChar) {
            return "";
        }
        return encodeChar.replaceAll("\"", "&quot;").replaceAll("'", "&#39;").replaceAll("`", "&#96;").replaceAll("%", "&#37;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\\(", "&#40;").replaceAll("\\)", "&#41;").replaceAll("&lt;iframe", "").replaceAll(":", "&#58;");
    }

    public static String decodeByQuery(String encodedChar) {
        if (null == encodedChar) {
            return "";
        }
        return encodedChar.replaceAll("&quot;", "\"").replaceAll("&#39;", "'").replaceAll("&#96;", "`").replaceAll("&#37;", "%").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&#40;", "\\(").replaceAll("&#41;", "\\)").replaceAll("&#58;", ":");
    }

    public static String decodeByLength(String encodedChar) {
        return DiscParamValidator.decodeByLength((String)encodedChar);
    }

    public static String escapeFlexXml(String str) {
        if (null == str || str.trim().isEmpty()) {
            return str;
        }
        String escapedStr = str.replaceAll("<", "\u3008");
        escapedStr = escapedStr.replaceAll(">", "\u3009");
        escapedStr = escapedStr.replaceAll("\\\\", "\ufe68");
        escapedStr = escapedStr.replaceAll("\"", "\u201c");
        escapedStr = escapedStr.replaceAll("&", "\uff06");
        return escapedStr;
    }
}

