/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cxf.message.Message;

public class RequestUtil {
    private static final Log logger = LogFactory.getInstance(RequestUtil.class);
    private static final int MAX_TERMINAL_IP_LENGTH = 255;
    private static final String USER_PROXY_IP = "use.proxy.addr";

    public static String getClientIpAddress(HttpServletRequest request) {
        boolean useProxyIp = LegoConfig.getInstance((String)"../conf/catalina.properties").getBoolean(USER_PROXY_IP, Boolean.valueOf(false));
        if (!useProxyIp) {
            return RequestUtil.getQualifiedIp(request.getRemoteAddr());
        }
        String ip = request.getHeader("x-forwarded-for");
        if (VerifyUtil.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (VerifyUtil.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (VerifyUtil.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return RequestUtil.getQualifiedIp(ip);
    }

    private static String getQualifiedIp(String remoteAddr) {
        String terminalIp = RequestUtil.getLastIPFromIPStr(remoteAddr);
        if (terminalIp.length() > 255) {
            terminalIp = terminalIp.substring(0, 255);
            logger.error((Object)"Failed to get terminal ip: %s, cause the ip exceed the limit(255).", new Object[]{terminalIp});
            return terminalIp;
        }
        return terminalIp;
    }

    public static String getClientIpAddress(Message message) {
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        if (VerifyUtil.isEmpty((Object)request)) {
            return "unknown";
        }
        String ip = RequestUtil.getClientIpAddress(request);
        if (!VerifyUtil.isEmpty((String)ip) && ip.indexOf(",") != -1) {
            String[] arr = ip.split(",");
            ip = arr[arr.length - 1].trim();
        }
        return ip;
    }

    public static Locale getLocale(HttpServletRequest request) {
        if (null == request) {
            return Locale.ENGLISH;
        }
        Locale locale = null;
        HttpSession session = request.getSession(false);
        if (null != session) {
            try {
                locale = (Locale)session.getAttribute("WW_TRANS_I18N_LOCALE");
            }
            catch (IllegalStateException ex) {
                logger.error((Object)"Session already invalidated, retry to login for user, ex:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            }
        }
        if (null == locale) {
            String language = request.getParameter("rd_language");
            if ("en".equalsIgnoreCase(language)) {
                locale = Locale.ENGLISH;
            } else if ("zh_CN".equalsIgnoreCase(language)) {
                locale = Locale.SIMPLIFIED_CHINESE;
            }
        }
        if (null == locale) {
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    public static String getFirstIPFromIPStr(String ipStr) {
        if (!VerifyUtil.isEmpty((String)ipStr) && ipStr.contains(",")) {
            String[] arr = ipStr.split(",");
            ipStr = arr[0].trim();
        }
        return ipStr;
    }

    public static String getLastIPFromIPStr(String ipStr) {
        String resIp = ipStr;
        if (!VerifyUtil.isEmpty((String)ipStr) && ipStr.contains(",")) {
            String[] arr = ipStr.split(",");
            resIp = arr[arr.length - 1].trim();
        }
        return resIp;
    }
}

