/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.web.util.CommUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtil {
    private static Map<String, Map<String, String>> resMaps = new ConcurrentHashMap<String, Map<String, String>>();
    private static final Logger log = LoggerFactory.getLogger(ResourceUtil.class);
    private static ResourceUtil res = new ResourceUtil();
    private static String filterPattern = ".properties";
    private static Set<String> localParams = new HashSet<String>();

    public static ResourceUtil getInstance() {
        return res;
    }

    public String getText(String key, Locale locale) {
        if (VerifyUtil.isEmpty((String)key) || VerifyUtil.isEmpty((Object)locale)) {
            log.error("internal error, the locale or key is null !");
            return null;
        }
        this.internalFindString(locale);
        if (VerifyUtil.isEmpty(resMaps) || resMaps.get(locale.toString()) == null) {
            return key;
        }
        Map<String, String> textMap = resMaps.get(locale.toString());
        if (VerifyUtil.isEmpty((String)textMap.get(key))) {
            return key;
        }
        return textMap.get(key);
    }

    public String getText(String key, Locale locale, String[] params) {
        String value = this.getText(key, locale);
        if (value != null && !VerifyUtil.isEmpty((Object[])params)) {
            int i = 0;
            for (String param : params) {
                String str;
                String localParam;
                if (localParams.contains(param) && !VerifyUtil.isEmpty((String)(localParam = this.getText(param, locale)))) {
                    param = localParam;
                }
                if (value.indexOf(str = "{" + i + "}") != -1) {
                    value = value.replace(str, param);
                }
                ++i;
            }
        }
        return value;
    }

    private synchronized void internalFindString(Locale locale) {
        if (resMaps.get(locale.toString()) != null) {
            return;
        }
        resMaps.put(locale.toString(), new HashMap());
        try {
            File folder = new File(ResourceUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile();
            if (null != folder) {
                ResourceUtil.analysisJarProperties(folder, locale);
            }
        }
        catch (URISyntaxException e) {
            log.error("URISyntaxException read i18n file error ");
        }
        catch (IOException e) {
            log.error("IOException read i18n file error ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void analysisJarProperties(File folders, Locale locale) throws IOException {
        String dir = "en".equalsIgnoreCase(locale.toString()) ? "en" : "zh";
        Map<String, String> valueMap = resMaps.get(locale.toString());
        File folder = folders;
        File[] files = folder.listFiles();
        if (null == files) {
            log.debug("folder.listFiles() is null");
            return;
        }
        for (File fileEntry : files) {
            String entrty = fileEntry.getName();
            if (!entrty.matches("(.*?)\\.jar$")) continue;
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(fileEntry);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ResourceUtil.parsePropertiesFile(dir, valueMap, zipFile, entries);
                }
            }
            catch (Exception e) {
                log.error("Exception while parse zipFile: " + entrty);
            }
            finally {
                ResourceUtil.closeZipFile(entrty, zipFile);
            }
        }
    }

    private static void closeZipFile(String entrty, ZipFile zipFile) {
        if (null != zipFile) {
            try {
                zipFile.close();
            }
            catch (IOException e) {
                log.error("Exception while close zipFile: " + entrty);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parsePropertiesFile(String dir, Map<String, String> valueMap, ZipFile zipFile, Enumeration<? extends ZipEntry> entries) throws IOException {
        if (!entries.hasMoreElements()) {
            return;
        }
        ZipEntry entry = entries.nextElement();
        if (entry.getName().matches(".*?[\\/]" + dir + "[\\/].*?" + filterPattern + "$")) {
            InputStream stream = null;
            try {
                stream = zipFile.getInputStream(entry);
                Properties ress = new Properties();
                ress.load(stream);
                for (Map.Entry<Object, Object> resource : ress.entrySet()) {
                    Object key = resource.getKey();
                    Object value = resource.getValue();
                    valueMap.put(key != null ? key.toString() : null, value != null ? value.toString() : null);
                }
            }
            finally {
                CommUtils.closeInputStream(stream);
            }
        }
    }

    static {
        localParams.add("hypervault.local.backup");
        localParams.add("hypervault.remote.backup");
    }
}

