/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.web.filter.ParameterizedConfiguration;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UriUtil {
    private static String localRedirectURL = null;

    private UriUtil() {
    }

    public static String canonicalPath(String path) {
        if (VerifyUtil.isEmpty((String)path)) {
            return path;
        }
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "/";
        }
        path = Normalizer.normalize(path, Normalizer.Form.NFKC);
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        path = UriUtil.clearPath(path, ";");
        path = UriUtil.clearPath(path, "#");
        String[] paths = path.split("/");
        ArrayList<String> pathList = new ArrayList<String>();
        int end = paths.length - 1;
        int skip = 0;
        while (end > 0) {
            if (".".equals(paths[end])) {
                --end;
                continue;
            }
            if ("..".equals(paths[end])) {
                --end;
                ++skip;
                continue;
            }
            if (skip > 0) {
                --end;
                --skip;
                continue;
            }
            pathList.add(paths[end]);
            --end;
        }
        if (pathList.isEmpty()) {
            return "/";
        }
        end = pathList.size();
        StringBuilder buf = new StringBuilder();
        for (int i = end - 1; i >= 0; --i) {
            buf.append('/');
            buf.append((String)pathList.get(i));
        }
        return buf.toString();
    }

    private static String clearPath(String path, String state) {
        int pathEnd = path.indexOf(state);
        if (pathEnd >= 0) {
            return path.substring(0, pathEnd);
        }
        return path;
    }

    public static void writeLocalRedirect(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        UriUtil.writeRedirect(httpResponse, UriUtil.getLocalRedirectURL(httpRequest), true);
    }

    private static void writeRedirect(HttpServletResponse httpResponse, String redirect, boolean useBody) throws IOException {
        if (useBody) {
            String message = "{\"status\": 401,\"redirect\":\"" + redirect + "\"}";
            httpResponse.setHeader("Content-Type", "application/json;charset=UTF-8");
            httpResponse.getWriter().write(message);
        } else {
            httpResponse.setHeader("redirect", redirect);
        }
    }

    private static String getLocalRedirectURL(HttpServletRequest httpRequest) {
        if (localRedirectURL != null) {
            return localRedirectURL;
        }
        ServletContext context = httpRequest.getServletContext();
        ServletContext proxyContext = ParameterizedConfiguration.get(context).getProxy();
        String serverName = proxyContext.getInitParameter("serverName");
        if (VerifyUtil.isEmpty((String)serverName)) {
            throw new LegoCheckedException(1073947393L);
        }
        localRedirectURL = UriUtil.constructURL(serverName, "src/login/view/login.html");
        return localRedirectURL;
    }

    public static String constructURL(String prefix, String suffix) {
        if (prefix == null || "".equals(prefix)) {
            return suffix;
        }
        if (suffix == null || "".equals(suffix)) {
            return prefix;
        }
        prefix = prefix.replaceAll("/$", "");
        suffix = suffix.replaceAll("^/", "");
        return prefix + '/' + suffix;
    }

    public static String getNormalizeRequestServletUri(HttpServletRequest request) {
        String uri = Optional.ofNullable(request.getServletPath()).orElse("").trim();
        String pathInfo = Optional.ofNullable(request.getPathInfo()).orElse("").trim();
        return uri + pathInfo;
    }
}

