/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.validator;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.Normalizer;
import java.util.regex.Pattern;

public final class Validator {
    private static final Log log = LogFactory.getInstance(Validator.class);
    private static final String COUNTRY_SPEC = "^[\\+]{0,1}\\d+$";
    private static final String STRING_CHECK = "^.*[#&\u2019\u2018'\u201d\u201c'<>\"]+.*$";
    private static final int MAX_PORT = 65536;
    private static final int MAX_NUMBER_BYTE = 18;

    private Validator() {
    }

    public static synchronized boolean stringisNull(String str) {
        return null == str || str.trim().isEmpty();
    }

    public static boolean stringNotNull(String str) {
        return !Validator.stringisNull(str);
    }

    public static boolean regCheckStr(String str) {
        if (null == str || str.trim().isEmpty()) {
            throw new LegoCheckedException(250L);
        }
        String convertStr = HtmlStringConverter.decodeByLength(str);
        convertStr = Normalizer.normalize(convertStr, Normalizer.Form.NFKC);
        boolean b = Pattern.compile(STRING_CHECK).matcher(convertStr).matches();
        if (b) {
            throw new LegoCheckedException(250L);
        }
        return b;
    }

    public static String nulltoStr(String str) {
        return Validator.stringisNull(str) ? "" : str;
    }

    public static boolean stringNullNotTrim(String str) {
        if (null == str) {
            throw new LegoCheckedException(250L);
        }
        if (str.isEmpty()) {
            throw new LegoCheckedException(250L);
        }
        return false;
    }

    public static boolean stringNullTrim(String str) {
        if (null == str) {
            return true;
        }
        return str.trim().isEmpty();
    }

    public static boolean regExpCheck(String str, String pattern) {
        if (null == str || str.trim().isEmpty()) {
            throw new LegoCheckedException(250L);
        }
        str = Normalizer.normalize(str, Normalizer.Form.NFKC);
        boolean b = Pattern.compile(pattern).matcher(str).matches();
        if (!b) {
            throw new LegoCheckedException(250L);
        }
        return b;
    }

    public static boolean checkStringLength(String str, int length) {
        if (null == str) {
            return true;
        }
        String convertStr = HtmlStringConverter.decodeByLength(str);
        return convertStr.length() <= length;
    }

    public static boolean checkMinStringLength(String str, int length) {
        if (null == str) {
            return false;
        }
        String convertStr = HtmlStringConverter.decodeByLength(str);
        return convertStr.length() >= length;
    }

    public static boolean checkCountryCode(String str) {
        return Validator.regExpCheck(str, COUNTRY_SPEC);
    }

    public static boolean isNum(String str) {
        return Validator.regExpCheck(str, "^[1-9]\\d*|0$");
    }

    public static boolean isPre(String str) {
        return Validator.regExpCheck(str, "^[1-100]\\d*|0$");
    }

    public static boolean isCys(String str) {
        return Validator.regExpCheck(str, "^[1-9]|[1-9]\\d|100");
    }

    public static boolean isStr(String str) {
        return Validator.regExpCheck(str, "^[A-Za-z_]+$");
    }

    public static boolean isEnAndNum(String str) {
        return Validator.regExpCheck(str, "^[A-Za-z0-9]+$");
    }

    public static boolean isEnAndNumDown(String str) {
        return Validator.regExpCheck(str, "^\\w+$");
    }

    public static boolean canOrderBy(String str) {
        boolean b;
        if (null == str || str.trim().isEmpty()) {
            return true;
        }
        str = Normalizer.normalize(str, Normalizer.Form.NFKC);
        boolean bl = b = Pattern.compile("^\\w+$").matcher(str).matches() && !Pattern.compile("^[1-9]\\d*|0$").matcher(str).matches();
        if (!b) {
            throw new LegoCheckedException(250L);
        }
        return b;
    }

    public static boolean isDateAndTime(String str) {
        return Validator.regExpCheck(str, "^\\d{4}\\-\\d{2}\\-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}$");
    }

    public static boolean validateTime(String str) {
        return Validator.regExpCheck(str, "^([0]?\\d{1}|[2][0-3]{1}|[1]\\d{1})\\:[0-5]?[0-9]{1}\\:[0-5]?[0-9]{1}$");
    }

    public static boolean isEmail(String str) {
        return Validator.regExpCheck(str, "^[a-zA-Z0-9\\.\\-_\\!\\#\\$\\%\\&\\'\\*\\+\\/\\=\\?\\^\\`\\{\\|\\}\\~]+@[a-zA-Z0-9\\-_]+(\\.[a-zA-Z0-9\\-_]+)+$");
    }

    public static boolean isPhone(String str) {
        return Validator.regExpCheck(str, "^[0-9\\-+]{8,20}$");
    }

    public static boolean isPhoneInternation(String str) {
        return Validator.regExpCheck(str, "^[\\+]{0,1}(\\d|\\d[\\-]{0,1}\\d){3,20}$");
    }

    public static boolean isIp(String str) {
        return Validator.regExpCheck(str, "^(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])$");
    }

    public static boolean isProxyIp(String str) {
        int endIpNum;
        int firstIpNum;
        String[] ipStrs;
        boolean result = true;
        if (!Validator.isIp(str)) {
            result = false;
        }
        if ((ipStrs = str.split("\\.")).length < 4) {
            result = false;
            return result;
        }
        if (ipStrs[0].startsWith("0")) {
            result = false;
        }
        if ((firstIpNum = Integer.parseInt(ipStrs[0])) == 127 || firstIpNum > 223 || firstIpNum < 1) {
            result = false;
        }
        if ((endIpNum = Integer.parseInt(ipStrs[3])) == 0) {
            result = false;
        }
        return result;
    }

    public static boolean isStrs(String str) {
        return Validator.regExpCheck(str, "^\\D{1}\\w{0,31}$");
    }

    public static boolean isStrss(String str) {
        return Validator.regExpCheck(str, "^\\D{1}\\w{0,63}$");
    }

    public static boolean isEnZhCnAndNum(String str) {
        return Validator.regExpCheck(str, "^[a-zA-Z_0-9\u4e00-\u9fa5\\-]+$");
    }

    public static boolean isNumNoThrow(String str) {
        return Validator.regExpCheckNoThrow(str, "^\\d+$");
    }

    public static boolean isEnZhCnAndNumNoThrow(String str) {
        return Validator.regExpCheckNoThrow(str, "^[a-zA-Z_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*$");
    }

    public static boolean isIpNoThrow(String str) {
        return Validator.regExpCheckNoThrow(str, "^(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[0-9]{1,2})(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[0-9]{1,2})){3}$");
    }

    public static boolean regExpCheckNoThrow(String str, String pattern) {
        if (null == str || str.trim().length() <= 0) {
            return false;
        }
        str = Normalizer.normalize(str, Normalizer.Form.NFKC);
        boolean b = Pattern.compile(pattern).matcher(str).matches();
        return b;
    }

    public static boolean numArea(long min, long max, String param) {
        if (Validator.stringNotNull(param) && Validator.regExpCheckNoThrow(param, "^-?\\d+$")) {
            long l = NumberUtil.convertToLong((Object)param);
            return l >= min && l <= max;
        }
        return false;
    }

    public static boolean ipArea(String startId, String endIp) {
        if (!Validator.stringNotNull(startId) || !Validator.stringNotNull(endIp)) {
            return false;
        }
        if (!Validator.isIpNoThrow(startId) || !Validator.isIpNoThrow(endIp)) {
            return false;
        }
        try {
            String[] arrbegin = startId.split("\\.");
            String[] arrend = endIp.split("\\.");
            long beginIpNum = 0L;
            long endIpNum = 0L;
            for (int i = 0; i <= 3; ++i) {
                beginIpNum += Long.parseLong(arrbegin[i]);
                beginIpNum *= 1000L;
                endIpNum += Long.parseLong(arrend[i]);
                endIpNum *= 1000L;
            }
            return beginIpNum < endIpNum;
        }
        catch (Exception ex) {
            log.error((Object)("validate failed" + ExceptionUtil.getErrorMessage((Throwable)ex)), 653110170615808L);
            return false;
        }
    }

    public static boolean validateIP(String ip) {
        String[] ips;
        boolean validate = true;
        if (null == ip || ip.isEmpty()) {
            return false;
        }
        for (String one : ips = ip.split("\\.")) {
            if (null == one || one.trim().isEmpty()) {
                validate = false;
                break;
            }
            try {
                if (Integer.parseInt(one) >= 0 && Integer.parseInt(one) <= 255) continue;
                validate = false;
            }
            catch (Exception e) {
                validate = false;
            }
            break;
        }
        return validate;
    }

    public static boolean validateThreshold(String str) {
        if (Validator.stringNotNull(str)) {
            if (str.length() > 18) {
                return false;
            }
            return Validator.regExpCheckNoThrow(str, "^-?\\d+$");
        }
        return false;
    }

    public static boolean isIntergral(String str) {
        return Validator.regExpCheckNoThrow(str, "^-?\\d+$");
    }

    public static boolean validateQuery(String str, int len) {
        if (str != null && !str.isEmpty()) {
            return str.length() <= len;
        }
        return true;
    }

    public static Long convertString2Long(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (Exception e) {
            throw new LegoCheckedException(250L, (Throwable)e);
        }
    }

    public static Integer convertString2Integer(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (Exception e) {
            throw new LegoCheckedException(250L, (Throwable)e);
        }
    }

    public static boolean isPwd(String str) {
        try {
            boolean result = Validator.regExpCheckNoThrow(str, "(.*?\\d+.*?[a-zA-Z]+.*?)|(.*?[a-zA-Z]+.*?\\d+.*?)");
            if (!result) {
                return result;
            }
        }
        catch (Exception e) {
            log.error((Object)"Check pwd result:false", 653110170615808L);
        }
        return Validator.checkStringLength(str, 32);
    }

    public static boolean isPort(int port) {
        boolean result = false;
        if (port > 0 && port < 65536) {
            result = true;
        }
        return result;
    }

    public static boolean isDefaultName(String defaultName) {
        if (VerifyUtil.isEmpty((String)defaultName)) {
            return false;
        }
        String convertStr = HtmlStringConverter.decodeByLength(defaultName);
        if (convertStr.indexOf("'") != -1 || convertStr.indexOf(34) != -1 || convertStr.indexOf("<") != -1) {
            return false;
        }
        return convertStr.indexOf(">") == -1 && convertStr.indexOf("#") == -1 && convertStr.indexOf("&") == -1;
    }

    public static boolean isIPV6(String host) {
        InetAddress addressIpv6;
        try {
            addressIpv6 = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return addressIpv6 instanceof Inet6Address;
    }

    public static void checkLongTime(Long createTimeStart) {
        if (VerifyUtil.isEmpty((Object)createTimeStart) || createTimeStart < 0L) {
            throw new LegoCheckedException(250L);
        }
    }

    public static boolean isName(String name) {
        try {
            boolean result = Validator.regExpCheckNoThrow(name, "^[a-zA-Z0-9_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*$");
            if (!result) {
                return result;
            }
        }
        catch (Exception e) {
            log.error((Object)"Check name result:false", 653110170615808L);
        }
        return Validator.checkStringLength(name, 32);
    }

    public static boolean checkPageQueryParams(int pageSize, int startPage) {
        return 0 < pageSize && 0 <= startPage;
    }

    public static boolean checkPageQueryParams(String orderType, int pageSize, int startPage) {
        if (0 >= pageSize || 0 > startPage) {
            return false;
        }
        return null == orderType || orderType.equalsIgnoreCase("desc") || orderType.equalsIgnoreCase("asc");
    }
}

