/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2020-2021. All rights reserved.
 */

const strHlStart = "<span style='color:black; background-color:yellow'>";
const strHlEnd = '</span>';

function regexEncode(str) {
  if (str.length === 0) {
    return '';
  }
  let s = str.replace(/\\/g, '\\\\');
  s = s.replace(/\./g, '\\.');
  s = s.replace(/\^/g, '\\^');
  s = s.replace(/\|/g, '\\|');
  s = s.replace(/\$/g, '\\$');
  s = s.replace(/\[/g, '\\[');
  s = s.replace(/\?/g, '\\?');
  s = s.replace(/\+/g, '\\+');
  s = s.replace(/\*/g, '\\*');
  s = s.replace(/\(/g, '\\(');
  s = s.replace(/\)/g, '\\)');
  return s;
}

function htmlEncode(str) {
  if (str.length === 0) {
    return '';
  }
  return str.replace(/[&<>]/g, function(match) {
    switch (match) {
      case '&':
        return '&amp;';
      case '<':
        return '&lt;';
      case '>':
        return '&gt;';
      default:
        break;
    }
  });
}

function encode(str) {
  return regexEncode(htmlEncode(str));
}

function htmlDecode(str) {
  if (str.length === 0) {
    return '';
  }
  return str.replace(/&\w+;/g, function(match) {
    return { '&amp;': '&', '&lt;': '<', '&gt;': '>' }[match];
  });
}

function replaceStr(matchStr) {
  let result;
  const pattern = /<(?:"[^"]*"|'[^']*'|[^'">])*>/g;
  if (pattern.test(matchStr)) {
    const matchStrWithoutTag = htmlDecode(matchStr.replace(pattern, ''));

    // To know where the search starts in the matching string
    const beginIndex = matchStrWithoutTag.indexOf(keyWord);

    // To know where the search ends in the matching string
    let lastLength = keyWord.length;

    // Matches strings without tags in strings.
    const split = matchStr.split(pattern);

    // Matches HTML tags in strings.
    const htmlTagArr = matchStr.match(pattern);
    const resultArr = [];
    let slice;
    let decodeStr;
    for (let i = 0; i < split.length; i++) {
      if (!split[i] || split[i] === '') {
        resultArr.push(htmlTagArr[i]);
        continue;
      }

      // Encoded for comparison with keywords.
      decodeStr = htmlDecode(split[i]);

      // All strings that match keywords must be escaped in HTML format.
      if (i === 0) {
        slice =
          decodeStr.charAt(0) +
          htmlEncode(decodeStr.slice(1, beginIndex)) +
          strHlStart +
          htmlEncode(decodeStr.slice(beginIndex)) +
          strHlEnd;
        lastLength = lastLength - (decodeStr.length - beginIndex);
      } else if (i === split.length - 1) {
        slice =
          strHlStart +
          htmlEncode(decodeStr.slice(0, lastLength)) +
          strHlEnd +
          htmlEncode(decodeStr.slice(lastLength, decodeStr.length - 1)) +
          decodeStr.charAt(decodeStr.length - 1);
      } else {
        lastLength = lastLength - decodeStr.length;
        slice = strHlStart + split[i] + strHlEnd;
      }
      resultArr.push(slice);
      resultArr.push(htmlTagArr[i]);
    }
    result = resultArr.join('');
  } else {
    result = matchStr.replace(new RegExp(encode(keyWord), 'g'), strHlStart + htmlEncode(keyWord) + strHlEnd);
  }
  return result;
}

// Deduplication
function deduplicateArr(matchArr) {
  return matchArr
    ? matchArr.filter(function(item, index) {
        return matchArr.indexOf(item, 0) === index;
      })
    : null;
}

function highlightInnerHtml(matchArr, body) {
  if (!matchArr || matchArr.length === 0) {
    return;
  }
  let innerHtml = body.innerHTML;
  let replace;
  let matchStr;
  let replaceReg;
  for (let i = 0; i < matchArr.length; i++) {
    matchStr = matchArr[i];
    replace = replaceStr(matchStr);
    replaceReg = new RegExp(regexEncode(matchStr), 'g');
    innerHtml = innerHtml.replace(replaceReg, replace);
  }
  body.innerHTML = innerHtml;
}

// Special characters in regular expressions and HTML special characters are escaped for regular expression matching.
function escapeCharacter(keyWordArr) {
  for (let j = 0, length = keyWordArr.length; j < length; j++) {
    keyWordArr[j] = encode(keyWordArr[j]);
  }
}

function regexStrings(innerHtml) {
  const htmlTagPattern = '(<("[^"]*"|\'[^\']*\'|[^\'">])*>)*';
  const keyWordArr = keyWord.split('');

  escapeCharacter(keyWordArr);
  let regex = keyWordArr.join(htmlTagPattern);
  regex = '(>[^><]*){1}' + regex + '([^><]*<){1}';
  const pattern = new RegExp(regex, 'g');
  return innerHtml.match(pattern);
}

function highlight(body) {
  if (!body) {
    return;
  }
  const innerHtml = body.innerHTML;

  // Regular expression matching in the body tag
  let matchArr = regexStrings(innerHtml);

  // Deduplication and replacement of the same item at a time
  matchArr = deduplicateArr(matchArr);
  highlightInnerHtml(matchArr, body);
}
