(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["business-login-login-module"],{

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/login/login.component.html":
/*!*******************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/business/login/login.component.html ***!
  \*******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class=\"aui-login-container\">\n  <div class=\"aui-logo\"></div>\n  <lvp-toggle-i18n class='aui-language'></lvp-toggle-i18n>\n  <div class=\"aui-login-content\" *ngIf=\"!modifyPassword\">\n    <h1 class=\"aui-login-product-text\">OceanStor BCManager</h1>\n    <lv-form [formGroup]=\"loginFormGroup\" class=\"formGroup\" [lvLabelColon]=\"false\">\n      <lv-form-item>\n        <lv-form-label></lv-form-label>\n        <lv-form-control [lvErrorTip]=\"baseUtilService.requiredErrorTip\">\n          <input class=\"aui-login-input userName\" lv-input type=\"text\" (keydown.enter)=\"onLogin()\"\n            [attr.placeholder]=\"'common_username_label' | i18n\" formControlName=\"userName\" />\n        </lv-form-control>\n      </lv-form-item>\n      <lv-form-item>\n        <lv-form-label></lv-form-label>\n        <lv-form-control [lvErrorTip]=\"baseUtilService.requiredErrorTip\">\n          <input class=\"aui-login-input aui-password\" lv-input type=\"password\" (keydown.enter)=\"onLogin()\"\n            [attr.placeholder]=\"'common_password_label' | i18n\" formControlName=\"pwd\" />\n        </lv-form-control>\n      </lv-form-item>\n      <!-- 验证码 -->\n      <lv-form-item *ngIf=\"hasVerificationCode\">\n        <lv-form-label></lv-form-label>\n        <lv-form-control [lvErrorTip]=\"baseUtilService.requiredErrorTip\">\n          <div class=\"verify-code\">\n            <input class=\"login-input verify-code-text\" maxlength=\"4\" lv-input type=\"text\" formControlName=\"randomCode\"\n              (keydown.enter)=\"onLogin()\" (focus)=\"setVerifyCodeValidator()\" />\n            <img id=\"verifyCodeImg\" class=\"verify-code-img\" title=\"{{ 'common_term_verifytip_label' | i18n }}\"\n              (click)=\"changeVerifyCode()\" />\n          </div>\n        </lv-form-control>\n      </lv-form-item>\n    </lv-form>\n    <button class=\"aui-login-btn aui-gutter-column-lg\" (click)=\"onLogin()\">\n      <span>{{ 'common_login_label' | i18n }}</span>\n    </button>\n  </div>\n  <div class=\"aui-login-content\" *ngIf=\"modifyPassword\">\n    <h1 class=\"aui-login-product-text\">OceanStor BCManager</h1>\n    <lv-form [formGroup]=\"loginFormGroup\" class=\"formGroup\" [lvLabelColon]=\"false\">\n      <lv-form-item>\n        <lv-form-label></lv-form-label>\n        <lv-form-control [lvErrorTip]=\"baseUtilService.pwdErrorTip\">\n          <input class=\"aui-login-input aui-password\" lv-input type=\"password\" (keydown.enter)=\"modify()\"\n            [attr.placeholder]=\"'Login_Label_Old_Password' | i18n\" formControlName=\"originalPassword\" />\n        </lv-form-control>\n      </lv-form-item>\n      <lv-form-item>\n        <lv-form-label></lv-form-label>\n        <lv-form-control [lvErrorTip]=\"baseUtilService.pwdErrorTip\">\n          <input class=\"aui-login-input aui-password\" lv-input type=\"password\" (keydown.enter)=\"modify()\"\n            [attr.placeholder]=\"'Login_Label_New_Password' | i18n\" formControlName=\"newPassword\"\n            [lv-tooltip]=\"pwdComplexTipTpl\" lvTooltipTrigger=\"focus\" lvTooltipPosition=\"topLeft\"\n            lvTooltipTheme=\"light\" />\n        </lv-form-control>\n      </lv-form-item>\n      <lv-form-item>\n        <lv-form-label></lv-form-label>\n        <lv-form-control [lvErrorTip]=\"baseUtilService.pwdErrorTip\">\n          <input class=\"aui-login-input aui-password\" lv-input type=\"password\" (keydown.enter)=\"modify()\"\n            [attr.placeholder]=\"'Login_Label_Confirm_Password' | i18n\" formControlName=\"confrimNewPassword\" />\n        </lv-form-control>\n      </lv-form-item>\n    </lv-form>\n    <button class=\"ok-btn common-btn aui-gutter-column-lg common-btn-first\" (click)=\"modify()\">\n      <span>{{ 'common_modify_label' | i18n}}</span>\n    </button>\n    <button class=\"cancel-btn common-btn aui-gutter-column-lg common-btn-first\" (click)=\"cancel()\">\n      <span>{{ 'common_term_no_button' | i18n }}</span>\n    </button>\n  </div>\n\n  <div class=\"main-footer\">{{copyRight}}</div>\n</div>\n\n<ng-template #pwdComplexTipTpl>\n  <span [innerHTML]=\"pwdComplexTipLabel\"></span>\n</ng-template>");

/***/ }),

/***/ "./src/app/business/login/login-router.module.ts":
/*!*******************************************************!*\
  !*** ./src/app/business/login/login-router.module.ts ***!
  \*******************************************************/
/*! exports provided: LoginRouterModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LoginRouterModule", function() { return LoginRouterModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/__ivy_ngcc__/fesm2015/router.js");
/* harmony import */ var _login_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./login.component */ "./src/app/business/login/login.component.ts");




var routes = [{ path: '', component: _login_component__WEBPACK_IMPORTED_MODULE_3__["LoginComponent"] }];
var LoginRouterModule = /** @class */ (function () {
    function LoginRouterModule() {
    }
    LoginRouterModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forChild(routes)],
            exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]]
        })
    ], LoginRouterModule);
    return LoginRouterModule;
}());



/***/ }),

/***/ "./src/app/business/login/login.component.less":
/*!*****************************************************!*\
  !*** ./src/app/business/login/login.component.less ***!
  \*****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (".aui-login-container {\n  position: relative;\n  background: url('bg_login.png');\n  width: 100%;\n  height: 100%;\n  background-size: cover;\n}\n.aui-logo {\n  background: url('ereplication-logo.png') no-repeat;\n  height: 50px;\n  width: 375px;\n  position: absolute;\n  top: 56px;\n  left: 56px;\n}\n.aui-language {\n  position: absolute;\n  top: 56px;\n  right: 42px;\n  color: #fff;\n  line-height: 50px;\n}\n.aui-login-content {\n  position: absolute;\n  right: 180px;\n  top: 210px;\n  margin: 0 auto;\n  background-color: #fff;\n  width: 528px;\n  padding: 56px 46px 56px 41px;\n}\n.aui-login-product-text {\n  font-size: 28px;\n  margin-bottom: 50px;\n  margin-left: 15px;\n}\n.aui-login-input {\n  border: none;\n  outline: 0;\n  border-bottom: 1px solid #d9d9d9;\n  width: 95%;\n  font-size: 18px;\n  line-height: 20px;\n  font-family: 'HuaweiSans-Regular';\n}\n.aui-password {\n  margin-top: 20px;\n}\n.aui-login-btn {\n  font-family: 'HuaweiSans-Regular';\n  color: #fff;\n  font-size: 22px;\n  background: #6c92fa;\n  vertical-align: middle;\n  width: 93%;\n  cursor: pointer;\n  height: 48px;\n  box-sizing: border-box;\n  text-decoration: none;\n  border: 0px;\n  margin-top: 40px;\n  margin-left: 15px;\n}\n.main-footer {\n  position: absolute;\n  left: 0;\n  right: 0;\n  bottom: 24px;\n  font-size: 14px;\n  color: #888;\n  text-align: center;\n  line-height: 16px;\n}\n.common-btn {\n  font-family: 'HuaweiSans-Regular';\n  color: #fff;\n  font-size: 22px;\n  vertical-align: middle;\n  cursor: pointer;\n  height: 48px;\n  box-sizing: border-box;\n  text-decoration: none;\n  border: 0px;\n  margin-top: 55px;\n  margin-left: 15px;\n}\n.common-btn-first {\n  margin-top: 20px !important;\n}\n.ok-btn {\n  background: #6c92fa;\n  width: 46%;\n}\n.cancel-btn {\n  width: 46%;\n  background: #fff;\n  color: #000;\n  border: 1px solid #d9d9d9;\n}\n.verify-code {\n  display: flex;\n}\n.verify-code .verify-code-text {\n  width: 265px;\n  margin-top: 15px;\n}\n.verify-code .verify-code-img {\n  width: 107px;\n  height: 40px;\n  margin-left: 15px;\n  margin-top: 5px;\n  cursor: pointer;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "./src/app/business/login/login.component.ts":
/*!***************************************************!*\
  !*** ./src/app/business/login/login.component.ts ***!
  \***************************************************/
/*! exports provided: LoginComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LoginComponent", function() { return LoginComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/__ivy_ngcc__/fesm2015/forms.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @shared */ "./src/app/shared/index.ts");
/* harmony import */ var _shared_api_services__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @shared/api/services */ "./src/app/shared/api/services.ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _iux_live__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @iux/live */ "./node_modules/@iux/live/__ivy_ngcc__/fesm2015/iux-live.js");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ "./node_modules/rxjs/_esm2015/operators/index.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/__ivy_ngcc__/fesm2015/router.js");









var LoginComponent = /** @class */ (function () {
    function LoginComponent(router, fb, i18n, store, cookieService, messageBox, baseUtilService, systemApiService) {
        this.router = router;
        this.fb = fb;
        this.i18n = i18n;
        this.store = store;
        this.cookieService = cookieService;
        this.messageBox = messageBox;
        this.baseUtilService = baseUtilService;
        this.systemApiService = systemApiService;
        this.copyRight = this.i18n.get('common_copy_right_label', [new Date().getFullYear()]);
        this.modifyPassword = false;
        this.hasVerificationCode = false;
        this.pwdComplexTipLabel = this.i18n.get('common_pwdtip_label', []);
    }
    LoginComponent.prototype.ngOnInit = function () {
        this.initForm();
        this._initVerifyCode();
        this._showIsLicenseExpire();
        this.checkLoginFormStates();
    };
    LoginComponent.prototype.initForm = function () {
        this.loginFormGroup = this.fb.group({
            userName: new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"]('', { validators: [this.baseUtilService.VALID.required()] }),
            pwd: new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"]('', { validators: [this.baseUtilService.VALID.required()] })
        });
    };
    LoginComponent.prototype.onLogin = function () {
        var _this = this;
        for (var key in this.loginFormGroup.controls) {
            this.loginFormGroup.controls[key].markAsDirty();
            this.loginFormGroup.controls[key].updateValueAndValidity();
        }
        if (this.loginFormGroup.invalid) {
            return false;
        }
        this.systemApiService
            .CreateUserLogin({
            loginUserInfoRequestBody: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, Object(lodash__WEBPACK_IMPORTED_MODULE_2__["pick"])(this.loginFormGroup.value, this.hasVerificationCode ? ['userName', 'pwd', 'randomCode'] : ['userName', 'pwd'])), { lang: this.i18n.isZh ? 'zh' : 'en' }),
            lvpOperationTips: false
        })
            .subscribe(function (res) {
            if (Object(lodash__WEBPACK_IMPORTED_MODULE_2__["has"])(res, 'expireDay')) {
                _this._checkPwdTimeExpired(res);
            }
            else {
                _this._afterLogin(res);
            }
        }, function () {
            var _a;
            (_a = _this.loginFormGroup.get('pwd')) === null || _a === void 0 ? void 0 : _a.setValue('', { emitEvent: false });
            _this._initVerifyCode();
        });
    };
    LoginComponent.prototype.checkLoginFormStates = function () {
        var currentInfo = this.getBrowserInfo();
        var brower = currentInfo.browser.toLowerCase();
        var isIE = brower.indexOf('IE:11.0');
        var isIEAndZh = isIE && this.i18n.isZh;
        var formGroup = this.loginFormGroup;
        var markPristineCountUsername = 0;
        var markPristineCountPassword = 0;
        var maxCountNeeded = 0;
        if (isIEAndZh) {
            maxCountNeeded = 2;
        }
        else if (isIE) {
            maxCountNeeded = 1;
        }
        if (isIE) {
            var usernameChange$_1 = formGroup.get('userName').valueChanges.subscribe(function () {
                if (markPristineCountUsername < maxCountNeeded) {
                    markPristineCountUsername++;
                    formGroup.get('userName').markAsPristine();
                }
                else if (usernameChange$_1) {
                    usernameChange$_1.unsubscribe();
                }
            });
            var passwordChange$_1 = formGroup.get('pwd').valueChanges.subscribe(function () {
                if (markPristineCountPassword < maxCountNeeded) {
                    markPristineCountPassword++;
                    formGroup.get('pwd').markAsPristine();
                }
                else if (passwordChange$_1) {
                    passwordChange$_1.unsubscribe();
                }
            });
        }
    };
    LoginComponent.prototype.getBrowserInfo = function () {
        var Msie = /(msie\s|trident.*rv:)([\w.]+)/;
        var Firefox = /(firefox)\/([\w.]+)/;
        var Chrome = /(chrome)\/([\w.]+)/;
        var Opera = /(opera).+version\/([\w.]+)/;
        var Safari = /version\/([\w.]+).*(safari)/;
        var agent = navigator.userAgent.toLowerCase();
        var match = Msie.exec(agent);
        if (null != match) {
            return {
                browser: 'IE',
                version: match[2] || '0'
            };
        }
        match = Firefox.exec(agent);
        if (null != match) {
            return {
                browser: match[1] || '',
                version: match[2] || '0'
            };
        }
        match = Chrome.exec(agent);
        if (null != match) {
            return {
                browser: match[1] || '',
                version: match[2] || '0'
            };
        }
        match = Opera.exec(agent);
        if (null != match) {
            return {
                browser: match[1] || '',
                version: match[2] || '0'
            };
        }
        match = Safari.exec(agent);
        if (null != match) {
            return {
                browser: match[2] || '',
                version: match[1] || '0'
            };
        }
        return 'false';
    };
    LoginComponent.prototype._initVerifyCode = function () {
        var _this = this;
        this.hasVerificationCode = this.cookieService.get('needCaptcha') === 'true';
        if (!this.hasVerificationCode) {
            this.loginFormGroup.removeControl('randomCode');
        }
        else {
            this.loginFormGroup.addControl('randomCode', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"]('', {
                validators: [this.baseUtilService.VALID.required()]
            }));
        }
        this.loginFormGroup.updateValueAndValidity();
        Object(lodash__WEBPACK_IMPORTED_MODULE_2__["defer"])(function () { return _this.changeVerifyCode(); });
    };
    LoginComponent.prototype.changeVerifyCode = function () {
        var node = document.getElementById('verifyCodeImg');
        if (node) {
            node.src = _shared__WEBPACK_IMPORTED_MODULE_3__["SERVICE_PREFIX"] + "/auth?" + Math.random();
        }
    };
    LoginComponent.prototype._checkPwdTimeExpired = function (res) {
        var expireDay = parseInt(res['expireDay']);
        expireDay = isNaN(expireDay) ? -1 : expireDay;
        if (expireDay >= 0 && expireDay <= 3) {
            this.messageBox.confirm({
                lvHeader: this.i18n.get('common_info_label'),
                lvContent: this.i18n.get('common_login_page_pwd_time_expiring_msg', [expireDay]),
                lvAfterClose: this._afterLogin.bind(this, res)
            });
        }
        else if (expireDay < 0) {
            this.messageBox.confirm({
                lvHeader: this.i18n.get('common_info_label'),
                lvContent: this.i18n.get('common_login_page_pwd_time_expired_msg'),
                lvOk: this._afterLogin.bind(this, Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, res), { mustModifyPwd: 'true' }))
            });
        }
        else {
            this._afterLogin(res);
        }
    };
    LoginComponent.prototype._validUserNamePwd = function () {
        var _this = this;
        return function (control) {
            if (Object(lodash__WEBPACK_IMPORTED_MODULE_2__["isUndefined"])(_this.loginFormGroup)) {
                return null;
            }
            var userName = _this.cookieService.get('userName') || '';
            if (!userName) {
                return null;
            }
            var _reverseName = userName
                .split('')
                .reverse()
                .join('');
            if (control.value === userName || control.value === _reverseName) {
                return { invalidPwd: { value: control.value } };
            }
            return null;
        };
    };
    LoginComponent.prototype._validPwdAndOldpwd = function () {
        var _this = this;
        return function (control) {
            var originalPwd = _this.loginFormGroup.value.originalPassword;
            if (originalPwd === control.value) {
                return { sameHistoryPwd: { value: control.value } };
            }
            return null;
        };
    };
    LoginComponent.prototype._validConfirmPwdIsSame = function () {
        var _this = this;
        return function (control) {
            var _a;
            if (!!_this.loginFormGroup.value.confrimNewPassword &&
                _this.loginFormGroup.value.confrimNewPassword !== control.value) {
                return { diffPwd: { value: control.value } };
            }
            if (!!_this.loginFormGroup.value.confrimNewPassword) {
                (_a = _this.loginFormGroup.get('confrimNewPassword')) === null || _a === void 0 ? void 0 : _a.setErrors(null);
            }
            return null;
        };
    };
    LoginComponent.prototype._validNewPwdIsSame = function () {
        var _this = this;
        return function (control) {
            var _a;
            if (!!_this.loginFormGroup.value.newPassword && _this.loginFormGroup.value.newPassword !== control.value) {
                return { diffPwd: { value: control.value } };
            }
            if (!!_this.loginFormGroup.value.newPassword) {
                (_a = _this.loginFormGroup.get('newPassword')) === null || _a === void 0 ? void 0 : _a.setErrors(null);
            }
            return null;
        };
    };
    LoginComponent.prototype._ShowSecurityPolicy = function () {
        return this.systemApiService.ShowSecurityPolicy({ lvpDoException: false });
    };
    LoginComponent.prototype._setFormGroup = function (res) {
        this.loginFormGroup.removeControl('userName');
        this.loginFormGroup.removeControl('pwd');
        if (this.loginFormGroup.get('randomCode')) {
            this.loginFormGroup.removeControl('randomCode');
        }
        this.pwdComplexTipLabel = this.i18n.get('common_pwdtip_label', [
            (res === null || res === void 0 ? void 0 : res.passLenVal) || 8,
            64,
            (res === null || res === void 0 ? void 0 : res.passComplexVal) === 2 ? this.i18n.get('common_pwd_complex_label') : '',
            2,
            ''
        ]);
        this.loginFormGroup.addControl('originalPassword', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"]('', { validators: [this.baseUtilService.VALID.required()] }));
        this.loginFormGroup.addControl('newPassword', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"]('', {
            validators: [
                this.baseUtilService.VALID.required(),
                this.baseUtilService.VALID.password((res === null || res === void 0 ? void 0 : res.passLenVal) || 8, res.passComplexVal || 4, 64),
                this._validConfirmPwdIsSame(),
                this._validUserNamePwd(),
                this._validPwdAndOldpwd()
            ]
        }));
        this.loginFormGroup.addControl('confrimNewPassword', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"]('', {
            validators: [
                this.baseUtilService.VALID.required(),
                this.baseUtilService.VALID.password((res === null || res === void 0 ? void 0 : res.passLenVal) || 8, res.passComplexVal || 4, 64),
                this._validNewPwdIsSame(),
                this._validUserNamePwd(),
                this._validPwdAndOldpwd()
            ]
        }));
        this.modifyPassword = true;
    };
    LoginComponent.prototype._afterLogin = function (res) {
        var _this = this;
        if (Object(lodash__WEBPACK_IMPORTED_MODULE_2__["eq"])(Object(lodash__WEBPACK_IMPORTED_MODULE_2__["toString"])(res === null || res === void 0 ? void 0 : res.mustModifyPwd), 'true')) {
            this._ShowSecurityPolicy().subscribe(function (res) { return _this._setFormGroup(res); }, function () { return _this._setFormGroup(); });
        }
        else {
            this.redirectTo();
        }
    };
    LoginComponent.prototype._showIsLicenseExpire = function () {
        var _this = this;
        this.systemApiService.ShowIsLicenseExpire({ lvpLoading: false, lvpDoException: false }).subscribe(function (res) {
            if (res.expire) {
                return;
            }
            var installTime = res.installTime + 90 * 24 * 60 * 60 * 1000;
            var curTime = res.curTime;
            var leftDay = (installTime - curTime) / (24 * 60 * 60 * 1000);
            leftDay = parseInt(leftDay, 10);
            leftDay = isNaN(leftDay) ? 0 : Math.floor(leftDay);
            leftDay = leftDay < 0 ? 0 : leftDay;
            if (leftDay <= 10) {
                _this.messageBox.info(_this.i18n.get('login_page_license_time_expiring_msg', [leftDay]));
            }
        });
    };
    LoginComponent.prototype.modify = function () {
        var _this = this;
        for (var key in this.loginFormGroup.controls) {
            this.loginFormGroup.controls[key].markAsDirty();
            this.loginFormGroup.controls[key].updateValueAndValidity();
        }
        if (this.loginFormGroup.invalid) {
            return false;
        }
        this.systemApiService
            .ModifyOwnPassword({
            lvpOperationTipsContent: this.i18n.get('login_first_modify_pwd_successed_msg'),
            pwdBody: {
                oldPassword: this.loginFormGroup.value.originalPassword,
                newPassword: this.loginFormGroup.value.newPassword,
                confirmPassword: this.loginFormGroup.value.confrimNewPassword
            }
        })
            .subscribe(function () { return _this.toLoginPage(); });
    };
    LoginComponent.prototype.cancel = function () {
        this.toLoginPage();
    };
    LoginComponent.prototype.redirectTo = function () {
        this.store.emitStore({ action: 'common__login' });
        this.router.navigate(['/home']);
    };
    LoginComponent.prototype.toLoginPage = function () {
        var _this = this;
        this.systemApiService
            .CreateUserLoginOut({
            lvpOperationTips: false,
            logoutBody: {
                timeOut: false
            }
        })
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_7__["finalize"])(function () {
            _this.cookieService.clear();
            _this.modifyPassword = false;
            _this.loginFormGroup.addControl('userName', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"]('', { validators: [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required] }));
            _this.loginFormGroup.addControl('pwd', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"]('', { validators: [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required] }));
            _this.loginFormGroup.removeControl('originalPassword');
            _this.loginFormGroup.removeControl('newPassword');
            _this.loginFormGroup.removeControl('confrimNewPassword');
            _this._initVerifyCode();
        }))
            .subscribe();
    };
    LoginComponent.ctorParameters = function () { return [
        { type: _angular_router__WEBPACK_IMPORTED_MODULE_8__["Router"] },
        { type: _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormBuilder"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["I18NService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["StoreService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["CookieService"] },
        { type: _iux_live__WEBPACK_IMPORTED_MODULE_6__["MessageboxService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["BaseUtilService"] },
        { type: _shared_api_services__WEBPACK_IMPORTED_MODULE_4__["SystemApiService"] }
    ]; };
    LoginComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_5__["Component"])({
            selector: 'lvs-login',
            template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./login.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/login/login.component.html")).default,
            styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./login.component.less */ "./src/app/business/login/login.component.less")).default]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_8__["Router"],
            _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormBuilder"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["I18NService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["StoreService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["CookieService"],
            _iux_live__WEBPACK_IMPORTED_MODULE_6__["MessageboxService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["BaseUtilService"],
            _shared_api_services__WEBPACK_IMPORTED_MODULE_4__["SystemApiService"]])
    ], LoginComponent);
    return LoginComponent;
}());



/***/ }),

/***/ "./src/app/business/login/login.module.ts":
/*!************************************************!*\
  !*** ./src/app/business/login/login.module.ts ***!
  \************************************************/
/*! exports provided: LoginModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LoginModule", function() { return LoginModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _shared_shared_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @shared/shared.module */ "./src/app/shared/shared.module.ts");
/* harmony import */ var _login_router_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./login-router.module */ "./src/app/business/login/login-router.module.ts");
/* harmony import */ var _login_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./login.component */ "./src/app/business/login/login.component.ts");





var LoginModule = /** @class */ (function () {
    function LoginModule() {
    }
    LoginModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [_login_router_module__WEBPACK_IMPORTED_MODULE_3__["LoginRouterModule"], _shared_shared_module__WEBPACK_IMPORTED_MODULE_2__["SharedModule"]],
            declarations: [_login_component__WEBPACK_IMPORTED_MODULE_4__["LoginComponent"]]
        })
    ], LoginModule);
    return LoginModule;
}());



/***/ })

}]);
//# sourceMappingURL=business-login-login-module.js.map