(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["default~discovery-discovery-module~host-list-host-list-module"],{

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/resource/discovery/host-alarm-set/host-alarm-set.component.html":
/*!********************************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/business/resource/discovery/host-alarm-set/host-alarm-set.component.html ***!
  \********************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class=\"aui-text-desc mgb-10\" *ngIf=\"!item.deviceSn\">{{'common_term_security_auth_message' | i18n:['HMAC_SHA2']}}\n</div>\n<lv-form [formGroup]='formGroup'>\n    <lv-group [lvColumns]='[\"auto\", \"auto\"]' class=\"alarm-group\">\n        <lv-form-column>\n            <lv-form-item>\n                <lv-form-label>{{'common_term_type_label' | i18n}}</lv-form-label>\n                <lv-form-control>\n                    <lv-select formControlName=\"type\" [lvOptions]='typeOptions' lvValueKey='value' lvDisabled>\n                    </lv-select>\n                </lv-form-control>\n            </lv-form-item>\n            <lv-form-item>\n                <lv-form-label [lvRequired]=\"item.deviceSn && formGroup.value.alarmInfo\">\n                    {{'vrg_term_count_label' | i18n}}\n                </lv-form-label>\n                <lv-form-control>\n                    <lv-group lvGutter='8px'>\n                        <lv-spinner formControlName=\"count\" lvMax=\"5\" lvMin=\"0\" class=\"alarm-spinner\"\n                            [lvDisabled]=\"item.deviceSn && !formGroup.value.alarmInfo\"></lv-spinner>\n                        <span>(0-5)</span>\n                    </lv-group>\n                </lv-form-control>\n            </lv-form-item>\n            <lv-form-item>\n                <lv-form-label [lvRequired]=\"item.deviceSn && formGroup.value.alarmInfo\">\n                    {{'common_term_port_label' | i18n}}\n                </lv-form-label>\n                <lv-form-control>\n                    <lv-group lvGutter='8px'>\n                        <lv-spinner formControlName=\"alarmPort\" lvMax=\"65535\" lvMin=\"1\" class=\"alarm-spinner\"\n                            [lvDisabled]=\"item.deviceSn && !formGroup.value.alarmInfo\">\n                        </lv-spinner>\n                        <span>(1-65535)</span>\n                    </lv-group>\n                </lv-form-control>\n            </lv-form-item>\n            <lv-form-item>\n                <lv-form-label>{{'vrg_term_env_label' | i18n}}</lv-form-label>\n                <lv-form-control [lvErrorTip]=\"envErrorTip\">\n                    <input formControlName=\"env\" lv-input\n                        [attr.disabled]=\"item.deviceSn && !formGroup.value.alarmInfo ? '' : null\" />\n                </lv-form-control>\n            </lv-form-item>\n            <lv-form-item>\n                <lv-form-label>{{'vrg_term_auth_protocol_label' | i18n}}</lv-form-label>\n                <lv-form-control>\n                    <lv-select formControlName=\"authProtocol\" [lvOptions]='authProtocolOptions' lvValueKey='value'\n                        [lvDisabled]=\"item.deviceSn && !formGroup.value.alarmInfo\">\n                    </lv-select>\n                </lv-form-control>\n            </lv-form-item>\n            <lv-form-item>\n                <lv-form-label>{{'vrg_term_encrypt_protocol_label' | i18n}}</lv-form-label>\n                <lv-form-control>\n                    <lv-select formControlName=\"encryptProtocol\" [lvOptions]='encryptProtocolOptions' lvValueKey='value'\n                        [lvDisabled]=\"formGroup.value.authProtocol === dataMap.authProtocol.none.value || (item.deviceSn && !formGroup.value.alarmInfo)\">\n                    </lv-select>\n                </lv-form-control>\n            </lv-form-item>\n        </lv-form-column>\n        <lv-form-column>\n            <lv-form-item>\n                <lv-form-label [lvRequired]=\"item.deviceSn && formGroup.value.alarmInfo\">{{'vrg_term_timeout_label' |\n                    i18n}}</lv-form-label>\n                <lv-form-control>\n                    <lv-group lvGutter='8px'>\n                        <lv-spinner formControlName=\"timeout\" lvMax=\"5\" lvMin=\"0\" class=\"alarm-spinner\"\n                            [lvDisabled]=\"item.deviceSn && !formGroup.value.alarmInfo\"></lv-spinner>\n                        <span>(0-5)</span>\n                    </lv-group>\n                </lv-form-control>\n            </lv-form-item>\n            <lv-form-item>\n                <lv-form-label [lvRequired]=\"(item.deviceSn && formGroup.value.alarmInfo) || !item.deviceSn\">\n                    {{'common_term_username_label' | i18n}}\n                </lv-form-label>\n                <lv-form-control [lvErrorTip]=\"errorTip\">\n                    <input formControlName=\"alarmUsername\" lv-input\n                        [attr.disabled]=\"item.deviceSn && !formGroup.value.alarmInfo ? '' : null\" />\n                </lv-form-control>\n            </lv-form-item>\n            <lv-form-item>\n                <lv-form-label>{{'vrg_term_engine_label' | i18n}}</lv-form-label>\n                <lv-form-control>\n                    <input formControlName=\"engine\" lv-input [attr.disabled]=\"''\" />\n                </lv-form-control>\n            </lv-form-item>\n            <lv-form-item>\n                <lv-form-label [lvRequired]=\"formGroup.value.authProtocol !== dataMap.authProtocol.none.value\">\n                    {{'vrg_term_auth_pwd_label' | i18n}}</lv-form-label>\n                <lv-form-control [lvErrorTip]=\"errorTip\">\n                    <input formControlName=\"authPwd\" type=\"password\" lv-input\n                        [attr.disabled]=\"formGroup.value.authProtocol === dataMap.authProtocol.none.value || (item.deviceSn && !formGroup.value.alarmInfo) ? '' : null\" />\n                </lv-form-control>\n            </lv-form-item>\n            <lv-form-item>\n                <lv-form-label\n                    [lvRequired]=\"formGroup.value.authProtocol !== dataMap.authProtocol.none.value && formGroup.value.encryptProtocol !== dataMap.encryptProtocol.none.value\">\n                    {{'vrg_term_encrypt_pwd_label' | i18n}}</lv-form-label>\n                <lv-form-control [lvErrorTip]=\"errorTip\">\n                    <input formControlName=\"encryptPwd\" type=\"password\" lv-input\n                        [attr.disabled]=\"formGroup.value.authProtocol === dataMap.authProtocol.none.value || formGroup.value.encryptProtocol === dataMap.encryptProtocol.none.value || (item.deviceSn && !formGroup.value.alarmInfo) ? '' : null\" />\n                </lv-form-control>\n            </lv-form-item>\n        </lv-form-column>\n    </lv-group>\n</lv-form>");

/***/ }),

/***/ "./src/app/business/resource/discovery/host-alarm-set/host-alarm-set.component.less":
/*!******************************************************************************************!*\
  !*** ./src/app/business/resource/discovery/host-alarm-set/host-alarm-set.component.less ***!
  \******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (".alarm-group {\n  align-items: flex-end;\n}\n.alarm-group .lv-input,\n.alarm-group .lv-select {\n  width: 2.5rem;\n}\n.alarm-spinner {\n  width: 2.5rem;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi91c3IxL3dvcmtzcGFjZS9DTUNfUGFja2FnZV9FdWxlci9TZXJ2ZXIvc3JjL1dlYlVJL1RpbnlfdG9fTGl2ZVVJL3NyYy9hcHAvYnVzaW5lc3MvcmVzb3VyY2UvZGlzY292ZXJ5L2hvc3QtYWxhcm0tc2V0L2hvc3QtYWxhcm0tc2V0LmNvbXBvbmVudC5sZXNzIiwic3JjL2FwcC9idXNpbmVzcy9yZXNvdXJjZS9kaXNjb3ZlcnkvaG9zdC1hbGFybS1zZXQvaG9zdC1hbGFybS1zZXQuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDRSxxQkFBQTtBQ0NGO0FEQ0E7O0VBRUUsYUFBQTtBQ0NGO0FEQ0E7RUFDRSxhQUFBO0FDQ0YiLCJmaWxlIjoic3JjL2FwcC9idXNpbmVzcy9yZXNvdXJjZS9kaXNjb3ZlcnkvaG9zdC1hbGFybS1zZXQvaG9zdC1hbGFybS1zZXQuY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuYWxhcm0tZ3JvdXAge1xuICBhbGlnbi1pdGVtczogZmxleC1lbmQ7XG59XG4uYWxhcm0tZ3JvdXAgLmx2LWlucHV0LFxuLmFsYXJtLWdyb3VwIC5sdi1zZWxlY3Qge1xuICB3aWR0aDogMi41cmVtO1xufVxuLmFsYXJtLXNwaW5uZXIge1xuICB3aWR0aDogMi41cmVtO1xufVxuIiwiLmFsYXJtLWdyb3VwIHtcbiAgYWxpZ24taXRlbXM6IGZsZXgtZW5kO1xufVxuLmFsYXJtLWdyb3VwIC5sdi1pbnB1dCxcbi5hbGFybS1ncm91cCAubHYtc2VsZWN0IHtcbiAgd2lkdGg6IDIuNXJlbTtcbn1cbi5hbGFybS1zcGlubmVyIHtcbiAgd2lkdGg6IDIuNXJlbTtcbn1cbiJdfQ== */");

/***/ }),

/***/ "./src/app/business/resource/discovery/host-alarm-set/host-alarm-set.component.ts":
/*!****************************************************************************************!*\
  !*** ./src/app/business/resource/discovery/host-alarm-set/host-alarm-set.component.ts ***!
  \****************************************************************************************/
/*! exports provided: HostAlarmSetComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HostAlarmSetComponent", function() { return HostAlarmSetComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/__ivy_ngcc__/fesm2015/forms.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @shared */ "./src/app/shared/index.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_4__);





var HostAlarmSetComponent = /** @class */ (function () {
    function HostAlarmSetComponent(fb, i18n, dataMapService, baseUtilService) {
        this.fb = fb;
        this.i18n = i18n;
        this.dataMapService = dataMapService;
        this.baseUtilService = baseUtilService;
        this.typeOptions = [
            {
                label: 'SNMPv3',
                value: 'SNMPv3',
                key: 'SNMPv3',
                isLeaf: true
            }
        ];
        this.dataMap = _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"];
        this.authProtocolOptions = this.dataMapService.toArray('authProtocol').filter(function (item) { return (item.isLeaf = true); });
        this.encryptProtocolOptions = this.dataMapService
            .toArray('encryptProtocol')
            .filter(function (item) { return (item.isLeaf = true); });
        this.envErrorTip = {
            invalidMinLength: this.i18n.get('validate_term_common_length_range_0_64_msg'),
            invalidMaxLength: this.i18n.get('validate_term_common_length_range_0_64_msg')
        };
        this.errorTip = {
            required: this.i18n.get('common_required_label'),
            invalidMinLength: this.i18n.get('validate_term_common_length_range_1_64_msg'),
            invalidMaxLength: this.i18n.get('validate_term_common_length_range_1_64_msg')
        };
    }
    HostAlarmSetComponent.prototype.ngOnChanges = function (changes) {
        if (changes.item.previousValue) {
            this.initSetting();
        }
    };
    HostAlarmSetComponent.prototype.ngOnInit = function () {
        this.initForm();
        this.initSetting();
    };
    HostAlarmSetComponent.prototype.initForm = function () {
        var _this = this;
        var _a, _b;
        if (this.formGroup) {
            this.formGroup.addControl('type', new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('SNMPv3'));
            this.formGroup.addControl('count', new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](3));
            this.formGroup.addControl('alarmPort', new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](161));
            this.formGroup.addControl('env', new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](''));
            this.formGroup.addControl('authProtocol', new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](_shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].authProtocol.hmacsha2.value));
            this.formGroup.addControl('encryptProtocol', new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](_shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].encryptProtocol.aes.value));
            this.formGroup.addControl('timeout', new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](5));
            this.formGroup.addControl('alarmUsername', new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('rdadmin'));
            this.formGroup.addControl('engine', new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](''));
            this.formGroup.addControl('encryptPwd', new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](''));
            this.formGroup.addControl('authPwd', new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](''));
        }
        else {
            this.formGroup = this.fb.group({
                type: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('SNMPv3'),
                count: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](3),
                alarmPort: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](161),
                env: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('', {
                    validators: [this.baseUtilService.VALID.minLength(0), this.baseUtilService.VALID.maxLength(64)]
                }),
                authProtocol: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](_shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].authProtocol.hmacsha2.value),
                encryptProtocol: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](_shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].encryptProtocol.aes.value),
                timeout: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](5),
                alarmUsername: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('rdadmin', {
                    validators: [
                        this.baseUtilService.VALID.required(),
                        this.baseUtilService.VALID.minLength(1),
                        this.baseUtilService.VALID.maxLength(64)
                    ]
                }),
                engine: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](''),
                encryptPwd: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('', {
                    validators: [
                        this.baseUtilService.VALID.required(),
                        this.baseUtilService.VALID.minLength(1),
                        this.baseUtilService.VALID.maxLength(64)
                    ]
                }),
                authPwd: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('', {
                    validators: [
                        this.baseUtilService.VALID.required(),
                        this.baseUtilService.VALID.minLength(1),
                        this.baseUtilService.VALID.maxLength(64)
                    ]
                })
            });
        }
        // 校验
        (_a = this.formGroup.get('authProtocol')) === null || _a === void 0 ? void 0 : _a.valueChanges.subscribe(function (res) {
            var _a, _b, _c, _d, _e, _f, _g;
            // 主机修改不启用
            if (_this.item.deviceSn && !_this.formGroup.value.alarmInfo) {
                return;
            }
            if (res === _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].authProtocol.none.value) {
                (_a = _this.formGroup.get('encryptPwd')) === null || _a === void 0 ? void 0 : _a.clearValidators();
                (_b = _this.formGroup.get('authPwd')) === null || _b === void 0 ? void 0 : _b.clearValidators();
            }
            else {
                (_c = _this.formGroup
                    .get('authPwd')) === null || _c === void 0 ? void 0 : _c.setValidators([
                    _this.baseUtilService.VALID.required(),
                    _this.baseUtilService.VALID.minLength(1),
                    _this.baseUtilService.VALID.maxLength(64)
                ]);
                if (_this.formGroup.value.encryptProtocol !== _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].encryptProtocol.none.value) {
                    (_d = _this.formGroup
                        .get('encryptPwd')) === null || _d === void 0 ? void 0 : _d.setValidators([
                        _this.baseUtilService.VALID.required(),
                        _this.baseUtilService.VALID.minLength(1),
                        _this.baseUtilService.VALID.maxLength(64)
                    ]);
                }
                else {
                    (_e = _this.formGroup.get('encryptPwd')) === null || _e === void 0 ? void 0 : _e.clearValidators();
                }
            }
            (_f = _this.formGroup.get('encryptPwd')) === null || _f === void 0 ? void 0 : _f.updateValueAndValidity();
            (_g = _this.formGroup.get('authPwd')) === null || _g === void 0 ? void 0 : _g.updateValueAndValidity();
        });
        (_b = this.formGroup.get('encryptProtocol')) === null || _b === void 0 ? void 0 : _b.valueChanges.subscribe(function (res) {
            var _a, _b, _c;
            // 主机修改不启用
            if (_this.item.deviceSn && !_this.formGroup.value.alarmInfo) {
                return;
            }
            if (res === _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].encryptProtocol.none.value) {
                (_a = _this.formGroup.get('encryptPwd')) === null || _a === void 0 ? void 0 : _a.clearValidators();
            }
            else {
                (_b = _this.formGroup
                    .get('encryptPwd')) === null || _b === void 0 ? void 0 : _b.setValidators([
                    _this.baseUtilService.VALID.required(),
                    _this.baseUtilService.VALID.minLength(1),
                    _this.baseUtilService.VALID.maxLength(64)
                ]);
            }
            (_c = _this.formGroup.get('encryptPwd')) === null || _c === void 0 ? void 0 : _c.updateValueAndValidity();
        });
    };
    HostAlarmSetComponent.prototype.initSetting = function () {
        if (!this.item.alarmSetting || Object(lodash__WEBPACK_IMPORTED_MODULE_4__["isEmpty"])(this.item.alarm)) {
            return;
        }
        this.formGroup.patchValue({
            type: this.item.alarm.snmpVersion,
            count: this.item.alarm.snmpRetries,
            alarmPort: this.item.alarm.snmpPort,
            env: this.item.alarm.snmpContextName,
            authProtocol: this.item.alarm.snmpAuthProtocol || _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].authProtocol.none.value,
            encryptProtocol: this.item.alarm.snmpEncryptProtocol || _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].encryptProtocol.none.value,
            timeout: this.item.alarm.snmpTimeout,
            alarmUsername: this.item.alarm.snmpSecurityName,
            engine: this.item.alarm.snmpContextEngineId,
            encryptPwd: this.item.alarm.snmpEncryptPwd || '',
            authPwd: this.item.alarm.snmpAuthPwd || ''
        });
    };
    HostAlarmSetComponent.prototype.onOK = function () {
        var snmpv3ParamMap = {
            snmpVersion: this.formGroup.value.type,
            snmpRetries: this.formGroup.value.count,
            snmpTimeout: this.formGroup.value.timeout,
            snmpPort: this.formGroup.value.alarmPort,
            snmpSecurityName: this.formGroup.value.alarmUsername,
            snmpContextName: this.formGroup.value.env,
            snmpContextEngineId: this.formGroup.value.engine,
            snmpAuthProtocol: this.formGroup.value.authProtocol === _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].authProtocol.none.value ? '' : this.formGroup.value.authProtocol
        };
        if (this.formGroup.value.authProtocol !== _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].authProtocol.none.value) {
            Object(lodash__WEBPACK_IMPORTED_MODULE_4__["assign"])(snmpv3ParamMap, {
                snmpAuthPwd: this.formGroup.value.authPwd,
                snmpEncryptProtocol: this.formGroup.value.encryptProtocol === _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].encryptProtocol.none.value
                    ? ''
                    : this.formGroup.value.encryptProtocol
            });
            if (this.formGroup.value.encryptProtocol !== _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].encryptProtocol.none.value) {
                Object(lodash__WEBPACK_IMPORTED_MODULE_4__["assign"])(snmpv3ParamMap, {
                    snmpEncryptPwd: this.formGroup.value.encryptPwd
                });
            }
        }
        return snmpv3ParamMap;
    };
    HostAlarmSetComponent.ctorParameters = function () { return [
        { type: _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormBuilder"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["I18NService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["DataMapService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["BaseUtilService"] }
    ]; };
    HostAlarmSetComponent.propDecorators = {
        item: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"] }],
        formGroup: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"] }]
    };
    HostAlarmSetComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'lvs-host-alarm-set',
            template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./host-alarm-set.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/resource/discovery/host-alarm-set/host-alarm-set.component.html")).default,
            styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./host-alarm-set.component.less */ "./src/app/business/resource/discovery/host-alarm-set/host-alarm-set.component.less")).default]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormBuilder"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["I18NService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["DataMapService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["BaseUtilService"]])
    ], HostAlarmSetComponent);
    return HostAlarmSetComponent;
}());



/***/ }),

/***/ "./src/app/business/resource/discovery/host-alarm-set/host-alarm-set.module.ts":
/*!*************************************************************************************!*\
  !*** ./src/app/business/resource/discovery/host-alarm-set/host-alarm-set.module.ts ***!
  \*************************************************************************************/
/*! exports provided: HostAlarmSetModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HostAlarmSetModule", function() { return HostAlarmSetModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/__ivy_ngcc__/fesm2015/common.js");
/* harmony import */ var _shared_shared_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @shared/shared.module */ "./src/app/shared/shared.module.ts");
/* harmony import */ var _host_alarm_set_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./host-alarm-set.component */ "./src/app/business/resource/discovery/host-alarm-set/host-alarm-set.component.ts");





var HostAlarmSetModule = /** @class */ (function () {
    function HostAlarmSetModule() {
    }
    HostAlarmSetModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            declarations: [_host_alarm_set_component__WEBPACK_IMPORTED_MODULE_4__["HostAlarmSetComponent"]],
            imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__["CommonModule"], _shared_shared_module__WEBPACK_IMPORTED_MODULE_3__["SharedModule"]],
            exports: [_host_alarm_set_component__WEBPACK_IMPORTED_MODULE_4__["HostAlarmSetComponent"]]
        })
    ], HostAlarmSetModule);
    return HostAlarmSetModule;
}());



/***/ })

}]);
//# sourceMappingURL=default~discovery-discovery-module~host-list-host-list-module.js.map