(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["notification-server-notification-server-module"],{

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/notification-server/email-server/email-server.component.html":
/*!*********************************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/notification-server/email-server/email-server.component.html ***!
  \*********************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class=\"aui-header-2 aui-gutter-column-md\">\n  <h2>{{ 'set_email_server_label' | i18n }}</h2>\n  <div>\n    <a (click)=\"testData()\" *ngIf=\"!isView\"\n      [ngClass]=\"{ 'aui-link': formGroup.valid, 'aui-link-disabled': formGroup.invalid }\">\n      {{ 'common_test_label' | i18n }}\n    </a>\n    <a (click)=\"saveData()\" *ngIf=\"!isView\"\n      [ngClass]=\"{ 'aui-link': formGroup.valid, 'aui-link-disabled': formGroup.invalid }\">\n      {{ 'common_save_label' | i18n }}\n    </a>\n    <a (click)=\"cancelData()\" *ngIf=\"!isView\" class=\"aui-link\">\n      {{ 'common_cancel_label' | i18n }}\n    </a>\n    <a (click)=\"modifyData()\" *ngIf=\"isView && securityRightService.checkRight('lego.sys.serverEdit')\" class=\"aui-link\">\n      {{ 'common_modify_label' | i18n }}\n    </a>\n  </div>\n</div>\n<div class=\"dashed-split-line\"></div>\n<div *ngIf=\"!isView\">\n  <lv-form [formGroup]=\"formGroup\">\n    <lv-form-item>\n      <lv-form-label lvRequired>{{ 'set_smtp_server_label' | i18n }}</lv-form-label>\n      <lv-form-control [lvErrorTip]=\"invalidIpErrorTip\">\n        <input formControlName=\"server\" type=\"text\" (ngModelChange)=\"listenServer($event)\" lv-input/>\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label lvRequired>{{ 'set_server_port_label' | i18n }}</lv-form-label>\n      <lv-form-control [lvErrorTip]=\"invalidPortErrorTip\">\n        <input formControlName=\"port\" type=\"number\" lv-input />\n        <lv-tooltip class=\"tips\">(1-65535)</lv-tooltip>\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label lvRequired>{{ 'set_addressor_email_label' | i18n }}</lv-form-label>\n      <lv-form-control [lvErrorTip]=\"invalidEmailErrorTip\">\n        <input formControlName=\"emailFrom\" type=\"text\" (blur)=\"emailBlur()\" (focus)=\"emailFocus()\" lv-input />\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label>{{ 'set_test_email_label' | i18n }}</lv-form-label>\n      <lv-form-control [lvErrorTip]=\"invalidEmailErrorTip\">\n        <input formControlName=\"testEmail\" type=\"text\" (blur)=\"testEmailBlur()\" (focus)=\"testEmailFocus()\" lv-input />\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label>{{ 'set_encryption_label' | i18n }}</lv-form-label>\n      <lv-form-control>\n        <lv-select lvValueKey=\"label\" formControlName=\"encryption\" [lvOptions]=\"encryptionTypeOptions\"\n          (lvOpenChange)=\"onEncryptionTypeChange()\"></lv-select>\n        <ng-container *ngIf=\"formGroup.value.encryption === 'TLS'\">\n          <lv-group lvGutter='4px' class=\"mgt-10\">\n            <i lv-icon=\"lv-icon-status-warning-info\"></i>\n            <span class=\"aui-text-label\">\n              {{'server_term_securityssl_tls_icontip' | i18n}}\n            </span>\n          </lv-group>\n        </ng-container>\n        <ng-container *ngIf=\"formGroup.value.encryption !== 'TLS'\">\n          <lv-group lvGutter='4px' class=\"mgt-10\">\n            <i lv-icon=\"lv-icon-status-warning-info\"></i>\n            <span class=\"aui-text-label\">\n              {{'set_email_server_warnning_label' | i18n:[formGroup.value.encryption]}}\n            </span>\n          </lv-group>\n        </ng-container>\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label [lvRequired]=\"isSslSmtpPortEnable\">{{ 'set_ssl_port_label' | i18n }}</lv-form-label>\n      <lv-form-control [lvErrorTip]=\"invalidPortErrorTip\">\n        <input formControlName=\"sslSmtpPort\" type=\"number\" lv-input />\n        <lv-tooltip class=\"tips\" *ngIf=\"isSslSmtpPortEnable\">(1-65535)</lv-tooltip>\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label>{{ 'set_smtp_identity_authentication_label' | i18n }}</lv-form-label>\n      <lv-form-control>\n        <lv-switch formControlName=\"isValidateEnable\" style=\"margin: 6px 8px;\" [lvDisabled]=\"needValidate\"\n          (ngModelChange)=\"isValidateEnable($event)\"></lv-switch>\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label [lvRequired]=\"formGroup.value.isValidateEnable\">{{ 'common_username_label' | i18n }}\n      </lv-form-label>\n      <lv-form-control [lvErrorTip]=\"invalidUserNameErrorTip\">\n        <input formControlName=\"userName\" type=\"text\" lv-input />\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label [lvRequired]=\"formGroup.value.isValidateEnable\">{{ 'common_password_label' | i18n }}\n      </lv-form-label>\n      <lv-form-control [lvErrorTip]=\"invalidPassWordErrorTip\">\n        <input formControlName=\"password\" type=\"password\" lv-input />\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label>{{ 'set_proxy_server_label' | i18n }}</lv-form-label>\n      <lv-form-control>\n        <lv-switch formControlName=\"isProxyEnable\" style=\"margin: 6px 8px;\" (ngModelChange)=\"isProxyEnable($event)\">\n        </lv-switch>\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label [lvRequired]=\"formGroup.value.isProxyEnable\">{{ 'common_ip_addr_label' | i18n }}</lv-form-label>\n      <lv-form-control>\n        <lv-form-control [lvErrorTip]=\"invalidIpErrorTip\">\n          <input formControlName=\"proxyServer\" type=\"text\" lv-input />\n        </lv-form-control>\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label [lvRequired]=\"formGroup.value.isProxyEnable\">{{ 'common_port_label' | i18n }}</lv-form-label>\n      <lv-form-control [lvErrorTip]=\"invalidPortErrorTip\">\n        <input formControlName=\"proxyPort\" type=\"number\" lv-input />\n        <lv-tooltip class=\"tips\" *ngIf=\"formGroup.value.isProxyEnable\">(1-65535)</lv-tooltip>\n      </lv-form-control>\n    </lv-form-item>\n  </lv-form>\n</div>\n<div *ngIf=\"isView\">\n  <lv-form>\n    <ng-container *ngFor=\"let item of formItems\">\n      <lv-form-item>\n        <lv-form-label>{{ item.label | i18n }}</lv-form-label>\n        <lv-form-control [ngSwitch]=\"item.key\">\n          <ng-container *ngSwitchCase=\"'proxyServer'\">\n            {{ (formGroup.value.isProxyEnable ? item.value : null) | nil }}\n          </ng-container>\n          <ng-container *ngSwitchDefault>\n            {{ item.value | nil }}\n          </ng-container>\n        </lv-form-control>\n      </lv-form-item>\n    </ng-container>\n  </lv-form>\n</div>");

/***/ }),

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/notification-server/message-server/message-server.component.html":
/*!*************************************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/notification-server/message-server/message-server.component.html ***!
  \*************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class=\"aui-header-2 aui-gutter-column-md\">\n  <h2>{{ 'set_message_server_label' | i18n }}</h2>\n  <div>\n    <a (click)=\"testData()\" *ngIf=\"!isView\"\n      [ngClass]=\"{ 'aui-link': formGroup.valid, 'aui-link-disabled': formGroup.invalid }\">\n      {{ 'common_test_label' | i18n }}\n    </a>\n    <a (click)=\"saveData()\" *ngIf=\"!isView\"\n      [ngClass]=\"{ 'aui-link': formGroup.valid, 'aui-link-disabled': formGroup.invalid }\">\n      {{ 'common_save_label' | i18n }}\n    </a>\n    <a (click)=\"cancelData()\" *ngIf=\"!isView\" class=\"aui-link\">\n      {{ 'common_cancel_label' | i18n }}\n    </a>\n    <a (click)=\"modifyData()\" *ngIf=\"isView && securityRightService.checkRight('lego.sys.serverEdit')\" class=\"aui-link\">\n      {{ 'common_modify_label' | i18n }}\n    </a>\n  </div>\n</div>\n<div class=\"dashed-split-line\"></div>\n<div *ngIf=\"!isView\">\n  <lv-form [formGroup]=\"formGroup\">\n    <lv-form-item>\n      <lv-form-label lvRequired>{{ 'set_port_name_label' | i18n }}</lv-form-label>\n      <lv-form-control [lvErrorTip]=\"portNameErrorTip\">\n        <input formControlName=\"portName\" lv-input class=\"spinner\" />\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label>{{ 'set_baud_rate_label' | i18n }}</lv-form-label>\n      <lv-form-control>\n        <lv-select formControlName=\"baudRate\" [lvOptions]=\"baudRateOptions\" lvValueKey=\"label\" class=\"spinner\">\n        </lv-select>\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label lvRequired>{{ 'set_country_code_label' | i18n }}</lv-form-label>\n      <lv-form-control [lvErrorTip]=\"countryCodeErrorTip\">\n        <input formControlName=\"countryCode\" lv-input class=\"spinner\" />\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label>{{ 'set_test_number_label' | i18n }}</lv-form-label>\n      <lv-form-control [lvErrorTip]=\"telErrorTip\">\n        <input formControlName=\"testModemPhone\" lv-input class=\"spinner\" (blur)=\"phoneBlur()\"\n          (focus)=\"phoneFocus()\" />\n      </lv-form-control>\n    </lv-form-item>\n  </lv-form>\n</div>\n<div *ngIf=\"isView\">\n  <lv-form>\n    <ng-container *ngFor=\"let item of formItems\">\n      <lv-form-item>\n        <lv-form-label>{{ item.label | i18n }}</lv-form-label>\n        <lv-form-control>\n          {{ item.value | nil }}\n        </lv-form-control>\n      </lv-form-item>\n    </ng-container>\n  </lv-form>\n</div>");

/***/ }),

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/notification-server/notification-server.component.html":
/*!***************************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/notification-server/notification-server.component.html ***!
  \***************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class=\"aui-fullpage\">\n  <div class=\"aui-header-1\">\n    <h1>{{ 'common_notification_label' | i18n }}</h1>\n  </div>\n  <div class=\"flex-row\">\n    <div class=\"aui-block aui-gutter-row-md\">\n      <lvs-email-server></lvs-email-server>\n    </div>\n    <div class=\"aui-block\">\n      <lvs-message-server></lvs-message-server>\n    </div>\n  </div>\n</div>\n");

/***/ }),

/***/ "./src/app/business/set/notification-server/email-server/email-server.component.less":
/*!*******************************************************************************************!*\
  !*** ./src/app/business/set/notification-server/email-server/email-server.component.less ***!
  \*******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (".spinner {\n  width: 320px;\n}\n.tag {\n  margin-bottom: 20px;\n}\n.tips {\n  margin-left: 8px;\n  height: 32px;\n  line-height: 32px;\n}\n.button {\n  margin: 20px 0 20px 170px;\n}\nbutton /deep/ .lv-icon-host {\n  float: right;\n}\n.icon {\n  height: 32px;\n  margin: 0 12px;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi91c3IxL3dvcmtzcGFjZS9DTUNfUGFja2FnZV9FdWxlci9TZXJ2ZXIvc3JjL1dlYlVJL1RpbnlfdG9fTGl2ZVVJL3NyYy9hcHAvYnVzaW5lc3Mvc2V0L25vdGlmaWNhdGlvbi1zZXJ2ZXIvZW1haWwtc2VydmVyL2VtYWlsLXNlcnZlci5jb21wb25lbnQubGVzcyIsInNyYy9hcHAvYnVzaW5lc3Mvc2V0L25vdGlmaWNhdGlvbi1zZXJ2ZXIvZW1haWwtc2VydmVyL2VtYWlsLXNlcnZlci5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNFLFlBQUE7QUNDRjtBREVBO0VBQ0UsbUJBQUE7QUNBRjtBREdBO0VBQ0UsZ0JBQUE7RUFDQSxZQUFBO0VBQ0EsaUJBQUE7QUNERjtBRElBO0VBQ0UseUJBQUE7QUNGRjtBREtBO0VBRUksWUFBQTtBQ0pKO0FEUUE7RUFDRSxZQUFBO0VBQ0EsY0FBQTtBQ05GIiwiZmlsZSI6InNyYy9hcHAvYnVzaW5lc3Mvc2V0L25vdGlmaWNhdGlvbi1zZXJ2ZXIvZW1haWwtc2VydmVyL2VtYWlsLXNlcnZlci5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIi5zcGlubmVyIHtcbiAgd2lkdGg6IDMyMHB4O1xufVxuXG4udGFnIHtcbiAgbWFyZ2luLWJvdHRvbTogMjBweDtcbn1cblxuLnRpcHMge1xuICBtYXJnaW4tbGVmdDogOHB4O1xuICBoZWlnaHQ6IDMycHg7XG4gIGxpbmUtaGVpZ2h0OiAzMnB4O1xufVxuXG4uYnV0dG9uIHtcbiAgbWFyZ2luOiAyMHB4IDAgMjBweCAxNzBweDtcbn1cblxuYnV0dG9uIHtcbiAgL2RlZXAvIC5sdi1pY29uLWhvc3Qge1xuICAgIGZsb2F0OiByaWdodDtcbiAgfVxufVxuXG4uaWNvbiB7XG4gIGhlaWdodDogMzJweDtcbiAgbWFyZ2luOiAwIDEycHg7XG59XG4iLCIuc3Bpbm5lciB7XG4gIHdpZHRoOiAzMjBweDtcbn1cbi50YWcge1xuICBtYXJnaW4tYm90dG9tOiAyMHB4O1xufVxuLnRpcHMge1xuICBtYXJnaW4tbGVmdDogOHB4O1xuICBoZWlnaHQ6IDMycHg7XG4gIGxpbmUtaGVpZ2h0OiAzMnB4O1xufVxuLmJ1dHRvbiB7XG4gIG1hcmdpbjogMjBweCAwIDIwcHggMTcwcHg7XG59XG5idXR0b24gL2RlZXAvIC5sdi1pY29uLWhvc3Qge1xuICBmbG9hdDogcmlnaHQ7XG59XG4uaWNvbiB7XG4gIGhlaWdodDogMzJweDtcbiAgbWFyZ2luOiAwIDEycHg7XG59XG4iXX0= */");

/***/ }),

/***/ "./src/app/business/set/notification-server/email-server/email-server.component.ts":
/*!*****************************************************************************************!*\
  !*** ./src/app/business/set/notification-server/email-server/email-server.component.ts ***!
  \*****************************************************************************************/
/*! exports provided: EmailServerComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EmailServerComponent", function() { return EmailServerComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _iux_live__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @iux/live */ "./node_modules/@iux/live/__ivy_ngcc__/fesm2015/iux-live.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/__ivy_ngcc__/fesm2015/forms.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @shared */ "./src/app/shared/index.ts");






var EmailServerComponent = /** @class */ (function () {
    function EmailServerComponent(fb, i18n, baseUtil, utilsService, messageBox, dataMapService, systemApiService, securityRightService) {
        this.fb = fb;
        this.i18n = i18n;
        this.baseUtil = baseUtil;
        this.utilsService = utilsService;
        this.messageBox = messageBox;
        this.dataMapService = dataMapService;
        this.systemApiService = systemApiService;
        this.securityRightService = securityRightService;
        this.isView = true;
        this.isSslSmtpPortEnable = false;
        this.needValidate = false;
        this.formItems = [
            {
                key: 'server',
                label: this.i18n.get('set_smtp_server_label'),
                value: '90'
            },
            {
                key: 'port',
                label: this.i18n.get('set_server_port_label'),
                value: '90'
            },
            {
                key: 'emailFrom',
                label: this.i18n.get('set_addressor_email_label'),
                value: '90'
            },
            {
                key: 'testEmail',
                label: this.i18n.get('set_test_email_label'),
                value: '90'
            },
            {
                key: 'encryption',
                label: this.i18n.get('set_encryption_label'),
                value: '2'
            },
            {
                key: 'sslSmtpPort',
                label: this.i18n.get('set_ssl_port_label'),
                value: '1'
            },
            {
                key: 'isValidateEnable',
                label: this.i18n.get('set_smtp_identity_authentication_label'),
                value: '1'
            },
            {
                key: 'userName',
                label: this.i18n.get('common_username_label'),
                value: '1'
            },
            {
                key: 'password',
                label: this.i18n.get('common_password_label'),
                value: '1'
            },
            {
                key: 'isProxyEnable',
                label: this.i18n.get('set_proxy_server_label'),
                value: '1'
            },
            {
                key: 'proxyServer',
                label: this.i18n.get('common_ip_addr_label'),
                value: '1'
            },
            {
                key: 'proxyPort',
                label: this.i18n.get('common_port_label'),
                value: '1'
            }
        ];
        this.encryptionTypeOptions = [
            { label: 'TLS', isLeaf: true },
            { label: 'SSL', isLeaf: true },
            { label: this.i18n.get('set_not_encryption_label'), isLeaf: true }
        ];
        this.invalidIpErrorTip = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.baseUtil.requiredErrorTip), this.baseUtil.ipErrorTip);
        this.invalidPortErrorTip = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.baseUtil.requiredErrorTip), { invalidInput: this.i18n.get('common_invalid_input_label'), invalidRang: this.i18n.get('common_valid_rang_label', [1, 65535]) });
        this.invalidEmailErrorTip = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.baseUtil.emailErrorTip);
        this.invalidUserNameErrorTip = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.baseUtil.requiredErrorTip), { invalidName: this.i18n.get('set_port_name_tip_label'), invalidMaxLength: this.i18n.get('common_valid_maxlength_label', [32]) });
        this.invalidPassWordErrorTip = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.baseUtil.requiredErrorTip), { invalidMaxLength: this.i18n.get('common_valid_maxlength_label', [32]) });
    }
    EmailServerComponent.prototype.ngOnInit = function () {
        this.initForm();
        this.getData();
    };
    EmailServerComponent.prototype.saveData = function () {
        var _this = this;
        var params = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.formGroup.value);
        Object(lodash__WEBPACK_IMPORTED_MODULE_2__["assign"])(params, {
            emailFrom: this.originalEmailFrom,
            testEmail: this.originalTestEmail
        });
        Reflect.deleteProperty(params, 'encryption');
        if (this.formGroup.value.encryption === 'SSL') {
            params.protocol = '1';
            params.isSSLEnable = true;
            params.isTLSEnable = false;
        }
        else if (this.formGroup.value.encryption === 'TLS') {
            params.protocol = '2';
            params.isSSLEnable = false;
            params.isTLSEnable = true;
        }
        else {
            params.protocol = '0';
            params.isSSLEnable = false;
            params.isTLSEnable = false;
        }
        this.systemApiService.UpdateEmailServer({ email: params }).subscribe(function () {
            _this.cancelData();
        });
    };
    EmailServerComponent.prototype.modifyData = function () {
        this.cancelData();
    };
    EmailServerComponent.prototype.cancelData = function () {
        this.originalEmailFrom = '';
        this.originalTestEmail = '';
        this.getData();
        this.isView = !this.isView;
    };
    EmailServerComponent.prototype.initForm = function () {
        var userNameReg = /^[^\#\&\’\‘\'\”\“\<\>\"]+$/;
        this.formGroup = this.fb.group({
            server: new _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormControl"]('', [this.baseUtil.VALID.required(), this.baseUtil.VALID._ipWithMulticast()]),
            port: new _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormControl"]('', [
                this.baseUtil.VALID.required(),
                this.baseUtil.VALID.rangeValue(1, 65535),
                this.baseUtil.VALID.integer()
            ]),
            emailFrom: new _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormControl"]('', [
                this.baseUtil.VALID.required(),
                this.baseUtil.VALID.maxLength(254),
                this.baseUtil.VALID.email()
            ]),
            testEmail: new _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormControl"]('', [this.baseUtil.VALID.maxLength(254), this.baseUtil.VALID.email()]),
            encryption: new _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormControl"](),
            sslSmtpPort: new _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormControl"]('', [
                this.baseUtil.VALID.required(),
                this.baseUtil.VALID.rangeValue(1, 65535),
                this.baseUtil.VALID.integer()
            ]),
            isValidateEnable: new _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormControl"](false),
            userName: new _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormControl"]('', [
                this.baseUtil.VALID.required(),
                this.baseUtil.VALID.maxLength(32),
                this.baseUtil.VALID.name(userNameReg, false)
            ]),
            password: new _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormControl"]('', [this.baseUtil.VALID.required(), this.baseUtil.VALID.maxLength(32)]),
            isProxyEnable: new _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormControl"](false),
            proxyServer: new _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormControl"]('', [this.baseUtil.VALID.required(), this.baseUtil.VALID._ipWithMulticast()]),
            proxyPort: new _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormControl"]('', [
                this.baseUtil.VALID.required(),
                this.baseUtil.VALID.rangeValue(1, 65535),
                this.baseUtil.VALID.integer()
            ])
        });
    };
    EmailServerComponent.prototype.listenServer = function (res) {
        var _a, _b;
        if (res && res !== this.originalServer) {
            (_a = this.formGroup.get('isValidateEnable')) === null || _a === void 0 ? void 0 : _a.setValue(true);
            this.needValidate = true;
        }
        else {
            (_b = this.formGroup.get('isValidateEnable')) === null || _b === void 0 ? void 0 : _b.setValue(false);
            this.needValidate = false;
        }
    };
    EmailServerComponent.prototype.emailBlur = function () {
        var _a;
        if (this.formGroup.controls.emailFrom.status !== 'VALID') {
            return;
        }
        this.originalEmailFrom = this.formGroup.value.emailFrom;
        (_a = this.formGroup.get('emailFrom')) === null || _a === void 0 ? void 0 : _a.setValue(this.utilsService.maskEmail(this.originalEmailFrom));
    };
    EmailServerComponent.prototype.emailFocus = function () {
        var _a;
        if (this.originalEmailFrom) {
            (_a = this.formGroup.get('emailFrom')) === null || _a === void 0 ? void 0 : _a.setValue(this.originalEmailFrom);
        }
    };
    EmailServerComponent.prototype.testEmailBlur = function () {
        var _a;
        if (this.formGroup.controls.testEmail.status !== 'VALID') {
            return;
        }
        this.originalTestEmail = this.formGroup.value.testEmail;
        (_a = this.formGroup.get('testEmail')) === null || _a === void 0 ? void 0 : _a.setValue(this.utilsService.maskEmail(this.originalTestEmail));
    };
    EmailServerComponent.prototype.testEmailFocus = function () {
        var _a;
        if (this.originalTestEmail) {
            (_a = this.formGroup.get('testEmail')) === null || _a === void 0 ? void 0 : _a.setValue(this.originalTestEmail);
        }
    };
    EmailServerComponent.prototype.getData = function () {
        var _this = this;
        this.systemApiService.ShowEmailServer({}).subscribe(function (res) {
            if (res.isSSLEnable) {
                _this.formGroup.patchValue({ encryption: 'SSL' });
            }
            else if (res.isTLSEnable) {
                _this.formGroup.patchValue({ encryption: 'TLS' });
            }
            else {
                _this.formGroup.patchValue({ encryption: _this.i18n.get('set_not_encryption_label') });
            }
            _this.originalEmailFrom = res.emailFrom;
            _this.originalTestEmail = res.testEmail;
            _this.originalServer = res.server;
            _this.formGroup.patchValue({
                server: res.server,
                port: res.port,
                emailFrom: _this.utilsService.maskEmail(res.emailFrom),
                testEmail: _this.utilsService.maskEmail(res.testEmail),
                sslSmtpPort: res.sslSmtpPort,
                isValidateEnable: res.isValidateEnable,
                userName: res.userName,
                password: res.password,
                isProxyEnable: res.isProxyEnable,
                proxyServer: res.proxyServer,
                proxyPort: res.proxyPort
            });
            _this.onEncryptionTypeChange();
            _this.isProxyEnable(res.isProxyEnable);
            _this.isValidateEnable(res.isValidateEnable);
            Object(lodash__WEBPACK_IMPORTED_MODULE_2__["each"])(_this.formItems, function (item) {
                if (item.key === 'isValidateEnable' || item.key === 'isProxyEnable') {
                    item.value = _this.dataMapService.getLabel('switchStatus', res[item.key]);
                }
                else if (item.key === 'encryption') {
                    if (res.isSSLEnable) {
                        item.value = 'SSL';
                    }
                    else if (res.isTLSEnable) {
                        item.value = 'TLS';
                    }
                    else {
                        item.value = _this.i18n.get('set_not_encryption_label');
                    }
                }
                else if (item.key === 'emailFrom' || item.key === 'testEmail') {
                    item.value = _this.utilsService.maskEmail(res[item.key]);
                }
                else {
                    item.value = res[item.key];
                }
            });
        });
    };
    EmailServerComponent.prototype.testData = function () {
        var _this = this;
        if (!this.formGroup.value.testEmail) {
            this.messageBox.error(this.i18n.get('set_test_email_error_label'));
            return;
        }
        var params = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.formGroup.value);
        Object(lodash__WEBPACK_IMPORTED_MODULE_2__["assign"])(params, {
            emailFrom: this.originalEmailFrom,
            testEmail: this.originalTestEmail
        });
        Reflect.deleteProperty(params, 'encryption');
        params.port = Object(lodash__WEBPACK_IMPORTED_MODULE_2__["parseInt"])(params.port);
        params.sslSmtpPort = Object(lodash__WEBPACK_IMPORTED_MODULE_2__["parseInt"])(params.sslSmtpPort);
        params.proxyPort = Object(lodash__WEBPACK_IMPORTED_MODULE_2__["parseInt"])(params.proxyPort);
        if (this.formGroup.value.encryption === 'SSL') {
            params.protocol = '1';
            params.isSSLEnable = true;
            params.isTLSEnable = false;
        }
        else if (this.formGroup.value.encryption === 'TLS') {
            params.protocol = '2';
            params.isSSLEnable = false;
            params.isTLSEnable = true;
        }
        else {
            params.protocol = '0';
            params.isSSLEnable = false;
            params.isTLSEnable = false;
        }
        this.systemApiService.UpdateTestEmailServer({ email: params }).subscribe(function (res) {
            _this.getData();
        });
    };
    EmailServerComponent.prototype.onEncryptionTypeChange = function () {
        if (this.formGroup.value.encryption === 'SSL') {
            this.isSslSmtpPortEnable = true;
            this.formGroup.controls.sslSmtpPort.enable();
        }
        else {
            this.isSslSmtpPortEnable = false;
            this.formGroup.controls.sslSmtpPort.disable();
        }
    };
    EmailServerComponent.prototype.isValidateEnable = function (value) {
        if (value) {
            this.formGroup.controls.userName.enable();
            this.formGroup.controls.password.enable();
        }
        else {
            this.formGroup.controls.userName.disable();
            this.formGroup.controls.password.disable();
        }
    };
    EmailServerComponent.prototype.isProxyEnable = function (value) {
        if (value) {
            this.formGroup.controls.proxyServer.enable();
            this.formGroup.controls.proxyPort.enable();
        }
        else {
            this.formGroup.controls.proxyServer.disable();
            this.formGroup.controls.proxyPort.disable();
        }
    };
    EmailServerComponent.ctorParameters = function () { return [
        { type: _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormBuilder"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_5__["I18NService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_5__["BaseUtilService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_5__["UtilsService"] },
        { type: _iux_live__WEBPACK_IMPORTED_MODULE_1__["MessageboxService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_5__["DataMapService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_5__["SystemApiService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_5__["SecurityRightService"] }
    ]; };
    EmailServerComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_4__["Component"])({
            selector: 'lvs-email-server',
            template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./email-server.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/notification-server/email-server/email-server.component.html")).default,
            styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./email-server.component.less */ "./src/app/business/set/notification-server/email-server/email-server.component.less")).default]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormBuilder"],
            _shared__WEBPACK_IMPORTED_MODULE_5__["I18NService"],
            _shared__WEBPACK_IMPORTED_MODULE_5__["BaseUtilService"],
            _shared__WEBPACK_IMPORTED_MODULE_5__["UtilsService"],
            _iux_live__WEBPACK_IMPORTED_MODULE_1__["MessageboxService"],
            _shared__WEBPACK_IMPORTED_MODULE_5__["DataMapService"],
            _shared__WEBPACK_IMPORTED_MODULE_5__["SystemApiService"],
            _shared__WEBPACK_IMPORTED_MODULE_5__["SecurityRightService"]])
    ], EmailServerComponent);
    return EmailServerComponent;
}());



/***/ }),

/***/ "./src/app/business/set/notification-server/email-server/email-server.module.ts":
/*!**************************************************************************************!*\
  !*** ./src/app/business/set/notification-server/email-server/email-server.module.ts ***!
  \**************************************************************************************/
/*! exports provided: EmailServerModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EmailServerModule", function() { return EmailServerModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _shared_shared_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @shared/shared.module */ "./src/app/shared/shared.module.ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/__ivy_ngcc__/fesm2015/common.js");
/* harmony import */ var _email_server_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./email-server.component */ "./src/app/business/set/notification-server/email-server/email-server.component.ts");





var EmailServerModule = /** @class */ (function () {
    function EmailServerModule() {
    }
    EmailServerModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_2__["NgModule"])({
            declarations: [_email_server_component__WEBPACK_IMPORTED_MODULE_4__["EmailServerComponent"]],
            imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _shared_shared_module__WEBPACK_IMPORTED_MODULE_1__["SharedModule"]],
            exports: [_email_server_component__WEBPACK_IMPORTED_MODULE_4__["EmailServerComponent"]]
        })
    ], EmailServerModule);
    return EmailServerModule;
}());



/***/ }),

/***/ "./src/app/business/set/notification-server/message-server/message-server.component.less":
/*!***********************************************************************************************!*\
  !*** ./src/app/business/set/notification-server/message-server/message-server.component.less ***!
  \***********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (".spinner {\n  width: 320px;\n}\n.tag {\n  margin-bottom: 20px;\n}\n.tips {\n  margin-left: 8px;\n  height: 32px;\n  line-height: 32px;\n}\n.button {\n  margin: 20px 0 20px 170px;\n}\nbutton /deep/ .lv-icon-host {\n  float: right;\n}\n.icon {\n  height: 32px;\n  margin: 0 12px;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi91c3IxL3dvcmtzcGFjZS9DTUNfUGFja2FnZV9FdWxlci9TZXJ2ZXIvc3JjL1dlYlVJL1RpbnlfdG9fTGl2ZVVJL3NyYy9hcHAvYnVzaW5lc3Mvc2V0L25vdGlmaWNhdGlvbi1zZXJ2ZXIvbWVzc2FnZS1zZXJ2ZXIvbWVzc2FnZS1zZXJ2ZXIuY29tcG9uZW50Lmxlc3MiLCJzcmMvYXBwL2J1c2luZXNzL3NldC9ub3RpZmljYXRpb24tc2VydmVyL21lc3NhZ2Utc2VydmVyL21lc3NhZ2Utc2VydmVyLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0UsWUFBQTtBQ0NGO0FERUE7RUFDRSxtQkFBQTtBQ0FGO0FER0E7RUFDRSxnQkFBQTtFQUNBLFlBQUE7RUFDQSxpQkFBQTtBQ0RGO0FESUE7RUFDRSx5QkFBQTtBQ0ZGO0FES0E7RUFFSSxZQUFBO0FDSko7QURRQTtFQUNFLFlBQUE7RUFDQSxjQUFBO0FDTkYiLCJmaWxlIjoic3JjL2FwcC9idXNpbmVzcy9zZXQvbm90aWZpY2F0aW9uLXNlcnZlci9tZXNzYWdlLXNlcnZlci9tZXNzYWdlLXNlcnZlci5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIi5zcGlubmVyIHtcbiAgd2lkdGg6IDMyMHB4O1xufVxuXG4udGFnIHtcbiAgbWFyZ2luLWJvdHRvbTogMjBweDtcbn1cblxuLnRpcHMge1xuICBtYXJnaW4tbGVmdDogOHB4O1xuICBoZWlnaHQ6IDMycHg7XG4gIGxpbmUtaGVpZ2h0OiAzMnB4O1xufVxuXG4uYnV0dG9uIHtcbiAgbWFyZ2luOiAyMHB4IDAgMjBweCAxNzBweDtcbn1cblxuYnV0dG9uIHtcbiAgL2RlZXAvIC5sdi1pY29uLWhvc3Qge1xuICAgIGZsb2F0OiByaWdodDtcbiAgfVxufVxuXG4uaWNvbiB7XG4gIGhlaWdodDogMzJweDtcbiAgbWFyZ2luOiAwIDEycHg7XG59XG4iLCIuc3Bpbm5lciB7XG4gIHdpZHRoOiAzMjBweDtcbn1cbi50YWcge1xuICBtYXJnaW4tYm90dG9tOiAyMHB4O1xufVxuLnRpcHMge1xuICBtYXJnaW4tbGVmdDogOHB4O1xuICBoZWlnaHQ6IDMycHg7XG4gIGxpbmUtaGVpZ2h0OiAzMnB4O1xufVxuLmJ1dHRvbiB7XG4gIG1hcmdpbjogMjBweCAwIDIwcHggMTcwcHg7XG59XG5idXR0b24gL2RlZXAvIC5sdi1pY29uLWhvc3Qge1xuICBmbG9hdDogcmlnaHQ7XG59XG4uaWNvbiB7XG4gIGhlaWdodDogMzJweDtcbiAgbWFyZ2luOiAwIDEycHg7XG59XG4iXX0= */");

/***/ }),

/***/ "./src/app/business/set/notification-server/message-server/message-server.component.ts":
/*!*********************************************************************************************!*\
  !*** ./src/app/business/set/notification-server/message-server/message-server.component.ts ***!
  \*********************************************************************************************/
/*! exports provided: MessageServerComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MessageServerComponent", function() { return MessageServerComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @shared */ "./src/app/shared/index.ts");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/__ivy_ngcc__/fesm2015/forms.js");





var MessageServerComponent = /** @class */ (function () {
    function MessageServerComponent(fb, i18n, baseUtil, utilsService, systemApiService, securityRightService) {
        this.fb = fb;
        this.i18n = i18n;
        this.baseUtil = baseUtil;
        this.utilsService = utilsService;
        this.systemApiService = systemApiService;
        this.securityRightService = securityRightService;
        this.isView = true;
        this.formItems = [
            {
                key: 'portName',
                label: this.i18n.get('set_port_name_label'),
                value: ''
            },
            {
                key: 'baudRate',
                label: this.i18n.get('set_baud_rate_label'),
                value: '300'
            },
            {
                key: 'countryCode',
                label: this.i18n.get('set_country_code_label'),
                value: ''
            },
            {
                key: 'testModemPhone',
                label: this.i18n.get('set_test_number_label'),
                value: ''
            }
        ];
        this.baudRateOptions = [
            { label: '300', isLeaf: true },
            { label: '600', isLeaf: true },
            { label: '1200', isLeaf: true },
            { label: '2400', isLeaf: true },
            { label: '4800', isLeaf: true },
            { label: '9600', isLeaf: true },
            { label: '19200', isLeaf: true },
            { label: '38400', isLeaf: true },
            { label: '57600', isLeaf: true },
            { label: '115200', isLeaf: true }
        ];
        this.telErrorTip = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.baseUtil.telErrorTip), { invalidMaxLength: this.i18n.get('common_valid_maxlength_label', [32]) });
        this.portNameErrorTip = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.baseUtil.requiredErrorTip), { invalidPortName: this.i18n.get('set_port_name_tip_label') });
        this.countryCodeErrorTip = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.baseUtil.requiredErrorTip), { invalidCountryCode: this.i18n.get('set_country_code_tip_label') });
    }
    MessageServerComponent.prototype.ngOnInit = function () {
        this.initForm();
        this.getData();
    };
    MessageServerComponent.prototype.getData = function () {
        var _this = this;
        this.systemApiService.ShowSmsServer({}).subscribe(function (res) {
            _this.originalPhone = res.testModemPhone;
            _this.formGroup.setValue({
                portName: res.portName,
                baudRate: res.baudRate,
                countryCode: res.countryCode,
                testModemPhone: _this.utilsService.maskPhone(res.testModemPhone)
            }, { emitEvent: false });
            Object(lodash__WEBPACK_IMPORTED_MODULE_1__["each"])(_this.formItems, function (item) {
                if (item.key === 'testModemPhone') {
                    item.value = _this.utilsService.maskPhone(res[item.key]);
                }
                else {
                    item.value = res[item.key];
                }
            });
        });
    };
    MessageServerComponent.prototype.testData = function () {
        var params = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.formGroup.value);
        Object(lodash__WEBPACK_IMPORTED_MODULE_1__["assign"])(params, {
            testModemPhone: this.originalPhone
        });
        this.systemApiService.UpdateSmsTestServer({ sms: params }).subscribe(function (res) { });
    };
    MessageServerComponent.prototype.saveData = function () {
        var _this = this;
        var params = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.formGroup.value);
        Object(lodash__WEBPACK_IMPORTED_MODULE_1__["assign"])(params, {
            testModemPhone: this.originalPhone
        });
        this.systemApiService.UpdateSmsServer({ sms: params }).subscribe(function () {
            _this.cancelData();
        });
    };
    MessageServerComponent.prototype.modifyData = function () {
        this.cancelData();
    };
    MessageServerComponent.prototype.cancelData = function () {
        this.getData();
        this.isView = !this.isView;
    };
    MessageServerComponent.prototype.phoneBlur = function () {
        var _a;
        if (this.formGroup.controls.testModemPhone.status !== 'VALID') {
            return;
        }
        this.originalPhone = this.formGroup.value.testModemPhone;
        (_a = this.formGroup.get('testModemPhone')) === null || _a === void 0 ? void 0 : _a.setValue(this.utilsService.maskPhone(this.originalPhone));
    };
    MessageServerComponent.prototype.phoneFocus = function () {
        var _a;
        if (this.originalPhone) {
            (_a = this.formGroup.get('testModemPhone')) === null || _a === void 0 ? void 0 : _a.setValue(this.originalPhone);
        }
    };
    MessageServerComponent.prototype.validPhone = function () {
        var _this = this;
        return function (control) {
            if (!Object(lodash__WEBPACK_IMPORTED_MODULE_1__["trim"])(control.value)) {
                return null;
            }
            if (!_this.originalPhone) {
                return _shared__WEBPACK_IMPORTED_MODULE_3__["REGEXP"].telephone.test(control.value)
                    ? null
                    : {
                        invalidTel: { value: control.value }
                    };
            }
            else {
                if (_this.utilsService.maskPhone(_this.originalPhone) !== control.value) {
                    return _shared__WEBPACK_IMPORTED_MODULE_3__["REGEXP"].telephone.test(control.value)
                        ? null
                        : {
                            invalidTel: { value: control.value }
                        };
                }
                return _shared__WEBPACK_IMPORTED_MODULE_3__["REGEXP"].telephone.test(_this.originalPhone)
                    ? null
                    : {
                        invalidTel: { value: control.value }
                    };
            }
        };
    };
    MessageServerComponent.prototype.initForm = function () {
        this.formGroup = this.fb.group({
            portName: new _angular_forms__WEBPACK_IMPORTED_MODULE_4__["FormControl"]('', [_angular_forms__WEBPACK_IMPORTED_MODULE_4__["Validators"].required, this.portNameValiator()]),
            baudRate: new _angular_forms__WEBPACK_IMPORTED_MODULE_4__["FormControl"]('300'),
            countryCode: new _angular_forms__WEBPACK_IMPORTED_MODULE_4__["FormControl"]('', [_angular_forms__WEBPACK_IMPORTED_MODULE_4__["Validators"].required, this.countryCodeValiator()]),
            testModemPhone: new _angular_forms__WEBPACK_IMPORTED_MODULE_4__["FormControl"]('', [this.baseUtil.VALID.maxLength(32), this.validPhone()])
        });
    };
    MessageServerComponent.prototype.countryCodeValiator = function () {
        return function (control) {
            if (!/^(([\+]{1}[0-9]{1,31})|\d{1,32})$/.test(control.value)) {
                return { invalidCountryCode: { value: control.value } };
            }
            else {
                return null;
            }
        };
    };
    MessageServerComponent.prototype.portNameValiator = function () {
        return function (control) {
            if (!/^[^\#\&\’\‘\'\”\“\<\>\"]{1,32}$/.test(control.value)) {
                return { invalidPortName: { value: control.value } };
            }
            else {
                return null;
            }
        };
    };
    MessageServerComponent.ctorParameters = function () { return [
        { type: _angular_forms__WEBPACK_IMPORTED_MODULE_4__["FormBuilder"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["I18NService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["BaseUtilService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["UtilsService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["SystemApiService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["SecurityRightService"] }
    ]; };
    MessageServerComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_2__["Component"])({
            selector: 'lvs-message-server',
            template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./message-server.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/notification-server/message-server/message-server.component.html")).default,
            styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./message-server.component.less */ "./src/app/business/set/notification-server/message-server/message-server.component.less")).default]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_forms__WEBPACK_IMPORTED_MODULE_4__["FormBuilder"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["I18NService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["BaseUtilService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["UtilsService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["SystemApiService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["SecurityRightService"]])
    ], MessageServerComponent);
    return MessageServerComponent;
}());



/***/ }),

/***/ "./src/app/business/set/notification-server/message-server/message-server.module.ts":
/*!******************************************************************************************!*\
  !*** ./src/app/business/set/notification-server/message-server/message-server.module.ts ***!
  \******************************************************************************************/
/*! exports provided: MessageServerModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MessageServerModule", function() { return MessageServerModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _shared_shared_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @shared/shared.module */ "./src/app/shared/shared.module.ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/__ivy_ngcc__/fesm2015/common.js");
/* harmony import */ var _message_server_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./message-server.component */ "./src/app/business/set/notification-server/message-server/message-server.component.ts");





var MessageServerModule = /** @class */ (function () {
    function MessageServerModule() {
    }
    MessageServerModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_2__["NgModule"])({
            declarations: [_message_server_component__WEBPACK_IMPORTED_MODULE_4__["MessageServerComponent"]],
            imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _shared_shared_module__WEBPACK_IMPORTED_MODULE_1__["SharedModule"]],
            exports: [_message_server_component__WEBPACK_IMPORTED_MODULE_4__["MessageServerComponent"]]
        })
    ], MessageServerModule);
    return MessageServerModule;
}());



/***/ }),

/***/ "./src/app/business/set/notification-server/notification-server-routing.module.ts":
/*!****************************************************************************************!*\
  !*** ./src/app/business/set/notification-server/notification-server-routing.module.ts ***!
  \****************************************************************************************/
/*! exports provided: NotificationServerRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NotificationServerRoutingModule", function() { return NotificationServerRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/__ivy_ngcc__/fesm2015/router.js");
/* harmony import */ var _notification_server_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./notification-server.component */ "./src/app/business/set/notification-server/notification-server.component.ts");




var routes = [{ path: '', component: _notification_server_component__WEBPACK_IMPORTED_MODULE_3__["NotificationServerComponent"] }];
var NotificationServerRoutingModule = /** @class */ (function () {
    function NotificationServerRoutingModule() {
    }
    NotificationServerRoutingModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forChild(routes)],
            exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]]
        })
    ], NotificationServerRoutingModule);
    return NotificationServerRoutingModule;
}());



/***/ }),

/***/ "./src/app/business/set/notification-server/notification-server.component.less":
/*!*************************************************************************************!*\
  !*** ./src/app/business/set/notification-server/notification-server.component.less ***!
  \*************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (".flex-row {\n  display: flex;\n  height: 100%;\n}\n.flex-row div {\n  flex-grow: 1;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi91c3IxL3dvcmtzcGFjZS9DTUNfUGFja2FnZV9FdWxlci9TZXJ2ZXIvc3JjL1dlYlVJL1RpbnlfdG9fTGl2ZVVJL3NyYy9hcHAvYnVzaW5lc3Mvc2V0L25vdGlmaWNhdGlvbi1zZXJ2ZXIvbm90aWZpY2F0aW9uLXNlcnZlci5jb21wb25lbnQubGVzcyIsInNyYy9hcHAvYnVzaW5lc3Mvc2V0L25vdGlmaWNhdGlvbi1zZXJ2ZXIvbm90aWZpY2F0aW9uLXNlcnZlci5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNFLGFBQUE7RUFDQSxZQUFBO0FDQ0Y7QURIQTtFQUtJLFlBQUE7QUNDSiIsImZpbGUiOiJzcmMvYXBwL2J1c2luZXNzL3NldC9ub3RpZmljYXRpb24tc2VydmVyL25vdGlmaWNhdGlvbi1zZXJ2ZXIuY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuZmxleC1yb3cge1xuICBkaXNwbGF5OiBmbGV4O1xuICBoZWlnaHQ6IDEwMCU7XG5cbiAgZGl2IHtcbiAgICBmbGV4LWdyb3c6IDE7XG4gIH1cbn1cbiIsIi5mbGV4LXJvdyB7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGhlaWdodDogMTAwJTtcbn1cbi5mbGV4LXJvdyBkaXYge1xuICBmbGV4LWdyb3c6IDE7XG59XG4iXX0= */");

/***/ }),

/***/ "./src/app/business/set/notification-server/notification-server.component.ts":
/*!***********************************************************************************!*\
  !*** ./src/app/business/set/notification-server/notification-server.component.ts ***!
  \***********************************************************************************/
/*! exports provided: NotificationServerComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NotificationServerComponent", function() { return NotificationServerComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");


var NotificationServerComponent = /** @class */ (function () {
    function NotificationServerComponent() {
    }
    NotificationServerComponent.prototype.ngOnInit = function () {
    };
    NotificationServerComponent.ctorParameters = function () { return []; };
    NotificationServerComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'lvs-notification-server',
            template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./notification-server.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/notification-server/notification-server.component.html")).default,
            styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./notification-server.component.less */ "./src/app/business/set/notification-server/notification-server.component.less")).default]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [])
    ], NotificationServerComponent);
    return NotificationServerComponent;
}());



/***/ }),

/***/ "./src/app/business/set/notification-server/notification-server.module.ts":
/*!********************************************************************************!*\
  !*** ./src/app/business/set/notification-server/notification-server.module.ts ***!
  \********************************************************************************/
/*! exports provided: NotificationServerModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NotificationServerModule", function() { return NotificationServerModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _shared_shared_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @shared/shared.module */ "./src/app/shared/shared.module.ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/__ivy_ngcc__/fesm2015/common.js");
/* harmony import */ var _notification_server_routing_module__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./notification-server-routing.module */ "./src/app/business/set/notification-server/notification-server-routing.module.ts");
/* harmony import */ var _notification_server_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./notification-server.component */ "./src/app/business/set/notification-server/notification-server.component.ts");
/* harmony import */ var _email_server_email_server_module__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./email-server/email-server.module */ "./src/app/business/set/notification-server/email-server/email-server.module.ts");
/* harmony import */ var _message_server_message_server_module__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./message-server/message-server.module */ "./src/app/business/set/notification-server/message-server/message-server.module.ts");








var NotificationServerModule = /** @class */ (function () {
    function NotificationServerModule() {
    }
    NotificationServerModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_2__["NgModule"])({
            declarations: [_notification_server_component__WEBPACK_IMPORTED_MODULE_5__["NotificationServerComponent"]],
            imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _notification_server_routing_module__WEBPACK_IMPORTED_MODULE_4__["NotificationServerRoutingModule"], _shared_shared_module__WEBPACK_IMPORTED_MODULE_1__["SharedModule"], _email_server_email_server_module__WEBPACK_IMPORTED_MODULE_6__["EmailServerModule"], _message_server_message_server_module__WEBPACK_IMPORTED_MODULE_7__["MessageServerModule"]]
        })
    ], NotificationServerModule);
    return NotificationServerModule;
}());



/***/ })

}]);
//# sourceMappingURL=notification-server-notification-server-module.js.map