(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["office-information-office-information-module"],{

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/office-information/office-information.component.html":
/*!*************************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/office-information/office-information.component.html ***!
  \*************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class=\"aui-fullpage\">\n  <div class=\"aui-header-1\">\n    <h1>{{ 'set_cs_term_station_label' | i18n }}</h1>\n  </div>\n  <div class=\"aui-block aui-gutter-column-md\">\n    <div class=\"aui-header-2\">\n      <h2>{{ 'set_cs_term_station_label' | i18n }}</h2>\n      <div>\n        <a (click)=\"saveData()\" *ngIf=\"!isView\" [ngClass]=\"{ 'aui-link': formGroup.valid, 'aui-link-disabled': formGroup.invalid }\">\n          {{ 'common_save_label' | i18n }}\n        </a>\n        <a (click)=\"cancelData()\" *ngIf=\"!isView\" class=\"aui-link\">\n          {{ 'common_cancel_label' | i18n }}\n        </a>\n        <a (click)=\"modifyData()\" *ngIf=\"isView\" class=\"aui-link\">\n          {{ 'common_modify_label' | i18n }}\n        </a>\n      </div>\n    </div>\n    <div class=\"dashed-split-line\"></div>\n    <div *ngIf=\"isView\">\n      <lv-form>\n        <ng-container *ngFor=\"let item of formItems\">\n          <lv-form-item>\n            <lv-form-label>{{ item.label | i18n }}</lv-form-label>\n            <lv-form-control>\n              {{ item.value | nil }}\n            </lv-form-control>\n          </lv-form-item>\n        </ng-container>\n      </lv-form>\n    </div>\n    <div *ngIf=\"!isView\">\n      <lv-form [formGroup]=\"formGroup\">\n        <lv-form-item>\n          <lv-form-label lvRequired>{{ 'set_cs_term_name_label' | i18n }}</lv-form-label>\n          <lv-form-control [lvErrorTip]=\"invalidNameErrorTip\">\n            <input lv-input type=\"text\" formControlName=\"clientName\" />\n          </lv-form-control>\n        </lv-form-item>\n\n        <lv-form-item>\n          <lv-form-label lvRequired>{{ 'set_cs_term_username_label' | i18n }}</lv-form-label>\n          <lv-form-control [lvErrorTip]=\"invalidNameErrorTip\">\n            <input lv-input type=\"text\" formControlName=\"linkman\" />\n          </lv-form-control>\n        </lv-form-item>\n        <lv-form-item>\n          <lv-form-label lvRequired>{{ 'set_cs_term_tel_label' | i18n }}</lv-form-label>\n          <lv-form-control [lvErrorTip]=\"invalidTelErrorTip\">\n            <input lv-input type=\"text\" formControlName=\"phone\" />\n          </lv-form-control>\n        </lv-form-item>\n        <lv-form-item>\n          <lv-form-label lvRequired>{{ 'set_cs_term_email_label' | i18n }}</lv-form-label>\n          <lv-form-control [lvErrorTip]=\"invalidEmailErrorTip\">\n            <input lv-input type=\"text\" formControlName=\"contactEmail\" />\n          </lv-form-control>\n        </lv-form-item>\n        <lv-form-item>\n          <lv-form-label>{{ 'set_cs_term_username2_label' | i18n }}</lv-form-label>\n          <lv-form-control [lvErrorTip]=\"invalidNameErrorTip\">\n            <input lv-input type=\"text\" formControlName=\"secendLinkman\" />\n          </lv-form-control>\n        </lv-form-item>\n        <lv-form-item>\n          <lv-form-label>{{ 'set_cs_term_tel2_label' | i18n }}</lv-form-label>\n          <lv-form-control [lvErrorTip]=\"invalidTelErrorTip\">\n            <input lv-input type=\"text\" formControlName=\"secendPhone\" />\n          </lv-form-control>\n        </lv-form-item>\n        <lv-form-item>\n          <lv-form-label>{{ 'set_cs_term_email2_label' | i18n }}</lv-form-label>\n          <lv-form-control [lvErrorTip]=\"invalidEmailErrorTip\">\n            <input lv-input type=\"text\" formControlName=\"secondContactEmail\" />\n          </lv-form-control>\n        </lv-form-item>\n        <lv-form-item>\n          <lv-form-label lvRequired>{{ 'set_cs_term_position_label' | i18n }}</lv-form-label>\n          <lv-form-control [lvErrorTip]=\"invalidLocationErrorTip\">\n            <textarea lv-input rows=\"4\" formControlName=\"location\"></textarea>\n          </lv-form-control>\n        </lv-form-item>\n      </lv-form>\n    </div>\n  </div>\n</div>\n");

/***/ }),

/***/ "./src/app/business/set/office-information/office-information-routing.module.ts":
/*!**************************************************************************************!*\
  !*** ./src/app/business/set/office-information/office-information-routing.module.ts ***!
  \**************************************************************************************/
/*! exports provided: OfficeInformationRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OfficeInformationRoutingModule", function() { return OfficeInformationRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/__ivy_ngcc__/fesm2015/router.js");
/* harmony import */ var _office_information_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./office-information.component */ "./src/app/business/set/office-information/office-information.component.ts");




var routes = [{ path: '', component: _office_information_component__WEBPACK_IMPORTED_MODULE_3__["OfficeInformationComponent"] }];
var OfficeInformationRoutingModule = /** @class */ (function () {
    function OfficeInformationRoutingModule() {
    }
    OfficeInformationRoutingModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forChild(routes)],
            exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]]
        })
    ], OfficeInformationRoutingModule);
    return OfficeInformationRoutingModule;
}());



/***/ }),

/***/ "./src/app/business/set/office-information/office-information.component.less":
/*!***********************************************************************************!*\
  !*** ./src/app/business/set/office-information/office-information.component.less ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL2J1c2luZXNzL3NldC9vZmZpY2UtaW5mb3JtYXRpb24vb2ZmaWNlLWluZm9ybWF0aW9uLmNvbXBvbmVudC5sZXNzIn0= */");

/***/ }),

/***/ "./src/app/business/set/office-information/office-information.component.ts":
/*!*********************************************************************************!*\
  !*** ./src/app/business/set/office-information/office-information.component.ts ***!
  \*********************************************************************************/
/*! exports provided: OfficeInformationComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OfficeInformationComponent", function() { return OfficeInformationComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/__ivy_ngcc__/fesm2015/forms.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @shared */ "./src/app/shared/index.ts");
/* harmony import */ var _shared_service_warning_message_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @shared/service/warning-message.service */ "./src/app/shared/service/warning-message.service.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_5__);






var OfficeInformationComponent = /** @class */ (function () {
    function OfficeInformationComponent(fb, i18n, baseUtilService, systemApiService, warningMessageService) {
        this.fb = fb;
        this.i18n = i18n;
        this.baseUtilService = baseUtilService;
        this.systemApiService = systemApiService;
        this.warningMessageService = warningMessageService;
        this.isView = true;
        this.formItems = [
            {
                key: 'clientName',
                label: 'set_cs_term_name_label'
            },
            {
                key: 'linkman',
                label: 'set_cs_term_username_label'
            },
            {
                key: 'phone',
                label: 'set_cs_term_tel_label'
            },
            {
                key: 'contactEmail',
                label: 'set_cs_term_email_label'
            },
            {
                key: 'secendLinkman',
                label: 'set_cs_term_username2_label'
            },
            {
                key: 'secendPhone',
                label: 'set_cs_term_tel2_label'
            },
            {
                key: 'secondContactEmail',
                label: 'set_cs_term_email2_label'
            },
            {
                key: 'location',
                label: 'set_cs_term_position_label'
            }
        ];
        this.invalidNameErrorTip = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.baseUtilService.requiredErrorTip), { invalidName: this.i18n.get('set_cs_term_name_valid_label') });
        this.invalidTelErrorTip = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.baseUtilService.requiredErrorTip), { invalidTel: this.i18n.get('common_tel_rule_label'), invalidMaxLength: this.i18n.get('common_valid_maxlength_label', [32]) });
        this.invalidEmailErrorTip = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.baseUtilService.requiredErrorTip), this.baseUtilService.emailErrorTip), { invalidMaxLength: this.i18n.get('common_valid_maxlength_label', [254]) });
        this.invalidLocationErrorTip = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.baseUtilService.requiredErrorTip), { invalidMaxLength: this.i18n.get('common_valid_maxlength_label', [128]) });
    }
    OfficeInformationComponent.prototype.ngOnInit = function () {
        this.initForm();
        this.getData();
    };
    OfficeInformationComponent.prototype.initForm = function () {
        this.formGroup = this.fb.group({
            clientName: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('', {
                validators: [this.baseUtilService.VALID.required(), this.baseUtilService.VALID.name(_shared__WEBPACK_IMPORTED_MODULE_3__["REGEXP"].name)]
            }),
            linkman: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('', {
                validators: [this.baseUtilService.VALID.required(), this.baseUtilService.VALID.name(_shared__WEBPACK_IMPORTED_MODULE_3__["REGEXP"].name)]
            }),
            phone: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('', {
                validators: [this.baseUtilService.VALID.required(), this.baseUtilService.VALID.tel(), this.baseUtilService.VALID.maxLength(32)]
            }),
            contactEmail: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('', {
                validators: [this.baseUtilService.VALID.required(), this.baseUtilService.VALID.email(), this.baseUtilService.VALID.maxLength(254)]
            }),
            secendLinkman: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('', {
                validators: [this.baseUtilService.VALID.name(_shared__WEBPACK_IMPORTED_MODULE_3__["REGEXP"].name, false)]
            }),
            secendPhone: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('', {
                validators: [this.baseUtilService.VALID.tel(), this.baseUtilService.VALID.maxLength(32)]
            }),
            secondContactEmail: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('', {
                validators: [this.baseUtilService.VALID.email(), this.baseUtilService.VALID.maxLength(254)]
            }),
            location: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"]('', {
                validators: [this.baseUtilService.VALID.required(), this.baseUtilService.VALID.maxLength(128)]
            })
        });
    };
    OfficeInformationComponent.prototype.getData = function () {
        var _this = this;
        this.systemApiService.ShowBureauInfo({}).subscribe(function (res) {
            _this.formGroup.patchValue(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, res));
            Object(lodash__WEBPACK_IMPORTED_MODULE_5__["each"])(_this.formItems, function (item) {
                item.value = res[item.key];
            });
        });
    };
    OfficeInformationComponent.prototype.saveData = function () {
        var _this = this;
        this.warningMessageService.create({
            content: this.i18n.get('set_bureau_info_warnning_label'),
            onOK: function () {
                _this.systemApiService.UpdateBureauInfo({ params: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, _this.formGroup.value) }).subscribe(function (res) { return _this.cancelData(); });
            }
        });
    };
    OfficeInformationComponent.prototype.modifyData = function () {
        this.cancelData();
    };
    OfficeInformationComponent.prototype.cancelData = function () {
        this.getData();
        this.isView = !this.isView;
    };
    OfficeInformationComponent.ctorParameters = function () { return [
        { type: _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormBuilder"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["I18NService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["BaseUtilService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["SystemApiService"] },
        { type: _shared_service_warning_message_service__WEBPACK_IMPORTED_MODULE_4__["WarningMessageService"] }
    ]; };
    OfficeInformationComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'lvs-office-information',
            template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./office-information.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/office-information/office-information.component.html")).default,
            styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./office-information.component.less */ "./src/app/business/set/office-information/office-information.component.less")).default]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormBuilder"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["I18NService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["BaseUtilService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["SystemApiService"],
            _shared_service_warning_message_service__WEBPACK_IMPORTED_MODULE_4__["WarningMessageService"]])
    ], OfficeInformationComponent);
    return OfficeInformationComponent;
}());



/***/ }),

/***/ "./src/app/business/set/office-information/office-information.module.ts":
/*!******************************************************************************!*\
  !*** ./src/app/business/set/office-information/office-information.module.ts ***!
  \******************************************************************************/
/*! exports provided: OfficeInformationModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OfficeInformationModule", function() { return OfficeInformationModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/__ivy_ngcc__/fesm2015/common.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _shared_shared_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @shared/shared.module */ "./src/app/shared/shared.module.ts");
/* harmony import */ var _office_information_routing_module__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./office-information-routing.module */ "./src/app/business/set/office-information/office-information-routing.module.ts");
/* harmony import */ var _office_information_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./office-information.component */ "./src/app/business/set/office-information/office-information.component.ts");






var OfficeInformationModule = /** @class */ (function () {
    function OfficeInformationModule() {
    }
    OfficeInformationModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_2__["NgModule"])({
            declarations: [_office_information_component__WEBPACK_IMPORTED_MODULE_5__["OfficeInformationComponent"]],
            imports: [_angular_common__WEBPACK_IMPORTED_MODULE_1__["CommonModule"], _office_information_routing_module__WEBPACK_IMPORTED_MODULE_4__["OfficeInformationRoutingModule"], _shared_shared_module__WEBPACK_IMPORTED_MODULE_3__["SharedModule"]]
        })
    ], OfficeInformationModule);
    return OfficeInformationModule;
}());



/***/ }),

/***/ "./src/app/shared/service/warning-message.service.ts":
/*!***********************************************************!*\
  !*** ./src/app/shared/service/warning-message.service.ts ***!
  \***********************************************************/
/*! exports provided: WarningMessageService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WarningMessageService", function() { return WarningMessageService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _iux_live__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @iux/live */ "./node_modules/@iux/live/__ivy_ngcc__/fesm2015/iux-live.js");
/* harmony import */ var _components_warning_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../components/warning.component */ "./src/app/shared/components/warning.component.ts");
/* harmony import */ var _models_live_const__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./../models/live.const */ "./src/app/shared/models/live.const.ts");
/* harmony import */ var _i18n_i18n_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./../i18n/i18n.service */ "./src/app/shared/i18n/i18n.service.ts");






var WarningMessageService = /** @class */ (function () {
    function WarningMessageService(drawModalService, i18n) {
        this.drawModalService = drawModalService;
        this.i18n = i18n;
        this.warningComponent = _components_warning_component__WEBPACK_IMPORTED_MODULE_3__["WarningComponent"];
    }
    WarningMessageService.prototype.create = function (options) {
        this.drawModalService.create(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, _models_live_const__WEBPACK_IMPORTED_MODULE_4__["MODAL_COMMON"].generateDrawerOptions()), { lvModalKey: 'warningMessage' }), {
            lvType: 'modal',
            lvDialogIcon: 'lv-icon-popup-danger-48',
            lvHeader: this.i18n.get('common_warning_label'),
            lvContent: this.warningComponent,
            lvComponentParams: {
                content: options.content
            },
            lvWidth: options.width || _models_live_const__WEBPACK_IMPORTED_MODULE_4__["MODAL_COMMON"].normalWidth,
            lvOkType: 'default',
            lvCancelType: 'primary',
            lvOkDisabled: true,
            lvFocusButtonId: 'cancel',
            lvCloseButtonDisplay: true,
            lvAfterOpen: function (modal) {
                var component = modal.getContentComponent();
                var modalIns = modal.getInstance();
                component.isChecked$.subscribe(function (e) {
                    modalIns.lvOkDisabled = !e;
                });
            },
            lvCancel: function (modal) {
                if (options.onCancel) {
                    options.onCancel();
                }
            },
            lvOk: function (modal) { return options.onOK(); },
            lvAfterClose: function (result) {
                if (options.lvAfterClose) {
                    options.lvAfterClose(result);
                }
            }
        }));
    };
    WarningMessageService.ctorParameters = function () { return [
        { type: _iux_live__WEBPACK_IMPORTED_MODULE_2__["ModalService"] },
        { type: _i18n_i18n_service__WEBPACK_IMPORTED_MODULE_5__["I18NService"] }
    ]; };
    WarningMessageService = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_iux_live__WEBPACK_IMPORTED_MODULE_2__["ModalService"], _i18n_i18n_service__WEBPACK_IMPORTED_MODULE_5__["I18NService"]])
    ], WarningMessageService);
    return WarningMessageService;
}());



/***/ })

}]);
//# sourceMappingURL=office-information-office-information-module.js.map