(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["online-admin-online-admin-module"],{

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/online-admin/online-admin.component.html":
/*!*************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/online-admin/online-admin.component.html ***!
  \*************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class=\"aui-fullpage\">\n  <div class=\"aui-header-1\">\n    <h1>{{ 'common_online_admin_label' | i18n }}</h1>\n  </div>\n\n  <div class=\"aui-block\">\n    <div class=\"aui-operation\">\n      <lv-group></lv-group>\n      <lv-group lvGutter=\"8px\">\n        <lv-group lvGutter=\"8px\">\n          <button class=\"aui-button-icon\" lv-button lvSize=\"auto\" (click)=\"dataTable.fetchData()\">\n            <i lv-icon=\"lv-icon-refresh\" [lvColorState]=\"true\"></i>\n          </button>\n        </lv-group>\n      </lv-group>\n    </div>\n    <div class=\"list-container\">\n      <lv-pro-table #dataTable [config]=\"tableConfig\" [data]=\"tableData\"></lv-pro-table>\n    </div>\n  </div>\n</div>\n\n<ng-template #loginTimeTpl let-item>\n  {{ getStayTime(item?.stayTime) }}\n</ng-template>\n");

/***/ }),

/***/ "./src/app/business/set/online-admin/online-admin-routing.module.ts":
/*!**************************************************************************!*\
  !*** ./src/app/business/set/online-admin/online-admin-routing.module.ts ***!
  \**************************************************************************/
/*! exports provided: OnlineAdminRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OnlineAdminRoutingModule", function() { return OnlineAdminRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/__ivy_ngcc__/fesm2015/router.js");
/* harmony import */ var _online_admin_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./online-admin.component */ "./src/app/business/set/online-admin/online-admin.component.ts");




var routes = [{ path: '', component: _online_admin_component__WEBPACK_IMPORTED_MODULE_3__["OnlineAdminComponent"] }];
var OnlineAdminRoutingModule = /** @class */ (function () {
    function OnlineAdminRoutingModule() {
    }
    OnlineAdminRoutingModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forChild(routes)],
            exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]]
        })
    ], OnlineAdminRoutingModule);
    return OnlineAdminRoutingModule;
}());



/***/ }),

/***/ "./src/app/business/set/online-admin/online-admin.component.less":
/*!***********************************************************************!*\
  !*** ./src/app/business/set/online-admin/online-admin.component.less ***!
  \***********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL2J1c2luZXNzL3NldC9vbmxpbmUtYWRtaW4vb25saW5lLWFkbWluLmNvbXBvbmVudC5sZXNzIn0= */");

/***/ }),

/***/ "./src/app/business/set/online-admin/online-admin.component.ts":
/*!*********************************************************************!*\
  !*** ./src/app/business/set/online-admin/online-admin.component.ts ***!
  \*********************************************************************/
/*! exports provided: OnlineAdminComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OnlineAdminComponent", function() { return OnlineAdminComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _shared_components_pro_table_index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @shared/components/pro-table/index */ "./src/app/shared/components/pro-table/index.ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @shared */ "./src/app/shared/index.ts");
/* harmony import */ var _shared_service_warning_message_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @shared/service/warning-message.service */ "./src/app/shared/service/warning-message.service.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_5__);






var OnlineAdminComponent = /** @class */ (function () {
    function OnlineAdminComponent(i18n, systemApiService, cdr, cookie, securityRightService, warningMessageService) {
        this.i18n = i18n;
        this.systemApiService = systemApiService;
        this.cdr = cdr;
        this.cookie = cookie;
        this.securityRightService = securityRightService;
        this.warningMessageService = warningMessageService;
        this.selectionData = [];
    }
    OnlineAdminComponent.prototype.ngAfterViewInit = function () {
        this.dataTable.fetchData();
    };
    OnlineAdminComponent.prototype.ngOnInit = function () {
        this.initConfig();
    };
    OnlineAdminComponent.prototype.initConfig = function () {
        var _this = this;
        var opts = [
            {
                id: 'forceLogout',
                label: this.i18n.get('set_force_offline_label'),
                disableCheck: function (data) {
                    var param = Object(lodash__WEBPACK_IMPORTED_MODULE_5__["first"])(data);
                    var isAdmin = _this.cookie.get('userName') === 'admin';
                    var isAdministrator = _this.cookie.get('isAdministrator') === 'true';
                    if (isAdmin && isAdministrator) {
                        return false;
                    }
                    if (isAdmin) {
                        if (param.userName === 'admin')
                            return true;
                        else
                            return false;
                    }
                    else {
                        if (param.userName === 'admin' || param.isAdministrator === 'true')
                            return true;
                        else
                            return false;
                    }
                },
                displayCheck: function () {
                    return _this.securityRightService.checkRight('lego.sys.onlineUserMgr.down');
                },
                onClick: function (data) {
                    _this.forceLogout(Object(lodash__WEBPACK_IMPORTED_MODULE_5__["first"])(data));
                }
            }
        ];
        var cols = [
            {
                key: 'userName',
                sort: true,
                name: this.i18n.get('common_username_label')
            },
            {
                key: 'ipAdr',
                sort: true,
                name: this.i18n.get('common_ip_addr_label')
            },
            {
                key: 'loginDate',
                sort: true,
                name: this.i18n.get('set_login_date_label')
            },
            {
                key: 'loginTime',
                name: this.i18n.get('set_login_time_label'),
                cellRender: this.loginTimeTpl
            },
            {
                key: 'operation',
                width: 130,
                name: this.i18n.get('common_operation_label'),
                cellRender: {
                    type: 'operation',
                    config: {
                        maxDisplayItems: 2,
                        items: opts
                    }
                }
            }
        ];
        this.tableConfig = {
            table: {
                autoPolling: _shared__WEBPACK_IMPORTED_MODULE_3__["CommonConsts"].TIME_INTERVAL,
                compareWith: 'userId',
                columns: cols,
                colDisplayControl: false,
                fetchData: function (filter) {
                    _this.getData(filter);
                },
                trackByFn: function (_, item) {
                    return item.userId;
                }
            }
        };
    };
    OnlineAdminComponent.prototype.forceLogout = function (item) {
        var _this = this;
        this.warningMessageService.create({
            content: this.i18n.get('set_force_offline_warn_label'),
            onOK: function () {
                _this.systemApiService
                    .CreateForceLogout({
                    forceBody: {
                        userId: item.userId,
                        sessionId: item.session
                    }
                })
                    .subscribe(function () { return _this.dataTable.fetchData(); });
            }
        });
    };
    OnlineAdminComponent.prototype.getData = function (filters) {
        var _this = this;
        var params = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, filters === null || filters === void 0 ? void 0 : filters.paginator), filters === null || filters === void 0 ? void 0 : filters.sort);
        this.systemApiService.ShowOnlineUsers(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, params), { lvpLoading: filters.lvpLoading })).subscribe(function (res) {
            _this.tableData = {
                data: res === null || res === void 0 ? void 0 : res.records,
                total: res === null || res === void 0 ? void 0 : res.totalCount
            };
            _this.cdr.detectChanges();
        });
    };
    OnlineAdminComponent.prototype.getStayTime = function (stayTime) {
        return stayTime
            .replace('day', this.i18n.get('common_day_label'))
            .replace('hour', this.i18n.get('common_hour_label'))
            .replace('minute', this.i18n.get('common_minute_label'))
            .replace('second', this.i18n.get('common_second_label'));
    };
    OnlineAdminComponent.ctorParameters = function () { return [
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["I18NService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["SystemApiService"] },
        { type: _angular_core__WEBPACK_IMPORTED_MODULE_2__["ChangeDetectorRef"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["CookieService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["SecurityRightService"] },
        { type: _shared_service_warning_message_service__WEBPACK_IMPORTED_MODULE_4__["WarningMessageService"] }
    ]; };
    OnlineAdminComponent.propDecorators = {
        dataTable: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_2__["ViewChild"], args: ['dataTable', { static: false },] }],
        loginTimeTpl: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_2__["ViewChild"], args: ['loginTimeTpl', { static: true },] }]
    };
    OnlineAdminComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_2__["Component"])({
            selector: 'lvs-online-admin',
            template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./online-admin.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/online-admin/online-admin.component.html")).default,
            changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_2__["ChangeDetectionStrategy"].OnPush,
            styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./online-admin.component.less */ "./src/app/business/set/online-admin/online-admin.component.less")).default]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_shared__WEBPACK_IMPORTED_MODULE_3__["I18NService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["SystemApiService"],
            _angular_core__WEBPACK_IMPORTED_MODULE_2__["ChangeDetectorRef"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["CookieService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["SecurityRightService"],
            _shared_service_warning_message_service__WEBPACK_IMPORTED_MODULE_4__["WarningMessageService"]])
    ], OnlineAdminComponent);
    return OnlineAdminComponent;
}());



/***/ }),

/***/ "./src/app/business/set/online-admin/online-admin.module.ts":
/*!******************************************************************!*\
  !*** ./src/app/business/set/online-admin/online-admin.module.ts ***!
  \******************************************************************/
/*! exports provided: OnlineAdminModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OnlineAdminModule", function() { return OnlineAdminModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _shared_shared_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @shared/shared.module */ "./src/app/shared/shared.module.ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/__ivy_ngcc__/fesm2015/common.js");
/* harmony import */ var _online_admin_routing_module__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./online-admin-routing.module */ "./src/app/business/set/online-admin/online-admin-routing.module.ts");
/* harmony import */ var _online_admin_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./online-admin.component */ "./src/app/business/set/online-admin/online-admin.component.ts");
/* harmony import */ var _shared_components_pro_table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @shared/components/pro-table */ "./src/app/shared/components/pro-table/index.ts");
/* harmony import */ var _shared_components_pro_button__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @shared/components/pro-button */ "./src/app/shared/components/pro-button/index.ts");
/* harmony import */ var _shared_components_pro_status__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @shared/components/pro-status */ "./src/app/shared/components/pro-status/index.ts");









var OnlineAdminModule = /** @class */ (function () {
    function OnlineAdminModule() {
    }
    OnlineAdminModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_2__["NgModule"])({
            declarations: [_online_admin_component__WEBPACK_IMPORTED_MODULE_5__["OnlineAdminComponent"]],
            imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _online_admin_routing_module__WEBPACK_IMPORTED_MODULE_4__["OnlineAdminRoutingModule"], _shared_shared_module__WEBPACK_IMPORTED_MODULE_1__["SharedModule"], _shared_components_pro_button__WEBPACK_IMPORTED_MODULE_7__["ProButtonModule"], _shared_components_pro_table__WEBPACK_IMPORTED_MODULE_6__["ProTableModule"], _shared_components_pro_status__WEBPACK_IMPORTED_MODULE_8__["ProStatusModule"]]
        })
    ], OnlineAdminModule);
    return OnlineAdminModule;
}());



/***/ }),

/***/ "./src/app/shared/service/warning-message.service.ts":
/*!***********************************************************!*\
  !*** ./src/app/shared/service/warning-message.service.ts ***!
  \***********************************************************/
/*! exports provided: WarningMessageService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WarningMessageService", function() { return WarningMessageService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _iux_live__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @iux/live */ "./node_modules/@iux/live/__ivy_ngcc__/fesm2015/iux-live.js");
/* harmony import */ var _components_warning_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../components/warning.component */ "./src/app/shared/components/warning.component.ts");
/* harmony import */ var _models_live_const__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./../models/live.const */ "./src/app/shared/models/live.const.ts");
/* harmony import */ var _i18n_i18n_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./../i18n/i18n.service */ "./src/app/shared/i18n/i18n.service.ts");






var WarningMessageService = /** @class */ (function () {
    function WarningMessageService(drawModalService, i18n) {
        this.drawModalService = drawModalService;
        this.i18n = i18n;
        this.warningComponent = _components_warning_component__WEBPACK_IMPORTED_MODULE_3__["WarningComponent"];
    }
    WarningMessageService.prototype.create = function (options) {
        this.drawModalService.create(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, _models_live_const__WEBPACK_IMPORTED_MODULE_4__["MODAL_COMMON"].generateDrawerOptions()), { lvModalKey: 'warningMessage' }), {
            lvType: 'modal',
            lvDialogIcon: 'lv-icon-popup-danger-48',
            lvHeader: this.i18n.get('common_warning_label'),
            lvContent: this.warningComponent,
            lvComponentParams: {
                content: options.content
            },
            lvWidth: options.width || _models_live_const__WEBPACK_IMPORTED_MODULE_4__["MODAL_COMMON"].normalWidth,
            lvOkType: 'default',
            lvCancelType: 'primary',
            lvOkDisabled: true,
            lvFocusButtonId: 'cancel',
            lvCloseButtonDisplay: true,
            lvAfterOpen: function (modal) {
                var component = modal.getContentComponent();
                var modalIns = modal.getInstance();
                component.isChecked$.subscribe(function (e) {
                    modalIns.lvOkDisabled = !e;
                });
            },
            lvCancel: function (modal) {
                if (options.onCancel) {
                    options.onCancel();
                }
            },
            lvOk: function (modal) { return options.onOK(); },
            lvAfterClose: function (result) {
                if (options.lvAfterClose) {
                    options.lvAfterClose(result);
                }
            }
        }));
    };
    WarningMessageService.ctorParameters = function () { return [
        { type: _iux_live__WEBPACK_IMPORTED_MODULE_2__["ModalService"] },
        { type: _i18n_i18n_service__WEBPACK_IMPORTED_MODULE_5__["I18NService"] }
    ]; };
    WarningMessageService = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_iux_live__WEBPACK_IMPORTED_MODULE_2__["ModalService"], _i18n_i18n_service__WEBPACK_IMPORTED_MODULE_5__["I18NService"]])
    ], WarningMessageService);
    return WarningMessageService;
}());



/***/ })

}]);
//# sourceMappingURL=online-admin-online-admin-module.js.map