(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["sound-set-sound-set-module"],{

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/insight/sound-set/sound-set.component.html":
/*!***********************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/business/insight/sound-set/sound-set.component.html ***!
  \***********************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class=\"aui-fullpage\">\n  <div class=\"aui-header-1\">\n    <h1>{{ 'common_sound_set_label' | i18n }}</h1>\n  </div>\n  <div class=\"aui-block\">\n    <div class=\"aui-header-2 aui-gutter-column-md\">\n      <div>{{ 'insight_alarm_term_setting_titlle_label' | i18n }}</div>\n      <div>\n        <a (click)=\"saveData()\" *ngIf=\"!isView\" class=\"aui-link\">\n          {{ 'common_save_label' | i18n }}\n        </a>\n        <a (click)=\"cancelData()\" *ngIf=\"!isView\" class=\"aui-link\">\n          {{ 'common_cancel_label' | i18n }}\n        </a>\n        <a (click)=\"modifyData()\" *ngIf=\"isView\" class=\"aui-link\">\n          {{ 'common_modify_label' | i18n }}\n        </a>\n      </div>\n    </div>\n    <div class=\"dashed-split-line\"></div>\n    <div class=\"setting-table\">\n      <lv-datatable [lvData]=\"tableData\">\n        <thead>\n          <tr>\n            <th>{{ 'insight_alarm_level_all_label' | i18n }}</th>\n            <th>{{ 'common_type_label' | i18n }}</th>\n            <th>{{ 'insight_alarm_term_setting_try_label' | i18n }}</th>\n          </tr>\n        </thead>\n        <tbody>\n          <ng-container *ngFor=\"let item of tableData\">\n            <tr>\n              <td>\n                <alarm-level [level]=\"item.severity\"></alarm-level>\n              </td>\n              <td>\n                <ng-container *ngIf=\"!isView; else elseTemplate\">\n                  <lv-select [lvOptions]=\"settingOptions\" [(ngModel)]='item.audioValue' lvValueKey=\"value\"\n                    class=\"setting-select\"></lv-select>\n                </ng-container>\n                <ng-template #elseTemplate>\n                  <ng-container *ngIf=\"item.switchValue; else elseTemplate\">\n                    {{item.audioValue | textMap: 'soundSettingType' | nil}}\n                  </ng-container>\n                  <ng-template #elseTemplate>\n                    --\n                  </ng-template>\n\n                </ng-template>\n              </td>\n              <td>\n                <div class=\"iconbutton-listen\" [ngClass]=\"{ 'iconbutton-listen-disabled': item.audioValue === '-1' }\"\n                  (click)=\"listen(item.listenKey, item.audioValue)\"></div>\n              </td>\n            </tr>\n          </ng-container>\n        </tbody>\n      </lv-datatable>\n      <div id=\"voicePlayer\"></div>\n    </div>\n  </div>\n</div>");

/***/ }),

/***/ "./src/app/business/insight/sound-set/sound-set-routing.module.ts":
/*!************************************************************************!*\
  !*** ./src/app/business/insight/sound-set/sound-set-routing.module.ts ***!
  \************************************************************************/
/*! exports provided: SoundSetRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SoundSetRoutingModule", function() { return SoundSetRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/__ivy_ngcc__/fesm2015/router.js");
/* harmony import */ var _sound_set_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sound-set.component */ "./src/app/business/insight/sound-set/sound-set.component.ts");




var routes = [{ path: '', component: _sound_set_component__WEBPACK_IMPORTED_MODULE_3__["SoundSetComponent"] }];
var SoundSetRoutingModule = /** @class */ (function () {
    function SoundSetRoutingModule() {
    }
    SoundSetRoutingModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forChild(routes)],
            exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]]
        })
    ], SoundSetRoutingModule);
    return SoundSetRoutingModule;
}());



/***/ }),

/***/ "./src/app/business/insight/sound-set/sound-set.component.less":
/*!*********************************************************************!*\
  !*** ./src/app/business/insight/sound-set/sound-set.component.less ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (".iconbutton-listen {\n  background: url('rd_common.png') no-repeat -128px -352px;\n  cursor: pointer;\n  width: 16px;\n  height: 16px;\n}\n.iconbutton-listen:hover {\n  background-position: -144px -352px;\n}\n.iconbutton-listen-disabled {\n  background: url('rd_common.png') no-repeat -176px -352px !important;\n  cursor: default !important;\n  width: 16px;\n  height: 16px;\n}\n.setting-select {\n  width: 196px;\n}\n.setting-control {\n  height: 48px;\n  padding-top: 8px;\n}\n.listen-td {\n  padding-left: 24px !important;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "./src/app/business/insight/sound-set/sound-set.component.ts":
/*!*******************************************************************!*\
  !*** ./src/app/business/insight/sound-set/sound-set.component.ts ***!
  \*******************************************************************/
/*! exports provided: SoundSetComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SoundSetComponent", function() { return SoundSetComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/__ivy_ngcc__/fesm2015/forms.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @shared */ "./src/app/shared/index.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_4__);





var SoundSetComponent = /** @class */ (function () {
    function SoundSetComponent(fb, i18n, dataMapService, alarmApiService) {
        var _this = this;
        this.fb = fb;
        this.i18n = i18n;
        this.dataMapService = dataMapService;
        this.alarmApiService = alarmApiService;
        this.settingOptions = this.dataMapService.toArray('soundSettingType').filter(function (item) {
            if (item.value === _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].soundSettingType.unseleted.value) {
                item.label = _this.i18n.get('common_none_label');
            }
            return true;
        });
        this.tableData = [
            {
                severity: _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].alarmLevel.critical.value,
                switchKey: 'critical-switch',
                switchValue: false,
                audioKey: 'critical-audio',
                audioValue: '-1',
                listenKey: 'critical'
            },
            {
                severity: _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].alarmLevel.major.value,
                switchKey: 'major-switch',
                switchValue: false,
                audioKey: 'major-audio',
                audioValue: '-1',
                listenKey: 'major'
            },
            {
                severity: _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].alarmLevel.warning.value,
                switchKey: 'warn-switch',
                switchValue: false,
                audioKey: 'warn-audio',
                audioValue: '-1',
                listenKey: 'warn'
            },
            {
                severity: _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].alarmLevel.info.value,
                switchKey: 'info-switch',
                switchValue: false,
                audioKey: 'info-audio',
                audioValue: '-1',
                listenKey: 'info'
            }
        ];
        this.isView = true;
    }
    SoundSetComponent.prototype.ngOnInit = function () {
        this.updateData();
    };
    SoundSetComponent.prototype.updateData = function () {
        var _this = this;
        this.alarmApiService.ShowAudio({}).subscribe(function (res) {
            Object(lodash__WEBPACK_IMPORTED_MODULE_4__["each"])(_this.tableData, function (item) {
                item.switchValue = res[item.switchKey] === '1';
                item.audioValue = res[item.audioKey];
            });
            _this.isView = true;
        });
    };
    SoundSetComponent.prototype.listen = function (level, type) {
        if (!level || type === _shared__WEBPACK_IMPORTED_MODULE_3__["DataMap"].soundSettingType.unseleted.value) {
            return;
        }
        var voicePlayer = document.getElementById('voicePlayer');
        var time = 3000;
        var url = '/src/assets/audio/' + level + type + '.mp3';
        if (!voicePlayer) {
            return;
        }
        voicePlayer.innerHTML = "<audio src='" + url + "' autoplay='autoplay'></audio>";
        var timeOut = setTimeout(function () {
            voicePlayer.innerHTML = '';
            clearTimeout(timeOut);
        }, time);
    };
    SoundSetComponent.prototype.modifyData = function () {
        this.isView = false;
    };
    SoundSetComponent.prototype.cancelData = function () {
        this.updateData();
    };
    SoundSetComponent.prototype.saveData = function () {
        var _this = this;
        var _a, _b, _c, _d, _e, _f, _g, _h;
        var params = {
            audioCritical: (_a = Object(lodash__WEBPACK_IMPORTED_MODULE_4__["find"])(this.tableData, { listenKey: 'critical' })) === null || _a === void 0 ? void 0 : _a.audioValue,
            audioMajor: (_b = Object(lodash__WEBPACK_IMPORTED_MODULE_4__["find"])(this.tableData, { listenKey: 'major' })) === null || _b === void 0 ? void 0 : _b.audioValue,
            audioWarn: (_c = Object(lodash__WEBPACK_IMPORTED_MODULE_4__["find"])(this.tableData, { listenKey: 'warn' })) === null || _c === void 0 ? void 0 : _c.audioValue,
            audioInfo: (_d = Object(lodash__WEBPACK_IMPORTED_MODULE_4__["find"])(this.tableData, { listenKey: 'info' })) === null || _d === void 0 ? void 0 : _d.audioValue,
            isEnabledCritical: ((_e = Object(lodash__WEBPACK_IMPORTED_MODULE_4__["find"])(this.tableData, { listenKey: 'critical' })) === null || _e === void 0 ? void 0 : _e.audioValue) !== '-1',
            isEnabledMajor: ((_f = Object(lodash__WEBPACK_IMPORTED_MODULE_4__["find"])(this.tableData, { listenKey: 'major' })) === null || _f === void 0 ? void 0 : _f.audioValue) !== '-1',
            isEnabledWarn: ((_g = Object(lodash__WEBPACK_IMPORTED_MODULE_4__["find"])(this.tableData, { listenKey: 'warn' })) === null || _g === void 0 ? void 0 : _g.audioValue) !== '-1',
            isEnabledInfo: ((_h = Object(lodash__WEBPACK_IMPORTED_MODULE_4__["find"])(this.tableData, { listenKey: 'info' })) === null || _h === void 0 ? void 0 : _h.audioValue) !== '-1'
        };
        this.alarmApiService.ModifyAudioSetting({ ModifyAudioSettingReq: params }).subscribe(function () {
            _this.updateData();
        });
    };
    SoundSetComponent.ctorParameters = function () { return [
        { type: _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormBuilder"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["I18NService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["DataMapService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["AlarmApiService"] }
    ]; };
    SoundSetComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'lvs-sound-set',
            template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./sound-set.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/insight/sound-set/sound-set.component.html")).default,
            styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./sound-set.component.less */ "./src/app/business/insight/sound-set/sound-set.component.less")).default]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormBuilder"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["I18NService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["DataMapService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["AlarmApiService"]])
    ], SoundSetComponent);
    return SoundSetComponent;
}());



/***/ }),

/***/ "./src/app/business/insight/sound-set/sound-set.module.ts":
/*!****************************************************************!*\
  !*** ./src/app/business/insight/sound-set/sound-set.module.ts ***!
  \****************************************************************/
/*! exports provided: SoundSetModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SoundSetModule", function() { return SoundSetModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _shared_shared_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @shared/shared.module */ "./src/app/shared/shared.module.ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/__ivy_ngcc__/fesm2015/common.js");
/* harmony import */ var _sound_set_routing_module__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sound-set-routing.module */ "./src/app/business/insight/sound-set/sound-set-routing.module.ts");
/* harmony import */ var _sound_set_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./sound-set.component */ "./src/app/business/insight/sound-set/sound-set.component.ts");
/* harmony import */ var _shared_components_alarm_level__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @shared/components/alarm-level */ "./src/app/shared/components/alarm-level/index.ts");
/* harmony import */ var _shared_components_pro_button__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @shared/components/pro-button */ "./src/app/shared/components/pro-button/index.ts");








var SoundSetModule = /** @class */ (function () {
    function SoundSetModule() {
    }
    SoundSetModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_2__["NgModule"])({
            declarations: [_sound_set_component__WEBPACK_IMPORTED_MODULE_5__["SoundSetComponent"]],
            imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _sound_set_routing_module__WEBPACK_IMPORTED_MODULE_4__["SoundSetRoutingModule"], _shared_shared_module__WEBPACK_IMPORTED_MODULE_1__["SharedModule"], _shared_components_alarm_level__WEBPACK_IMPORTED_MODULE_6__["AlarmLevelModule"], _shared_components_pro_button__WEBPACK_IMPORTED_MODULE_7__["ProButtonModule"]]
        })
    ], SoundSetModule);
    return SoundSetModule;
}());



/***/ }),

/***/ "./src/app/shared/components/alarm-level/alarm-level.component.less":
/*!**************************************************************************!*\
  !*** ./src/app/shared/components/alarm-level/alarm-level.component.less ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (".info {\n  background: url('rd_common.png') no-repeat -240px 0;\n}\n.warning {\n  background: url('rd_common.png') no-repeat -224px 0;\n}\n.major {\n  background: url('rd_common.png') no-repeat -208px 0;\n}\n.critical {\n  background: url('rd_common.png') no-repeat -192px 0;\n}\n.alarm-span {\n  margin: 3px 5px;\n  width: 16px;\n  height: 16px;\n  float: left;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi91c3IxL3dvcmtzcGFjZS9DTUNfUGFja2FnZV9FdWxlci9TZXJ2ZXIvc3JjL1dlYlVJL1RpbnlfdG9fTGl2ZVVJL3NyYy9hcHAvc2hhcmVkL2NvbXBvbmVudHMvYWxhcm0tbGV2ZWwvYWxhcm0tbGV2ZWwuY29tcG9uZW50Lmxlc3MiLCJzcmMvYXBwL3NoYXJlZC9jb21wb25lbnRzL2FsYXJtLWxldmVsL2FsYXJtLWxldmVsLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0UsbURBQUE7QUNDRjtBREVBO0VBQ0UsbURBQUE7QUNBRjtBREdBO0VBQ0UsbURBQUE7QUNERjtBRElBO0VBQ0UsbURBQUE7QUNGRjtBREtBO0VBQ0UsZUFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0VBQ0EsV0FBQTtBQ0hGIiwiZmlsZSI6InNyYy9hcHAvc2hhcmVkL2NvbXBvbmVudHMvYWxhcm0tbGV2ZWwvYWxhcm0tbGV2ZWwuY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuaW5mbyB7XG4gIGJhY2tncm91bmQ6IHVybCgnLi4vLi4vLi4vLi4vYXNzZXRzL2ltZy9yZF9jb21tb24ucG5nJykgbm8tcmVwZWF0IC0yNDBweCAwO1xufVxuXG4ud2FybmluZyB7XG4gIGJhY2tncm91bmQ6IHVybCgnLi4vLi4vLi4vLi4vYXNzZXRzL2ltZy9yZF9jb21tb24ucG5nJykgbm8tcmVwZWF0IC0yMjRweCAwO1xufVxuXG4ubWFqb3Ige1xuICBiYWNrZ3JvdW5kOiB1cmwoJy4uLy4uLy4uLy4uL2Fzc2V0cy9pbWcvcmRfY29tbW9uLnBuZycpIG5vLXJlcGVhdCAtMjA4cHggMDtcbn1cblxuLmNyaXRpY2FsIHtcbiAgYmFja2dyb3VuZDogdXJsKCcuLi8uLi8uLi8uLi9hc3NldHMvaW1nL3JkX2NvbW1vbi5wbmcnKSBuby1yZXBlYXQgLTE5MnB4IDA7XG59XG5cbi5hbGFybS1zcGFuIHtcbiAgbWFyZ2luOiAzcHggNXB4O1xuICB3aWR0aDogMTZweDtcbiAgaGVpZ2h0OiAxNnB4O1xuICBmbG9hdDogbGVmdDtcbn1cbiIsIi5pbmZvIHtcbiAgYmFja2dyb3VuZDogdXJsKCcuLi8uLi8uLi8uLi9hc3NldHMvaW1nL3JkX2NvbW1vbi5wbmcnKSBuby1yZXBlYXQgLTI0MHB4IDA7XG59XG4ud2FybmluZyB7XG4gIGJhY2tncm91bmQ6IHVybCgnLi4vLi4vLi4vLi4vYXNzZXRzL2ltZy9yZF9jb21tb24ucG5nJykgbm8tcmVwZWF0IC0yMjRweCAwO1xufVxuLm1ham9yIHtcbiAgYmFja2dyb3VuZDogdXJsKCcuLi8uLi8uLi8uLi9hc3NldHMvaW1nL3JkX2NvbW1vbi5wbmcnKSBuby1yZXBlYXQgLTIwOHB4IDA7XG59XG4uY3JpdGljYWwge1xuICBiYWNrZ3JvdW5kOiB1cmwoJy4uLy4uLy4uLy4uL2Fzc2V0cy9pbWcvcmRfY29tbW9uLnBuZycpIG5vLXJlcGVhdCAtMTkycHggMDtcbn1cbi5hbGFybS1zcGFuIHtcbiAgbWFyZ2luOiAzcHggNXB4O1xuICB3aWR0aDogMTZweDtcbiAgaGVpZ2h0OiAxNnB4O1xuICBmbG9hdDogbGVmdDtcbn1cbiJdfQ== */");

/***/ }),

/***/ "./src/app/shared/components/alarm-level/alarm-level.component.ts":
/*!************************************************************************!*\
  !*** ./src/app/shared/components/alarm-level/alarm-level.component.ts ***!
  \************************************************************************/
/*! exports provided: AlarmLevelComponent, AlarmLevelModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AlarmLevelComponent", function() { return AlarmLevelComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AlarmLevelModule", function() { return AlarmLevelModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @shared */ "./src/app/shared/index.ts");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/__ivy_ngcc__/fesm2015/common.js");




var AlarmLevelComponent = /** @class */ (function () {
    function AlarmLevelComponent(i18n, dataMapService) {
        this.i18n = i18n;
        this.dataMapService = dataMapService;
        this.alarmLevel = _shared__WEBPACK_IMPORTED_MODULE_2__["DataMap"].alarmLevel;
    }
    AlarmLevelComponent.prototype.ngOnInit = function () {
        this.init();
    };
    AlarmLevelComponent.prototype.ngOnChanges = function (changes) {
        if (changes.type) {
            this.init();
        }
    };
    AlarmLevelComponent.prototype.init = function () {
        this.alarmLabel = this.i18n.get(this.dataMapService.getLabel('alarmLevel', this.level));
    };
    AlarmLevelComponent.ctorParameters = function () { return [
        { type: _shared__WEBPACK_IMPORTED_MODULE_2__["I18NService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_2__["DataMapService"] }
    ]; };
    AlarmLevelComponent.propDecorators = {
        level: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"] }]
    };
    AlarmLevelComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'alarm-level',
            template: "\n    <ng-container [ngSwitch]=\"level\">\n      <span *ngSwitchCase=\"alarmLevel.info.value\" class=\"alarm-span info\"></span>\n      <span *ngSwitchCase=\"alarmLevel.warning.value\" class=\"alarm-span warning\"></span>\n      <span *ngSwitchCase=\"alarmLevel.major.value\" class=\"alarm-span major\"></span>\n      <span *ngSwitchCase=\"alarmLevel.critical.value\" class=\"alarm-span critical\"></span>\n    </ng-container>\n    <span>{{ alarmLabel || '--' }}</span>\n  ",
            styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./alarm-level.component.less */ "./src/app/shared/components/alarm-level/alarm-level.component.less")).default]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_shared__WEBPACK_IMPORTED_MODULE_2__["I18NService"], _shared__WEBPACK_IMPORTED_MODULE_2__["DataMapService"]])
    ], AlarmLevelComponent);
    return AlarmLevelComponent;
}());

var AlarmLevelModule = /** @class */ (function () {
    function AlarmLevelModule() {
    }
    AlarmLevelModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            declarations: [AlarmLevelComponent],
            imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"]],
            exports: [AlarmLevelComponent]
        })
    ], AlarmLevelModule);
    return AlarmLevelModule;
}());



/***/ }),

/***/ "./src/app/shared/components/alarm-level/index.ts":
/*!********************************************************!*\
  !*** ./src/app/shared/components/alarm-level/index.ts ***!
  \********************************************************/
/*! exports provided: AlarmLevelComponent, AlarmLevelModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _alarm_level_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./alarm-level.component */ "./src/app/shared/components/alarm-level/alarm-level.component.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AlarmLevelComponent", function() { return _alarm_level_component__WEBPACK_IMPORTED_MODULE_0__["AlarmLevelComponent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AlarmLevelModule", function() { return _alarm_level_component__WEBPACK_IMPORTED_MODULE_0__["AlarmLevelModule"]; });




/***/ })

}]);
//# sourceMappingURL=sound-set-sound-set-module.js.map