(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["sys-role-sys-role-module"],{

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/sys-role/create-role/create-role.component.html":
/*!********************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/sys-role/create-role/create-role.component.html ***!
  \********************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class=\"create-role-modal\">\n  <lv-form [formGroup]=\"formGroup\" class=\"formGroup\">\n    <lv-form-item>\n      <lv-form-label lvRequired>{{ 'common_name_label' | i18n }}</lv-form-label>\n      <lv-form-control [lvErrorTip]=\"nameErrorTip\">\n        <input lv-input formControlName=\"name\" [attr.disabled]=\"rowItem && rowItem.roleId ? '' : null\" />\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label>{{ 'common_desc_label' | i18n }}</lv-form-label>\n      <lv-form-control>\n        <lv-input-lint>\n          <textarea formControlName=\"description\" rows=\"3\" maxlength=\"100\" lv-input [attr.disabled]=\"viewRole ? '' : null\"></textarea>\n        </lv-input-lint>\n      </lv-form-control>\n    </lv-form-item>\n    <lv-form-item>\n      <lv-form-label>{{ 'set_permission_set_label' | i18n }}</lv-form-label>\n      <lv-form-control>\n        <div class=\"permission-tree\">\n          <ng-container *ngIf=\"!viewRole\">\n            <lv-tree\n              [lvData]=\"permissionData\"\n              #tree\n              lvShowCheckbox\n              lvSelectedByCheckbox\n              lvSelectionMode=\"multiple\"\n              [(lvSelection)]=\"permissionSelection\"\n              (lvSelectionChange)=\"selectionChange()\"\n              (lvCheck)=\"nodeCheck($event)\"\n              lvShowContentIcon\n              lvAsync\n              lvVirtualScroll\n              [lvScroll]=\"{ y: '450px' }\"\n              lvCompareWith=\"id\"\n            ></lv-tree>\n          </ng-container>\n          <ng-container *ngIf=\"viewRole\">\n            <lv-tree\n              [lvData]=\"permissionData\"\n              #tree\n              lvShowContentIcon\n              lvAsync\n              lvVirtualScroll\n              [lvScroll]=\"{ y: '450px' }\"\n              lvCompareWith=\"id\"\n            ></lv-tree>\n          </ng-container>\n        </div>\n      </lv-form-control>\n    </lv-form-item>\n  </lv-form>\n</div>\n");

/***/ }),

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/sys-role/role-user/role-user.component.html":
/*!****************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/sys-role/role-user/role-user.component.html ***!
  \****************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<lv-pro-table #dataTable [config]=\"tableConfig\" [data]=\"tableData\"></lv-pro-table>");

/***/ }),

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/sys-role/sys-role.component.html":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/sys-role/sys-role.component.html ***!
  \*****************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class=\"aui-fullpage\">\n    <div class=\"aui-header-1\">\n        <h1>{{'common_role_label' | i18n}}</h1>\n    </div>\n\n    <div class=\"aui-block\">\n        <div class=\"aui-operation\">\n            <lv-group>\n                <lv-pro-button-group [config]=\"optsConfig\" [bindData]=\"selectionData\"></lv-pro-button-group>\n            </lv-group>\n            <lv-group lvGutter=\"8px\">\n                <lv-group lvGutter=\"8px\">\n                    <button class=\"aui-button-icon\" lv-button lvSize=\"auto\" (click)=\"dataTable.fetchData()\">\n                        <i lv-icon=\"lv-icon-refresh\" [lvColorState]=\"true\"></i>\n                    </button>\n                </lv-group>\n            </lv-group>\n        </div>\n        <div class='list-container'>\n            <lv-pro-table #dataTable [config]=\"tableConfig\" [data]=\"tableData\"></lv-pro-table>\n        </div>\n    </div>\n</div>\n");

/***/ }),

/***/ "./src/app/business/set/sys-role/create-role/create-role.component.less":
/*!******************************************************************************!*\
  !*** ./src/app/business/set/sys-role/create-role/create-role.component.less ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (".create-role-modal .permission-tree {\n  height: 450px;\n  border: 1px solid #bcbcc2;\n}\n.create-role-modal .lv-tree {\n  width: 100%;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi91c3IxL3dvcmtzcGFjZS9DTUNfUGFja2FnZV9FdWxlci9TZXJ2ZXIvc3JjL1dlYlVJL1RpbnlfdG9fTGl2ZVVJL3NyYy9hcHAvYnVzaW5lc3Mvc2V0L3N5cy1yb2xlL2NyZWF0ZS1yb2xlL2NyZWF0ZS1yb2xlLmNvbXBvbmVudC5sZXNzIiwic3JjL2FwcC9idXNpbmVzcy9zZXQvc3lzLXJvbGUvY3JlYXRlLXJvbGUvY3JlYXRlLXJvbGUuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFFSSxhQUFBO0VBQ0EseUJBQUE7QUNBSjtBREhBO0VBTUksV0FBQTtBQ0FKIiwiZmlsZSI6InNyYy9hcHAvYnVzaW5lc3Mvc2V0L3N5cy1yb2xlL2NyZWF0ZS1yb2xlL2NyZWF0ZS1yb2xlLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiLmNyZWF0ZS1yb2xlLW1vZGFsIHtcbiAgLnBlcm1pc3Npb24tdHJlZSB7XG4gICAgaGVpZ2h0OiA0NTBweDtcbiAgICBib3JkZXI6IDFweCBzb2xpZCAjYmNiY2MyO1xuICB9XG4gIC5sdi10cmVlIHtcbiAgICB3aWR0aDogMTAwJTtcbiAgfVxufVxuIiwiLmNyZWF0ZS1yb2xlLW1vZGFsIC5wZXJtaXNzaW9uLXRyZWUge1xuICBoZWlnaHQ6IDQ1MHB4O1xuICBib3JkZXI6IDFweCBzb2xpZCAjYmNiY2MyO1xufVxuLmNyZWF0ZS1yb2xlLW1vZGFsIC5sdi10cmVlIHtcbiAgd2lkdGg6IDEwMCU7XG59XG4iXX0= */");

/***/ }),

/***/ "./src/app/business/set/sys-role/create-role/create-role.component.ts":
/*!****************************************************************************!*\
  !*** ./src/app/business/set/sys-role/create-role/create-role.component.ts ***!
  \****************************************************************************/
/*! exports provided: CreateRoleComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CreateRoleComponent", function() { return CreateRoleComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/__ivy_ngcc__/fesm2015/forms.js");
/* harmony import */ var _iux_live__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @iux/live */ "./node_modules/@iux/live/__ivy_ngcc__/fesm2015/iux-live.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @shared */ "./src/app/shared/index.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs */ "./node_modules/rxjs/_esm2015/index.js");







var CreateRoleComponent = /** @class */ (function () {
    function CreateRoleComponent(fb, modal, i18n, cdr, baseUtilService, systemApiService) {
        this.fb = fb;
        this.modal = modal;
        this.i18n = i18n;
        this.cdr = cdr;
        this.baseUtilService = baseUtilService;
        this.systemApiService = systemApiService;
        this.permissionData = [];
        this.permissionSelection = [];
        this.nameErrorTip = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, this.baseUtilService.requiredErrorTip), this.baseUtilService.nameErrorTip);
    }
    CreateRoleComponent.prototype.ngOnInit = function () {
        this.initForm();
        this.getPermissionData();
    };
    CreateRoleComponent.prototype.initForm = function () {
        var _this = this;
        this.formGroup = this.fb.group({
            name: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](this.rowItem ? this.rowItem.roleName : '', {
                validators: [this.baseUtilService.VALID.name(_shared__WEBPACK_IMPORTED_MODULE_4__["REGEXP"].roleName, true)]
            }),
            description: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormControl"](this.rowItem ? this.rowItem.roleDes : '')
        });
        this.formGroup.statusChanges.subscribe(function () { return _this.validOkDisable(); });
    };
    CreateRoleComponent.prototype.validOkDisable = function () {
        this.modal.getInstance().lvOkDisabled = this.formGroup.invalid || !Object(lodash__WEBPACK_IMPORTED_MODULE_5__["size"])(this.permissionSelection);
    };
    CreateRoleComponent.prototype.getPermissionData = function () {
        var _this = this;
        if (this.viewRole && this.rowItem.privilegeTree) {
            var rootNode = Object(lodash__WEBPACK_IMPORTED_MODULE_5__["find"])(this.rowItem.privilegeTree, { pid: '-1' });
            this.permissionData = [
                Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({ label: this.i18n.get(rootNode.name), isLeaf: false, expanded: rootNode.open, children: [] }, rootNode)
            ];
            this.createTree(this.rowItem.privilegeTree, this.permissionData[0]);
        }
        else {
            this.systemApiService.ShowRolesPrivilegeTrees({}).subscribe(function (res) {
                var rootNode = Object(lodash__WEBPACK_IMPORTED_MODULE_5__["find"])(res, { pid: '-1' });
                _this.permissionData = [
                    Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({ label: _this.i18n.get(rootNode.name), isLeaf: false, expanded: rootNode.open, children: [] }, rootNode)
                ];
                _this.createTree(res, _this.permissionData[0]);
                if (_this.rowItem && _this.rowItem.privilegeTree) {
                    var leafNode_1 = [];
                    Object(lodash__WEBPACK_IMPORTED_MODULE_5__["each"])(_this.rowItem.privilegeTree, function (item) {
                        if (!Object(lodash__WEBPACK_IMPORTED_MODULE_5__["find"])(_this.rowItem.privilegeTree, { pid: item.id })) {
                            leafNode_1.push(item);
                        }
                    });
                    var checkedId_1 = Object(lodash__WEBPACK_IMPORTED_MODULE_5__["map"])(leafNode_1, 'id');
                    Object(lodash__WEBPACK_IMPORTED_MODULE_5__["each"])(leafNode_1, function (item) {
                        _this.checkJoinId(res, item, checkedId_1);
                    });
                    _this.checkJoinSelection(_this.permissionData[0], checkedId_1);
                }
                _this.cdr.detectChanges();
            });
        }
    };
    CreateRoleComponent.prototype.checkJoinId = function (source, leafNode, checkedId) {
        var parentNode = Object(lodash__WEBPACK_IMPORTED_MODULE_5__["find"])(source, {
            id: leafNode.pid
        });
        var brotherNodes = Object(lodash__WEBPACK_IMPORTED_MODULE_5__["filter"])(source, function (item) {
            return item.pid === leafNode.pid;
        });
        var checkedBrotherNodes = Object(lodash__WEBPACK_IMPORTED_MODULE_5__["filter"])(this.rowItem.privilegeTree, function (item) {
            return item.pid === leafNode.pid;
        });
        if (parentNode && Object(lodash__WEBPACK_IMPORTED_MODULE_5__["size"])(brotherNodes) === Object(lodash__WEBPACK_IMPORTED_MODULE_5__["size"])(checkedBrotherNodes)) {
            checkedId.push(parentNode.id);
            this.checkJoinId(source, parentNode, checkedId);
        }
    };
    CreateRoleComponent.prototype.checkJoinSelection = function (node, checkedId) {
        var _this = this;
        if (Object(lodash__WEBPACK_IMPORTED_MODULE_5__["includes"])(checkedId, node.id)) {
            this.permissionSelection.push(node);
        }
        if (!Object(lodash__WEBPACK_IMPORTED_MODULE_5__["isEmpty"])(node.children)) {
            Object(lodash__WEBPACK_IMPORTED_MODULE_5__["each"])(node.children, function (item) {
                _this.checkJoinSelection(item, checkedId);
            });
        }
    };
    CreateRoleComponent.prototype.createTree = function (resourceData, parentNode) {
        var _this = this;
        var childrenNode = Object(lodash__WEBPACK_IMPORTED_MODULE_5__["filter"])(resourceData, function (item) {
            return item.pid === parentNode.id;
        });
        if (!Object(lodash__WEBPACK_IMPORTED_MODULE_5__["isEmpty"])(childrenNode)) {
            Object(lodash__WEBPACK_IMPORTED_MODULE_5__["each"])(childrenNode, function (item) {
                var grandChildrenNode = Object(lodash__WEBPACK_IMPORTED_MODULE_5__["filter"])(resourceData, function (g) {
                    return g.pid === item.id;
                });
                var childrenTreeNode = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({ label: _this.i18n.get(item.name), isLeaf: !Object(lodash__WEBPACK_IMPORTED_MODULE_5__["size"])(grandChildrenNode), expanded: item.open, children: !Object(lodash__WEBPACK_IMPORTED_MODULE_5__["size"])(grandChildrenNode) ? null : [] }, item);
                parentNode.children.push(childrenTreeNode);
                if (!childrenTreeNode.isLeaf) {
                    _this.createTree(resourceData, childrenTreeNode);
                }
            });
        }
    };
    CreateRoleComponent.prototype.selectionChange = function () {
        this.validOkDisable();
    };
    CreateRoleComponent.prototype.getCheckedPermission = function (idsSet, node) {
        if (!Object(lodash__WEBPACK_IMPORTED_MODULE_5__["includes"])(idsSet, node.id)) {
            idsSet.push(node.id);
            if (!Object(lodash__WEBPACK_IMPORTED_MODULE_5__["isEmpty"])(node.parent)) {
                this.getCheckedPermission(idsSet, node.parent);
            }
        }
    };
    CreateRoleComponent.prototype.nodeCheck = function (event) { };
    CreateRoleComponent.prototype.onOK = function () {
        var _this = this;
        return new rxjs__WEBPACK_IMPORTED_MODULE_6__["Observable"](function (observer) {
            var optIdsSet = [];
            Object(lodash__WEBPACK_IMPORTED_MODULE_5__["each"])(_this.permissionSelection, function (item) {
                _this.getCheckedPermission(optIdsSet, item);
            });
            if (_this.rowItem) {
                _this.systemApiService
                    .UpdateRoles({
                    roleId: _this.rowItem.roleId,
                    RoleBody: {
                        roleName: _this.formGroup.value.name,
                        roleDes: _this.formGroup.value.description,
                        optIdsSet: optIdsSet
                    }
                })
                    .subscribe(function (res) {
                    observer.next();
                    observer.complete();
                }, function (err) {
                    observer.error(err);
                    observer.complete();
                });
            }
            else {
                _this.systemApiService
                    .CreateRoles({
                    forceBody: {
                        roleName: _this.formGroup.value.name,
                        roleDes: _this.formGroup.value.description,
                        optIdsSet: optIdsSet
                    }
                })
                    .subscribe(function (res) {
                    observer.next();
                    observer.complete();
                }, function (err) {
                    observer.error(err);
                    observer.complete();
                });
            }
        });
    };
    CreateRoleComponent.ctorParameters = function () { return [
        { type: _angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormBuilder"] },
        { type: _iux_live__WEBPACK_IMPORTED_MODULE_3__["ModalRef"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_4__["I18NService"] },
        { type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["ChangeDetectorRef"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_4__["BaseUtilService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_4__["SystemApiService"] }
    ]; };
    CreateRoleComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'lvs-create-role',
            template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./create-role.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/sys-role/create-role/create-role.component.html")).default,
            changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__["ChangeDetectionStrategy"].OnPush,
            styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./create-role.component.less */ "./src/app/business/set/sys-role/create-role/create-role.component.less")).default]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_forms__WEBPACK_IMPORTED_MODULE_2__["FormBuilder"],
            _iux_live__WEBPACK_IMPORTED_MODULE_3__["ModalRef"],
            _shared__WEBPACK_IMPORTED_MODULE_4__["I18NService"],
            _angular_core__WEBPACK_IMPORTED_MODULE_1__["ChangeDetectorRef"],
            _shared__WEBPACK_IMPORTED_MODULE_4__["BaseUtilService"],
            _shared__WEBPACK_IMPORTED_MODULE_4__["SystemApiService"]])
    ], CreateRoleComponent);
    return CreateRoleComponent;
}());



/***/ }),

/***/ "./src/app/business/set/sys-role/role-user/role-user.component.less":
/*!**************************************************************************!*\
  !*** ./src/app/business/set/sys-role/role-user/role-user.component.less ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL2J1c2luZXNzL3NldC9zeXMtcm9sZS9yb2xlLXVzZXIvcm9sZS11c2VyLmNvbXBvbmVudC5sZXNzIn0= */");

/***/ }),

/***/ "./src/app/business/set/sys-role/role-user/role-user.component.ts":
/*!************************************************************************!*\
  !*** ./src/app/business/set/sys-role/role-user/role-user.component.ts ***!
  \************************************************************************/
/*! exports provided: RoleUserComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RoleUserComponent", function() { return RoleUserComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @shared */ "./src/app/shared/index.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);




var RoleUserComponent = /** @class */ (function () {
    function RoleUserComponent(i18n) {
        this.i18n = i18n;
    }
    RoleUserComponent.prototype.ngOnInit = function () {
        this.initTableConfig();
    };
    RoleUserComponent.prototype.initTableConfig = function () {
        var _a, _b;
        this.tableConfig = {
            table: {
                async: false,
                compareWith: 'userId',
                columns: [
                    {
                        key: 'userName',
                        name: this.i18n.get('common_username_label')
                    },
                    {
                        key: 'description',
                        name: this.i18n.get('common_desc_label')
                    }
                ],
                colDisplayControl: false
            },
            pagination: {
                pageIndex: _shared__WEBPACK_IMPORTED_MODULE_2__["CommonConsts"].PAGE_START,
                pageSize: _shared__WEBPACK_IMPORTED_MODULE_2__["CommonConsts"].PAGE_SIZE,
                showPageSizeOptions: false,
                mode: 'simple'
            }
        };
        this.tableData = {
            data: (_a = this === null || this === void 0 ? void 0 : this.rowItem) === null || _a === void 0 ? void 0 : _a.userSet,
            total: Object(lodash__WEBPACK_IMPORTED_MODULE_3__["size"])((_b = this === null || this === void 0 ? void 0 : this.rowItem) === null || _b === void 0 ? void 0 : _b.userSet)
        };
    };
    RoleUserComponent.ctorParameters = function () { return [
        { type: _shared__WEBPACK_IMPORTED_MODULE_2__["I18NService"] }
    ]; };
    RoleUserComponent.propDecorators = {
        rowItem: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"] }]
    };
    RoleUserComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'lvs-role-user',
            template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./role-user.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/sys-role/role-user/role-user.component.html")).default,
            styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./role-user.component.less */ "./src/app/business/set/sys-role/role-user/role-user.component.less")).default]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_shared__WEBPACK_IMPORTED_MODULE_2__["I18NService"]])
    ], RoleUserComponent);
    return RoleUserComponent;
}());



/***/ }),

/***/ "./src/app/business/set/sys-role/sys-role-routing.module.ts":
/*!******************************************************************!*\
  !*** ./src/app/business/set/sys-role/sys-role-routing.module.ts ***!
  \******************************************************************/
/*! exports provided: SysRoleRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SysRoleRoutingModule", function() { return SysRoleRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/__ivy_ngcc__/fesm2015/router.js");
/* harmony import */ var _sys_role_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sys-role.component */ "./src/app/business/set/sys-role/sys-role.component.ts");




var routes = [{ path: '', component: _sys_role_component__WEBPACK_IMPORTED_MODULE_3__["SysRoleComponent"] }];
var SysRoleRoutingModule = /** @class */ (function () {
    function SysRoleRoutingModule() {
    }
    SysRoleRoutingModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forChild(routes)],
            exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]]
        })
    ], SysRoleRoutingModule);
    return SysRoleRoutingModule;
}());



/***/ }),

/***/ "./src/app/business/set/sys-role/sys-role.component.less":
/*!***************************************************************!*\
  !*** ./src/app/business/set/sys-role/sys-role.component.less ***!
  \***************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL2J1c2luZXNzL3NldC9zeXMtcm9sZS9zeXMtcm9sZS5jb21wb25lbnQubGVzcyJ9 */");

/***/ }),

/***/ "./src/app/business/set/sys-role/sys-role.component.ts":
/*!*************************************************************!*\
  !*** ./src/app/business/set/sys-role/sys-role.component.ts ***!
  \*************************************************************/
/*! exports provided: SysRoleComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SysRoleComponent", function() { return SysRoleComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @shared */ "./src/app/shared/index.ts");
/* harmony import */ var _shared_components_pro_table_index__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @shared/components/pro-table/index */ "./src/app/shared/components/pro-table/index.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _shared_service_warning_message_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @shared/service/warning-message.service */ "./src/app/shared/service/warning-message.service.ts");
/* harmony import */ var _create_role_create_role_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./create-role/create-role.component */ "./src/app/business/set/sys-role/create-role/create-role.component.ts");
/* harmony import */ var _role_user_role_user_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./role-user/role-user.component */ "./src/app/business/set/sys-role/role-user/role-user.component.ts");








var SysRoleComponent = /** @class */ (function () {
    function SysRoleComponent(i18n, cdr, systemApiService, drawModalService, securityRightService, warningMessageService) {
        this.i18n = i18n;
        this.cdr = cdr;
        this.systemApiService = systemApiService;
        this.drawModalService = drawModalService;
        this.securityRightService = securityRightService;
        this.warningMessageService = warningMessageService;
        this.optsConfig = [];
        this.selectionData = [];
    }
    SysRoleComponent.prototype.ngAfterViewInit = function () {
        this.dataTable.fetchData();
    };
    SysRoleComponent.prototype.ngOnInit = function () {
        this.initConfig();
    };
    SysRoleComponent.prototype.initConfig = function () {
        var _this = this;
        var opts = [
            {
                id: 'create',
                type: 'primary',
                label: this.i18n.get('common_create_label'),
                disableCheck: function (data) {
                    return false;
                },
                displayCheck: function () {
                    return _this.securityRightService.checkRight('lego.sys.role.add');
                },
                onClick: function (data) {
                    _this.createRoles(Object(lodash__WEBPACK_IMPORTED_MODULE_4__["first"])(data));
                }
            },
            {
                id: 'modify',
                label: this.i18n.get('common_modify_label'),
                disableCheck: function (data) {
                    return Object(lodash__WEBPACK_IMPORTED_MODULE_4__["includes"])([
                        _shared__WEBPACK_IMPORTED_MODULE_2__["DataMap"].userRole.unknown.value,
                        _shared__WEBPACK_IMPORTED_MODULE_2__["DataMap"].userRole.administrator.value,
                        _shared__WEBPACK_IMPORTED_MODULE_2__["DataMap"].userRole.auditor.value,
                        _shared__WEBPACK_IMPORTED_MODULE_2__["DataMap"].userRole.operator.value,
                        _shared__WEBPACK_IMPORTED_MODULE_2__["DataMap"].userRole.nbirole.value
                    ], +data[0].roleId);
                },
                displayCheck: function () {
                    return _this.securityRightService.checkRight('lego.sys.role.edit');
                },
                onClick: function (data) {
                    _this.modifyRoles(Object(lodash__WEBPACK_IMPORTED_MODULE_4__["first"])(data));
                }
            },
            {
                id: 'delete',
                label: this.i18n.get('common_delete_label'),
                disableCheck: function (data) {
                    return Object(lodash__WEBPACK_IMPORTED_MODULE_4__["includes"])([
                        _shared__WEBPACK_IMPORTED_MODULE_2__["DataMap"].userRole.unknown.value,
                        _shared__WEBPACK_IMPORTED_MODULE_2__["DataMap"].userRole.administrator.value,
                        _shared__WEBPACK_IMPORTED_MODULE_2__["DataMap"].userRole.auditor.value,
                        _shared__WEBPACK_IMPORTED_MODULE_2__["DataMap"].userRole.operator.value,
                        _shared__WEBPACK_IMPORTED_MODULE_2__["DataMap"].userRole.nbirole.value
                    ], +data[0].roleId);
                },
                displayCheck: function () {
                    return _this.securityRightService.checkRight('lego.sys.role.delete');
                },
                onClick: function (data) {
                    _this.deleteRoles(Object(lodash__WEBPACK_IMPORTED_MODULE_4__["first"])(data));
                }
            }
        ];
        var cols = [
            {
                key: 'roleName',
                sort: true,
                name: this.i18n.get('common_name_label'),
                cellRender: {
                    type: 'text',
                    config: {
                        click: function (data) {
                            _this.getRoleDetail(data);
                        }
                    }
                }
            },
            {
                key: 'userNum',
                sort: true,
                name: this.i18n.get('set_number_associated_admin_label'),
                cellRender: {
                    type: 'text',
                    config: {
                        click: function (data) {
                            _this.getUserNum(data);
                        }
                    }
                }
            },
            {
                key: 'roleDes',
                sort: true,
                name: this.i18n.get('common_desc_label')
            },
            {
                key: 'operation',
                width: 130,
                name: this.i18n.get('common_operation_label'),
                cellRender: {
                    type: 'operation',
                    config: {
                        maxDisplayItems: 1,
                        items: Object(lodash__WEBPACK_IMPORTED_MODULE_4__["reject"])(opts, { id: 'create' })
                    }
                }
            }
        ];
        this.tableConfig = {
            table: {
                autoPolling: _shared__WEBPACK_IMPORTED_MODULE_2__["CommonConsts"].TIME_INTERVAL,
                compareWith: 'roleId',
                columns: cols,
                colDisplayControl: false,
                fetchData: function (filters, args) {
                    _this.getData(filters, args);
                },
                trackByFn: function (index, item) {
                    return item.userId;
                }
            }
        };
        this.optsConfig = Object(lodash__WEBPACK_IMPORTED_MODULE_4__["filter"])(opts, { id: 'create' });
    };
    SysRoleComponent.prototype.getRoleDetail = function (item) {
        var _this = this;
        this.systemApiService.ShowRolesPrivilegeTrees({ roleId: item.roleId }).subscribe(function (res) {
            _this.drawModalService.create(Object(lodash__WEBPACK_IMPORTED_MODULE_4__["assign"])({}, _shared__WEBPACK_IMPORTED_MODULE_2__["MODAL_COMMON"].options, {
                lvModalKey: 'role-view-modal',
                lvWidth: _shared__WEBPACK_IMPORTED_MODULE_2__["MODAL_COMMON"].normalWidth + 100,
                lvHeader: _this.i18n.get('set_view_role_label'),
                lvComponentParams: {
                    rowItem: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, item), { privilegeTree: res }),
                    viewRole: true
                },
                lvOkDisabled: true,
                lvContent: _create_role_create_role_component__WEBPACK_IMPORTED_MODULE_6__["CreateRoleComponent"],
                lvFooter: [
                    {
                        label: _this.i18n.get('common_close_label'),
                        onClick: function (modal) { return modal.close(); }
                    }
                ]
            }));
        });
    };
    SysRoleComponent.prototype.getUserNum = function (item) {
        var _this = this;
        this.systemApiService.ShowRoleById({ roleId: item.roleId }).subscribe(function (res) {
            _this.drawModalService.create(Object(lodash__WEBPACK_IMPORTED_MODULE_4__["assign"])({}, _shared__WEBPACK_IMPORTED_MODULE_2__["MODAL_COMMON"].options, {
                lvModalKey: 'user-view-modal',
                lvWidth: _shared__WEBPACK_IMPORTED_MODULE_2__["MODAL_COMMON"].normalWidth + 100,
                lvHeader: _this.i18n.get('set_view_role_user_label'),
                lvComponentParams: {
                    rowItem: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, res)
                },
                lvOkDisabled: true,
                lvContent: _role_user_role_user_component__WEBPACK_IMPORTED_MODULE_7__["RoleUserComponent"],
                lvFooter: [
                    {
                        label: _this.i18n.get('common_close_label'),
                        onClick: function (modal) { return modal.close(); }
                    }
                ]
            }));
        });
    };
    SysRoleComponent.prototype.createRoles = function (item) {
        var _this = this;
        this.drawModalService.create(Object(lodash__WEBPACK_IMPORTED_MODULE_4__["assign"])({}, _shared__WEBPACK_IMPORTED_MODULE_2__["MODAL_COMMON"].options, {
            lvModalKey: 'role-add-modal',
            lvWidth: _shared__WEBPACK_IMPORTED_MODULE_2__["MODAL_COMMON"].normalWidth + 100,
            lvHeader: item ? this.i18n.get('set_modify_role_label') : this.i18n.get('set_create_role_label'),
            lvComponentParams: {
                rowItem: Object(lodash__WEBPACK_IMPORTED_MODULE_4__["cloneDeep"])(item)
            },
            lvOkDisabled: true,
            lvContent: _create_role_create_role_component__WEBPACK_IMPORTED_MODULE_6__["CreateRoleComponent"],
            lvOk: function (modal) {
                return new Promise(function (resolve) {
                    var content = modal.getContentComponent();
                    content.onOK().subscribe(function (res) {
                        resolve(true);
                        _this.dataTable.fetchData();
                    }, function (err) {
                        resolve(false);
                    });
                });
            }
        }));
    };
    SysRoleComponent.prototype.modifyRoles = function (item) {
        var _this = this;
        this.systemApiService.ShowRolesPrivilegeTrees({ roleId: item.roleId }).subscribe(function (res) {
            _this.createRoles(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, item), { privilegeTree: res }));
        });
    };
    SysRoleComponent.prototype.deleteRoles = function (item) {
        var _this = this;
        this.warningMessageService.create({
            content: this.i18n.get('set_delete_roles_label', [item.roleName]),
            onOK: function () {
                _this.systemApiService.DeleteRoles({ RoleIds: [item.roleId] }).subscribe(function () { return _this.dataTable.fetchData(); });
            }
        });
    };
    SysRoleComponent.prototype.getData = function (filters, args) {
        var _this = this;
        var params = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, filters === null || filters === void 0 ? void 0 : filters.paginator), filters === null || filters === void 0 ? void 0 : filters.sort);
        this.systemApiService.ShowRoles(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, params), { lvpLoading: filters.lvpLoading })).subscribe(function (res) {
            _this.tableData = {
                data: res === null || res === void 0 ? void 0 : res.roleList,
                total: res === null || res === void 0 ? void 0 : res.total
            };
            _this.cdr.detectChanges();
        });
    };
    SysRoleComponent.ctorParameters = function () { return [
        { type: _shared__WEBPACK_IMPORTED_MODULE_2__["I18NService"] },
        { type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["ChangeDetectorRef"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_2__["SystemApiService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_2__["DrawModalService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_2__["SecurityRightService"] },
        { type: _shared_service_warning_message_service__WEBPACK_IMPORTED_MODULE_5__["WarningMessageService"] }
    ]; };
    SysRoleComponent.propDecorators = {
        dataTable: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"], args: ['dataTable', { static: false },] }]
    };
    SysRoleComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'lvs-sys-role',
            template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./sys-role.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/set/sys-role/sys-role.component.html")).default,
            changeDetection: _angular_core__WEBPACK_IMPORTED_MODULE_1__["ChangeDetectionStrategy"].OnPush,
            styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./sys-role.component.less */ "./src/app/business/set/sys-role/sys-role.component.less")).default]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_shared__WEBPACK_IMPORTED_MODULE_2__["I18NService"],
            _angular_core__WEBPACK_IMPORTED_MODULE_1__["ChangeDetectorRef"],
            _shared__WEBPACK_IMPORTED_MODULE_2__["SystemApiService"],
            _shared__WEBPACK_IMPORTED_MODULE_2__["DrawModalService"],
            _shared__WEBPACK_IMPORTED_MODULE_2__["SecurityRightService"],
            _shared_service_warning_message_service__WEBPACK_IMPORTED_MODULE_5__["WarningMessageService"]])
    ], SysRoleComponent);
    return SysRoleComponent;
}());



/***/ }),

/***/ "./src/app/business/set/sys-role/sys-role.module.ts":
/*!**********************************************************!*\
  !*** ./src/app/business/set/sys-role/sys-role.module.ts ***!
  \**********************************************************/
/*! exports provided: SysRoleModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SysRoleModule", function() { return SysRoleModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/__ivy_ngcc__/fesm2015/common.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _shared_components_pro_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @shared/components/pro-button */ "./src/app/shared/components/pro-button/index.ts");
/* harmony import */ var _shared_components_pro_status__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @shared/components/pro-status */ "./src/app/shared/components/pro-status/index.ts");
/* harmony import */ var _shared_components_pro_table__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @shared/components/pro-table */ "./src/app/shared/components/pro-table/index.ts");
/* harmony import */ var _shared_shared_module__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @shared/shared.module */ "./src/app/shared/shared.module.ts");
/* harmony import */ var _create_role_create_role_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./create-role/create-role.component */ "./src/app/business/set/sys-role/create-role/create-role.component.ts");
/* harmony import */ var _sys_role_routing_module__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./sys-role-routing.module */ "./src/app/business/set/sys-role/sys-role-routing.module.ts");
/* harmony import */ var _sys_role_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./sys-role.component */ "./src/app/business/set/sys-role/sys-role.component.ts");
/* harmony import */ var _role_user_role_user_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./role-user/role-user.component */ "./src/app/business/set/sys-role/role-user/role-user.component.ts");











var SysRoleModule = /** @class */ (function () {
    function SysRoleModule() {
    }
    SysRoleModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_2__["NgModule"])({
            declarations: [_sys_role_component__WEBPACK_IMPORTED_MODULE_9__["SysRoleComponent"], _create_role_create_role_component__WEBPACK_IMPORTED_MODULE_7__["CreateRoleComponent"], _role_user_role_user_component__WEBPACK_IMPORTED_MODULE_10__["RoleUserComponent"]],
            imports: [_angular_common__WEBPACK_IMPORTED_MODULE_1__["CommonModule"], _sys_role_routing_module__WEBPACK_IMPORTED_MODULE_8__["SysRoleRoutingModule"], _shared_shared_module__WEBPACK_IMPORTED_MODULE_6__["SharedModule"], _shared_components_pro_button__WEBPACK_IMPORTED_MODULE_3__["ProButtonModule"], _shared_components_pro_table__WEBPACK_IMPORTED_MODULE_5__["ProTableModule"], _shared_components_pro_status__WEBPACK_IMPORTED_MODULE_4__["ProStatusModule"]]
        })
    ], SysRoleModule);
    return SysRoleModule;
}());



/***/ }),

/***/ "./src/app/shared/service/warning-message.service.ts":
/*!***********************************************************!*\
  !*** ./src/app/shared/service/warning-message.service.ts ***!
  \***********************************************************/
/*! exports provided: WarningMessageService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WarningMessageService", function() { return WarningMessageService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _iux_live__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @iux/live */ "./node_modules/@iux/live/__ivy_ngcc__/fesm2015/iux-live.js");
/* harmony import */ var _components_warning_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../components/warning.component */ "./src/app/shared/components/warning.component.ts");
/* harmony import */ var _models_live_const__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./../models/live.const */ "./src/app/shared/models/live.const.ts");
/* harmony import */ var _i18n_i18n_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./../i18n/i18n.service */ "./src/app/shared/i18n/i18n.service.ts");






var WarningMessageService = /** @class */ (function () {
    function WarningMessageService(drawModalService, i18n) {
        this.drawModalService = drawModalService;
        this.i18n = i18n;
        this.warningComponent = _components_warning_component__WEBPACK_IMPORTED_MODULE_3__["WarningComponent"];
    }
    WarningMessageService.prototype.create = function (options) {
        this.drawModalService.create(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, _models_live_const__WEBPACK_IMPORTED_MODULE_4__["MODAL_COMMON"].generateDrawerOptions()), { lvModalKey: 'warningMessage' }), {
            lvType: 'modal',
            lvDialogIcon: 'lv-icon-popup-danger-48',
            lvHeader: this.i18n.get('common_warning_label'),
            lvContent: this.warningComponent,
            lvComponentParams: {
                content: options.content
            },
            lvWidth: options.width || _models_live_const__WEBPACK_IMPORTED_MODULE_4__["MODAL_COMMON"].normalWidth,
            lvOkType: 'default',
            lvCancelType: 'primary',
            lvOkDisabled: true,
            lvFocusButtonId: 'cancel',
            lvCloseButtonDisplay: true,
            lvAfterOpen: function (modal) {
                var component = modal.getContentComponent();
                var modalIns = modal.getInstance();
                component.isChecked$.subscribe(function (e) {
                    modalIns.lvOkDisabled = !e;
                });
            },
            lvCancel: function (modal) {
                if (options.onCancel) {
                    options.onCancel();
                }
            },
            lvOk: function (modal) { return options.onOK(); },
            lvAfterClose: function (result) {
                if (options.lvAfterClose) {
                    options.lvAfterClose(result);
                }
            }
        }));
    };
    WarningMessageService.ctorParameters = function () { return [
        { type: _iux_live__WEBPACK_IMPORTED_MODULE_2__["ModalService"] },
        { type: _i18n_i18n_service__WEBPACK_IMPORTED_MODULE_5__["I18NService"] }
    ]; };
    WarningMessageService = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_iux_live__WEBPACK_IMPORTED_MODULE_2__["ModalService"], _i18n_i18n_service__WEBPACK_IMPORTED_MODULE_5__["I18NService"]])
    ], WarningMessageService);
    return WarningMessageService;
}());



/***/ })

}]);
//# sourceMappingURL=sys-role-sys-role-module.js.map