(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["task-task-module"],{

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/insight/task/task.component.html":
/*!*************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/business/insight/task/task.component.html ***!
  \*************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class=\"aui-fullpage\">\n  <div class=\"aui-header-1\">\n    <h1>{{ 'common_back_task_label' | i18n }}</h1>\n  </div>\n  <div class=\"aui-block\">\n    <div class=\"aui-operation\">\n      <lv-group>\n        <lv-pro-button-group [config]=\"btnsConfig\" [bindData]=\"selectionData\"></lv-pro-button-group>\n      </lv-group>\n      <lv-group lvGutter=\"8px\">\n        <lv-group lvGutter=\"8px\">\n          <button class=\"aui-button-icon\" lv-button lvSize=\"auto\" (click)=\"dataTable.fetchData()\">\n            <i lv-icon=\"lv-icon-refresh\" [lvColorState]=\"true\"></i>\n          </button>\n        </lv-group>\n      </lv-group>\n    </div>\n    <div class=\"list-container\">\n      <lv-pro-table #dataTable [config]=\"tableConfig\" [data]=\"tableData\"></lv-pro-table>\n    </div>\n  </div>\n</div>\n\n<ng-template #statusTpl let-item>\n  <lv-group lvGutter='4px'>\n    <i class=\"status-icon\" [lv-icon]=\"item.taskResult | textMap: 'backTaskStatusIcon'\" [lvColorState]=\"true\"></i>\n    <span>{{ item.taskResult | textMap: 'backTaskStatus' | nil }}</span>\n  </lv-group>\n</ng-template>\n\n<ng-template #taskNameTpl let-item>\n  <span lv-overflow>{{ item.taskName | i18n }}</span>\n</ng-template>\n\n<ng-template #progressTpl let-item>\n  <lv-progress [lvValue]=\"item.taskProgress\"></lv-progress>\n</ng-template>\n\n<ng-template #detailDialogTpl>\n  <div *ngIf=\"currentRow?.taskName !== 'ism.drm.pg.export' || currentRow?.taskResult !== 0; else downloadTpl\">\n    <span [innerHtml]=\"getTaskDetail()\"></span>\n  </div>\n  <ng-template #downloadTpl>\n    <button lv-button [lvType]=\"'link'\" (click)=\"downloadFile()\">{{ 'common_download_file_label' | i18n }}</button>\n  </ng-template>\n</ng-template>");

/***/ }),

/***/ "./src/app/business/insight/task/task-routing.module.ts":
/*!**************************************************************!*\
  !*** ./src/app/business/insight/task/task-routing.module.ts ***!
  \**************************************************************/
/*! exports provided: TaskRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TaskRoutingModule", function() { return TaskRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _task_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./task.component */ "./src/app/business/insight/task/task.component.ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/__ivy_ngcc__/fesm2015/router.js");




var routes = [{ path: '', component: _task_component__WEBPACK_IMPORTED_MODULE_1__["TaskComponent"] }];
var TaskRoutingModule = /** @class */ (function () {
    function TaskRoutingModule() {
    }
    TaskRoutingModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_2__["NgModule"])({
            imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__["RouterModule"].forChild(routes)],
            exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__["RouterModule"]]
        })
    ], TaskRoutingModule);
    return TaskRoutingModule;
}());



/***/ }),

/***/ "./src/app/business/insight/task/task.component.less":
/*!***********************************************************!*\
  !*** ./src/app/business/insight/task/task.component.less ***!
  \***********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (".filter-select {\n  width: 200px;\n}\n.status-icon {\n  padding-bottom: 2px;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi91c3IxL3dvcmtzcGFjZS9DTUNfUGFja2FnZV9FdWxlci9TZXJ2ZXIvc3JjL1dlYlVJL1RpbnlfdG9fTGl2ZVVJL3NyYy9hcHAvYnVzaW5lc3MvaW5zaWdodC90YXNrL3Rhc2suY29tcG9uZW50Lmxlc3MiLCJzcmMvYXBwL2J1c2luZXNzL2luc2lnaHQvdGFzay90YXNrLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0UsWUFBQTtBQ0NGO0FERUE7RUFDRSxtQkFBQTtBQ0FGIiwiZmlsZSI6InNyYy9hcHAvYnVzaW5lc3MvaW5zaWdodC90YXNrL3Rhc2suY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuZmlsdGVyLXNlbGVjdCB7XG4gIHdpZHRoOiAyMDBweDtcbn1cblxuLnN0YXR1cy1pY29uIHtcbiAgcGFkZGluZy1ib3R0b206IDJweDtcbn1cbiIsIi5maWx0ZXItc2VsZWN0IHtcbiAgd2lkdGg6IDIwMHB4O1xufVxuLnN0YXR1cy1pY29uIHtcbiAgcGFkZGluZy1ib3R0b206IDJweDtcbn1cbiJdfQ== */");

/***/ }),

/***/ "./src/app/business/insight/task/task.component.ts":
/*!*********************************************************!*\
  !*** ./src/app/business/insight/task/task.component.ts ***!
  \*********************************************************/
/*! exports provided: TaskComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TaskComponent", function() { return TaskComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _shared_components_pro_table__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @shared/components/pro-table */ "./src/app/shared/components/pro-table/index.ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _shared_service_warning_message_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @shared/service/warning-message.service */ "./src/app/shared/service/warning-message.service.ts");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @shared */ "./src/app/shared/index.ts");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common/http */ "./node_modules/@angular/common/__ivy_ngcc__/fesm2015/http.js");







var TaskComponent = /** @class */ (function () {
    function TaskComponent(i18n, http, dataMap, utilsService, systemApi, drawModal, warningMessage) {
        this.i18n = i18n;
        this.http = http;
        this.dataMap = dataMap;
        this.utilsService = utilsService;
        this.systemApi = systemApi;
        this.drawModal = drawModal;
        this.warningMessage = warningMessage;
    }
    TaskComponent.prototype.ngOnInit = function () {
        this.initConfig();
    };
    TaskComponent.prototype.ngAfterViewInit = function () {
        this.dataTable.fetchData();
    };
    TaskComponent.prototype.initConfig = function () {
        var _this = this;
        var genColItem = function (key, label, moreOpts) { return (Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({ key: key, sort: true, name: _this.i18n.get(label) }, moreOpts)); };
        var btns = [
            {
                id: 'delete',
                label: this.i18n.get('common_delete_label'),
                onClick: Object(lodash__WEBPACK_IMPORTED_MODULE_1__["bind"])(this.deleteRows, this),
                disableCheck: function () { return Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isEmpty"])(_this.selectionData); }
            }
        ];
        var oprateCellRender = {
            type: 'operation',
            config: {
                maxDisplayItems: 3,
                items: [
                    {
                        id: 'delete',
                        label: this.i18n.get('common_delete_label'),
                        onClick: Object(lodash__WEBPACK_IMPORTED_MODULE_1__["bind"])(this.deleteRows, this)
                    },
                    {
                        id: 'detail',
                        label: this.i18n.get('common_lookover_label'),
                        disableCheck: function (_a) {
                            var _b = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__read"])(_a, 1), row = _b[0];
                            if (Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isNil"])(row))
                                return;
                            if (Object(lodash__WEBPACK_IMPORTED_MODULE_1__["eq"])(row.taskName, 'ism.drm.pg.export') && !Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isEmpty"])(row.taskLink))
                                return false;
                            return Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isEmpty"])(row.taskDetail);
                        },
                        onClick: function (_a) {
                            var _b = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__read"])(_a, 1), row = _b[0];
                            if (Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isNil"])(row))
                                return;
                            _this.drawModal.create({
                                lvHeader: _this.i18n.get('common_details_info_label'),
                                lvContent: _this.detailDialogTpl,
                                lvFooter: null,
                                lvBeforeOpen: function () {
                                    Object(lodash__WEBPACK_IMPORTED_MODULE_1__["set"])(_this, 'currentRow', row);
                                }
                            });
                        }
                    }
                ]
            }
        };
        var cols = [
            genColItem('taskResult', 'common_status_label', {
                cellRender: this.statusTpl,
                width: 160,
                filter: {
                    type: 'select',
                    options: this.dataMap.toArray('backTaskStatus')
                }
            }),
            genColItem('taskName', 'common_name_label', {
                cellRender: this.taskNameTpl,
                width: 200
            }),
            genColItem('targetName', 'common_operation_target_name_label'),
            genColItem('startTime', 'common_start_time_label'),
            genColItem('endTime', 'common_end_time_label'),
            genColItem('taskProgress', 'common_task_progress_label', {
                cellRender: this.progressTpl,
                width: 160
            }),
            genColItem('operation', 'common_operation_label', {
                cellRender: oprateCellRender,
                width: 150,
                sort: false
            })
        ];
        this.btnsConfig = btns;
        this.tableConfig = {
            table: {
                autoPolling: _shared__WEBPACK_IMPORTED_MODULE_5__["CommonConsts"].TIME_INTERVAL,
                colDisplayControl: false,
                compareWith: 'taskId',
                columns: cols,
                rows: {
                    selectionMode: 'multiple',
                    selectionTrigger: 'selector',
                    showSelector: true
                },
                selectionChange: function (selection) {
                    Object(lodash__WEBPACK_IMPORTED_MODULE_1__["set"])(_this, 'selectionData', selection);
                },
                fetchData: function (filters, args) {
                    _this.getData(filters, args);
                },
                trackByFn: function (_, item) { return item.taskId; }
            }
        };
    };
    TaskComponent.prototype.getTaskDetail = function () {
        var detail = '';
        if (!Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isEmpty"])(Object(lodash__WEBPACK_IMPORTED_MODULE_1__["toString"])(this.currentRow.taskDetail))) {
            try {
                detail = this.utilsService.getStringWithBothParams(["" + _shared__WEBPACK_IMPORTED_MODULE_5__["ERROR_CONST"].ERRORCODE_PRE + this.currentRow.taskDetail].concat(this.currentRow['taskDetailParas'] || []));
                if (this.currentRow.taskDetail === '1073947478') {
                    detail = detail.split('\n').join('<br>');
                }
            }
            catch (error) {
                detail = '--';
            }
        }
        return detail;
    };
    TaskComponent.prototype.genParams = function (_filters) {
        var _a = Object(lodash__WEBPACK_IMPORTED_MODULE_1__["cloneDeep"])(_filters), paginator = _a.paginator, sort = _a.sort, filters = _a.filters;
        var result = {};
        var getFilterVal = function (key) { return Object(lodash__WEBPACK_IMPORTED_MODULE_1__["first"])(Object(lodash__WEBPACK_IMPORTED_MODULE_1__["get"])(Object(lodash__WEBPACK_IMPORTED_MODULE_1__["first"])(Object(lodash__WEBPACK_IMPORTED_MODULE_1__["filter"])(filters, { key: key })), 'value')); };
        if (!Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isNil"])(paginator)) {
            var _b = paginator, pageSize = _b.pageSize, startPage = _b.startPage;
            Object(lodash__WEBPACK_IMPORTED_MODULE_1__["assign"])(result, { pageSize: pageSize, startPage: startPage });
        }
        if (!Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isNil"])(sort)) {
            var _c = sort, orderBy = _c.orderBy, orderType = _c.orderType;
            Object(lodash__WEBPACK_IMPORTED_MODULE_1__["assign"])(result, { orderType: orderType, orderBy: orderBy });
        }
        if (!Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isEmpty"])(filters)) {
            var taskResult = getFilterVal('taskResult');
            Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isNumber"])(taskResult) && Object(lodash__WEBPACK_IMPORTED_MODULE_1__["assign"])(result, { taskResult: taskResult });
        }
        return result;
    };
    TaskComponent.prototype.getData = function (filters, args) {
        var _this = this;
        var params = this.genParams(filters);
        this.systemApi.ShowTasks(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, params), { lvpLoading: filters.lvpLoading })).subscribe(function (res) {
            (Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isNil"])(args) || !args.isAutoPolling) && _this.resetSelection();
            if (Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isNil"])(res.records))
                return;
            Object(lodash__WEBPACK_IMPORTED_MODULE_1__["each"])(res.records, function (item) {
                if (item.taskName === 'ism.drm.pg.export' && item.targetName === 'Protected group') {
                    Object(lodash__WEBPACK_IMPORTED_MODULE_1__["assign"])(item, {
                        targetName: _this.i18n.get('ism.drm.guide.protection.group')
                    });
                }
            });
            Object(lodash__WEBPACK_IMPORTED_MODULE_1__["set"])(_this, 'tableData', {
                total: res.totalCount || Object(lodash__WEBPACK_IMPORTED_MODULE_1__["size"])(res.records),
                data: res.records
            });
        });
    };
    TaskComponent.prototype.resetSelection = function () {
        if (Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isEmpty"])(this.selectionData))
            return;
        Object(lodash__WEBPACK_IMPORTED_MODULE_1__["set"])(this, 'selectionData', []);
        this.dataTable.setSelections([]);
    };
    TaskComponent.prototype.deleteRows = function (rows) {
        var _this = this;
        if (Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isNil"])(rows))
            rows = this.selectionData;
        var ids = Object(lodash__WEBPACK_IMPORTED_MODULE_1__["map"])(rows, function (item) { return item.taskId; });
        this.warningMessage.create({
            content: this.i18n.get('common_delete_warning_label', [this.i18n.get('common_back_task_label')]),
            onOK: function () { return _this.systemApi.DeleteTasks({ ids: ids }).subscribe(function () { return _this.dataTable.fetchData(); }); }
        });
    };
    TaskComponent.prototype.downloadFile = function () {
        var filePath = Object(lodash__WEBPACK_IMPORTED_MODULE_1__["get"])(this, ['currentRow', 'taskLink']);
        if (Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isNil"])(filePath))
            return;
        var url = Object(lodash__WEBPACK_IMPORTED_MODULE_1__["join"])(['/ws', filePath], '');
        var req = new _angular_common_http__WEBPACK_IMPORTED_MODULE_6__["HttpRequest"]('GET', url);
        this.http.request(req).subscribe();
        this.drawModal.destroyAllModals();
    };
    TaskComponent.ctorParameters = function () { return [
        { type: _shared__WEBPACK_IMPORTED_MODULE_5__["I18NService"] },
        { type: _angular_common_http__WEBPACK_IMPORTED_MODULE_6__["HttpClient"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_5__["DataMapService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_5__["UtilsService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_5__["SystemApiService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_5__["DrawModalService"] },
        { type: _shared_service_warning_message_service__WEBPACK_IMPORTED_MODULE_4__["WarningMessageService"] }
    ]; };
    TaskComponent.propDecorators = {
        dataTable: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["ViewChild"], args: ['dataTable',] }],
        detailDialogTpl: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["ViewChild"], args: ['detailDialogTpl',] }],
        statusTpl: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["ViewChild"], args: ['statusTpl', { static: true },] }],
        taskNameTpl: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["ViewChild"], args: ['taskNameTpl', { static: true },] }],
        progressTpl: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["ViewChild"], args: ['progressTpl', { static: true },] }]
    };
    TaskComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'lvs-task',
            template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./task.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/insight/task/task.component.html")).default,
            styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./task.component.less */ "./src/app/business/insight/task/task.component.less")).default]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_shared__WEBPACK_IMPORTED_MODULE_5__["I18NService"],
            _angular_common_http__WEBPACK_IMPORTED_MODULE_6__["HttpClient"],
            _shared__WEBPACK_IMPORTED_MODULE_5__["DataMapService"],
            _shared__WEBPACK_IMPORTED_MODULE_5__["UtilsService"],
            _shared__WEBPACK_IMPORTED_MODULE_5__["SystemApiService"],
            _shared__WEBPACK_IMPORTED_MODULE_5__["DrawModalService"],
            _shared_service_warning_message_service__WEBPACK_IMPORTED_MODULE_4__["WarningMessageService"]])
    ], TaskComponent);
    return TaskComponent;
}());



/***/ }),

/***/ "./src/app/business/insight/task/task.module.ts":
/*!******************************************************!*\
  !*** ./src/app/business/insight/task/task.module.ts ***!
  \******************************************************/
/*! exports provided: TaskModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TaskModule", function() { return TaskModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/__ivy_ngcc__/fesm2015/common.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _shared_shared_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @shared/shared.module */ "./src/app/shared/shared.module.ts");
/* harmony import */ var _task_routing_module__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./task-routing.module */ "./src/app/business/insight/task/task-routing.module.ts");
/* harmony import */ var _task_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./task.component */ "./src/app/business/insight/task/task.component.ts");
/* harmony import */ var _shared_components_pro_button__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @shared/components/pro-button */ "./src/app/shared/components/pro-button/index.ts");
/* harmony import */ var _shared_components_pro_table__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @shared/components/pro-table */ "./src/app/shared/components/pro-table/index.ts");








var TaskModule = /** @class */ (function () {
    function TaskModule() {
    }
    TaskModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_2__["NgModule"])({
            declarations: [_task_component__WEBPACK_IMPORTED_MODULE_5__["TaskComponent"]],
            imports: [_angular_common__WEBPACK_IMPORTED_MODULE_1__["CommonModule"], _task_routing_module__WEBPACK_IMPORTED_MODULE_4__["TaskRoutingModule"], _shared_shared_module__WEBPACK_IMPORTED_MODULE_3__["SharedModule"], _shared_components_pro_button__WEBPACK_IMPORTED_MODULE_6__["ProButtonModule"], _shared_components_pro_table__WEBPACK_IMPORTED_MODULE_7__["ProTableModule"]],
            exports: [_task_component__WEBPACK_IMPORTED_MODULE_5__["TaskComponent"]]
        })
    ], TaskModule);
    return TaskModule;
}());



/***/ }),

/***/ "./src/app/shared/service/warning-message.service.ts":
/*!***********************************************************!*\
  !*** ./src/app/shared/service/warning-message.service.ts ***!
  \***********************************************************/
/*! exports provided: WarningMessageService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WarningMessageService", function() { return WarningMessageService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _iux_live__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @iux/live */ "./node_modules/@iux/live/__ivy_ngcc__/fesm2015/iux-live.js");
/* harmony import */ var _components_warning_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../components/warning.component */ "./src/app/shared/components/warning.component.ts");
/* harmony import */ var _models_live_const__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./../models/live.const */ "./src/app/shared/models/live.const.ts");
/* harmony import */ var _i18n_i18n_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./../i18n/i18n.service */ "./src/app/shared/i18n/i18n.service.ts");






var WarningMessageService = /** @class */ (function () {
    function WarningMessageService(drawModalService, i18n) {
        this.drawModalService = drawModalService;
        this.i18n = i18n;
        this.warningComponent = _components_warning_component__WEBPACK_IMPORTED_MODULE_3__["WarningComponent"];
    }
    WarningMessageService.prototype.create = function (options) {
        this.drawModalService.create(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"])({}, _models_live_const__WEBPACK_IMPORTED_MODULE_4__["MODAL_COMMON"].generateDrawerOptions()), { lvModalKey: 'warningMessage' }), {
            lvType: 'modal',
            lvDialogIcon: 'lv-icon-popup-danger-48',
            lvHeader: this.i18n.get('common_warning_label'),
            lvContent: this.warningComponent,
            lvComponentParams: {
                content: options.content
            },
            lvWidth: options.width || _models_live_const__WEBPACK_IMPORTED_MODULE_4__["MODAL_COMMON"].normalWidth,
            lvOkType: 'default',
            lvCancelType: 'primary',
            lvOkDisabled: true,
            lvFocusButtonId: 'cancel',
            lvCloseButtonDisplay: true,
            lvAfterOpen: function (modal) {
                var component = modal.getContentComponent();
                var modalIns = modal.getInstance();
                component.isChecked$.subscribe(function (e) {
                    modalIns.lvOkDisabled = !e;
                });
            },
            lvCancel: function (modal) {
                if (options.onCancel) {
                    options.onCancel();
                }
            },
            lvOk: function (modal) { return options.onOK(); },
            lvAfterClose: function (result) {
                if (options.lvAfterClose) {
                    options.lvAfterClose(result);
                }
            }
        }));
    };
    WarningMessageService.ctorParameters = function () { return [
        { type: _iux_live__WEBPACK_IMPORTED_MODULE_2__["ModalService"] },
        { type: _i18n_i18n_service__WEBPACK_IMPORTED_MODULE_5__["I18NService"] }
    ]; };
    WarningMessageService = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_iux_live__WEBPACK_IMPORTED_MODULE_2__["ModalService"], _i18n_i18n_service__WEBPACK_IMPORTED_MODULE_5__["I18NService"]])
    ], WarningMessageService);
    return WarningMessageService;
}());



/***/ })

}]);
//# sourceMappingURL=task-task-module.js.map