(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["topo-view-topo-view-module"],{

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/insight/topo-view/topo-view.component.html":
/*!***********************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/business/insight/topo-view/topo-view.component.html ***!
  \***********************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div id=\"topoContainer\">\n    <div id=\"globalTopoBox\"></div>\n    <div id=\"globalTopoLegend\" [ngClass]=\"{'container-visible': displayLegend, 'container-hidden': !displayLegend}\">\n        <div id=\"legendTitle\">\n            {{'protecion_topo_legend_title_label' | i18n}}\n        </div>\n        <div id=\"globalLegendBox\"></div>\n    </div>\n    <div id=\"noTopoDataContainer\"\n        [ngClass]=\"{'container-visible': noTopoDataShow, 'container-hidden': !noTopoDataShow}\">\n        {{'protecion_topo_no_data_label' | i18n}}\n    </div>\n</div>");

/***/ }),

/***/ "./src/app/business/insight/topo-view/topo-view-routing.module.ts":
/*!************************************************************************!*\
  !*** ./src/app/business/insight/topo-view/topo-view-routing.module.ts ***!
  \************************************************************************/
/*! exports provided: TopoViewRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TopoViewRoutingModule", function() { return TopoViewRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/__ivy_ngcc__/fesm2015/router.js");
/* harmony import */ var _topo_view_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./topo-view.component */ "./src/app/business/insight/topo-view/topo-view.component.ts");




var routes = [{ path: '', component: _topo_view_component__WEBPACK_IMPORTED_MODULE_3__["TopoViewComponent"] }];
var TopoViewRoutingModule = /** @class */ (function () {
    function TopoViewRoutingModule() {
    }
    TopoViewRoutingModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forChild(routes)],
            exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]]
        })
    ], TopoViewRoutingModule);
    return TopoViewRoutingModule;
}());



/***/ }),

/***/ "./src/app/business/insight/topo-view/topo-view.component.less":
/*!*********************************************************************!*\
  !*** ./src/app/business/insight/topo-view/topo-view.component.less ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("#topoContainer {\n  height: 100%;\n  width: 100%;\n  background: #f5f5f5;\n}\n#legendTitle {\n  height: 30px;\n  text-align: center;\n  color: #666666;\n  font-weight: bold;\n  background-color: #dedede;\n  line-height: 30px;\n}\n#globalTopoLegend {\n  position: absolute;\n  width: 240px;\n  height: 280px;\n  border: 1px solid #e0e0e0;\n  box-shadow: 0px 20px 12px #c4c4c4;\n}\n#globalLegendBox {\n  background: #f5f5f5;\n}\n#noTopoDataContainer {\n  width: 800px;\n  text-align: center;\n  position: absolute;\n  top: 240px;\n  color: #666666;\n}\n.container-visible {\n  display: block;\n}\n.container-hidden {\n  display: none;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "./src/app/business/insight/topo-view/topo-view.component.ts":
/*!*******************************************************************!*\
  !*** ./src/app/business/insight/topo-view/topo-view.component.ts ***!
  \*******************************************************************/
/*! exports provided: TopoViewComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TopoViewComponent", function() { return TopoViewComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _iux_live__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @iux/live */ "./node_modules/@iux/live/__ivy_ngcc__/fesm2015/iux-live.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @shared */ "./src/app/shared/index.ts");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs */ "./node_modules/rxjs/_esm2015/index.js");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ "./node_modules/rxjs/_esm2015/operators/index.js");








var TopoViewComponent = /** @class */ (function () {
    function TopoViewComponent(i18n, messageService, systemApiService, topoLayoutService, siteResourceApiService) {
        this.i18n = i18n;
        this.messageService = messageService;
        this.systemApiService = systemApiService;
        this.topoLayoutService = topoLayoutService;
        this.siteResourceApiService = siteResourceApiService;
        this.clientURL = location.protocol + '//' + location.host;
        this.lang = this.i18n.isZh ? 'zh_CN' : 'en_US';
        this.displayLegend = false;
        this.noTopoDataShow = false;
        this.topoRefreshTime = 30 * 1e3;
        this.topoSub = new rxjs__WEBPACK_IMPORTED_MODULE_6__["Subscription"]();
    }
    TopoViewComponent.prototype.ngAfterViewInit = function () {
        var _this = this;
        Object(lodash__WEBPACK_IMPORTED_MODULE_5__["defer"])(function () { return _this.initTopo(); });
    };
    TopoViewComponent.prototype.ngOnDestroy = function () {
        if (this.topoSub) {
            this.topoSub.unsubscribe();
        }
    };
    TopoViewComponent.prototype.ngOnInit = function () {
        this.registerTopoImage();
    };
    // 注册topo图片
    TopoViewComponent.prototype.registerTopoImage = function () {
        var clientURL = location.protocol + '//' + location.host;
        this.topoLayoutService.registerImage(clientURL);
    };
    TopoViewComponent.prototype.getStorageLinkDetail = function (devSN, trgSN) { };
    TopoViewComponent.prototype.getHostLinkDetail = function (devSN, trgSN) { };
    TopoViewComponent.prototype.getQuorumLinkDetail = function (devSN, trgSN) { };
    TopoViewComponent.prototype.viewAppInfo = function (hostSN, locationX, locationY) { };
    TopoViewComponent.prototype.viewStorageInfo = function (storageSN) {
        this.siteResourceApiService.ShowDeviceManageSite({ deviceSn: storageSN }).subscribe(function (result) {
            var ip = result.linkIp;
            if (_shared__WEBPACK_IMPORTED_MODULE_3__["BaseUtilService"].validateIpv6(ip)) {
                ip = "[" + ip + "]";
            }
            if (result.linkPort) {
                window.open("https://" + ip + ":" + result.linkPort);
            }
            else {
                window.open("https://" + ip);
            }
        });
    };
    TopoViewComponent.prototype.setDrResourceSite = function (selectId, devSN, siteID, devName, siteName, srcSiteName) { };
    TopoViewComponent.prototype.initPopupMenu = function (popupMenu, network) {
        var _this = this;
        var lastData, magnifyInteraction;
        popupMenu.onMenuShowing = function (e) {
            lastData = network.getSelectionModel().getLastData();
            magnifyInteraction = null;
            network.getInteractions().forEach(function (interaction) {
                if (interaction instanceof twaver.network.interaction.MagnifyInteraction ||
                    interaction instanceof twaver.canvas.interaction.MagnifyInteraction) {
                    magnifyInteraction = interaction;
                }
            });
            return true;
        };
        popupMenu.onAction = function (menuItem) {
            var devSN, trgSN, nodeID;
            switch (menuItem.type) {
                case 'storageLink':
                    devSN = lastData.getClient('devSN');
                    trgSN = lastData.getClient('trgSN');
                    if (devSN == null || trgSN == null) {
                        return;
                    }
                    _this.getStorageLinkDetail(devSN, trgSN);
                    break;
                case 'hostLink':
                    devSN = lastData.getClient('devSN');
                    trgSN = lastData.getClient('trgSN');
                    if (devSN == null || trgSN == null) {
                        return;
                    }
                    _this.getHostLinkDetail(devSN, trgSN);
                    break;
                case 'quorumLink':
                    devSN = lastData.getClient('devSN');
                    trgSN = lastData.getClient('trgSN');
                    if (devSN == null || trgSN == null) {
                        return;
                    }
                    _this.getQuorumLinkDetail(devSN, trgSN);
                    break;
                case 'host':
                    nodeID = lastData.getId();
                    var hostAndSite = nodeID.split('---');
                    _this.viewAppInfo(hostAndSite[0], lastData.getLocation().x, lastData.getLocation().y);
                    break;
                case 'storage':
                    nodeID = lastData.getId();
                    var storageAndSite = nodeID.split('---');
                    _this.viewStorageInfo(storageAndSite[0]);
                    break;
                case 'vis':
                    nodeID = lastData.getClient('moID');
                    _this.viewStorageInfo(nodeID);
                    break;
                case 'vsphere':
                    devSN = lastData.getClient('devSN');
                    var selectId = lastData.getId();
                    var siteID = lastData.getClient('siteID');
                    var devName = lastData.getClient('topoHostName');
                    var siteName = lastData.getClient('topoSiteName');
                    var srcSiteName = lastData.getClient('srcSiteName');
                    _this.setDrResourceSite(selectId, devSN, siteID, devName, siteName, srcSiteName);
                    break;
                default:
                    break;
            }
        };
        popupMenu.isVisible = function (menuItem) {
            if (magnifyInteraction) {
                return menuItem.group === 'Magnify';
            }
            else {
                if (lastData) {
                    var selectId = lastData.getId();
                    if (lastData instanceof twaver.Link) {
                        if (selectId.indexOf('storagelink-') > -1) {
                            return menuItem.type === 'storageLink';
                        }
                        else if (selectId.indexOf('hostlink-') > -1) {
                            return menuItem.type === 'hostLink';
                        }
                        else if (selectId.indexOf('quorumlink-') > -1) {
                            return menuItem.type === 'quorumLink';
                        }
                        else {
                            return false;
                        }
                    }
                    if (lastData instanceof twaver.Node) {
                        var elementNode = lastData;
                        var isHost = elementNode.getClient('isHostOrStorage');
                        if (isHost == null) {
                            return false;
                        }
                        else if (isHost.indexOf('host') > -1) {
                            return menuItem.type === 'host';
                        }
                        else if (isHost.indexOf('storage') > -1) {
                            return menuItem.type === 'storage';
                        }
                        else if (isHost.indexOf('vis') > -1) {
                            return menuItem.type === 'vis';
                        }
                        else if (isHost.indexOf('vsphere') > -1) {
                            return menuItem.type === 'vsphere';
                        }
                        else {
                            return false;
                        }
                    }
                }
                else {
                    return false;
                }
            }
        };
        popupMenu.setMenuItems([
            {
                type: 'storageLink',
                label: this.i18n.get('protecion_topo_link_info_label'),
                group: 'Element'
            },
            {
                type: 'hostLink',
                label: this.i18n.get('protecion_topo_hostlink_info_label'),
                group: 'Element'
            },
            {
                type: 'quorumLink',
                label: this.i18n.get('protecion_topo_link_info_label'),
                group: 'Element'
            },
            {
                type: 'host',
                label: this.i18n.get('protecion_topo_app_info_label'),
                group: 'Element'
            },
            {
                type: 'storage',
                label: this.i18n.get('protecion_topo_view_storage_label'),
                group: 'Element'
            },
            {
                type: 'vis',
                label: this.i18n.get('protecion_topo_view_storage_label'),
                group: 'Element'
            },
            {
                type: 'vsphere',
                label: this.i18n.get('protecion_topo_reset_site_label'),
                group: 'Element'
            }
        ]);
    };
    TopoViewComponent.prototype.initNetwork = function (network, toolBar, fullFlag) {
        var networkPane = new twaver.controls.BorderPane(network, toolBar);
        var height = jquery__WEBPACK_IMPORTED_MODULE_4__('body').height() - jquery__WEBPACK_IMPORTED_MODULE_4__('#topoContainer').offset().top;
        if (fullFlag) {
            networkPane.adjustBounds({
                x: 0,
                y: 0,
                width: jquery__WEBPACK_IMPORTED_MODULE_4__('body').width(),
                height: jquery__WEBPACK_IMPORTED_MODULE_4__('body').height()
            });
        }
        else {
            networkPane.adjustBounds({
                x: jquery__WEBPACK_IMPORTED_MODULE_4__('#topoContainer').offset().left,
                y: jquery__WEBPACK_IMPORTED_MODULE_4__('#topoContainer').offset().top,
                width: jquery__WEBPACK_IMPORTED_MODULE_4__('#topoContainer').width(),
                height: height - 10
            });
        }
        networkPane.getView().style.backgroundColor = '#F5F5F5';
        jquery__WEBPACK_IMPORTED_MODULE_4__('#globalTopoBox').append(networkPane.getView());
        jquery__WEBPACK_IMPORTED_MODULE_4__('#globalTopoLegend').width(!this.i18n.isZh ? 260 : 240);
    };
    TopoViewComponent.prototype.addButton = function (toolbar, label, src, handler) {
        var button = document.createElement('input');
        button.onclick = handler;
        button.setAttribute('type', 'button');
        button.setAttribute('title', label);
        button.style.width = '28px';
        button.style.height = '28px';
        button.style.border = '1px solid #676767';
        button.style.background = 'url(' + src + ') no-repeat';
        button.style['background-position'] = 'center';
        button.style['border-radius'] = '3px';
        toolbar.appendChild(button);
    };
    TopoViewComponent.prototype.checkFull = function () {
        var isFull = document.fullscreenElement ||
            document['mozFullScreenElement'] ||
            document['webkitFullscreenElement'] ||
            document['msFullscreenElement'];
        if (isFull === undefined) {
            isFull = false;
        }
        return isFull;
    };
    TopoViewComponent.prototype.createCheckBox = function (toolBar) {
        var _this = this;
        var checkBoxContainer = document.createElement('div');
        checkBoxContainer.style.float = 'right';
        checkBoxContainer.style['margin-right'] = '28px';
        checkBoxContainer.style['margin-top'] = '12px';
        var checkbox = document.createElement('input');
        checkbox.setAttribute('type', 'checkbox');
        checkbox.setAttribute('id', 'showLegendCheckbox');
        checkbox.addEventListener('change', function (e) {
            jquery__WEBPACK_IMPORTED_MODULE_4__('#globalTopoLegend').css('top', jquery__WEBPACK_IMPORTED_MODULE_4__(e.target).offset().top + 24);
            jquery__WEBPACK_IMPORTED_MODULE_4__('#globalTopoLegend').css('left', jquery__WEBPACK_IMPORTED_MODULE_4__(e.target).offset().left - jquery__WEBPACK_IMPORTED_MODULE_4__('#globalTopoLegend').width() + (!_this.i18n.isZh ? 86 : 62));
            _this.displayLegend = jquery__WEBPACK_IMPORTED_MODULE_4__(e.target).is(':checked');
        });
        checkBoxContainer.appendChild(checkbox);
        var labelSpan = document.createElement('label');
        labelSpan.setAttribute('for', 'showLegendCheckbox');
        labelSpan.innerText = this.i18n.get('protecion_show_topo_legend_label');
        labelSpan.style.color = '#666666';
        labelSpan.style.position = 'relative';
        labelSpan.style.top = '-2px';
        labelSpan.style.left = '4px';
        checkBoxContainer.appendChild(labelSpan);
        toolBar.appendChild(checkBoxContainer);
    };
    TopoViewComponent.prototype.createRefreshInput = function (toolBar) {
        var _this = this;
        var inputContainer = document.createElement('div');
        inputContainer.style.float = 'right';
        inputContainer.style['margin-right'] = '28px';
        inputContainer.style['margin-top'] = '12px';
        var labelSpan = document.createElement('span');
        labelSpan.innerText = this.i18n.get('protecion_topo_period_label');
        labelSpan.style.color = '#666666';
        labelSpan.style.position = 'relative';
        labelSpan.style.top = '-2px';
        labelSpan.style.left = '4px';
        inputContainer.appendChild(labelSpan);
        var select = document.createElement('select');
        select.setAttribute('id', 'refreshTopoPeriod');
        select.innerHTML =
            "<option value='0'>" +
                this.i18n.get('protecion_topo_second_period_label') +
                '</option>' +
                "<option value='1'>" +
                this.i18n.get('protecion_topo_min_1_period_label') +
                '</option>' +
                "<option value='2'>" +
                this.i18n.get('protecion_topo_min_2_period_label') +
                '</option>' +
                "<option value='3'>" +
                this.i18n.get('protecion_topo_min_5_period_label') +
                '</option>' +
                "<option value='4'>" +
                this.i18n.get('protecion_topo_min_10_period_label') +
                '</option>' +
                "<option value='5'>" +
                this.i18n.get('protecion_topo_min_30_period_label') +
                '</option>';
        select.style.width = '80px';
        select.style.position = 'relative';
        select.style.top = '-2px';
        select.style.left = '10px';
        select.addEventListener('change', function (e) {
            _this.systemApiService
                .ModifyPollPeriod({
                lvpDoException: false,
                lvpOperationTips: false,
                requestBody: {
                    topoPeriodIndex: jquery__WEBPACK_IMPORTED_MODULE_4__(e.target).val()
                }
            })
                .subscribe(function (res) {
                if (res.result === 'success') {
                    _this.originalTime = jquery__WEBPACK_IMPORTED_MODULE_4__(e.target).val();
                    _this.messageService.success(_this.i18n.get('common_term_operation_success_label'), {
                        lvMessageKey: 'modify-success',
                        lvShowCloseButton: true
                    });
                    //刷新数据
                    _this.initTopo();
                }
                else if (res.result === 'busy') {
                    jquery__WEBPACK_IMPORTED_MODULE_4__('#refreshTopoPeriod').val(_this.originalTime);
                    _this.messageService.error(_this.i18n.get('protecion_modify_topo_refresh_busy_label'), {
                        lvMessageKey: 'error-busy',
                        lvShowCloseButton: true
                    });
                }
                else {
                    _this.messageService.error(_this.i18n.get('protecion_modify_topo_refresh_fail_label'), {
                        lvMessageKey: 'error-fail',
                        lvShowCloseButton: true
                    });
                    jquery__WEBPACK_IMPORTED_MODULE_4__('#refreshTopoPeriod').val(_this.originalTime);
                }
            });
        });
        inputContainer.appendChild(select);
        toolBar.appendChild(inputContainer);
    };
    TopoViewComponent.prototype.initToolbar = function (toolBar, network, box) {
        var _this = this;
        this.addButton(toolBar, this.i18n.get('protecion_topo_zoom_in_label'), '/src/assets/img/toolbar/zoomIn.png', function () {
            network.zoomIn();
        });
        this.addButton(toolBar, this.i18n.get('protecion_topo_zoom_out_label'), '/src/assets/img/toolbar/zoomOut.png', function () {
            network.zoomOut();
        });
        this.addButton(toolBar, this.i18n.get('protecion_topo_zoom_reset_label'), '/src/assets/img/toolbar/zoomReset.png', function () {
            network.zoomReset();
        });
        this.addButton(toolBar, this.i18n.get('protecion_topo_zoom_overview_label'), '/src/assets/img/toolbar/zoomOverview.png', function () {
            network.zoomOverview();
        });
        this.addButton(toolBar, this.i18n.get('protecion_topo_zoom_fullscreeen_label'), '/src/assets/img/toolbar/fullscreen.png', function () {
            var docElm = document.documentElement;
            if (docElm.requestFullscreen ||
                docElm['webkitRequestFullScreen'] ||
                docElm['mozRequestFullScreen'] ||
                docElm['msRequestFullscreen']) {
                var fullscreen = document.fullscreen ||
                    document['mozFullScreen'] ||
                    document['webkitIsFullScreen'] ||
                    document['msFullscreenElement'];
                if (!fullscreen) {
                    var boxElm = document.getElementById('topoContainer');
                    if (boxElm.requestFullscreen) {
                        boxElm.requestFullscreen();
                    }
                    else if (boxElm.webkitRequestFullScreen) {
                        boxElm.webkitRequestFullScreen();
                    }
                    else if (boxElm.mozRequestFullScreen) {
                        boxElm.mozRequestFullScreen();
                    }
                    else if (boxElm.msRequestFullscreen) {
                        boxElm.msRequestFullscreen();
                    }
                    _this.initTopo(true);
                }
                else {
                    if (document.exitFullscreen) {
                        document.exitFullscreen();
                    }
                    else if (document['mozCancelFullScreen']) {
                        document['mozCancelFullScreen']();
                    }
                    else if (document['webkitCancelFullScreen']) {
                        document['webkitCancelFullScreen']();
                    }
                    else if (document['msExitFullscreen']) {
                        document['msExitFullscreen']();
                    }
                    _this.initTopo(false);
                }
                window.addEventListener('resize', function () {
                    if (!_this.checkFull()) {
                        _this.initTopo(false);
                    }
                });
            }
        });
        //保存
        this.addButton(toolBar, this.i18n.get('protecion_topo_zoom_save_label'), '/src/assets/img/toolbar/save.png', function () {
            var com = new CommonXmlSerializer(box);
            var datas = com.serializeCommon();
            datas = datas.replace("<topo version='5.9.3' platform='java'>", "<twaver v='2.0' p='flex'>");
            datas = datas.replace(/class=/g, 'type=');
            _this.systemApiService
                .ModifyTopodata({
                requestBody: {
                    clientURL: _this.clientURL,
                    topoXml: datas
                }
            })
                .subscribe(function () { });
        });
        //显示图例checkbox
        this.createCheckBox(toolBar);
        //刷新周期
        this.createRefreshInput(toolBar);
    };
    TopoViewComponent.prototype.initTopo = function (fullFlag) {
        jquery__WEBPACK_IMPORTED_MODULE_4__('#globalTopoBox').empty();
        jquery__WEBPACK_IMPORTED_MODULE_4__('#globalLegendBox').empty();
        var toolBar = document.createElement('div');
        toolBar.style.padding = '5px';
        this.topoLayoutService.registerClient();
        var box = new twaver.ElementBox();
        var network = new twaver.vector.Network(box);
        network.setWheelToZoom(false);
        network.setDoubleClickToGroupExpand(false);
        var popupMenu = new twaver.controls.PopupMenu(network);
        this.initPopupMenu(popupMenu, network);
        // 图例box
        var legendBox = new twaver.ElementBox();
        var legendNetwork = new twaver.vector.Network(legendBox);
        legendNetwork.setInteractions(null);
        // 初始化容器
        this.initNetwork(network, toolBar, fullFlag);
        // 初始化工具条
        this.initToolbar(toolBar, network, box);
        //查询topo数据
        this.getTopoData(box, network, legendBox, legendNetwork);
    };
    TopoViewComponent.prototype.getLegendPanaelHeight = function (box) {
        var rootGroup = null;
        box.forEachByBreadthFirst(function (element) {
            if (element.getParent() == null) {
                rootGroup = element;
                return;
            }
        });
        return rootGroup.getHeight() + 10;
    };
    TopoViewComponent.prototype.getTopoData = function (box, network, legendBox, legendNetwork) {
        var _this = this;
        if (this.topoSub) {
            this.topoSub.unsubscribe();
        }
        this.topoSub = Object(rxjs__WEBPACK_IMPORTED_MODULE_6__["timer"])(0, this.topoRefreshTime)
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_7__["switchMap"])(function (index) {
            return _this.systemApiService.ShowGloabelSiteTopo({ localeString: _this.lang, lvpLoading: !index });
        }))
            .subscribe(function (result) {
            if (Object(lodash__WEBPACK_IMPORTED_MODULE_5__["isEmpty"])(result.topodataList) || !Object(lodash__WEBPACK_IMPORTED_MODULE_5__["isArray"])(result.topodataList)) {
                _this.messageService.error(_this.i18n.get('-1'), {
                    lvMessageKey: 'error-topo',
                    lvShowCloseButton: true
                });
                return;
            }
            var resultTag = result.topodataList[0];
            if (resultTag === 'success') {
                var boxString = result.topodataList[1];
                boxString = _this.topoLayoutService.replaceTwaverNode(boxString);
                boxString = _this.topoLayoutService.replaceTwaverColor(boxString);
                var legendString = result.topodataList[2];
                box.clear();
                var boxCom = new CommonXmlSerializer(box);
                boxCom.deserializeCommon(boxString);
                var isTopoSaved = result.topodataList[3];
                _this.topoLayoutService.addDoubleClick(network, _this);
                legendBox.clear();
                var legendCom = new CommonXmlSerializer(legendBox);
                legendCom.deserializeCommon(legendString);
                //计算legend长度
                var legendHeight = _this.getLegendPanaelHeight(legendBox);
                jquery__WEBPACK_IMPORTED_MODULE_4__('#globalTopoLegend').height(legendHeight + 30);
                jquery__WEBPACK_IMPORTED_MODULE_4__('#globalLegendBox').height(legendHeight);
                legendNetwork.adjustBounds({
                    x: 0,
                    y: 30,
                    width: jquery__WEBPACK_IMPORTED_MODULE_4__('#globalTopoLegend').width(),
                    height: legendHeight
                });
                jquery__WEBPACK_IMPORTED_MODULE_4__('#globalLegendBox').append(legendNetwork.getView());
                _this.topoLayoutService.handlerToolTip(box);
                _this.topoLayoutService.doLegendLayout(legendBox, legendNetwork, 0, _this.lang);
                _this.topoLayoutService.globalMouseDown(network);
                //处理topo无数据
                if (!box.getDatas().size()) {
                    jquery__WEBPACK_IMPORTED_MODULE_4__('#noTopoDataContainer').css('left', (document.body.clientWidth - 800) / 2);
                    _this.noTopoDataShow = true;
                }
                var timeIndex = result.topodataList[8];
                jquery__WEBPACK_IMPORTED_MODULE_4__('#refreshTopoPeriod').val(timeIndex || '0');
                _this.originalTime = timeIndex;
                switch (timeIndex) {
                    case '0':
                        _this.topoRefreshTime = 30 * 1e3;
                        break;
                    case '1':
                        _this.topoRefreshTime = 1 * 60 * 1e3;
                        break;
                    case '2':
                        _this.topoRefreshTime = 2 * 60 * 1e3;
                        break;
                    case '3':
                        _this.topoRefreshTime = 5 * 60 * 1e3;
                        break;
                    case '4':
                        _this.topoRefreshTime = 10 * 60 * 1e3;
                        break;
                    case '5':
                        _this.topoRefreshTime = 30 * 60 * 1e3;
                        break;
                }
            }
            else {
                _this.messageService.error(_this.i18n.get(result.topodataList[2]), {
                    lvMessageKey: 'error-topo',
                    lvShowCloseButton: true
                });
                if (_this.topoSub) {
                    _this.topoSub.unsubscribe();
                }
            }
        }, function () {
            if (_this.topoSub) {
                _this.topoSub.unsubscribe();
            }
        });
    };
    TopoViewComponent.ctorParameters = function () { return [
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["I18NService"] },
        { type: _iux_live__WEBPACK_IMPORTED_MODULE_2__["MessageService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["SystemApiService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["TopoLayoutService"] },
        { type: _shared__WEBPACK_IMPORTED_MODULE_3__["SiteResourceApiService"] }
    ]; };
    TopoViewComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'lvs-topo-view',
            template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./topo-view.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/business/insight/topo-view/topo-view.component.html")).default,
            styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./topo-view.component.less */ "./src/app/business/insight/topo-view/topo-view.component.less")).default]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_shared__WEBPACK_IMPORTED_MODULE_3__["I18NService"],
            _iux_live__WEBPACK_IMPORTED_MODULE_2__["MessageService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["SystemApiService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["TopoLayoutService"],
            _shared__WEBPACK_IMPORTED_MODULE_3__["SiteResourceApiService"]])
    ], TopoViewComponent);
    return TopoViewComponent;
}());



/***/ }),

/***/ "./src/app/business/insight/topo-view/topo-view.module.ts":
/*!****************************************************************!*\
  !*** ./src/app/business/insight/topo-view/topo-view.module.ts ***!
  \****************************************************************/
/*! exports provided: TopoViewModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TopoViewModule", function() { return TopoViewModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _shared_shared_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @shared/shared.module */ "./src/app/shared/shared.module.ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/__ivy_ngcc__/fesm2015/common.js");
/* harmony import */ var _topo_view_routing_module__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./topo-view-routing.module */ "./src/app/business/insight/topo-view/topo-view-routing.module.ts");
/* harmony import */ var _topo_view_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./topo-view.component */ "./src/app/business/insight/topo-view/topo-view.component.ts");






var TopoViewModule = /** @class */ (function () {
    function TopoViewModule() {
    }
    TopoViewModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_2__["NgModule"])({
            declarations: [_topo_view_component__WEBPACK_IMPORTED_MODULE_5__["TopoViewComponent"]],
            imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"], _topo_view_routing_module__WEBPACK_IMPORTED_MODULE_4__["TopoViewRoutingModule"], _shared_shared_module__WEBPACK_IMPORTED_MODULE_1__["SharedModule"]]
        })
    ], TopoViewModule);
    return TopoViewModule;
}());



/***/ })

}]);
//# sourceMappingURL=topo-view-topo-view-module.js.map