/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.arbitration.security;

import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.ism.drm.arbitration.service.ArbitrationCenterHelper;
import com.huawei.ism.drm.arbitration.util.ArbProperties;
import com.huawei.ism.drm.arbitration.util.VerifyUtil;
import com.huawei.jetcd.client.EtcdConfig;
import com.huawei.jetcd.exception.EtcdServerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyStore;

public final class ArbSecurityCertificateManager {
    private static final String KEY_STORE = "arb.privatepwd";

    private ArbSecurityCertificateManager() {
    }

    public static KeyStore getDefaultKeyStore(String keyStoreFile, EtcdConfig etcdConfig) throws EtcdServerException {
        KeyStore keyStore = null;
        FileInputStream in = null;
        try {
            if (VerifyUtil.isEmpty(keyStoreFile)) {
                LogManager.error("keyStoreFile is null.");
                throw new EtcdServerException(207);
            }
            File file = new File(keyStoreFile);
            if (!file.exists()) {
                LogManager.error("keyStore is not exist.");
                throw new EtcdServerException(207);
            }
            Path path = file.toPath();
            if (!ArbSecurityCertificateManager.isInSecureDir(path)) {
                LogManager.error("File not in secure directory");
                throw new EtcdServerException(207, "File not in secure directory");
            }
            if (!Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)) {
                LogManager.error("Not a regular file");
                throw new EtcdServerException(207, "Not a regular file");
            }
            in = new FileInputStream(file);
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String keyStorePwd = etcdConfig.getKeyStorePwd();
            if (!VerifyUtil.isEmpty(keyStorePwd)) {
                keyStore.load(in, keyStorePwd.toCharArray());
            } else {
                String keyStoreValue = ArbProperties.getInstance().getProperty(KEY_STORE, "");
                if (VerifyUtil.isEmpty(keyStoreValue)) {
                    LogManager.error("arb.privatepwd is empty.");
                    throw new EtcdServerException(207);
                }
                keyStore.load(in, ArbitrationCenterHelper.getInstance().decrypt(keyStoreValue).toCharArray());
            }
        }
        catch (Exception e) {
            LogManager.error("Initializing KeyStore failed." + LogManager.getErrorMessage(e));
            throw new EtcdServerException(207);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogManager.error("Initializing KeyStore failed." + LogManager.getErrorMessage(e));
                }
            }
        }
        return keyStore;
    }

    private static boolean isInSecureDir(Path path) {
        return !VerifyUtil.isEmpty(path);
    }
}

