/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.arbitration.service;

import com.huawei.aamonitor.sdk.AAMonitorClient;
import com.huawei.aamonitor.util.consts.MonitorStatus;
import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.ism.drm.arbitration.util.ArbProperties;
import com.huawei.ism.drm.arbitration.util.JSONObject;
import com.huawei.ism.drm.arbitration.util.VerifyUtil;
import com.huawei.ism.drm.wcc.util.WccHelper;
import com.huawei.jetcd.client.EtcdConfig;
import com.huawei.jetcd.exception.EtcdException;
import com.huawei.jetcd.exception.EtcdServerException;

public class ArbitrationCenterHelper {
    private static ArbitrationCenterHelper instance = null;

    private ArbitrationCenterHelper() {
    }

    public static ArbitrationCenterHelper getInstance() {
        if (null == instance) {
            instance = new ArbitrationCenterHelper();
        }
        return instance;
    }

    public void authUser(String[] strs, String password) throws Exception {
        LogManager.info("auth is start >>>>>");
        if (VerifyUtil.isEmpty(strs)) {
            LogManager.error("params is null or empty.");
            throw new EtcdServerException(1073947393L);
        }
        JSONObject result = JSONObject.fromObject(strs[0]);
        String userName = result.getString("userName");
        String ips = result.getString("ips");
        String keyStorePwd = this.decrypt(ArbProperties.getInstance().getProperty("arb.privatepwd", ""));
        String dc = result.getString("dc");
        if (this.isEmpty(ips) || this.isEmpty(userName) || this.isEmpty(password) || this.isEmpty(keyStorePwd) || this.isEmpty(dc)) {
            LogManager.error("ips is: " + ips + ",userName is: " + userName + ",dc is: " + dc);
            throw new EtcdServerException(1073947393L);
        }
        EtcdConfig.Builder aamEtcdConfigBuilder = new EtcdConfig.Builder();
        aamEtcdConfigBuilder.setServer(ips.split(","));
        aamEtcdConfigBuilder.setKeepAlive(true);
        aamEtcdConfigBuilder.setHealthCheck(false);
        aamEtcdConfigBuilder.setUsername(userName);
        aamEtcdConfigBuilder.setPassword(password);
        aamEtcdConfigBuilder.setKeyStorePwd(keyStorePwd);
        EtcdConfig etcConfig = aamEtcdConfigBuilder.build();
        AAMonitorClient aamClient = null;
        try {
            aamClient = new AAMonitorClient(etcConfig, true);
            aamClient.listDir(new JSONObject());
            aamClient.getDetailStatus(dc);
        }
        catch (Exception e) {
            LogManager.error("all Etcd servers connect failed. cause by " + LogManager.getErrorMessage(e));
            throw e;
        }
        finally {
            if (null != aamClient) {
                aamClient.close();
            }
        }
        LogManager.info("auth success.");
    }

    public String getDetailStatus(String regionId) throws Exception {
        return this.getDetailStatus(regionId, Boolean.FALSE);
    }

    public String getDetailStatus(String regionId, boolean isForceCheckCert) throws Exception {
        String pre;
        LogManager.debug(">>>>>>>>>>> start init query arb status >>>>>>>>>>>");
        String string = pre = VerifyUtil.isEmpty(regionId) ? "" : regionId + ".";
        if (!this.checkParam(pre)) {
            return "";
        }
        EtcdConfig.Builder aamEtcdConfigBuilder = new EtcdConfig.Builder();
        aamEtcdConfigBuilder.setServer(ArbProperties.getInstance().getProperty(pre + "arb.ips", "").split(","));
        aamEtcdConfigBuilder.setKeepAlive(true);
        aamEtcdConfigBuilder.setHealthCheck(true);
        aamEtcdConfigBuilder.setUsername(ArbProperties.getInstance().getProperty(pre + "arb.username", ""));
        aamEtcdConfigBuilder.setPassword(this.decrypt(ArbProperties.getInstance().getProperty(pre + "arb.password", "")));
        EtcdConfig etcConfig = aamEtcdConfigBuilder.build();
        AAMonitorClient aamClient = new AAMonitorClient(etcConfig, true, isForceCheckCert);
        JSONObject result = new JSONObject();
        result.put("cert_auth_flag", (Object)false);
        if (!aamClient.connect(result)) {
            LogManager.error("all Etcd servers connect failed.");
            throw new EtcdServerException(1073947647L);
        }
        try {
            String localStatus = aamClient.getDetailStatus(ArbProperties.getInstance().getProperty(pre + "arb.localDC", ""));
            String remoteStatus = aamClient.getDetailStatus(ArbProperties.getInstance().getProperty(pre + "arb.remoteDC", ""));
            result.put("localDcStatus", localStatus);
            result.put("remoteDcStatus", remoteStatus);
            result.put("isMatch", (Object)MonitorStatus.mirrorDetailStatus(localStatus).equals(remoteStatus));
            LogManager.debug("end query arb status, the json result is :" + result.toString());
        }
        catch (EtcdException e) {
            LogManager.error("query localStatus status fail, cause by " + LogManager.getErrorMessage(e));
            throw e;
        }
        finally {
            if (null != aamClient) {
                aamClient.close();
            }
        }
        LogManager.info(">>>>>>>>>>> query arb status end>>>>>>>>>>>");
        return result.toString();
    }

    private boolean checkParam(String pre) throws EtcdServerException {
        String arbEnable = ArbProperties.getInstance().getProperty(pre + "arb.enable", "");
        if (VerifyUtil.isEmpty(arbEnable)) {
            LogManager.error("arbEnable param is empty.");
            throw new EtcdServerException(1073947393L);
        }
        if (!Boolean.parseBoolean(arbEnable)) {
            LogManager.error("window version not support check etcd status. and arbEnable is: " + arbEnable);
            return false;
        }
        String arbIps = ArbProperties.getInstance().getProperty(pre + "arb.ips", "");
        String arbLocalDc = ArbProperties.getInstance().getProperty(pre + "arb.localDC", "");
        String arbRemoteDc = ArbProperties.getInstance().getProperty(pre + "arb.remoteDC", "");
        String userName = ArbProperties.getInstance().getProperty(pre + "arb.username", "");
        String password = ArbProperties.getInstance().getProperty(pre + "arb.password", "");
        if (this.isEmpty(arbIps) || this.isEmpty(arbLocalDc) || this.isEmpty(arbRemoteDc) || this.isEmpty(userName) || this.isEmpty(password)) {
            LogManager.error("arbIps is: " + arbIps + ", arbLocalDc is: " + arbLocalDc + ", arbRemoteDc is: " + arbRemoteDc + ", userName is: " + userName);
            throw new EtcdServerException(1073947393L);
        }
        return true;
    }

    public String decrypt(String txt) {
        String decryptCtxt = "";
        try {
            WccHelper wccInstance = WccHelper.getInstance();
            if (null == wccInstance) {
                LogManager.error("wccInstance is null.");
                return "";
            }
            decryptCtxt = wccInstance.decrypt(txt);
        }
        catch (Exception e) {
            decryptCtxt = "";
            LogManager.error("decrypt failed, cause by: " + LogManager.getErrorMessage(e));
        }
        return decryptCtxt;
    }

    private boolean isEmpty(String string) {
        return null == string || string.trim().isEmpty();
    }
}

