/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.jetcd.client.parser;

import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.ism.drm.arbitration.util.JSONObject;
import com.huawei.jetcd.exception.EtcdAuthException;
import com.huawei.jetcd.exception.EtcdClientException;
import com.huawei.jetcd.exception.EtcdException;
import com.huawei.jetcd.exception.EtcdServerException;
import com.huawei.jetcd.model.EtcdHeaders;
import com.huawei.jetcd.model.EtcdInternalResult;
import com.huawei.jetcd.model.EtcdResult;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.http.Header;

public final class EtcdResultTranslator {
    private static final String X_ETCD_CLUSTER_ID = "X-Etcd-Cluster-Id";
    private static final String X_ETCD_INDEX = "X-Etcd-Index";
    private static final String X_RAFT_INDEX = "X-Raft-Index";
    private static final String X_RAFT_TERM = "X-Raft-Term";
    private static final String UTF_8 = "utf-8";
    private static final int SERVER_SELECT_ERROR = 500;

    private EtcdResultTranslator() {
    }

    public static String translateVersion(SimpleHttpResponse response) throws EtcdException {
        try {
            return response.getBodyText();
        }
        catch (Exception e) {
            LogManager.error("Error extracting response entity" + LogManager.getErrorMessage(e));
            throw new EtcdClientException("Error extracting response entity", e);
        }
    }

    public static EtcdResult translateKeyResult(SimpleHttpResponse response) throws EtcdException {
        if (response == null) {
            LogManager.error("Can not translate normal result beacuse parameter error: response null");
            throw new EtcdClientException("HttpResponse return no content!");
        }
        int httpCode = response.getCode();
        if (httpCode == 500) {
            LogManager.error("Translate Key Result exception,Etcd servers maybe cann't select leader,httpCode:" + httpCode);
            throw new EtcdClientException("http code = 500,Internal Server Error. Etcd servers maybe cann't select leader!");
        }
        if (httpCode == 401) {
            LogManager.error("Translate Key Result exception beacuse response status is Unauthorized.httpCode:" + httpCode);
            throw new EtcdAuthException(401, "Unauthorized");
        }
        if (httpCode == 403) {
            LogManager.error("Translate Key Result exception beacuse response status is Forbidden.httpCode:" + httpCode);
            throw new EtcdAuthException(403, "Forbidden");
        }
        EtcdHeaders headers = EtcdResultTranslator.parseHead(response);
        EtcdInternalResult result = EtcdResultTranslator.jsonToBean(response, EtcdInternalResult.class);
        if (result == null) {
            LogManager.error("translate Key Result exception beacuse is null.");
            throw new EtcdClientException("response is null");
        }
        result.setHeaders(headers);
        if (result.getErrorCode() != 0) {
            LogManager.error("translate Key Result exception beacuse result isn't sucess: errorcode:" + result.getErrorCode());
            throw new EtcdServerException(result.getErrorCode(), result.getCause(), result.getMessage(), result.getIndex());
        }
        return result;
    }

    private static <T> T jsonToBean(SimpleHttpResponse response, Class<T> cls) throws EtcdClientException {
        String json = null;
        try {
            json = response.getBodyText();
        }
        catch (Exception e) {
            LogManager.error("convert json to bean exception," + LogManager.getErrorMessage(e));
            throw new EtcdClientException("Error extracting response entity", e);
        }
        return JSONObject.toBean(json, cls);
    }

    private static EtcdHeaders parseHead(SimpleHttpResponse response) {
        EtcdHeaders headers = new EtcdHeaders();
        block12: for (Header header : response.getHeaders()) {
            String value = header.getValue();
            if (VerifyUtil.isEmpty((String)value)) continue;
            switch (header.getName()) {
                case "X-Etcd-Cluster-Id": {
                    headers.setEtcdClusterId(value);
                    continue block12;
                }
                case "X-Etcd-Index": {
                    headers.setEtcdIndex(Long.valueOf(value));
                    continue block12;
                }
                case "X-Raft-Index": {
                    headers.setRaftIndex(Long.valueOf(value));
                    continue block12;
                }
                case "X-Raft-Term": {
                    headers.setRaftTerm(Long.valueOf(value));
                    continue block12;
                }
                default: {
                    LogManager.debug("Header not used: " + header.getName());
                }
            }
        }
        return headers;
    }
}

