/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.alarm.service;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.rest.service.framework.alarm.model.ThirdAlarmVo;
import com.huawei.lego.cbb.task.sdk.model.Task;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class AlarmExtend {
    private static final Log logger = LogFactory.getInstance(AlarmExtend.class);

    public static String resetOrderField(String orderBy) {
        String orderByField = "modTime";
        if (orderBy != null && !orderBy.equalsIgnoreCase("alarmTimeStr")) {
            orderByField = orderBy;
            if (orderBy.equalsIgnoreCase("firstTimeStr")) {
                orderByField = "createTime";
            }
        }
        return orderByField;
    }

    public static void setBaseTimeAndNextTime(Task task, Integer cycleDate, String time) {
        int newtaskPeriod;
        Date baseTime = task.getBaseTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        int taskPeriod = task.getPeriod();
        if (taskPeriod != (newtaskPeriod = cycleDate.intValue())) {
            task.setPeriod(cycleDate);
            Date latelyTime = new Date();
            task.setBaseTime(AlarmExtend.getBaseTime(latelyTime, time, "0"));
            task.setNextTime(null);
        } else if (!time.equalsIgnoreCase(dateFormat.format(baseTime))) {
            Date latelyTime = null != task.getNextTime() ? task.getNextTime() : task.getBaseTime();
            Date nextDate = AlarmExtend.getBaseTime(latelyTime, time);
            if (null != task.getNextTime()) {
                task.setNextTime(nextDate);
            }
            task.setBaseTime(nextDate);
        }
    }

    private static Date getBaseTime(Date date, String time1, String cycle) {
        Calendar nextCal = Calendar.getInstance();
        nextCal.setTime(date);
        if (date.before(new Date())) {
            nextCal.add(5, NumberUtil.convertToInteger((Object)cycle));
        }
        Date baseTime = nextCal.getTime();
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            baseTime = dateFormat.parse(formatDay.format(baseTime) + " " + time1);
        }
        catch (ParseException e) {
            logger.error((Object)"StorageAction getBaseTime:", (Throwable)e, 250L);
        }
        if (baseTime.before(new Date())) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(baseTime);
            cal.add(5, 1);
            baseTime = cal.getTime();
        }
        return baseTime;
    }

    private static Date getBaseTime(Date date, String time1) {
        Calendar nextCal = Calendar.getInstance();
        nextCal.setTime(date);
        Date baseTime = nextCal.getTime();
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            baseTime = dateFormat.parse(formatDay.format(baseTime) + " " + time1);
        }
        catch (ParseException e) {
            logger.error((Object)"StorageAction getBaseTime:", (Throwable)e, 250L);
        }
        if (baseTime.before(new Date())) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(baseTime);
            cal.add(5, 1);
            baseTime = cal.getTime();
        }
        return baseTime;
    }

    public static LegoAlarm convertAlarmVoToLegoAlarm(ThirdAlarmVo alarmVo) {
        LegoAlarm legoAlarm = new LegoAlarm();
        legoAlarm.setAlarmId("0x" + Long.toHexString(alarmVo.getAlarmId()).toUpperCase(Locale.US));
        legoAlarm.setAlarmLevel(FaultEnum.AlarmSeverity.getSeverity((int)alarmVo.getSeverity()));
        legoAlarm.setAlarmTime(alarmVo.getCreateTime().longValue());
        legoAlarm.setMoName(alarmVo.getMoName());
        legoAlarm.setMoIP(alarmVo.getMoIp());
        if (null != alarmVo.getParam()) {
            legoAlarm.setAlarmParam(alarmVo.getParam().split(","));
        }
        if (null != alarmVo.getSequence()) {
            legoAlarm.setAlarmSequence(alarmVo.getSequence().longValue());
        }
        return legoAlarm;
    }
}

