/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.securitypolicy.service;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.securitypolicy.model.CertSwitchVo;
import com.huawei.ism.drm.rest.service.framework.securitypolicy.model.SecurityPolicyVo;
import com.huawei.ism.drm.rest.service.framework.securitypolicy.service.ISecurityPolicyRestService;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.ParamValidator;
import com.huawei.ism.drm.rest.util.Permission;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CertSwitch;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICertConfigService;
import com.huawei.lego.cbb.user.sdk.model.UserLoginPolicy;
import com.huawei.lego.cbb.user.sdk.model.UserSecPolicy;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;

public class SecurityPolicyRestServiceImpl
extends AbstractRestService
implements ISecurityPolicyRestService {
    private static final int DEFAULT_MINLIFETIME = 3;
    private static final int UNSET_LOCK_TIME_MARK = -1;
    private static final int INIT_LOCK_TIME = 3;
    private static final int ENABLE_PASSWORD_VALID_PERIOD = 1;
    private static final int DISABLE_PASSWORD_VALID_PERIOD = 0;
    private static final Integer SESSION_OUT_TIME = Integer.MAX_VALUE;
    private static final Log LOGGER = FELogFactory.getInstance((String)"ui");

    @Override
    public SecurityPolicyVo querySecurityPolicy() {
        SecurityPolicyVo vo = new SecurityPolicyVo();
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        UserSecPolicy usrPolicy = mgr.getUserSecPolicy();
        UserLoginPolicy usrLogPolicy = mgr.getLoginPolicy();
        vo.setPassErrNum(usrLogPolicy.getLgoinCount());
        if (usrLogPolicy.getLockTime() == -1) {
            vo.setPassLockTime(3);
        } else {
            vo.setPassLockTime(usrLogPolicy.getLockTime());
        }
        vo.setSessionTime(usrLogPolicy.getSessionTimeOut());
        vo.setPassLenVal(usrPolicy.getPswLenth());
        String pwdComplex = usrPolicy.getComplex();
        int pwdComplexInt = 8;
        try {
            pwdComplexInt = Integer.parseInt(pwdComplex);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e, 90160758784000L);
        }
        vo.setPassComplexVal(pwdComplexInt);
        if (usrPolicy.getUnseal() == 1) {
            vo.setPassCtrl(true);
        } else {
            vo.setPassCtrl(false);
        }
        vo.setUsefulLife(usrPolicy.getUsefulLife());
        int minlifetime = usrPolicy.getMinlifetime() == null ? 3 : usrPolicy.getMinlifetime();
        vo.setMinlifetime(minlifetime);
        return vo;
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="user_setSecurityPolicy_operateName", operationModule="security_policy", level=3)
    @Permission(name="lego.sys.sysLoginPolicy.modify")
    public Response modifySecurityPolicy(SecurityPolicyVo vo) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"securityPolicy_objectName");
        this.checkPara(vo);
        try {
            this.doModifySecurityPolicy(vo);
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="user_setCertSwitch_operateName", operationModule="security_policy", level=4)
    @Permission(name="lego.sys.certSwitch.modify")
    public Response modifyCertSwitch(CertSwitchVo certSwitchVo) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"securityPolicy_objectName");
        if (certSwitchVo == null || certSwitchVo.getCertAuthSwitch() == null) {
            LOGGER.error((Object)"ModifyCertSwitch failed cause certAuthSwitch param is null.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            ICertConfigService certConfigService = this.getBundleService(ICertConfigService.class);
            certConfigService.modifyCertSwitch(this.convertToCertSwitch(certSwitchVo));
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    @Override
    @Permission(name="lego.sys.certSwitch.scan")
    public CertSwitchVo getCertSwitch() {
        ICertConfigService certConfigService = this.getBundleService(ICertConfigService.class);
        CertSwitch certSwitch = certConfigService.getCertSwitch();
        return this.convertToCertSwitchVo(certSwitch);
    }

    @Override
    @Permission(name="lego.sys.httpsConnect.scan")
    public List<String> getConnectFailedServices() {
        ICertConfigService certConfigService = this.getBundleService(ICertConfigService.class);
        return certConfigService.getConnectFailedServices();
    }

    private CertSwitchVo convertToCertSwitchVo(CertSwitch certSwitch) {
        CertSwitchVo certSwitchVo = new CertSwitchVo();
        certSwitchVo.setCertAuthSwitch(certSwitch.getCertAuthSwitch());
        return certSwitchVo;
    }

    private CertSwitch convertToCertSwitch(CertSwitchVo certSwitchVo) {
        CertSwitch certSwitch = new CertSwitch();
        certSwitch.setCertAuthSwitch(certSwitchVo.getCertAuthSwitch());
        return certSwitch;
    }

    private void doModifySecurityPolicy(SecurityPolicyVo vo) {
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        UserLoginPolicy usrLogPolicytemp = mgr.getLoginPolicy();
        Integer sessionTime = vo.getSessionTime();
        if (LegoProperties.isInstalledIntegrated()) {
            sessionTime = SESSION_OUT_TIME;
        }
        usrLogPolicytemp.setSessionTimeOut(sessionTime.intValue());
        usrLogPolicytemp.setLgoinCount(vo.getPassErrNum().intValue());
        usrLogPolicytemp.setLockTime(vo.getPassLockTime().intValue());
        mgr.updateLoginPolicy(usrLogPolicytemp);
        UserSecPolicy usrPolicy = mgr.getUserSecPolicy();
        usrPolicy.setPswLenth(vo.getPassLenVal());
        usrPolicy.setComplex(String.valueOf(vo.getPassComplexVal()));
        Boolean passCtrl = vo.getPassCtrl();
        if (!VerifyUtil.isEmpty((Object)passCtrl) && passCtrl.booleanValue()) {
            usrPolicy.setUnseal(Integer.valueOf(1));
            usrPolicy.setUsefulLife(vo.getUsefulLife());
            usrPolicy.setMinlifetime(vo.getMinlifetime());
        } else {
            usrPolicy.setUnseal(Integer.valueOf(0));
        }
        mgr.updateUserSecPolicy(usrPolicy);
    }

    private void checkPara(SecurityPolicyVo vo) {
        if (VerifyUtil.isEmpty((Object)vo)) {
            LOGGER.error((Object)"The param vo is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkNumContains(vo.getPassLenVal(), Arrays.asList(8, 10));
        this.checkNumContains(vo.getPassComplexVal(), Arrays.asList(2, 4));
        this.checkNumArea(vo.getSessionTime(), 1, 100);
        this.checkNumArea(vo.getPassErrNum(), 1, 9);
        this.checkNumArea(vo.getPassLockTime(), 3, 2000);
        this.checkPassCtrl(vo);
    }

    private void checkNumArea(Integer num, int min, int max) {
        if (VerifyUtil.isEmpty((Object)num) || num < min || num > max) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkNumContains(Integer num, List<Integer> list) {
        if (VerifyUtil.isEmpty((Object)num) || !list.contains(num)) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkPassCtrl(SecurityPolicyVo vo) {
        Boolean passCtrl = vo.getPassCtrl();
        if (!VerifyUtil.isEmpty((Object)passCtrl) && passCtrl.booleanValue()) {
            Integer usefulLife = vo.getUsefulLife();
            Integer minLifeTime = vo.getMinlifetime();
            if (VerifyUtil.isEmpty((Object)usefulLife) || usefulLife < 60 || usefulLife > 360) {
                throw new LegoCheckedException(250L);
            }
            if (VerifyUtil.isEmpty((Object)minLifeTime) || minLifeTime < 1 || minLifeTime > 9999) {
                throw new LegoCheckedException(250L);
            }
        }
    }
}

