/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.user.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserVo;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.model.UserAcl;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class UserUtil {
    public static final String SYSTEM_USER_LIMIT_TOTALS = "system.user.limit.totals";
    public static final long SYSTEM_USER_LIMIT_TOTALS_DEFAULT_VALUE = 64L;

    public static UserVo convertUser2UserVo(User queryUsr, String[] grantedObjects) {
        if (null == queryUsr) {
            throw new LegoCheckedException(1073947393L);
        }
        UserVo vo = new UserVo();
        vo.setResIds(queryUsr.getMoAuthIdsSet());
        Set rolesSet = queryUsr.getRolesSet();
        if (!VerifyUtil.isEmpty((Collection)rolesSet)) {
            HashSet<Long> roleSet = new HashSet<Long>();
            for (Role role : rolesSet) {
                roleSet.add(role.getRoleId());
            }
            vo.setRolesIdsSet(roleSet);
        }
        vo.setBizObjs(grantedObjects);
        vo.setSessionControl(queryUsr.getSessionControl());
        vo.setSessionLimit(queryUsr.getSessionLimit());
        vo.setUserName(queryUsr.getUserName());
        vo.setPasswordModel(queryUsr.getPasswordModel());
        vo.setDefaultUser(queryUsr.getDefaultUser());
        vo.setDescription(queryUsr.getDescription());
        vo.setIpAdr(queryUsr.getIpAdr());
        vo.setIsAdmin(queryUsr.getIsAdmin());
        vo.setIsAdministrator(queryUsr.getIsAdministrator());
        vo.setIsLock(queryUsr.getIsLock());
        vo.setLoginDate(queryUsr.getLoginDate());
        vo.setLoginTime(queryUsr.getLoginTime());
        vo.setMoAutSeth(queryUsr.getMoAutSeth());
        vo.setMoGroupIdsSet(queryUsr.getMoGroupIdsSet());
        vo.setMustModifyPwd(queryUsr.isMustModifyPwd());
        vo.setSelectType(queryUsr.getSelectType());
        vo.setSetTime(queryUsr.getSetTime());
        vo.setStayTime(queryUsr.getStayTime());
        Set userAclSet = queryUsr.getUserAclSet();
        if (!VerifyUtil.isEmpty((Collection)userAclSet)) {
            Iterator iterator = userAclSet.iterator();
            while (iterator.hasNext()) {
                UserAcl userAcl;
                String des = (userAcl = (UserAcl)iterator.next()).getDes();
                userAcl.setDes(des == null ? "" : des);
            }
        }
        vo.setUserAclSet(userAclSet);
        vo.setUserId(queryUsr.getUserId());
        return vo;
    }

    public static String bizObjsArrayToStr(String[] bizObjArray) {
        if (VerifyUtil.isEmpty((Object[])bizObjArray)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String str : bizObjArray) {
            sb.append(str).append(',');
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static int getUserLimitSize() {
        return (int)LegoConfig.getInstance().getNumber(SYSTEM_USER_LIMIT_TOTALS, 64L);
    }
}

