/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.recovery;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.rest.service.platform.recovery.ProtectObjectSettingBean;
import com.huawei.ism.drm.rest.service.platform.recovery.RecoveryPlanQueryRestServiceImpl;
import com.huawei.ism.drm.rest.service.platform.recovery.util.RecoveryPlanExcelDetailsOperator;
import com.huawei.ism.drm.rest.service.platform.recovery.util.RecoveryPlanLogExcelOperator;
import com.huawei.ism.drm.rest.util.BaseRestUtils;
import com.huawei.ism.drm.rest.util.DownloadFileUtil;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.ParamValidator;
import com.huawei.ism.drm.rest.util.Permission;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.FileExcelUtil;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.util.StringUtils;

public class RecoveryPlanRestServiceImpl
extends RecoveryPlanQueryRestServiceImpl {
    private static final Log LOGGER = LogFactory.getInstance(RecoveryPlanRestServiceImpl.class);

    @Override
    @ParamValidator
    @OperationLog(operationName="recoveryPlan_modify_operateName", operationModule="recovery", level=3)
    @Permission(name="ism.drm.drp.auth.modify")
    public Response modifyDrp(String planId, RecoveryPlan rp) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(rp == null ? "" : rp.getName()));
        LOGGER.debug((Object)"enter modifyDrp");
        this.checkPlanId(planId);
        if (null == rp) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkDrmDescParam((String)rp.getDescription())) {
            LOGGER.error((Object)"Invalid description of rp");
            throw new LegoCheckedException(-1L);
        }
        String recoveryPlanDes = rp.getDescription();
        String recoveryPlanName = rp.getName();
        String checkRecoveryPlanDes = HtmlStringConverter.decodeByLength(recoveryPlanDes);
        if (!CommUtil.checkDrmNameParam((String)recoveryPlanName) || !CommUtil.checkDrmDescParam((String)checkRecoveryPlanDes)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("recoveryPlan_modify_operateName", 3, planId);
        try {
            RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
            if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
                throw new LegoCheckedException(1073947453L);
            }
            this.getRecoveryPlanService().modifyRpBasicInfo(planId, recoveryPlan.getUse(), recoveryPlanName, recoveryPlanDes);
            String oldName = recoveryPlan.getName();
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)oldName);
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)rp.getName());
            throw e;
        }
        catch (Exception e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)rp.getName());
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="recoveryPlan_enableTest_operateName", operationModule="recovery", level=3)
    @Permission(name="ism.drm.drp.auth.test")
    public Response test(String planId, Map<String, String> recoveryContext) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)planId);
        this.checkPlanId(planId);
        this.checkRecoveryContext(recoveryContext);
        this.checkUserBizObjAuthority("recoveryPlan_enableTest_operateName", 3, planId);
        RecoveryPlan recoveryPlan = null;
        try {
            recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)recoveryPlan.getName());
            this.checkLicenseControl(recoveryPlan);
            if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
                throw new LegoCheckedException(1073947453L);
            }
            IRecoveryManager rm = this.getBundleService(IRecoveryManager.class);
            rm.startRecoveryDrilling(planId, recoveryContext, this.getCurrentUser());
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("test failed. PlanId:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan == null ? "" : recoveryPlan.getName()));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("test failed. PlanId:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan == null ? "" : recoveryPlan.getName()));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="recoveryPlan_enableClear_operateName", operationModule="recovery", level=3)
    @Permission(name="ism.drm.drp.auth.cleartest")
    public Response testCleanup(String planId) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)planId);
        this.checkPlanId(planId);
        this.checkUserBizObjAuthority("recoveryPlan_enableClear_operateName", 3, planId);
        RecoveryPlan recoveryPlan = null;
        try {
            recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId, false, false);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)recoveryPlan.getName());
            this.checkLicenseControl(recoveryPlan);
            if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
                throw new LegoCheckedException(1073947453L);
            }
            this.getBundleService(IRecoveryManager.class).cleanRecoveryDrilling(planId, this.getCurrentUser(), null);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("clean failed. PlanId:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan == null ? "" : recoveryPlan.getName()));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("clean failed. PlanId:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan == null ? "" : recoveryPlan.getName()));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private boolean validateIsHypermetro(RecoveryPlan recoveryPlan) {
        Set protectGroups = recoveryPlan.getProtectGroups();
        for (ProtectGroup pg : protectGroups) {
            if (pg.getTemplate().getType() != 25) continue;
            return true;
        }
        return false;
    }

    private boolean validateIsReplication(RecoveryPlan recoveryPlan) {
        Set protectGroups = recoveryPlan.getProtectGroups();
        for (ProtectGroup pg : protectGroups) {
            if (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(pg.getProps().get("serviceInstanceType")) && !ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.isCurrent((String)pg.getProps().get("serviceInstanceType"))) continue;
            return true;
        }
        return false;
    }

    private boolean isCshaCsdrWithinRegion(RecoveryPlan recoveryPlan, Map<String, String> recoveryContext) {
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        if (pg.getTemplate().getType() != 37) {
            return false;
        }
        return !VerifyUtil.isEmpty(recoveryContext) && null != recoveryContext.get("recovery_region_id") && pg.getProperty("regionId").contains(recoveryContext.get("recovery_region_id"));
    }

    private void checkRecoveryContext(Map<String, String> recoveryContext) {
        if (VerifyUtil.isEmpty(recoveryContext)) {
            return;
        }
        int maxRecoveryContextCount = 32;
        if (recoveryContext.entrySet().size() > maxRecoveryContextCount) {
            LOGGER.error((Object)"too many attributes in recoveryContext.");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkMapValue(recoveryContext, "recovery_region_id", ParamChecker::checkGeneralId);
        this.checkMapValue(recoveryContext, "recovery_az_id", ParamChecker::checkGeneralId);
        this.checkMapValue(recoveryContext, "region_id", ParamChecker::checkGeneralId);
        this.checkMapValue(recoveryContext, "az_id", ParamChecker::checkGeneralId);
    }

    private <K, V> void checkMapValue(Map<K, V> map, K key, Predicate<V> checker) {
        V value = map.get(key);
        if (!VerifyUtil.isEmpty(value) && !checker.test(value)) {
            LOGGER.error((Object)"%s is incorrect.", new Object[]{key});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkConfirmReprotection(Map<String, String> recoveryContext) {
        if (VerifyUtil.isEmpty(recoveryContext)) {
            return;
        }
        if (!recoveryContext.containsKey("is_confirm_reprotection")) {
            recoveryContext.put("is_confirm_reprotection", Boolean.FALSE.toString());
        } else {
            String confirmReprotection = recoveryContext.get("is_confirm_reprotection");
            if (confirmReprotection == null) {
                LOGGER.error((Object)"Parameter isConfirmReprotection  of recoveryContext is null.");
                throw new LegoCheckedException(1073947393L);
            }
            confirmReprotection = confirmReprotection.toLowerCase(Locale.ROOT);
            if (!Boolean.FALSE.toString().equals(confirmReprotection) && !Boolean.TRUE.toString().equals(confirmReprotection)) {
                LOGGER.error((Object)"Parameter isConfirmReprotection  of recoveryContext is incorrect.");
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="recoveryPlan_enablePlannedMigration_operateName", operationModule="recovery", level=2)
    @Permission(name="ism.drm.drp.auth.planed.motion")
    public Response plannedMigration(String planId, Map<String, String> recoveryContext) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)planId);
        this.checkPlanId(planId);
        this.checkConfirmReprotection(recoveryContext);
        this.checkRecoveryContext(recoveryContext);
        this.checkUserBizObjAuthority("recoveryPlan_enablePlannedMigration_operateName", 2, planId);
        RecoveryPlan recoveryPlan = null;
        try {
            recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)recoveryPlan.getName());
            this.checkLicenseControl(recoveryPlan);
            this.getBundleService(IRecoveryManager.class).startPlanedMotion(planId, recoveryContext, this.getCurrentUser());
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("planedmotion failed. PlanId:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan == null ? "" : recoveryPlan.getName()));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("planedmotion failed. PlanId:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan == null ? "" : recoveryPlan.getName()));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="recoveryPlan_isEnablePlannedMigration_operateName", operationModule="recovery", level=2)
    @Permission(name="ism.drm.drp.auth.planed.motion")
    public Response actionContinue(String planId, String actionType, Map<String, String> recoveryContext) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)planId);
        this.checkPlanId(planId);
        if (!StringUtils.hasText((String)actionType) || !DrmEnumDefine.RecoveryActionType.PLANED_MOTION.getValue().equals(actionType)) {
            LOGGER.error((Object)"Parameter actionType is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("recoveryPlan_enablePlannedMigration_operateName", 2, planId);
        String recoveryPlanPlanName = "";
        Boolean isContinue = Boolean.parseBoolean(recoveryContext.get("recovery_continue_key"));
        try {
            RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
            recoveryPlanPlanName = recoveryPlan.getName();
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)recoveryPlanPlanName);
            if (DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue() != recoveryPlan.getPlanStatus()) {
                throw new LegoCheckedException("RecoveryPlan planStatus is incorrect.");
            }
            this.checkLicenseControl(recoveryPlan);
            this.getBundleService(IRecoveryManager.class).continuePlannedMigration(planId, recoveryContext, this.getCurrentUser());
            this.getContinueOperationName(actionType, isContinue);
        }
        catch (LegoCheckedException e) {
            this.getContinueOperationName(actionType, isContinue);
            LOGGER.error((Object)"Action[%s] continue of RecoveryPlan failed. PlanId is %s,error:%s.", new Object[]{actionType, planId, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)recoveryPlanPlanName);
            throw e;
        }
        catch (Exception ex) {
            this.getContinueOperationName(actionType, isContinue);
            LOGGER.error((Object)"Action[%s] continue of RecoveryPlan failed. PlanId is %s,error:%s.", new Object[]{actionType, planId, ExceptionUtil.getErrorMessage((Throwable)ex)});
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)recoveryPlanPlanName);
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private void getContinueOperationName(String actionType, Boolean isContinue) {
        if (DrmEnumDefine.RecoveryActionType.PLANED_MOTION.getValue().equals(actionType) && isContinue.booleanValue()) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME, (Object)"recoveryPlan_enableContinuePlannedMigration_operateName");
        } else if (DrmEnumDefine.RecoveryActionType.PLANED_MOTION.getValue().equals(actionType) && !isContinue.booleanValue()) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME, (Object)"recoveryPlan_cancelContinuePlannedMigration_operateName");
        } else {
            LOGGER.error((Object)"getContinueOperationName failed.");
        }
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="recoveryPlan_enableHotMigration_operateName", operationModule="recovery", level=2)
    @Permission(name="ism.drm.drp.auth.planed.hotmigration")
    public Response hotMigration(String planId, Map<String, String> recoveryContext) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)planId);
        this.checkPlanId(planId);
        this.checkRecoveryContext(recoveryContext);
        this.checkUserBizObjAuthority("recoveryPlan_enableHotMigration_operateName", 2, planId);
        RecoveryPlan recoveryPlan = null;
        try {
            recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)recoveryPlan.getName());
            this.checkLicenseControl(recoveryPlan);
            if (null == recoveryContext) {
                recoveryContext = new HashMap<String, String>();
            }
            this.getBundleService(IRecoveryManager.class).startHotMigration(planId, recoveryContext, this.getCurrentUser());
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"planedmotion failed. PlanId:%s, errMsg:%s", new Object[]{planId, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan == null ? "" : recoveryPlan.getName()));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"planedmotion failed. PlanId:%s, errMsg:%s", new Object[]{planId, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan == null ? "" : recoveryPlan.getName()));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="recoveryPlan_enableFaultRecovery_operateName", operationModule="recovery", level=2)
    @Permission(name="ism.drm.drp.auth.disaster.recovery")
    public Response diasterRecovery(String planId, Map<String, String> recoveryContext) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)planId);
        this.checkPlanId(planId);
        this.checkRecoveryContext(recoveryContext);
        this.checkUserBizObjAuthority("recoveryPlan_enableFaultRecovery_operateName", 2, planId);
        RecoveryPlan recoveryPlan = null;
        try {
            recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)recoveryPlan.getName());
            this.checkLicenseControl(recoveryPlan);
            String regionUuid = recoveryPlan.getProtectGroup().getProperty("regionId");
            if (this.getBundleService(ICloudConfigService.class).checkArbitrationSwitchMode(BaseRestUtils.getIdFromUuid(regionUuid))) {
                if (this.validateIsHypermetro(recoveryPlan)) {
                    throw new LegoCheckedException(1073948807L, new String[]{BaseRestUtils.getIdFromUuid(regionUuid)});
                }
                if (this.isCshaCsdrWithinRegion(recoveryPlan, recoveryContext)) {
                    throw new LegoCheckedException(1073949723L);
                }
            }
            this.getBundleService(IRecoveryManager.class).startDisasterRecovery(planId, recoveryContext, this.getCurrentUser());
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("disaster recovery failed. PlanId:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan == null ? "" : recoveryPlan.getName()));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("disaster recovery failed. PlanId:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan == null ? "" : recoveryPlan.getName()));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="recoveryPlan_reProtect_operateName", operationModule="recovery", level=2)
    @Permission(name="ism.drm.drp.auth.reprotect")
    public Response executeReprotectPlan(String planId, Map<String, String> recoveryContext) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)planId);
        this.checkPlanId(planId);
        this.checkRecoveryContext(recoveryContext);
        String isResverdValue = recoveryContext.get("isReserved");
        if (!"true".equalsIgnoreCase(isResverdValue) && !"false".equalsIgnoreCase(isResverdValue)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("recoveryPlan_reProtect_operateName", 2, planId);
        RecoveryPlan recoveryPlan = null;
        try {
            recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)recoveryPlan.getName());
            this.checkLicenseControl(recoveryPlan);
            ProtectGroup pg = recoveryPlan.getProtectGroup();
            String regionUuid = pg.getProperty("regionId");
            if ((this.validateIsHypermetro(recoveryPlan) || pg.getTemplate().getType() == 37 && "REGION_TYPE_WITHIN".equals(pg.getProperty("RECOVERY_REGION_TYPE"))) && this.getBundleService(ICloudConfigService.class).checkArbitrationSwitchMode(BaseRestUtils.getIdFromUuid(regionUuid))) {
                throw new LegoCheckedException(1073948807L, new String[]{BaseRestUtils.getIdFromUuid(regionUuid)});
            }
            IRecoveryManager rm = this.getBundleService(IRecoveryManager.class.getName(), IRecoveryManager.class);
            rm.reprotectRecoveryPlan(planId, recoveryContext, this.getCurrentUser());
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("Reprotect failed. PlanId:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan == null ? "" : recoveryPlan.getName()));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Reprotect failed. PlanId:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan == null ? "" : recoveryPlan.getName()));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="recoveryPlan_delete_operateName", operationModule="recovery", level=2)
    @Permission(name="ism.drm.drp.auth.delete")
    public Response delRecoveryPlan(String planId) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)planId);
        LOGGER.debug((Object)"enter delRecoveryPlan");
        this.checkPlanId(planId);
        this.checkUserBizObjAuthority("recoveryPlan_delete_operateName", 2, planId);
        IRecoveryPlanService rpService = this.getRecoveryPlanService();
        RecoveryPlan recoveryPlan = null;
        try {
            recoveryPlan = rpService.getRecoveryPlan(planId, false, false);
            if (null == recoveryPlan) {
                throw new LegoCheckedException(201L);
            }
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)recoveryPlan.getName());
            if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
                throw new LegoCheckedException(1073947453L);
            }
            rpService.removeRecoveryPlan(planId);
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan != null ? recoveryPlan.getName() : ""));
            throw e;
        }
        catch (Exception e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan != null ? recoveryPlan.getName() : ""));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="recoveryPlan_create_operateName", operationModule="recovery", level=1)
    @Permission(name="ism.drm.drp.auth.add")
    public Response createRecoveryPlan(RecoveryPlan rp) {
        LOGGER.debug((Object)"enter createRecoveryPlan");
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)rp.getName());
        String pgUUID = this.checkRecoverPlanAndgetPgId(rp);
        this.checkUserBizObjAuthority("recoveryPlan_create_operateName", 1, pgUUID);
        try {
            ProtectGroup pg = this.getBundleService(IProtectGroupService.class).getProtectGroupByID(pgUUID, false);
            if (null == pg) {
                throw new LegoCheckedException(1073947394L);
            }
            HashSet<ProtectGroup> pgs = new HashSet<ProtectGroup>();
            pgs.add(pg);
            IRecoveryPlanService planService = this.getRecoveryPlanService();
            DrmEnumDefine.RecoveryPlanTypeE planType = planService.getSuitablePlanType(pg);
            rp.setPlanType(planType.getValue());
            rp.setProtectGroups(pgs);
            rp.setRecoverySettings(new HashSet());
            rp.setGlobalSettings(new HashMap());
            this.checkLicenseCount(pg);
            IRecoveryPlanService rpService = this.getRecoveryPlanService();
            rpService.createRecoveryPlan(this.getCurrentUserId().longValue(), rp);
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private String checkRecoverPlanAndgetPgId(RecoveryPlan rp) {
        if (VerifyUtil.isEmpty((Object)rp)) {
            throw new LegoCheckedException(-1L);
        }
        if (!CommUtil.checkDrmDescParam((String)rp.getDescription())) {
            LOGGER.error((Object)"Invalid description of rp");
            throw new LegoCheckedException(-1L);
        }
        String checkRpDesc = HtmlStringConverter.decodeByLength(rp.getDescription());
        rp.setDescription(checkRpDesc);
        if (!CommUtil.checkDrmNameParam((String)rp.getName()) || !CommUtil.checkDrmDescParam((String)checkRpDesc)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)rp.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        int maxProtectGroupsInRecoveryPlan = 1;
        if (rp.getProtectGroups().size() > maxProtectGroupsInRecoveryPlan) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!Validator.checkStringLength(rp.getProcessesSerialMsg(), 1024)) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = rp.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(2117645L);
        }
        String pgUUID = ((ProtectGroup)iterator.next()).getUuid();
        if (VerifyUtil.isEmpty((String)pgUUID)) {
            throw new LegoCheckedException(1073947393L);
        }
        return pgUUID;
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="recoveryPlan_modifyRecoveryStartSetting_operateName", operationModule="recovery", level=2)
    @Permission(name="ism.drm.drp.auth.recoverysetting.modify.operateID")
    public Response setRecoverySettings(String planId, List<ProtectObjectSettingBean> settings) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)planId);
        LOGGER.debug((Object)"enter setRecoverySettings");
        this.checkPlanId(planId);
        int maxRecoverySettingsOfProtectGroups = 2000;
        if (settings.size() > maxRecoverySettingsOfProtectGroups) {
            throw new LegoCheckedException(1073947393L);
        }
        this.verifyProtectObjectSetting(settings);
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)recoveryPlan.getName());
        CommUtils.checkObjectExists(recoveryPlan);
        if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
            throw new LegoCheckedException(1073947453L);
        }
        this.checkUserBizObjAuthority("recoveryPlan_modifyRecoveryStartSetting_operateName", 2, planId);
        try {
            ArrayList<RecoverySetting> recoverySettings = new ArrayList<RecoverySetting>();
            CommUtils.checkObjectExists(recoveryPlan.getProtectGroups());
            for (ProtectObjectSettingBean poSettingbean : settings) {
                RecoverySetting setting = new RecoverySetting();
                setting.setRecoveryPlan(recoveryPlan);
                setting.setOwnerId(poSettingbean.getUuid());
                setting.setName(poSettingbean.getName());
                setting.setValue(poSettingbean.getValue());
                recoverySettings.add(setting);
            }
            this.getRecoveryPlanService().saveOrUpdateRecoverySettings(planId, recoverySettings);
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private boolean checkSettingName(String settingName) {
        if (!VerifyUtil.isEmpty((String)settingName)) {
            return "isStart".equals(settingName) || "startOrder".equals(settingName) || "PLACEHOLDVM".equals(settingName) || "PLACEHOLDVMNAME".equals(settingName) || "TESTNETWORKCONFIG".equals(settingName);
        }
        return true;
    }

    @Override
    @ParamValidator
    @Permission(name="ism.drm.drp.auth.scan")
    public String getRecoverySettings(String planId, String ownerUuid, String settingName) {
        this.checkPlanId(planId);
        if (!ParamChecker.checkGeneralId((String)ownerUuid)) {
            LOGGER.error((Object)"Invalid ownerUuid!");
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.checkSettingName(settingName)) {
            LOGGER.error((Object)"Invalid settingName!");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, planId);
        IRecoveryPlanService planService = this.getRecoveryPlanService();
        RecoveryPlan recoveryPlan = planService.getRecoveryPlan(planId, false, false);
        if (null == recoveryPlan) {
            throw new LegoCheckedException(1073947394L);
        }
        Set settings = recoveryPlan.getRecoverySettings();
        if (null == settings) {
            LOGGER.error((Object)("the recoverysetting is null: " + recoveryPlan.getPlanId()));
            return "";
        }
        JSONArray array = new JSONArray();
        for (RecoverySetting setting : settings) {
            if (!VerifyUtil.isEmpty((String)ownerUuid) && !ownerUuid.equals(setting.getOwnerId()) || !VerifyUtil.isEmpty((String)settingName) && !settingName.equals(setting.getName())) continue;
            JSONObject object = new JSONObject();
            object.put((Object)"uuid", (Object)setting.getOwnerId());
            object.put((Object)"name", (Object)setting.getName());
            object.put((Object)"value", (Object)setting.getValue());
            array.add((Object)object);
        }
        return array.toString();
    }

    private boolean isStepBeanUnValid(String stepName, String scriptName) {
        LOGGER.debug((Object)"enter isStepBeanUnValid");
        return !CommUtil.checkDrmNameParam((String)stepName) || !CommUtil.checkParam((String)scriptName, (int)4, (int)64) || !Pattern.matches("^[a-zA-Z0-9_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*(\\.bat|\\.sh){1}$", Normalizer.normalize(scriptName, Normalizer.Form.NFKC));
    }

    private void verifyProtectObjectSetting(List<ProtectObjectSettingBean> settings) {
        LOGGER.debug((Object)"enter verifyProtectObjectSetting");
        if (VerifyUtil.isEmpty(settings)) {
            throw new LegoCheckedException(1073947393L);
        }
        for (ProtectObjectSettingBean setting : settings) {
            if (VerifyUtil.isEmpty((String)setting.getUuid()) || VerifyUtil.isEmpty((String)setting.getName()) || VerifyUtil.isEmpty((String)setting.getValue())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)setting.getUuid())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!this.checkSettingName(setting.getName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (ParamChecker.checkGeneralText((String)setting.getValue())) continue;
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkTestParams(String planId, String disasterHostSn, String replicaId, String productSiteId) {
        LOGGER.debug((Object)"enter checkTestParams");
        this.checkPlanId(planId);
        if (VerifyUtil.isEmpty((String)disasterHostSn)) {
            LOGGER.error((Object)"disasterHostSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)disasterHostSn)) {
            LOGGER.error((Object)"disasterHostSn is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)replicaId)) {
            LOGGER.error((Object)"replicaId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)replicaId)) {
            LOGGER.error((Object)"replicaId is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)productSiteId)) {
            LOGGER.error((Object)"productSiteId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)productSiteId)) {
            LOGGER.error((Object)"productSiteId is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="recoveryPlan_exportRecoveryPlanLog_operateName", operationModule="recovery", level=1)
    @Permission(name="ism.drm.drp.auth.recoverymapping.export")
    public Response exportRecoveryPlanLog(String planId) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)planId);
        this.checkPlanId(planId);
        this.checkUserBizObjAuthority("recoveryPlan_exportRecoveryPlanLog_operateName", SysoplogLevel.INFO.getValue(), planId);
        BatchOperationResult result = new BatchOperationResult();
        RecoveryPlan recoveryPlan = null;
        try {
            recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)recoveryPlan.getName());
            CommUtils.checkObjectExists(recoveryPlan);
            if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
                throw new LegoCheckedException(1073947453L);
            }
            int pageSize = 20001;
            Page pageQueryRecoveryLogs = this.getRecoveryPlanService().pageQueryRecoveryLog(planId, 0, pageSize, "startTime", false);
            List recoveryLogs = pageQueryRecoveryLogs.getResult();
            CommUtils.checkObjectExists(recoveryLogs);
            if (recoveryLogs.size() > 20000) {
                throw new LegoCheckedException(1574L);
            }
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            this.exportLogHelper(recoveryLogs, result, recoveryPlan);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("Export recoveryplan log failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan == null ? "" : recoveryPlan.getName()));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Export recoveryplan log failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(recoveryPlan == null ? "" : recoveryPlan.getName()));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok((Object)result).build();
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="recoveryPlan_exportRecoveryPlanLogDetail_operateName", operationModule="recovery", level=1)
    @Permission(name="ism.drm.drp.auth.scan")
    public Response exportRecoveryPlanLogDetails(String planId, String logId) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)planId);
        this.checkPlanId(planId);
        if (VerifyUtil.isEmpty((String)logId)) {
            LOGGER.debug((Object)"logId is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)logId)) {
            LOGGER.error((Object)"logId is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("recoveryPlan_exportRecoveryPlanLogDetail_operateName", SysoplogLevel.INFO.getValue(), planId);
        List recoverDetails = this.getRecoveryPlanService().getRecoveryProcessorDetailsByLogId(planId, logId);
        BatchOperationResult result = new BatchOperationResult();
        RecoveryPlan plan = null;
        try {
            CommUtils.checkObjectExists(recoverDetails);
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            plan = this.getRecoveryPlanService().getRecoveryPlan(planId, false, false);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)plan.getName());
            if (this.validateIsHypermetro(plan) || this.validateIsReplication(plan)) {
                throw new LegoCheckedException(1073947453L);
            }
            this.exportRecoveryHelper(recoverDetails, result, plan.getName());
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("Export recoveryplan log details failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(plan == null ? "" : plan.getName()));
            throw e;
        }
        catch (Exception le) {
            LOGGER.error((Object)("Export recoveryplan log details failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)le)));
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(plan == null ? "" : plan.getName()));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok((Object)result).build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportRecoveryHelper(List<RecoveryProcessorDetail> recoverDetails, BatchOperationResult result, String planName) {
        File excelFile;
        block10: {
            RecoveryPlanExcelDetailsOperator details = new RecoveryPlanExcelDetailsOperator(this);
            FileOutputStream fileOutputStream = null;
            excelFile = null;
            try {
                Workbook wb = details.createExportExcel(recoverDetails, result);
                excelFile = new File(this.getExportCSVFilePath(planName, recoverDetails));
                fileOutputStream = new FileOutputStream(excelFile);
                wb.write((OutputStream)fileOutputStream);
                DownloadFileUtil.downloadFile(this.getResponse(), this.getRequest(), excelFile);
                if (fileOutputStream == null) break block10;
            }
            catch (LegoCheckedException e) {
                try {
                    LOGGER.error((Object)"Creating exported excel failed.", (Throwable)e, 90160758784001L);
                    throw e;
                    catch (Exception ex) {
                        LOGGER.error((Object)("Export recoveryplan log details failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)ex)));
                        throw new LegoCheckedException(1073948423L, (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException e2) {
                            LOGGER.error((Object)e2, 90160758784000L);
                        }
                    }
                    this.deleteTempFile(excelFile);
                    throw throwable;
                }
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e, 90160758784000L);
            }
        }
        this.deleteTempFile(excelFile);
    }

    private void deleteTempFile(File excelFile) {
        if (excelFile != null && excelFile.exists() && !excelFile.delete()) {
            LOGGER.error((Object)"Delete file error.");
        }
    }

    private static String getDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
        try {
            Long ll = Long.parseLong(date);
            return sdf.format(new Date(ll));
        }
        catch (Exception e) {
            if (date.length() <= 10) {
                return sdf.format(new Date());
            }
            return date.substring(0, date.length() - 10);
        }
    }

    private static String getEnd(List<RecoveryProcessorDetail> recoverDetails) {
        String end = "--";
        for (RecoveryProcessorDetail palnLog : recoverDetails) {
            if (null == palnLog.getEndTime() || "".equals(palnLog.getEndTime()) || "--".equals(palnLog.getEndTime())) break;
            end = palnLog.getEndTime();
        }
        return end;
    }

    private String getExportCSVFilePath(String planName, List<RecoveryProcessorDetail> recoverDetails) {
        String fileName = RecoveryPlanRestServiceImpl.getDate(recoverDetails.get(0).getStartTime()) + "_" + RecoveryPlanRestServiceImpl.getDate(RecoveryPlanRestServiceImpl.getEnd(recoverDetails));
        return FileExcelUtil.createTempDownloadPath(this.getSession(), planName, fileName, "csv");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportLogHelper(List<RecoveryLog> recoveryLogs, BatchOperationResult result, RecoveryPlan recoveryPlan) {
        File excelFile;
        block10: {
            RecoveryPlanLogExcelOperator operator = new RecoveryPlanLogExcelOperator(this);
            FileOutputStream fileOutputStream = null;
            excelFile = null;
            try {
                Workbook wb = operator.createExportExcel(recoveryLogs, result);
                String filePath = FileExcelUtil.createTempDownloadPath(this.getSession(), recoveryPlan.getName(), null, "csv");
                excelFile = new File(filePath);
                fileOutputStream = new FileOutputStream(excelFile);
                wb.write((OutputStream)fileOutputStream);
                DownloadFileUtil.downloadLogFile(this.getResponse(), this.getRequest(), excelFile);
                if (fileOutputStream == null) break block10;
            }
            catch (LegoCheckedException e) {
                try {
                    LOGGER.error((Object)"Creating exported excel failed.", (Throwable)e, 90160758784001L);
                    throw e;
                    catch (Exception ex) {
                        LOGGER.error((Object)("Export recoveryplan log failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)ex)));
                        throw new LegoCheckedException(1073948423L, (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException e2) {
                            LOGGER.error((Object)e2, 90160758784000L);
                        }
                    }
                    this.deleteTempFile(excelFile);
                    throw throwable;
                }
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e, 90160758784000L);
            }
        }
        this.deleteTempFile(excelFile);
    }

    private int getResourceType(ProtectGroup pg) {
        ProtectObject po = (ProtectObject)pg.getPolist().iterator().next();
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            LOGGER.error((Object)("usedStorageResourceSet is empty! pgName : " + pg.getName() + ", po:" + po.getMoUuid() + ", poName:" + po.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)usedStorageResourceSet.iterator().next();
        return posi.getResourceType();
    }
}

