/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.report.util;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.platform.report.ProtectGroupStatisticInfoVo;
import com.huawei.ism.drm.web.util.FileExcelUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;

public class ExportProtectGroupReportUtilExcel
extends FileExcelUtil {
    private static final int COL_WIDTH = 5000;
    private static final String RPO_ITEM_KEY = "RPO_ITEM_KEY";
    private static final String RTO_ITEM_KEY = "RTO_ITEM_KEY";
    private static final long SECOND = 1000L;
    private static final long SIXTY = 60L;
    private static final long TWENTYFOURE = 24L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final String BLANK_SPACE = " ";
    private String dayText;
    private String hourText;
    private String minText;
    private String secText;
    private boolean isEnglish = false;

    @Override
    protected List<List<String>> constructDataRows() {
        this.getText();
        List voList = (List)this.getDataList();
        if (VerifyUtil.isEmpty((Collection)voList)) {
            return null;
        }
        ArrayList<List<String>> rowDataList = new ArrayList<List<String>>();
        for (ProtectGroupStatisticInfoVo data : voList) {
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add(data.getPgName());
            rowData.add(data.getPpTypeStr());
            rowData.add(data.getProduceSiteName());
            rowData.add(data.getRecoverSiteName());
            rowData.add(data.getPoTypeStr());
            this.addRPOAndRTO(rowData, data.getProps());
            rowData.add(data.getSuccessNum() + "");
            rowData.add(data.getTotalNum() - data.getSuccessNum() + "");
            rowDataList.add(rowData);
        }
        return rowDataList;
    }

    private void getText() {
        this.dayText = this.getAbstractRestService().getText("common_term_day_plural_label");
        this.hourText = this.getAbstractRestService().getText("common_term_hour_plural_label");
        this.minText = this.getAbstractRestService().getText("common_term_minute_plural_label");
        this.secText = this.getAbstractRestService().getText("common_term_second_plural_label");
        Locale locale = this.getAbstractRestService().getLocale();
        if (!VerifyUtil.isEmpty((Object)locale) && "en".equalsIgnoreCase(locale.toString())) {
            this.dayText = BLANK_SPACE + this.dayText + BLANK_SPACE;
            this.hourText = BLANK_SPACE + this.hourText + BLANK_SPACE;
            this.minText = BLANK_SPACE + this.minText + BLANK_SPACE;
            this.secText = BLANK_SPACE + this.secText + BLANK_SPACE;
            this.isEnglish = true;
        }
    }

    private void addRPOAndRTO(List<String> rowData, Map<String, String> props) {
        if (VerifyUtil.isEmpty(props)) {
            rowData.add("--");
            rowData.add("--");
            rowData.add("--");
            return;
        }
        this.addColumValueRPO(rowData, props);
        this.addColumnValueRTO(rowData, props);
    }

    private void addColumnValueRTO(List<String> rowData, Map<String, String> props) {
        String rtoStr = props.get(RTO_ITEM_KEY);
        if (VerifyUtil.isEmpty((String)rtoStr)) {
            rowData.add("--");
        } else {
            JSONArray jsonArray = JSONArray.fromObject((Object)rtoStr);
            StringBuilder sbRto = new StringBuilder();
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                JSONObject obj = JSONObject.fromObject(iterator.next());
                String estimateRTO = obj.getString("estimateRTO");
                sbRto.append(this.formatTime(estimateRTO)).append(",");
            }
            if (sbRto.length() > 0) {
                rowData.add(sbRto.substring(0, sbRto.length() - 1));
            } else {
                rowData.add("--");
            }
        }
    }

    private void addColumValueRPO(List<String> rowData, Map<String, String> props) {
        String rpoStr = props.get(RPO_ITEM_KEY);
        if (VerifyUtil.isEmpty((String)rpoStr)) {
            rowData.add("--");
            rowData.add("--");
        } else {
            JSONArray jsonArray = JSONArray.fromObject((Object)rpoStr);
            StringBuilder sbCfgRpo = new StringBuilder();
            StringBuilder sbActualRpo = new StringBuilder();
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                JSONObject obj = JSONObject.fromObject(iterator.next());
                String configuredRPO = obj.getString("configuredRPO");
                String actualRPO = obj.getString("actualRPO");
                sbCfgRpo.append(this.formatTime(configuredRPO)).append(",");
                sbActualRpo.append(this.formatTime(actualRPO)).append(",");
            }
            if (sbCfgRpo.length() > 0) {
                rowData.add(sbCfgRpo.substring(0, sbCfgRpo.length() - 1));
            } else {
                rowData.add("--");
            }
            if (sbActualRpo.length() > 0) {
                rowData.add(sbActualRpo.substring(0, sbActualRpo.length() - 1));
            } else {
                rowData.add("--");
            }
        }
    }

    private String formatTime(String configuredRPO) {
        Long time = NumberUtil.convertToLong((Object)configuredRPO);
        if (time == 0L) {
            return "0";
        }
        if (time < 0L) {
            return "--";
        }
        return this.calculatTime(time);
    }

    @Override
    protected void setColumnWidth(Sheet sheetTab) {
        super.setColumnWidth(sheetTab);
        sheetTab.setColumnWidth(0, 5000);
        sheetTab.setColumnWidth(1, 5000);
        sheetTab.setColumnWidth(2, 5000);
        sheetTab.setColumnWidth(3, 5000);
        sheetTab.setColumnWidth(6, 5000);
        sheetTab.setColumnWidth(7, 5000);
        sheetTab.setColumnWidth(8, 5000);
    }

    public String calculatTime(long milliSecondTime) {
        long minute;
        long seconds;
        long day = milliSecondTime / 86400000L;
        long hour = (milliSecondTime -= day * 86400000L) / 3600000L;
        milliSecondTime -= hour * 3600000L;
        if ((seconds = (milliSecondTime -= (minute = milliSecondTime / 60000L) * 60000L) / 1000L) >= 60L) {
            minute += (seconds %= 60L) / 60L;
        }
        if (minute >= 60L) {
            hour += (minute %= 60L) / 60L;
        }
        if (hour >= 24L) {
            day += (hour %= 24L) / 24L;
        }
        StringBuilder sbBuilder = new StringBuilder();
        this.appendTime(day, sbBuilder, this.dayText);
        this.appendTime(hour, sbBuilder, this.hourText);
        this.appendTime(minute, sbBuilder, this.minText);
        this.appendTime(seconds, sbBuilder, this.secText);
        if (sbBuilder.length() == 0) {
            sbBuilder.append("--");
        } else if (this.isEnglish) {
            sbBuilder.replace(sbBuilder.length() - 1, sbBuilder.length(), "");
        }
        return sbBuilder.toString();
    }

    private void appendTime(long time, StringBuilder sbBuilder, String text) {
        if (0L < time) {
            sbBuilder.append(time + text);
        }
    }
}

