/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.site;

import com.huawei.ism.cbb.base.sdk.util.ValidateUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.site.IManagementServerRestService;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.ParamValidator;
import com.huawei.ism.drm.rest.util.Permission;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.List;
import javax.ws.rs.core.Response;

public class ManagementServerRestServiceImpl
extends AbstractRestService
implements IManagementServerRestService {
    private static final Log LOGGER = LogFactory.getInstance(ManagementServerRestServiceImpl.class);

    @Override
    @ParamValidator
    @OperationLog(operationName="server_modifyServer_operateName", operationModule="manage", level=3)
    @Permission(name="ism.drm.servers.auth.modify")
    public Response updateServer(String uuid, ManagementServer server) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)uuid);
        if (VerifyUtil.isEmpty((String)uuid) || !ParamChecker.checkGeneralId((String)uuid)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (null == server) {
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer replica = this.getServerService().getServer(uuid);
        if (null == replica) {
            throw new LegoCheckedException(2117645L);
        }
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)replica.getName());
        String user = HtmlStringConverter.decodeByLength(server.getUser());
        if (null != user && !VerifyUtil.isEmpty((String)user) && !"SyncAdmin".equals(user)) {
            LOGGER.error((Object)("updateServer user is error :" + user));
            throw new LegoCheckedException(1073947393L);
        }
        String pwd = HtmlStringConverter.decodeByLength(server.getPwd());
        if (null != pwd && !pwd.isEmpty()) {
            ValidateUtil.validate((String)"^.{1,64}$", (String)pwd);
            server.setPwd(WccEncryptor.encrypt((String)pwd));
        } else {
            server.setPwd(null);
        }
        server.setUuid(uuid);
        try {
            this.getServerService().updateServer(server);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{replica.getName(), replica.getName()});
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Update server fail, uuid=" + uuid + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758784000L);
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    @Override
    @Permission(name="ism.drm.servers.auth.scan")
    public String getServerInfo() {
        ManagementServer serverInfo = this.getServerService().getServerInfo();
        return this.beanToJson(serverInfo).toString();
    }

    private JSONObject beanToJson(ManagementServer bean) {
        JSONObject json = new JSONObject();
        json.put((Object)"uuid", (Object)bean.getUuid());
        json.put((Object)"name", (Object)bean.getName());
        json.put((Object)"devAlias", (Object)bean.getDevAlias());
        json.put((Object)"status", (Object)bean.getStatus());
        json.put((Object)"ip", (Object)bean.getIp());
        json.put((Object)"port", (Object)bean.getPort());
        json.put((Object)"serverType", (Object)bean.getServerType());
        json.put((Object)"version", (Object)bean.getVersion());
        json.put((Object)"user", (Object)bean.getUser());
        return json;
    }

    @Override
    @Permission(name="ism.drm.servers.auth.scan")
    public String getServers() {
        List servers = this.getServerService().getServers();
        JSONArray array = new JSONArray();
        for (ManagementServer server : servers) {
            array.add((Object)this.beanToJson(server));
        }
        return array.toString();
    }

    private IManagementServerService getServerService() {
        return (IManagementServerService)this.getBundleService("DRM_Base", IManagementServerService.class.getName());
    }
}

