/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.util;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.util.Permission;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class AuthCheckAspect {
    private static final Log LOGGER = LogFactory.getInstance(AuthCheckAspect.class);

    public void before(JoinPoint joinPoint) {
        if (!(joinPoint.getTarget() instanceof AbstractRestService)) {
            LOGGER.error((Object)"Cannot get rest service.");
            throw new LegoCheckedException(-1L);
        }
        AbstractRestService restService = (AbstractRestService)joinPoint.getTarget();
        Long userId = restService.getCurrentUserId();
        if (userId == null) {
            LOGGER.error((Object)"Cannot get current user.", 653110170615808L);
            throw new LegoCheckedException(1073947400L);
        }
        if (!(ServiceLocator.getBundleService((String)"user", (String)"usermgr") instanceof IUserMgr)) {
            LOGGER.error((Object)"Cannot get usermgr service.");
            throw new LegoCheckedException(-1L);
        }
        IUserMgr mgr = (IUserMgr)ServiceLocator.getBundleService((String)"user", (String)"usermgr");
        if (!(joinPoint.getSignature() instanceof MethodSignature)) {
            LOGGER.error((Object)"Get method signature failed");
            throw new LegoCheckedException(1073947393L);
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Permission permission = signature.getMethod().getAnnotation(Permission.class);
        boolean hasRight = mgr.checkUserRight(userId.longValue(), permission.name());
        if (!hasRight) {
            throw new LegoCheckedException(1073947400L);
        }
    }
}

