/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public final class BaseRestUtils {
    private static final Log LOGGER = LogFactory.getInstance(BaseRestUtils.class);

    private BaseRestUtils() {
    }

    public static void checkParamCommon(Object ... params) {
        if (!VerifyUtil.isEmpty((Object[])params)) {
            for (Object paramTmp : params) {
                if (!VerifyUtil.isEmpty((Object)paramTmp)) continue;
                LOGGER.error((Object)"paramter is null.", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
        } else {
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static String getIdFromUuid(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            return "";
        }
        if (uuid.contains(":")) {
            uuid = uuid.split(":")[1];
        }
        return uuid;
    }

    public static boolean isQuerySelfOnly(Long userId) {
        if (VerifyUtil.isEmpty((Object)userId) || userId == -1L) {
            LOGGER.warn((Object)"UserId is empty or sso user.");
            return false;
        }
        IUserMgr mgr = (IUserMgr)ServiceLocator.getBundleService((String)"user", (String)"usermgr");
        User user = mgr.getUserInfo(userId.longValue());
        Set roles = user.getRolesSet();
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return false;
        }
        return roles.stream().map(Role::getRoleId).noneMatch(roleId -> roleId == 1L || roleId == 3L);
    }
}

