/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.util;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.web.util.RequestUtil;
import com.huawei.ism.drm.web.util.UriUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class OperationLogAspect {
    private static final Log LOGGER = LogFactory.getInstance(OperationLogAspect.class);
    private static final int SUCCESS = 1;
    private static final int FAILURE = 0;
    private static final int MAX_TERMINAL_IP_LENGTH = 255;
    private static final String AFTER_PREFIX = "After Method: ";
    private static final String THROW_PREFIX = "Exception in Method: ";
    private List<String> cloudUris = Arrays.asList("/ws/csha", "/ws/csdr", "/ws/bcs", "/ws/om", "/ws/csr");

    public void before(JoinPoint joinPoint) {
        LOGGER.info((Object)"Before execute method %s", new Object[]{joinPoint.getSignature().getName()});
    }

    public void doAfterReturning(JoinPoint joinPoint) {
        try {
            SysOptLog sysOptLog = this.buildBaseLogInfo(joinPoint);
            sysOptLog.setLevel(1);
            sysOptLog.setResult(1);
            sysOptLog.setDetail("--");
            SysOpLogBuilder.writeOperateLog(sysOptLog);
            LOGGER.info((Object)"After execute method %s", new Object[]{joinPoint.getSignature().getName()});
        }
        catch (Exception err) {
            LOGGER.error((Object)"After returning pointcut execute failed, err: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)err)});
        }
    }

    public void doThrowing(JoinPoint joinPoint, Exception ex) {
        try {
            SysOptLog sysOptLog = this.buildBaseLogInfo(joinPoint);
            sysOptLog.setLevel(3);
            sysOptLog.setResult(0);
            if (ex instanceof LegoCheckedException) {
                sysOptLog.setDetail("lego.err." + ((LegoCheckedException)((Object)ex)).getErrorCode());
                sysOptLog.setDetailPara(((LegoCheckedException)((Object)ex)).getParameters());
            } else {
                sysOptLog.setDetail("lego.err.-1");
                sysOptLog.setDetailPara(new String[0]);
            }
            SysOpLogBuilder.writeOperateLog(sysOptLog);
            LOGGER.info((Object)(THROW_PREFIX + joinPoint.getSignature().getName()));
        }
        catch (Exception err) {
            LOGGER.error((Object)"Throwing pointcut execute failed, err: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)err)});
        }
    }

    private SysOptLog buildBaseLogInfo(JoinPoint joinPoint) {
        if (!(joinPoint.getSignature() instanceof MethodSignature)) {
            LOGGER.error((Object)"Get method signature failed");
            throw new LegoCheckedException(1073947393L);
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        AbstractRestService restService = (AbstractRestService)joinPoint.getTarget();
        return this.buildSysOptlog(restService, method);
    }

    private SysOptLog buildSysOptlog(AbstractRestService restService, Method method) {
        SysOptLog sysOptLog = new SysOptLog();
        OperationLog opLog = method.getAnnotation(OperationLog.class);
        if (opLog != null) {
            String currentUserName;
            HttpServletRequest request = restService.getRequest();
            String tokenUser = (String)request.getAttribute("iam-x-auth-user-json");
            JSONObject jsonObject = JSONObject.fromObject((Object)tokenUser);
            if (!VerifyUtil.isEmpty((Map)jsonObject)) {
                currentUserName = jsonObject.getString("name");
            } else if (!VerifyUtil.isEmpty((Object)request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_USER_NAME))) {
                currentUserName = (String)request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_USER_NAME);
            } else {
                currentUserName = "NoLoginUser";
                try {
                    currentUserName = restService.getCurrentUser().getUserName();
                }
                catch (LegoCheckedException e) {
                    LOGGER.info((Object)"User did not login.");
                }
            }
            sysOptLog.setOperation(opLog.operationName());
            if (!VerifyUtil.isEmpty((Object)request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME))) {
                sysOptLog.setOperation((String)request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME));
            }
            sysOptLog.setOperator(currentUserName);
            sysOptLog.setDate(new Date(System.currentTimeMillis()));
            sysOptLog.setModule(opLog.operationModule());
            if (VerifyUtil.isEmpty((String)opLog.operationDetail())) {
                sysOptLog.setDetail("");
            } else {
                sysOptLog.setDetail(opLog.operationDetail());
            }
            sysOptLog.setLevel(opLog.level());
            sysOptLog.setServiceType(this.getServiceType(request, opLog));
            sysOptLog.setTokenUser(VerifyUtil.isEmpty((String)tokenUser) ? currentUserName : tokenUser);
            sysOptLog.setProjectId((String)request.getAttribute("iam-x-auth-user-project"));
            sysOptLog.setTarget(VerifyUtil.isEmpty((Object)request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET)) ? "" : (String)request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET));
            if (!VerifyUtil.isEmpty((Object)request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM)) && request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM) instanceof String[]) {
                sysOptLog.setDetailPara((String[])request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM));
            }
            sysOptLog.setTargetLocal(Boolean.TRUE);
            sysOptLog.setTerminalIp(this.getTerminalIp(restService, sysOptLog));
            sysOptLog.setLogType(this.getLogType(restService));
        }
        return sysOptLog;
    }

    private String getServiceType(HttpServletRequest request, OperationLog opLog) {
        return Optional.ofNullable(request).map(req -> Optional.ofNullable(req.getAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE)).map(String::valueOf).orElse(req.getHeader("servicetype"))).orElse(opLog.drType());
    }

    private String getLogType(AbstractRestService restService) {
        String uri = this.getRequestUri(restService);
        if (this.isCloudRestService(uri)) {
            return "tenantlog";
        }
        return "administratorlog";
    }

    private String getTerminalIp(AbstractRestService restService, SysOptLog sysOptLog) {
        String remoteAddr = AbstractRestService.getRemoteAddr(restService.getRequest());
        String terminalIp = this.isCloudRestService(this.getRequestUri(restService)) ? RequestUtil.getFirstIPFromIPStr(remoteAddr) : RequestUtil.getLastIPFromIPStr(remoteAddr);
        if (terminalIp.length() > 255) {
            LOGGER.error((Object)"Failed to getTerminalIp, cause terminalIp exceed the limit,operator:%s,operation:%s,target:%s,date:%s,terminalIp:%s", new Object[]{sysOptLog.getOperator(), sysOptLog.getOperation(), sysOptLog.getTarget(), sysOptLog.getDate(), terminalIp});
            return terminalIp.substring(0, 255);
        }
        return terminalIp;
    }

    private String getRequestUri(AbstractRestService restService) {
        String uri = restService.getRequest().getRequestURI();
        return UriUtil.canonicalPath(uri);
    }

    private boolean isCloudRestService(String uri) {
        for (String subUri : this.cloudUris) {
            if (!uri.startsWith(subUri)) continue;
            return true;
        }
        return false;
    }
}

