/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.huawei.ism.drm.web.filter.ParameterizedFilterConfig;
import com.huawei.ism.drm.web.filter.SystemSecurityFilter;
import com.huawei.ism.drm.web.util.CookieUtil;
import com.huawei.ism.drm.web.util.FilterUtil;
import com.huawei.ism.drm.web.util.SessionUtil;
import com.huawei.ism.drm.web.util.UriUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.util.ReflectUtils;

public class SSOIntegrateFilter
implements Filter {
    public static final String PAGE_INDEX = "/src/index.html";
    public static final String WRAPPED_FILTER_CLASS = "wrappedFilterClass";
    public static final String SESSION_LANGUAGE = "WW_TRANS_I18N_LOCALE";
    public static final long FORBIDDEN = 403L;
    public static final String TINY_LANGUAGE = "tiny_language";
    private static final String SSO_ERROR = "SSO-Error: ";
    private static final String HTTP_METHOD_GET = "GET";
    private static final String EN = "en";
    private static final String ZH = "zh";
    private static final Log LOGGER = LogFactory.getInstance(SSOIntegrateFilter.class);
    private static final String PAGE_LOGIN = "/src";
    private boolean ssoDeployMode;
    private Map<String, String> loginMap = null;
    private List<String> noAuthResources = null;
    private Filter filter = null;

    public void destroy() {
        this.noAuthResources = null;
        this.loginMap = null;
        if (this.filter != null) {
            this.filter.destroy();
            this.filter = null;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = httpRequest.getRequestURI();
        uri = UriUtil.canonicalPath(uri);
        String method = httpRequest.getMethod();
        if (PAGE_LOGIN.equals(uri)) {
            this.setLanguage(httpRequest, httpResponse);
            this.redirectToLoginPage(httpResponse);
            return;
        }
        if ("/".equals(uri) && "get".equalsIgnoreCase(method)) {
            this.setLanguage(httpRequest, httpResponse);
            this.redirectToHomePage(httpResponse);
            return;
        }
        this.refreshLoginMap(httpRequest);
        boolean ignore = !this.ssoDeployMode;
        boolean bl = ignore = ignore || SystemSecurityFilter.checkNoAuthResources(this.noAuthResources, uri, method);
        if (SessionUtil.isLocalLoginMode(httpRequest)) {
            ignore = true;
        } else if (SessionUtil.isSSOLoginMode(httpRequest)) {
            if (this.redirectToHomePageWhenNativeLogin(uri, method, httpResponse)) {
                return;
            }
        } else {
            boolean miVisited;
            boolean login = SystemSecurityFilter.checkUriAndMethod(this.loginMap, uri, method);
            boolean cloud = SystemSecurityFilter.isCloudRestService(uri);
            boolean bl2 = miVisited = SystemSecurityFilter.getMachineInterfaceVisitorName(httpRequest, uri) != null;
            if (SystemSecurityFilter.isRestRequest(uri) && !login && !cloud && !miVisited) {
                String userLoginMode = httpRequest.getHeader("user.login.mode");
                if ("sso".equals(userLoginMode)) {
                    UriUtil.writeSSORedirect(httpRequest, httpResponse);
                } else {
                    UriUtil.writeLocalRedirect(httpRequest, httpResponse);
                }
                return;
            }
            ignore = ignore || login;
            ignore = ignore || cloud;
            boolean bl3 = ignore = ignore || miVisited;
        }
        if (ignore) {
            chain.doFilter(request, response);
        } else {
            this.doSSOFilter(httpRequest, httpResponse, chain);
        }
    }

    private void refreshLoginMap(HttpServletRequest httpRequest) {
        boolean isLocalLogin = Boolean.parseBoolean(httpRequest.getParameter("localProtalLogin"));
        if (isLocalLogin) {
            this.loginMap.put(PAGE_INDEX, HTTP_METHOD_GET);
        } else {
            this.loginMap.remove(PAGE_INDEX);
        }
    }

    private void setLanguage(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String language = httpRequest.getParameter("locale");
        if (VerifyUtil.isEmpty((String)language)) {
            return;
        }
        LOGGER.debug((Object)"get language is %s", new Object[]{language});
        HttpSession session = httpRequest.getSession();
        if ("zh-cn".equalsIgnoreCase(language)) {
            session.setAttribute(SESSION_LANGUAGE, (Object)Locale.SIMPLIFIED_CHINESE);
            CookieUtil.addCookie(httpResponse, "rd_language", ZH);
            CookieUtil.addCookie(httpResponse, TINY_LANGUAGE, ZH);
        } else {
            session.setAttribute(SESSION_LANGUAGE, (Object)Locale.ENGLISH);
            CookieUtil.addCookie(httpResponse, "rd_language", EN);
            CookieUtil.addCookie(httpResponse, TINY_LANGUAGE, EN);
        }
    }

    private void doSSOFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        }
        catch (LegoCheckedException e) {
            HttpSession session = request.getSession(false);
            String message = e.getMessage();
            if (e.getErrorCode() == 403L && message != null && message.contains("SSO-Error: permission denied")) {
                if (session != null) {
                    Locale language = (Locale)session.getAttribute(SESSION_LANGUAGE);
                    if (!VerifyUtil.isEmpty((Object)language)) {
                        String tempLanguage = Locale.ENGLISH.equals(language) ? EN : ZH;
                        CookieUtil.addCookie(response, "rd_language", tempLanguage, "/pages/");
                    }
                    session.invalidate();
                }
                response.sendRedirect("/pages/forbidden.html");
            }
            if (message != null && message.startsWith(SSO_ERROR)) {
                response.getWriter().append("{\"status\": 403}");
                if (session != null) {
                    session.invalidate();
                }
                response.sendError(403);
            }
            throw e;
        }
    }

    private void redirectToHomePage(HttpServletResponse response) throws IOException {
        response.sendRedirect(PAGE_INDEX);
    }

    private void redirectToLoginPage(HttpServletResponse response) throws IOException {
        response.sendRedirect("/src/index.html?localProtalLogin=true");
    }

    private boolean redirectToHomePageWhenNativeLogin(String uri, String method, HttpServletResponse response) throws IOException {
        boolean matched = SystemSecurityFilter.checkUriAndMethod(this.loginMap, uri, method);
        if (!matched || !uri.endsWith("/login")) {
            return false;
        }
        this.redirectToHomePage(response);
        return true;
    }

    public void init(FilterConfig config) throws ServletException {
        this.ssoDeployMode = "true".equalsIgnoreCase(config.getServletContext().getInitParameter("SSODeployMode"));
        String validUris = FilterUtil.getInitParameter(config, SystemSecurityFilter.class, "validUris");
        this.noAuthResources = SystemSecurityFilter.addNoAuthResources(new ArrayList<String>());
        this.loginMap = FilterUtil.initSpecialUriMap(validUris, new HashMap<String, String>());
        String clazz = config.getInitParameter(WRAPPED_FILTER_CLASS);
        this.filter = (Filter)ReflectUtils.newInstance((String)clazz, (Object[])new Object[0]);
        this.filter.init((FilterConfig)new ParameterizedFilterConfig(config));
    }
}

