/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.drm.rest.service.framework.system.service.SystemRestServiceImpl;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.ILogConfigService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.util.StringUtils;
import org.xml.sax.SAXException;

public class Log4jListenerAdaptor
extends FileAlterationListenerAdaptor {
    private static final String LOGGER_LEGO_NAME = "com.huawei.lego";
    private static final String LOGGER_ISM_NAME = "com.huawei.ism";
    private static final String LOG4J_NAME = "log4j.xml";
    private static final String LOG4J_LEVEL2_NODE = "Loggers";
    private static final String LOG4J_LEVEL3_NODE = "AsyncLogger";
    private static final Log LOG = FELogFactory.getInstance((String)"Log4jListenerAdaptor");
    private static final Map<String, Level> LEVELS;
    private static final String LOG4J_FILE_INCORRECT_FORMAT = "File log4j.xml Incorrect format.";

    public void onFileChange(File file) {
        if (LOG4J_NAME.equals(file.getName())) {
            Map<String, String> levelMap;
            boolean isCorrect;
            Level preLevel = LogManager.getLogger((String)LOGGER_LEGO_NAME).getLevel();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Front log level is %s", new Object[]{preLevel.toString().toUpperCase(Locale.ENGLISH)});
            }
            if (!(isCorrect = this.validateLevelInfo(levelMap = this.parserLog4jXml(file), preLevel))) {
                return;
            }
            String legoLevel = levelMap.get(LOGGER_LEGO_NAME).toUpperCase(Locale.ROOT);
            Configurator.setAllLevels((String)LOGGER_LEGO_NAME, (Level)LEVELS.get(legoLevel));
            Configurator.setAllLevels((String)LOGGER_ISM_NAME, (Level)LEVELS.get(legoLevel));
            LOG.warn((Object)"Succeeded in modifying front log level. The level is '%s'.", new Object[]{preLevel});
            if (!this.configBackgroundLog(legoLevel)) {
                Configurator.setAllLevels((String)LOGGER_LEGO_NAME, (Level)preLevel);
                Configurator.setAllLevels((String)LOGGER_ISM_NAME, (Level)preLevel);
                LOG.warn((Object)"Rolling Back Front Log Levels. The level is '%s'.", new Object[]{preLevel});
            }
        }
    }

    private boolean validateLevelInfo(Map<String, String> levelMap, Level preLevel) {
        if (levelMap.isEmpty() || !levelMap.containsKey(LOGGER_LEGO_NAME) || !levelMap.containsKey(LOGGER_ISM_NAME)) {
            LOG.error((Object)LOG4J_FILE_INCORRECT_FORMAT);
            return false;
        }
        String legoLevel = levelMap.get(LOGGER_LEGO_NAME);
        String ismLevel = levelMap.get(LOGGER_ISM_NAME);
        if (!(StringUtils.hasText((String)legoLevel) && StringUtils.hasText((String)ismLevel) && legoLevel.equals(ismLevel))) {
            LOG.error((Object)"Log level of 'com.huawei.lego' or 'com.huawei.ism' Incorrect format.");
            return false;
        }
        if (!LEVELS.containsKey(legoLevel.toUpperCase(Locale.ROOT))) {
            LOG.error((Object)"Log level of 'com.huawei.lego' or 'com.huawei.ism' Incorrect format.");
            return false;
        }
        if (LEVELS.get(legoLevel.toUpperCase(Locale.ROOT)).equals((Object)preLevel)) {
            LOG.error((Object)"Modifying Log level equals Previous Log Level.");
            return false;
        }
        return true;
    }

    private boolean configBackgroundLog(String paramString) {
        if (!StringUtils.hasText((String)paramString)) {
            LOG.error((Object)"Background log level is null.");
            return false;
        }
        ILogConfigService localLogConfigService = SystemRestServiceImpl.getService();
        if (localLogConfigService == null) {
            LOG.error((Object)"Get log config Service failed.");
            return false;
        }
        boolean isSuccess = localLogConfigService.changeLevel(paramString);
        if (isSuccess) {
            LOG.warn((Object)"Succeeded in modifying background log level. The level is '%s'.", new Object[]{paramString});
            return true;
        }
        LOG.error((Object)"Failed in modifying background log level. The level is '%s'.", new Object[]{paramString});
        return false;
    }

    private Map<String, String> parserLog4jXml(File file) {
        HashMap<String, String> levelMap = new HashMap<String, String>();
        try {
            SAXReader reader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(file);
            if (document == null) {
                LOG.error((Object)LOG4J_FILE_INCORRECT_FORMAT);
                return levelMap;
            }
            Element root = document.getRootElement();
            List list = root.elements(LOG4J_LEVEL2_NODE);
            if (VerifyUtil.isEmpty((Collection)list)) {
                LOG.error((Object)LOG4J_FILE_INCORRECT_FORMAT);
                return levelMap;
            }
            this.parserSecondNode(list, levelMap);
        }
        catch (DocumentException | SAXException ex) {
            LOG.error((Object)"File log4j.xml does not exist:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        return levelMap;
    }

    private void parserSecondNode(List<Element> list, Map<String, String> levelMap) {
        for (Element ele : list) {
            List third = ele.elements(LOG4J_LEVEL3_NODE);
            if (VerifyUtil.isEmpty((Collection)third)) continue;
            for (Element th : third) {
                String attributeName = th.attributeValue("name");
                String attributeLevel = th.attributeValue("level");
                if (!LOGGER_LEGO_NAME.equals(attributeName) && !LOGGER_ISM_NAME.equals(attributeName)) continue;
                levelMap.put(attributeName, attributeLevel);
            }
        }
    }

    static {
        HashMap<String, Level> map = new HashMap<String, Level>(3);
        map.put("DEBUG", Level.DEBUG);
        map.put("INFO", Level.INFO);
        LEVELS = Collections.unmodifiableMap(map);
    }
}

