/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManagerBase;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.msg.IAsyncTaskResponseChecker;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackStorageResourcePool;
import com.huawei.ism.drm.openstack.sdk.msg.CreateVhaCsdrRingInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ReplicationDriverDataInfo;
import com.huawei.ism.drm.openstack.sdk.msg.StoragePoolInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VhaCsdrRingInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolReplicaCgCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolReplicaCgUpdateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.util.endpointutil.ServiceEndpointUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DrExtendManager
extends DrExtendManagerBase {
    private static final Log LOG = LogFactory.getInstance(DrExtendManager.class);
    private static final List<String> REPLICATION_CAN_DELETE_STATUS = new ArrayList<String>(Arrays.asList(OpenstackEnumDefine.ReplicationStatusE.DELETING.getValue(), OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue(), OpenstackEnumDefine.ReplicationStatusE.ERROR.getValue(), OpenstackEnumDefine.ReplicationStatusE.ERROR_DELETING.getValue()));
    private static final List<String> NORMAL_REPLICATION_CAN_DELETE_STATUS = new ArrayList<String>(Arrays.asList(OpenstackEnumDefine.ReplicationStatusE.DELETING.getValue(), OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue()));
    private static final long EACH_PAIR_OVER_TIME = 60000L;

    @Override
    public List<VolumeReplicationInfo> getVolumeReplications(String regionUuid, String tokenId, String projUuid, Map<String, String> uriVariables, boolean isSummary) {
        if (VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)regionUuid)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<VolumeReplicationInfo> repInfolist = new ArrayList<VolumeReplicationInfo>();
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + (isSummary ? this.getSummaryUrl(uriVariables, projId) : this.getDetailUrl(uriVariables, projId));
        String limit = String.valueOf(1000);
        if (VerifyUtil.isEmpty(uriVariables)) {
            uriVariables = new HashMap<String, String>();
        }
        uriVariables.put("limit", limit);
        int offset = 0;
        String respStr = null;
        while (true) {
            uriVariables.put("offset", String.valueOf(offset));
            respStr = ClientUtil.sendGetRequest(newUrlStr, uriVariables, tokenId, new int[0]);
            List<VolumeReplicationInfo> list = this.getVolumeRepliInfosFromRespStr(respStr);
            repInfolist.addAll(list);
            if (list.size() < 1000) break;
            offset += 1000;
        }
        return repInfolist;
    }

    private List<VolumeReplicationInfo> getVolumeRepliInfosFromRespStr(String respStr) {
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (VerifyUtil.isEmpty((Object)jsonNode) || jsonNode.path("replications").isMissingNode()) {
            LOG.error((Object)("Bad Request getVolumeReplications, response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        List<VolumeReplicationInfo> repInfolist = JsonUtil.jsonArrayToList(jsonNode.path("replications").toString(), VolumeReplicationInfo.class);
        LOG.debug((Object)"GetVolumeReplications detail. response str=%s", (long)repInfolist.size());
        return repInfolist;
    }

    private List<VolumeReplicationCgInfo> getVolumeReplicationCgInfoFromRespStr(String respStr) {
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || jsonNode.path("replicationcgs").isMissingNode()) {
            LOG.error((Object)"Bad Request getVolumeReplicationCgInfo.");
            throw new LegoCheckedException(0x300001L);
        }
        List<VolumeReplicationCgInfo> repCgInfolist = JsonUtil.jsonArrayToList(jsonNode.path("replicationcgs").toString(), VolumeReplicationCgInfo.class);
        LOG.debug((Object)"GetVolumeReplicationCgInfo detail. response str=%s", (long)repCgInfolist.size());
        return repCgInfolist;
    }

    private String getDetailUrl(Map<String, String> uriVariables, String projId) {
        if (VerifyUtil.isEmpty(uriVariables)) {
            return String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_LIST_VOLREP_DETAILS.getUri(), projId);
        }
        return String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_LIST_VOLREP_DETAILS_CG.getUri(), projId);
    }

    private String getSummaryUrl(Map<String, String> uriVariables, String projId) {
        if (VerifyUtil.isEmpty(uriVariables)) {
            return String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_LIST_VOLREPS.getUri(), projId);
        }
        return String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_LIST_VOLREPS_CG.getUri(), projId);
    }

    @Override
    public VolumeReplicationInfo queryVolumeReplication(String regionUuid, String tokenId, String projUuid, String replicationId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationId)) {
            LOG.error((Object)"Query volume replication failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_QUERY_VOLREP.getUri(), projId, replicationId);
        LOG.debug((Object)"Query volume replication.request str=%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        LOG.debug((Object)"Query volume replication success. reponse str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Query volume replication failed.respStr is null.request str=" + newUrlStr + ", reponse str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            LOG.error((Object)("Query volume replication success.request str=" + newUrlStr + ", reponse str=" + respStr));
            return null;
        }
        if (jsonNode.path("replication").isMissingNode()) {
            LOG.error((Object)("Query volume replication failed.bad Request queryVolumeReplication.request str=" + newUrlStr + ", reponse str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        return JsonUtil.jsonToBean(jsonNode.path("replication").toString(), VolumeReplicationInfo.class);
    }

    @Override
    public AsyncTaskResponse createVolumeReplication(VolumeReplicationInfo volReplicaCreateInfo, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)volReplicaCreateInfo)) {
            LOG.error((Object)"Failed to create volume replication.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_CREATE_VOLREP.getUri(), projId);
        String tempStr = JsonUtil.beanToJson(volReplicaCreateInfo);
        JSONObject bodyJson = new JSONObject();
        bodyJson.put((Object)"replication", (Object)tempStr);
        String respStr = ClientUtil.sendPostRequest(newUrlStr, bodyJson.toString(), tokenId);
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Response string is empty");
            throw new LegoCheckedException(1073948407L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || jsonNode.path("replication").isMissingNode()) {
            LOG.error((Object)("Bad Request createVolumeReplication :" + volReplicaCreateInfo));
            throw new LegoCheckedException(1073948407L);
        }
        VolumeReplicationInfo info = JsonUtil.jsonToBean(jsonNode.path("replication").toString(), VolumeReplicationInfo.class);
        if (null == info) {
            LOG.error((Object)("Convert to VolumeReplicationInfo return null, Str=" + jsonNode.path("replication").toString()));
            throw new LegoCheckedException(0x300001L);
        }
        if (OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(info.getStatus())) {
            response.setSuccess(true);
            response.setTaskResult(info);
            return response;
        }
        return this.checkCreateVolReplicationResponse(regionUuid, tokenId, projUuid, info);
    }

    @Override
    protected AsyncTaskResponse deleteVolumeReplicationCall(String regionUuid, String tokenId, String projUuid, String replicationId, boolean isForce, boolean isSingleDel) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationId)) {
            LOG.error((Object)"Delete volume replication failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String message = this.getDelMessageBody(false, isForce, isSingleDel);
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_DELETE_VOLREP.getUri(), projId, replicationId);
        LOG.debug((Object)"Delete volume replication replicationId=%s,request str=%s", new Object[]{replicationId, newUrlStr});
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, message, tokenId);
        LOG.debug((Object)"Delete volume replication replicationId=%s,response str=%s", new Object[]{replicationId, respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeleteVolReplicationResponse(regionUuid, tokenId, projUuid, replicationId, isSingleDel);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.error((Object)("Delete volume replication success. replicationId=" + replicationId));
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        LOG.error((Object)("Delete volume replication replicationId=" + replicationId + " failed.bad Request.request str=" + newUrlStr + " ,response str=" + respStr));
        response.setErrorCode("3145729");
        return response;
    }

    @Override
    public List<VolumeReplicationCgInfo> getVolumeReplicationCGs(String regionUuid, String tokenId, String projUuid, Map<String, String> uriVariables, int ... retryTimes) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            LOG.error((Object)("Parameter is empty, regionUuid=" + regionUuid + " projUuid=" + projUuid));
            throw new LegoCheckedException(1073947393L);
        }
        String cacheKey = Joiner.on((String)"_@_").join((Object[])new String[]{OpenStackCommonUtil.getIdFromUuid(regionUuid), OpenStackCommonUtil.getIdFromUuid(projUuid)});
        if (OpenstackCache.containsKey(OpenstackCache.CacheType.OPENSTACK_REP_CG_LIST, cacheKey)) {
            List cgList = (List)OpenstackCache.getCache(OpenstackCache.CacheType.OPENSTACK_REP_CG_LIST, cacheKey);
            return new ArrayList<VolumeReplicationCgInfo>(cgList);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_LIST_VOLREPCG_DETAILS.getUri(), projId);
        ArrayList<VolumeReplicationCgInfo> repCgInfolist = new ArrayList<VolumeReplicationCgInfo>();
        if (VerifyUtil.isEmpty(uriVariables)) {
            uriVariables = new HashMap<String, String>();
        }
        String limit = String.valueOf(1000);
        uriVariables.put("limit", limit);
        int offset = 0;
        while (true) {
            uriVariables.put("offset", String.valueOf(offset));
            String respStr = ClientUtil.sendGetRequest(newUrlStr, uriVariables, tokenId, retryTimes);
            List<VolumeReplicationCgInfo> list = this.getVolumeReplicationCgInfoFromRespStr(respStr);
            repCgInfolist.addAll(list);
            if (list.size() < 1000) break;
            offset += 1000;
        }
        OpenstackCache.putCache(OpenstackCache.CacheType.OPENSTACK_REP_CG_LIST, cacheKey, new ArrayList(repCgInfolist));
        return repCgInfolist;
    }

    @Override
    public VolumeReplicationCgInfo queryVolumeReplicationCG(String regionUuid, String tokenId, String projUuid, String replicationCgId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            LOG.error((Object)"Failed to query volume replicationcg.parameter is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_QUERY_VOLREPCG.getUri(), projId, OpenStackCommonUtil.getIdFromUuid(replicationCgId));
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        LOG.debug((Object)"Query VolumeReplicationCG. request str=%s", new Object[]{newUrlStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Query VolumeReplicationCG failed. response string is empty,request str=%s", new Object[]{newUrlStr});
            throw new LegoCheckedException(0x300001L);
        }
        LOG.debug((Object)"Succeed querying VolumeReplicationCG. response str=%s", new Object[]{respStr});
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            LOG.error((Object)("Query VolumeReplicationCG failed. jsonNode is null.response str=" + respStr));
            return null;
        }
        if (jsonNode.path("replicationcg").isMissingNode()) {
            LOG.error((Object)("Query VolumeReplicationCG failed,bad Request getVolumeReplicationCG.response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        LOG.debug((Object)"Query VolumeReplicationCG succeed. response str=%s", new Object[]{respStr});
        return JsonUtil.jsonToBean(jsonNode.path("replicationcg").toString(), VolumeReplicationCgInfo.class);
    }

    @Override
    public VolumeReplicationCgInfo queryVolumeReplicationCGWithCache(String regionUuid, String tokenId, String projUuid, String replicationCgId, int ... retryTimes) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            LOG.error((Object)("Parameter is empty, regionUuid=" + regionUuid + " projUuid=" + projUuid + " replicationCgId=" + replicationCgId));
            throw new LegoCheckedException(1073947393L);
        }
        String cgId = OpenStackCommonUtil.getIdFromUuid(replicationCgId);
        List<VolumeReplicationCgInfo> cgList = this.getVolumeReplicationCGs(regionUuid, tokenId, projUuid, null, retryTimes);
        return cgList.stream().filter(cgInfo -> cgId.equals(cgInfo.getId())).findFirst().orElse(null);
    }

    public VhaCsdrRingInfo queryVolumeReplicationRing(String regionUuid, String tokenId, String projUuid, String replicationRingId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationRingId)) {
            LOG.error((Object)"Failed to query volume replication ring detail.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_QUERY_REPLICATION_RING.getUri(), projId, OpenStackCommonUtil.getIdFromUuid(replicationRingId));
        LOG.debug((Object)"Query volume replication ring detail.request str=%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        LOG.debug((Object)"Query volume replication ring detail.response str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Failed to query volume replication ring detail.response string is empty.request str=%s", new Object[]{newUrlStr});
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            LOG.error((Object)("Failed to query volume replication ring detail.jsonNode string is empty or missing.request str=" + newUrlStr + ", response str=" + respStr));
            return null;
        }
        if (jsonNode.path("dr_star").isMissingNode()) {
            LOG.error((Object)("Failed to query volume replication ring detail.bad Request getReplicationRing.request str=" + newUrlStr + ", response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        return JsonUtil.jsonToBean(jsonNode.path("dr_star").toString(), VhaCsdrRingInfo.class);
    }

    @Override
    public VolumeReplicationCgInfo queryRealtimeVolumeReplicationCG(String regionUuid, String tokenId, String projUuid, String replicationCgId, int ... retryParams) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            LOG.error((Object)"Failed to query realtime volumeReplicationCG.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_QUERY_VOLREPCG_REAL.getUri(), projId, OpenStackCommonUtil.getIdFromUuid(replicationCgId));
        LOG.debug((Object)"Query realtime volumeReplicationCG.request str=%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendGetRequest(newUrlStr, null, tokenId, retryParams);
        LOG.debug((Object)"Query realtime volumeReplicationCG.response str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Failed to query realtime volumeReplicationCG.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            return null;
        }
        if (jsonNode.path("replicationcg").isMissingNode()) {
            LOG.error((Object)("Failed to query realtime volumeReplicationCG.bad Request queryRealtimeVolumeReplicationCG.request str=" + newUrlStr + ", response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        return JsonUtil.jsonToBean(jsonNode.path("replicationcg").toString(), VolumeReplicationCgInfo.class);
    }

    @Override
    public AsyncTaskResponse createVolumeReplicationCG(VolReplicaCgCreateInfo createRepCgInfo, String regionUuid, String tokenId, String projUuid) {
        List<VolumeReplicationInfo> replicationInfos;
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)createRepCgInfo)) {
            LOG.error((Object)"Parameter is empty, regionUuid:%s, projUuid:%s, createRepCgInfo:%s,protectGroup name:%s", new Object[]{regionUuid, projUuid, createRepCgInfo, createRepCgInfo.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_CREATE_VOLREPCG.getUri(), projId);
        String tempStr = JsonUtil.beanToJson(createRepCgInfo);
        JSONObject requestJson = new JSONObject();
        requestJson.put((Object)"replicationcg", (Object)tempStr);
        LOG.debug((Object)"Create replicationcg request str=%s,protectGroup name=%s", new Object[]{tempStr, createRepCgInfo.getName()});
        String respStr = this.getRespStr(createRepCgInfo, tokenId, newUrlStr, tempStr, requestJson);
        AsyncTaskResponse response = new AsyncTaskResponse();
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || jsonNode.path("replicationcg").isMissingNode()) {
            LOG.error((Object)("Create replicationcg failed.bad Request createVolumeReplicationCG, createRepCgInfo:" + createRepCgInfo + ", request str=" + tempStr + " request str=" + tempStr + ",protectGroup name=" + createRepCgInfo.getName()));
            throw new LegoCheckedException(1073948407L);
        }
        HashSet<String> addReplications = new HashSet<String>(OpenStackCommonUtil.getListFromStr(createRepCgInfo.getReplications(), ","));
        LOG.info((Object)"AddReplications: %s", new Object[]{addReplications});
        VolumeReplicationCgInfo info = JsonUtil.jsonToBean(jsonNode.path("replicationcg").toString(), VolumeReplicationCgInfo.class);
        if (null == info) {
            LOG.error((Object)("Create replicationcg failed.convert to VolumeReplicationCgInfo return null, response str=" + respStr + " request str=" + tempStr + ",protectGroup name=" + createRepCgInfo.getName()));
            throw new LegoCheckedException(0x300001L);
        }
        if (OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(info.getStatus()) && this.checkReplicationInCG(replicationInfos = this.getRepsByRepCgId(info.getId(), regionUuid, tokenId, projUuid), addReplications, null)) {
            LOG.info((Object)"Create replicationcg success.Added replications is ReplicationCG, queryed replicationInfos=%s,added Replications:%s,protectGroup name=%s", new Object[]{replicationInfos, addReplications, createRepCgInfo.getName()});
            response.setSuccess(true);
            response.setTaskResult(info);
            return response;
        }
        return this.checkCreateVolReplicationCGResponse(regionUuid, tokenId, projUuid, info, addReplications);
    }

    private String getRespStr(VolReplicaCgCreateInfo createRepCgInfo, String tokenId, String newUrlStr, String tempStr, JSONObject requestJson) {
        String respStr = ClientUtil.sendPostRequest(newUrlStr, requestJson.toString(), tokenId);
        LOG.debug((Object)"Create replicationcg response str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Create replicationcg failed.response string is empty. createRepCgInfo=%s, request str=%s,protectGroup name=%s", new Object[]{createRepCgInfo, tempStr, createRepCgInfo.getName()});
            throw new LegoCheckedException(1073948407L);
        }
        return respStr;
    }

    public AsyncTaskResponse createVolumeReplicationRing(CreateVhaCsdrRingInfo createRepRingInfo, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)createRepRingInfo)) {
            LOG.error((Object)("Create volume replication ring.parameter is empty, protectGroup name=" + createRepRingInfo.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_CREATE_RING_ACTION.getUri(), projId);
        LOG.debug((Object)"Create volume replication ring.request str=%s, protectGroup name=%s", new Object[]{newUrlStr, createRepRingInfo.getName()});
        String tempStr = JsonUtil.beanToJson(createRepRingInfo);
        JSONObject requestJson = new JSONObject();
        requestJson.put((Object)"dr_star", (Object)tempStr);
        String respStr = ClientUtil.sendPostRequest(newUrlStr, requestJson.toString(), tokenId);
        LOG.debug((Object)"Create volume replication ring.reponse str=%s, protectGroup name=%s", new Object[]{respStr, createRepRingInfo.getName()});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Create volume replication ring failed.response string is empty.reponse str=" + respStr + ", protectGroup name=" + createRepRingInfo.getName() + ", request str=" + newUrlStr));
            throw new LegoCheckedException(1073948140L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || jsonNode.path("dr_star").isMissingNode()) {
            LOG.error((Object)("Create volume replication ring failed.bad Request createVolumeReplicationRing :" + createRepRingInfo + "reponse str=" + respStr + ", protectGroup name=" + createRepRingInfo.getName() + ", request str=" + newUrlStr));
            throw new LegoCheckedException(1073948140L);
        }
        List<String> addReplicationCGList = OpenStackCommonUtil.getListFromStr(createRepRingInfo.getReplicationcgs(), ",");
        HashSet<String> addReplicationUUIDCGs = new HashSet<String>();
        for (String cgID : addReplicationCGList) {
            addReplicationUUIDCGs.add(OpenStackCommonUtil.getIdFromUuid(cgID));
        }
        LOG.debug((Object)"AddReplicationUUIDCGs:%s,protectGroup name=%s", new Object[]{addReplicationUUIDCGs, createRepRingInfo.getName()});
        VhaCsdrRingInfo info = JsonUtil.jsonToBean(jsonNode.path("dr_star").toString(), VhaCsdrRingInfo.class);
        if (null == info) {
            LOG.error((Object)("Create volume replication ring failed.convert to VhaCsdrRingInfo return null, str=" + jsonNode.path("replicationcg").toString() + ",protectGroup name=" + createRepRingInfo.getName()));
            throw new LegoCheckedException(0x300001L);
        }
        return this.checkCreateVolReplicationRingResponse(regionUuid, tokenId, projUuid, info, addReplicationUUIDCGs);
    }

    @Override
    public AsyncTaskResponse updateVolumeReplicationCG(VolReplicaCgUpdateInfo updateRepCgInfo, String replicationCgId, String regionUuid, String tokenId, String projUuid) {
        List<VolumeReplicationInfo> replicationInfos;
        if (VerifyUtil.isEmpty((String)replicationCgId) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)updateRepCgInfo)) {
            LOG.error((Object)"Update volume replication CG failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String newUrlStr = this.getNewUrlStr(replicationCgId, regionUuid, projUuid);
        String tempStr = JsonUtil.beanToJson(updateRepCgInfo);
        String respStr = this.getRespStr(replicationCgId, tokenId, newUrlStr, tempStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            LOG.error((Object)("Update volume replication CG failed.request url=" + newUrlStr + ", request stringBody=" + tempStr + ", response stringBody=" + respStr + ", cgid=" + replicationCgId));
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        if (jsonNode.path("replicationcg").isMissingNode()) {
            this.resetResponse(replicationCgId, newUrlStr, tempStr, respStr, response);
            return response;
        }
        HashSet<String> addReplications = new HashSet<String>(OpenStackCommonUtil.getListFromStr(updateRepCgInfo.getAddReplicas(), ","));
        HashSet<String> removeReplications = new HashSet<String>(OpenStackCommonUtil.getListFromStr(updateRepCgInfo.getRemoveReplicas(), ","));
        VolumeReplicationCgInfo info = JsonUtil.jsonToBean(jsonNode.path("replicationcg").toString(), VolumeReplicationCgInfo.class);
        if (null == info) {
            LOG.error((Object)("Update volume replication CG failed.convert to VolumeReplicationCgInfo return null.request url=" + newUrlStr + ", request stringBody=" + tempStr + ", response stringBody=" + respStr + ", cgid=" + replicationCgId));
            throw new LegoCheckedException(0x300001L);
        }
        if (OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(info.getStatus()) && this.checkReplicationInCG(replicationInfos = this.getRepsByRepCgId(info.getId(), regionUuid, tokenId, projUuid), addReplications, removeReplications)) {
            LOG.info((Object)"Update volume replication CG succeed.cgid=%s", new Object[]{info.getId()});
            response.setSuccess(true);
            response.setTaskResult(info.getId());
            return response;
        }
        return this.checkUpdateVolReplicationCGResponse(regionUuid, tokenId, projUuid, info.getId(), addReplications, removeReplications);
    }

    private String getNewUrlStr(String replicationCgId, String regionUuid, String projUuid) {
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        return baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_UPDATE_VOLREPCG.getUri(), projId, replicationCgId);
    }

    private void resetResponse(String replicationCgId, String newUrlStr, String tempStr, String respStr, AsyncTaskResponse response) {
        LOG.error((Object)("Update volume replication CG failed.bad Request updateVolumeReplicationCG.request url=" + newUrlStr + ", request stringBody=" + tempStr + ", response stringBody=" + respStr + ", cgid=" + replicationCgId));
        response.setSuccess(false);
        response.setErrorCode("3145729");
    }

    private String getRespStr(String replicationCgId, String tokenId, String newUrlStr, String tempStr) {
        JSONObject requestJson = new JSONObject();
        requestJson.put((Object)"replicationcg", (Object)tempStr);
        LOG.debug((Object)"Update volume replication CG .request url=%s,cgid=%s", new Object[]{newUrlStr, replicationCgId});
        LOG.debug((Object)"Update volume replication CG .request stringBody=%s,cgid=%s", new Object[]{tempStr, replicationCgId});
        String respStr = ClientUtil.sendPutRequest(newUrlStr, requestJson.toString(), tokenId);
        LOG.debug((Object)"Update volume replication CG .response stringBody=%s,cgid=%s", new Object[]{respStr, replicationCgId});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Update volume replication CG failed.response string is empty.request url=" + newUrlStr + ",cgid=" + replicationCgId));
            throw new LegoCheckedException(0x300001L);
        }
        return respStr;
    }

    @Override
    public AsyncTaskResponse updateReplicationCGBandwidth(DmEnumDefine.SpeedLevelE speed, String replicationCgId, String regionUuid, String tokenId, String projUuid) {
        String message;
        if (VerifyUtil.isEmpty((String)replicationCgId) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_UPDATE_VOLREPCG.getUri(), projId, replicationCgId);
        String respStr = ClientUtil.sendPutRequest(newUrlStr, message = "{\"replicationcg\":{\"replication_bandwidth\":" + speed.getValue() + "}}", tokenId);
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        if (jsonNode.path("replicationcg").isMissingNode()) {
            LOG.error((Object)("Bad Request updateVolumeReplicationCG :" + respStr));
            response.setSuccess(false);
            response.setErrorCode("3145729");
            return response;
        }
        VolumeReplicationCgInfo info = JsonUtil.jsonToBean(jsonNode.path("replicationcg").toString(), VolumeReplicationCgInfo.class);
        if (null == info) {
            LOG.error((Object)"Response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        if (OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(info.getStatus()) && speed.getValue() == info.getReplicaBandwidth()) {
            response.setSuccess(true);
            response.setTaskResult(info.getId());
            return response;
        }
        return this.checkUpdateCGBandwidthResponse(regionUuid, tokenId, projUuid, info.getId(), speed.getValue());
    }

    private AsyncTaskResponse checkUpdateCGBandwidthResponse(final String regionUuid, final String tokenId, final String projUuid, final String replicationCgId, final int speed) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(replicationCgId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationCgInfo cg = DrExtendManager.this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationCgId);
                if (null == cg) {
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(cg.getStatus())) {
                    if (speed == cg.getReplicaBandwidth()) {
                        response.setSuccess(true);
                        response.setTaskResult(replicationCgId);
                        return true;
                    }
                } else if (!OpenstackEnumDefine.ReplicationStatusE.UPDATING.getValue().equals(cg.getStatus())) {
                    LOG.error((Object)("Cg status is not excepted, excepted status: available, current status : " + cg.getStatus() + ", cg id: " + replicationCgId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public AsyncTaskResponse updateReplicationCGRecoverStrategy(OpenstackEnumDefine.RecoverStrategy recoverStrategy, String replicationCgId, String regionUuid, String tokenId, String projUuid) {
        this.checkParams(recoverStrategy, replicationCgId, regionUuid, tokenId, projUuid);
        replicationCgId = OpenStackCommonUtil.getIdFromUuid(replicationCgId);
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_UPDATE_VOLREPCG.getUri(), projId, replicationCgId);
        AsyncTaskResponse response = new AsyncTaskResponse();
        VolumeReplicationCgInfo currentCg = this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationCgId);
        if (this.checkRecoverStrategy(currentCg, recoverStrategy)) {
            response.setSuccess(true);
            response.setTaskResult(currentCg.getId());
            return response;
        }
        String message = "{\"replicationcg\":{\"recover_strategy\":\"" + recoverStrategy.getUpdateVal() + "\"}}";
        String respStr = ClientUtil.sendPutRequest(newUrlStr, message, tokenId);
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        if (jsonNode.path("replicationcg").isMissingNode()) {
            LOG.error((Object)("Bad Request updateVolumeReplicationCG :" + respStr));
            response.setSuccess(false);
            response.setErrorCode("3145729");
            return response;
        }
        VolumeReplicationCgInfo info = JsonUtil.jsonToBean(jsonNode.path("replicationcg").toString(), VolumeReplicationCgInfo.class);
        if (null == info) {
            LOG.error((Object)"Response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        if (OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(info.getStatus()) && this.checkRecoverStrategy(info, recoverStrategy)) {
            response.setSuccess(true);
            response.setTaskResult(info.getId());
            return response;
        }
        return this.checkUpdateCGRecoverStrategyResponse(regionUuid, tokenId, projUuid, info.getId(), recoverStrategy);
    }

    private void checkParams(OpenstackEnumDefine.RecoverStrategy recoverStrategy, String replicationCgId, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((Object)recoverStrategy)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)replicationCgId) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private AsyncTaskResponse checkUpdateCGRecoverStrategyResponse(final String regionUuid, final String tokenId, final String projUuid, final String replicationCgId, final OpenstackEnumDefine.RecoverStrategy recoverStrategy) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(replicationCgId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationCgInfo cg = DrExtendManager.this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationCgId);
                if (null == cg) {
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(cg.getStatus())) {
                    if (DrExtendManager.this.checkRecoverStrategy(cg, recoverStrategy)) {
                        response.setSuccess(true);
                        response.setTaskResult(replicationCgId);
                        return true;
                    }
                } else if (!OpenstackEnumDefine.ReplicationStatusE.UPDATING.getValue().equals(cg.getStatus())) {
                    LOG.error((Object)("Cg status is not excepted, excepted status: available, current status : " + cg.getStatus() + ", cg id: " + replicationCgId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private boolean checkRecoverStrategy(VolumeReplicationCgInfo cg, OpenstackEnumDefine.RecoverStrategy recoverStrategy) {
        JSONObject jSONObject;
        String replicationExtendedStatus = cg.getReplicationExtendedStatus();
        if (!VerifyUtil.isEmpty((String)replicationExtendedStatus) && (jSONObject = JSONObject.fromObject((Object)replicationExtendedStatus)).containsKey((Object)"recover_strategy")) {
            String strategy = jSONObject.getString("recover_strategy");
            if (recoverStrategy.getQueryVal().equals(strategy)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public AsyncTaskResponse deleteVolumeReplicationCG(String regionUuid, String tokenId, String projUuid, String replicationCgId, boolean isForce, boolean isSingleDel) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            LOG.error((Object)"Failed to delete volumeReplicationCG.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String message = this.getDelMessageBody(true, isForce, isSingleDel);
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_DELETE_VOLREPCG.getUri(), projId, replicationCgId);
        LOG.debug((Object)"Delete volumeReplicationCG.request str=%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, message, tokenId);
        LOG.debug((Object)"Delete volumeReplicationCG.reponse str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeleteVolReplicationCGResponse(regionUuid, tokenId, projUuid, replicationCgId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        LOG.error((Object)("Faild to delete volumeReplicationCG.bad Request deleteVolumeReplicationCG: " + replicationCgId + "request str=" + newUrlStr + ", reponse str=" + respStr));
        response.setErrorCode("3145729");
        return response;
    }

    private String getDelMessageBody(boolean isCg, boolean isForce, boolean isSingleDel) {
        JSONObject ret = new JSONObject();
        JSONObject bodyJson = new JSONObject();
        bodyJson.put((Object)"force", (Object)Boolean.toString(isForce));
        bodyJson.put((Object)"single_delete", (Object)Boolean.toString(isSingleDel));
        String key = "replicationcg";
        if (!isCg) {
            key = "replication";
        }
        ret.put((Object)key, (Object)bodyJson);
        return ret.toString();
    }

    @Override
    public AsyncTaskResponse syncVolumeReplicationCG(String regionUuid, String tokenId, String projUuid, String replicationCgId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            LOG.error((Object)"Failed to sync volumeReplicationCG.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String newReplicationCgId = OpenStackCommonUtil.getIdFromUuid(replicationCgId);
        VolumeReplicationCgInfo cg = this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, newReplicationCgId);
        if (null == cg) {
            LOG.error((Object)("Failed to sync volumeReplicationCG.cg is empty.cgid=" + replicationCgId));
            throw new LegoCheckedException(2117645L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(cg.getReplicationStatus())) {
            response.setSuccess(true);
            return response;
        }
        this.checkReplicationStatus(replicationCgId, newReplicationCgId, cg);
        String message = "{\"os-sync-replicationcg\":{}}";
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_VOLREPCG_ACTION.getUri(), projId, newReplicationCgId);
        LOG.debug((Object)"Sync volumeReplicationCG.request str=%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        LOG.debug((Object)"Sync volumeReplicationCG.response str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            response.setSuccess(true);
            return response;
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        response.setSuccess(false);
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.error((Object)("Failed to sync volumeReplicationCG.itemNotFound :replicationCgId=" + replicationCgId));
            response.setErrorCode("2117645");
            return response;
        }
        LOG.error((Object)("Failed to sync volumeReplicationCG.bad Request SyncVolumeReplicationCG :replicationCgId=" + replicationCgId + ", request str=" + newUrlStr + ", response str=" + respStr));
        response.setErrorCode("3145729");
        return response;
    }

    private void checkReplicationStatus(String replicationCgId, String newReplicationCgId, VolumeReplicationCgInfo cg) {
        if (!OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(cg.getStatus()) || !OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue().equals(cg.getReplicationStatus()) && !OpenstackEnumDefine.ReplicationRepStatusE.ACTIVESTOPPED.getValue().equals(cg.getReplicationStatus()) && !OpenstackEnumDefine.ReplicationRepStatusE.INACTIVE.getValue().equals(cg.getReplicationStatus())) {
            LOG.error((Object)("Failed to sync volumeReplicationCG.cgid=" + replicationCgId + ",cg status is=" + cg.getStatus() + ",not avaiable. or cg replicationStatus is " + cg.getReplicationStatus() + ", not active or inactive or activestopped status."));
            if ("hypermetro".equals(cg.getReplicaModel())) {
                throw new LegoCheckedException(1073949707L, new String[]{newReplicationCgId});
            }
            throw new LegoCheckedException(1073949708L, new String[]{newReplicationCgId});
        }
    }

    @Override
    public AsyncTaskResponse splitVolumeReplicationCG(String regionUuid, String tokenId, String projUuid, String replicationCgId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            LOG.error((Object)"Failed to split volumeReplicationCG.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String message = "{\"os-failover-replicationcg\":{}}";
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_VOLREPCG_ACTION.getUri(), projId, replicationCgId);
        LOG.debug((Object)"Split volumeReplicationCG.request str=%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        LOG.debug((Object)"Split volumeReplicationCG.response str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkSplitVolReplicationCGResponse(regionUuid, tokenId, projUuid, replicationCgId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.error((Object)("Failed to split volumeReplicationCG.itemNotFound :" + replicationCgId + ", request str=" + newUrlStr));
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        return this.checkSplitVolReplicationCGResponse(regionUuid, tokenId, projUuid, replicationCgId);
    }

    @Override
    public AsyncTaskResponse splitRingVolumeReplicationCG(String regionUuid, String tokenId, String projUuid, String replicationCgId, String ringeID, String readWritePolicy) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            LOG.error((Object)"Failed to split ring volumeReplicationCG.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String message = this.getSplitRingMessageBody(replicationCgId, readWritePolicy);
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_VOLREPCG_RING_ACTION.getUri(), projId, ringeID);
        LOG.debug((Object)"Split ring volumeReplicationCG.request str=%s, message body=%s", new Object[]{newUrlStr, message});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        LOG.debug((Object)"Split ring volumeReplicationCG.respStr str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkSplitVolReplicationCGResponse(regionUuid, tokenId, projUuid, replicationCgId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.error((Object)("Failed to split ring volumeReplicationCG.itemNotFound :" + replicationCgId + ", request str=" + newUrlStr));
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        return this.checkSplitVolReplicationCGResponse(regionUuid, tokenId, projUuid, replicationCgId);
    }

    private String getSplitRingMessageBody(String replicationCgId, String readWritePolicy) {
        JSONObject ret = new JSONObject();
        JSONObject bodyJson = new JSONObject();
        bodyJson.put((Object)"replicationcg_id", (Object)replicationCgId);
        bodyJson.put((Object)"read_write_policy", (Object)readWritePolicy);
        String key = "os-failover-star";
        ret.put((Object)key, (Object)bodyJson);
        return ret.toString();
    }

    @Override
    public List<OpenStackStorageResourcePool> getStoragePoolInfo(String regionUuid, String tokenId, String projUuid, boolean queryDetail) {
        String respStr;
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_LIST_STORAGEPOOLS.getUri(), projId);
        if (queryDetail) {
            uriVariables.put("detail", "true");
        }
        if (VerifyUtil.isEmpty((String)(respStr = ClientUtil.sendGetRequest(newUrlStr, uriVariables, tokenId, new int[0])))) {
            LOG.error((Object)("Failed to get storage pool info.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"pools")) {
            LOG.error((Object)("Failed to get storage pool info.bad Request getStoragePoolInfo.request str=" + newUrlStr + ",response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        List<StoragePoolInfo> poolInfoList = this.getPoolBeanFromJson(json);
        ArrayList<OpenStackStorageResourcePool> openstackPoolList = new ArrayList<OpenStackStorageResourcePool>();
        for (StoragePoolInfo pool : poolInfoList) {
            OpenStackStorageResourcePool resPool = new OpenStackStorageResourcePool(pool);
            int hashcode = OpenStackCommonUtil.generateHashCode(regionUuid, projUuid, pool.getName());
            resPool.setUuid(openstackUuid + ":" + hashcode);
            resPool.setRegionUuid(regionUuid);
            resPool.setProjectUuid(projUuid);
            openstackPoolList.add(resPool);
        }
        return openstackPoolList;
    }

    private List<StoragePoolInfo> getPoolBeanFromJson(JSONObject json) {
        ArrayList<StoragePoolInfo> poolList = new ArrayList<StoragePoolInfo>();
        JSONArray poolArray = JSONArray.fromObject((Object)json.get("pools"));
        int zize = poolArray.size();
        for (int i = 0; i < zize; ++i) {
            JSONObject poolJson = poolArray.getJSONObject(i);
            StoragePoolInfo pool = (StoragePoolInfo)JSONObject.toBean((JSONObject)poolJson, StoragePoolInfo.class);
            poolList.add(pool);
        }
        return poolList;
    }

    @Override
    public List<VolumeReplicationInfo> getRepsByRepCgId(String replicationCgId, String regionUuid, String tokenId, String projUuid) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("replicationcg_id", replicationCgId);
        return this.getVolumeReplications(regionUuid, tokenId, projUuid, uriVariables, true);
    }

    private AsyncTaskResponse checkDeleteVolReplicationCGResponse(final String regionUuid, final String tokenId, final String projUuid, final String replicationCgId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponseTimeout(replicationCgId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationCgInfo cg = DrExtendManager.this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationCgId);
                if (null == cg) {
                    response.setSuccess(true);
                    return true;
                }
                if (!REPLICATION_CAN_DELETE_STATUS.contains(cg.getStatus())) {
                    LOG.error((Object)("Cg status is not excepted, excepted status: deleting or avaiable or error_deleting or error, current status : " + cg.getStatus() + ", cg id: " + replicationCgId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkCreateVolReplicationResponse(final String regionUuid, final String tokenId, final String projUuid, final VolumeReplicationInfo info) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(info, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationInfo replication = DrExtendManager.this.queryVolumeReplication(regionUuid, tokenId, projUuid, info.getId());
                if (null == replication) {
                    LOG.error((Object)("Failed to check create volReplication.replication is null.replicationID=" + info.getId()));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(replication.getStatus())) {
                    response.setSuccess(true);
                    response.setTaskResult(replication);
                    return true;
                }
                if (!OpenstackEnumDefine.ReplicationStatusE.CREATING.getValue().equals(replication.getStatus())) {
                    LOG.error((Object)("Replication status is not excepted, excepted status: available, current status : " + replication.getStatus() + ", replication id: " + info.getId()));
                    response.setSuccess(false);
                    response.setTaskResult(replication);
                    response.setErrorCode("1073948407");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkCreateVolReplicationCGResponse(final String regionUuid, final String tokenId, final String projUuid, final VolumeReplicationCgInfo replicationCg, final Set<String> replicationSet) {
        Long inputRetryTimes = null;
        if (!VerifyUtil.isEmpty(replicationSet)) {
            inputRetryTimes = 60000L * (long)replicationSet.size() / 10000L;
            LOG.debug((Object)"CheckCreateVolReplicationCGResponse inputRetryTimes:%s", new Object[]{String.valueOf(inputRetryTimes)});
        }
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponseTimeout(replicationCg, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                LOG.info((Object)"Start query VolumeReplicationCG,cg id=%s, protectGroup name=%s", new Object[]{replicationCg.getId(), replicationCg.getName()});
                VolumeReplicationCgInfo cg = DrExtendManager.this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationCg.getId());
                if (null == cg) {
                    LOG.error((Object)("Query VolumeReplicationCG failed,cg is null, cg id=" + replicationCg.getId() + "protectGroup name=" + replicationCg.getName()));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(cg.getStatus())) {
                    List<VolumeReplicationInfo> replicationInfos = DrExtendManager.this.getRepsByRepCgId(replicationCg.getId(), regionUuid, tokenId, projUuid);
                    if (DrExtendManager.this.checkReplicationInCG(replicationInfos, replicationSet, null)) {
                        LOG.info((Object)"Query VolumeReplicationCG success.Added replication is in ReplicationCG.cg id=%s,Query replicationInfos=%s,add replicationids=%s,protectGroup name=%s", new Object[]{replicationCg.getId(), replicationInfos, replicationSet.toString(), replicationCg.getName()});
                        response.setSuccess(true);
                        response.setTaskResult(cg);
                        return true;
                    }
                } else if (!OpenstackEnumDefine.ReplicationStatusE.CREATING.getValue().equals(cg.getStatus())) {
                    LOG.error((Object)("Query VolumeReplicationCG failed.cg status is not excepted, excepted status: available, current status : " + cg.getStatus() + ", cg id: " + replicationCg.getId() + "protectGroup name=" + replicationCg.getName()));
                    response.setSuccess(false);
                    response.setTaskResult(replicationCg);
                    response.setErrorCode("1073948407");
                    return true;
                }
                LOG.debug((Object)"Queryed VolumeReplicationCG,cg id=%s, cg info=%s, protectGroup name=%s", new Object[]{replicationCg.getId(), cg, replicationCg.getName()});
                return false;
            }
        }, inputRetryTimes);
        return response;
    }

    private AsyncTaskResponse checkCreateVolReplicationRingResponse(final String regionUuid, final String tokenId, final String projUuid, final VhaCsdrRingInfo replicationRing, final Set<String> replicationSet) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponseTimeout(replicationRing, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VhaCsdrRingInfo ringInfo = DrExtendManager.this.queryVolumeReplicationRing(regionUuid, tokenId, projUuid, replicationRing.getId());
                if (null == ringInfo) {
                    LOG.error((Object)("Check create replication ring failed. ringinfo is null,protectGroup name=" + replicationRing.getName()));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(ringInfo.getStatus())) {
                    if (DrExtendManager.this.checkReplicationCGInRing(ringInfo, replicationSet, null)) {
                        LOG.info((Object)"Check create replication ring succeed,protectGroup name=%s, ringID=%s", new Object[]{replicationRing.getName(), ringInfo.getId()});
                        response.setSuccess(true);
                        response.setTaskResult(ringInfo);
                        return true;
                    }
                    LOG.error((Object)("Check create replication ring failed.ring status is created, cg id of ring is expected. expeteced CG ID is" + replicationSet.toString() + ", cg id of current created ring is " + ringInfo.getReplicationcgLists().toString() + ", protectGroup name=" + replicationRing.getName() + ", ring id: " + ringInfo.getId()));
                    response.setSuccess(false);
                    response.setTaskResult(ringInfo);
                    response.setErrorCode("1073948140");
                    return true;
                }
                if (!OpenstackEnumDefine.ReplicationStatusE.CREATING.getValue().equals(ringInfo.getStatus())) {
                    LOG.error((Object)("Check create replication ring failed.ring status is not excepted, excepted status: available, current status : " + ringInfo.getStatus() + ", ring id: " + ringInfo.getId() + ", protectGroup name=" + replicationRing.getName()));
                    response.setSuccess(false);
                    response.setTaskResult(ringInfo);
                    response.setErrorCode("1073948140");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkUpdateVolReplicationCGResponse(final String regionUuid, final String tokenId, final String projUuid, final String replicationCgId, final Set<String> addReplications, final Set<String> removeReplications) {
        Long inputRetryTimes = null;
        int pairSize = this.getPairSize(addReplications, removeReplications);
        if (pairSize > 0) {
            inputRetryTimes = 60000L * (long)pairSize / 10000L;
            LOG.debug((Object)"CheckUpdateVolReplicationCGResponse inputRetryTimes:%s", new Object[]{String.valueOf(inputRetryTimes)});
        }
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponseTimeout(replicationCgId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationCgInfo cg = DrExtendManager.this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationCgId);
                if (null == cg) {
                    LOG.info((Object)"Check update volume replicationCG response,cg is null,cg id: %s", new Object[]{replicationCgId});
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(cg.getStatus())) {
                    List<VolumeReplicationInfo> replicationInfos = DrExtendManager.this.getRepsByRepCgId(replicationCgId, regionUuid, tokenId, projUuid);
                    if (DrExtendManager.this.checkReplicationInCG(replicationInfos, addReplications, removeReplications)) {
                        LOG.info((Object)"Check update volume replicationCG response succeed,cg id: %s", new Object[]{replicationCgId});
                        response.setSuccess(true);
                        response.setTaskResult(replicationCgId);
                        return true;
                    }
                } else if (!OpenstackEnumDefine.ReplicationStatusE.UPDATING.getValue().equals(cg.getStatus())) {
                    LOG.error((Object)("Check update volume replicationCG response failed.cg status is not excepted, excepted status: available, current status : " + cg.getStatus() + ", cg id: " + replicationCgId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                LOG.debug((Object)"Check update volume replicationCG response,cg id: %s,cginfo=%s", new Object[]{replicationCgId, cg});
                return false;
            }
        }, inputRetryTimes);
        return response;
    }

    private int getPairSize(Set<String> addReplications, Set<String> removeReplications) {
        int pairSize = 0;
        if (!VerifyUtil.isEmpty(addReplications)) {
            pairSize += addReplications.size();
        }
        if (!VerifyUtil.isEmpty(removeReplications)) {
            pairSize += removeReplications.size();
        }
        return pairSize;
    }

    private AsyncTaskResponse checkDeleteVolReplicationResponse(final String regionUuid, final String tokenId, final String projUuid, final String replicationId, final boolean isSingleDel) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(replicationId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationInfo replication = DrExtendManager.this.queryVolumeReplication(regionUuid, tokenId, projUuid, replicationId);
                if (null == replication) {
                    LOG.error((Object)("Check delete volume replication response success.repliation id: " + replicationId));
                    response.setSuccess(true);
                    return true;
                }
                if (!isSingleDel && !REPLICATION_CAN_DELETE_STATUS.contains(replication.getStatus())) {
                    LOG.error((Object)("Normal delete pair : repliation status is not excepted, excepted status: deleting or avaiable or error_deleting or error, current status : " + replication.getStatus() + ", repliation id: " + replicationId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                if (isSingleDel && !NORMAL_REPLICATION_CAN_DELETE_STATUS.contains(replication.getStatus())) {
                    LOG.error((Object)("Single delete pair : repliation status is not excepted, excepted status: deleting or avaiablecurrent status : " + replication.getStatus() + ", repliation id: " + replicationId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private boolean checkReplicationInCG(List<VolumeReplicationInfo> replicationInfos, Set<String> addReplications, Set<String> removeReplications) {
        if (null == replicationInfos) {
            LOG.error((Object)"CheckReplicationInCG failed. replicationInfos is null");
            return false;
        }
        LOG.debug((Object)"Start checkReplicationInCG, addReplications=%s, removeReplications=%s,query replicationInfos=%s", new Object[]{addReplications.toString(), removeReplications != null ? removeReplications.toString() : "", replicationInfos.toString()});
        HashSet<String> replicationIdSet = new HashSet<String>();
        for (VolumeReplicationInfo info : replicationInfos) {
            if (VerifyUtil.isEmpty((String)info.getId())) {
                LOG.error((Object)("VolumeReplicationInfo id is null. volumeReplicationInfo =" + info));
                continue;
            }
            replicationIdSet.add(info.getId());
        }
        LOG.debug((Object)String.format(Locale.ROOT, "AddReplications size =%s query return:%s", addReplications.size(), replicationIdSet));
        if (!VerifyUtil.isEmpty(addReplications) && !replicationIdSet.containsAll(addReplications)) {
            LOG.error((Object)"AddReplications size is not equal to query size");
            return false;
        }
        if (!VerifyUtil.isEmpty(removeReplications)) {
            for (String replicationId : removeReplications) {
                if (!replicationIdSet.contains(replicationId)) continue;
                LOG.error((Object)("replicationId can not be removed from cg,replicationId=" + replicationId));
                return false;
            }
        }
        return true;
    }

    private boolean checkReplicationCGInRing(VhaCsdrRingInfo ringInfo, Set<String> addReplications, Set<String> removeReplications) {
        if (null == ringInfo) {
            LOG.error((Object)"RingInfo is null");
            return false;
        }
        HashSet<String> replicationCGIdSet = new HashSet<String>();
        for (VolumeReplicationCgInfo info : ringInfo.getReplicationcgLists()) {
            if (VerifyUtil.isEmpty((String)info.getId())) continue;
            replicationCGIdSet.add(info.getId());
        }
        LOG.debug((Object)"AddReplications size=%s, query return:%s, protectGroup name=%s", new Object[]{String.valueOf(addReplications.size()), replicationCGIdSet, ringInfo.getName()});
        if (!VerifyUtil.isEmpty(addReplications) && !replicationCGIdSet.containsAll(addReplications)) {
            LOG.error((Object)("Added cgs:" + addReplications + "not in ring" + replicationCGIdSet + ", protectGroup name=" + ringInfo.getName()));
            return false;
        }
        if (!VerifyUtil.isEmpty(removeReplications)) {
            for (String replicationId : removeReplications) {
                if (!replicationCGIdSet.contains(replicationId)) continue;
                LOG.error((Object)("Removed cgs:" + replicationId + "is in ring" + replicationCGIdSet + ", protectGroup name=" + ringInfo.getName()));
                return false;
            }
        }
        return true;
    }

    private AsyncTaskResponse checkSplitVolReplicationCGResponse(String regionUuid, String tokenId, String projUuid, String replicationCgId) {
        return AsyncTaskResponse.queryTaskResponse(replicationCgId, response -> {
            VolumeReplicationCgInfo cg = this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationCgId);
            if (null == cg) {
                LOG.error((Object)"Failed to check split volume replicationCG. Cg not found, cg id:%s", new Object[]{replicationCgId});
                response.setSuccess(false);
                response.setErrorCode("2117645");
                return true;
            }
            String status = cg.getStatus();
            if (!OpenstackEnumDefine.ReplicationStatusE.FAILOVERING.getValue().equals(status) && !OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(status)) {
                LOG.error((Object)"Failed to check split volume replicationCG. Cg status is not excepted, excepted status: failovering or available, current status:%s, cg id:%s", new Object[]{status, replicationCgId});
                response.setSuccess(false);
                response.setErrorCode("3145729");
                return true;
            }
            String replicationStatus = cg.getReplicationStatus();
            if (OpenstackEnumDefine.ReplicationStatusE.AVAILABLE.getValue().equals(status) && (OpenstackEnumDefine.ReplicationRepStatusE.ACTIVESTOPPED.getValue().equals(replicationStatus) || OpenstackEnumDefine.ReplicationRepStatusE.INACTIVE.getValue().equals(replicationStatus))) {
                String failoverRet = this.getCgFailoverRet(cg);
                if (OpenstackEnumDefine.ReplicationStatusE.FAILOVER_RET_FAILED.getValue().equals(failoverRet)) {
                    LOG.error((Object)"Failed to check split volume replicationCG. Cg Status:%s, Cg ReplicationStatus:%s, Cg FailoverRet is:%s", new Object[]{status, replicationStatus, failoverRet});
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                } else {
                    response.setSuccess(true);
                }
                return true;
            }
            LOG.debug((Object)"Failed to check split volume replicationCG. Cg ReplicationExtendedStatus status is not excepted, excepted status: split, current status:%s, cg id:%s", new Object[]{replicationStatus, replicationCgId});
            return false;
        });
    }

    private String getCgFailoverRet(VolumeReplicationCgInfo cg) {
        String driverDataStr = cg.getReplicationDriverData();
        if (!VerifyUtil.isEmpty((String)driverDataStr)) {
            ReplicationDriverDataInfo driverData = JsonUtil.jsonToBean(driverDataStr, ReplicationDriverDataInfo.class);
            return driverData != null ? driverData.getFailoverRet() : "";
        }
        return "";
    }

    @Override
    public AsyncTaskResponse reverseVolumeReplicationCG(boolean replicationMaster, String replicaCgUuid, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicaCgUuid)) {
            LOG.error((Object)"Failed to reverse volume replicationCG.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String replicaCgId = OpenStackCommonUtil.getIdFromUuid(replicaCgUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_REVERSE_VOLREPCG.getUri(), projId, replicaCgId);
        String msg = "{\"os-reverse-replicationcg\":{\"replication_master\":" + replicationMaster + "}}";
        LOG.debug((Object)"Reverse volume replicationCG.request str=%s,message=%s", new Object[]{newUrlStr, msg});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, msg, tokenId);
        LOG.debug((Object)"Reverse volume replicationCG.respStr str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkReverseVolRepCg(regionUuid, tokenId, projUuid, replicaCgId, replicationMaster);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.error((Object)("Failed to reverse volume replicationCG.itemNotFound. replicaCgId:" + replicaCgId + ", request str=" + newUrlStr + ",message=" + msg + ", respStr str=" + respStr));
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        return this.checkReverseVolRepCg(regionUuid, tokenId, projUuid, replicaCgId, replicationMaster);
    }

    private AsyncTaskResponse checkReverseVolRepCg(final String regionUuid, final String tokenId, final String projUuid, final String replicaCgId, final boolean replicationMaster) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(replicaCgId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationCgInfo cg = DrExtendManager.this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicaCgId);
                if (null == cg) {
                    LOG.error((Object)("Failed to check reverse volumeReplicationCG.replicaCgId=" + replicaCgId));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (cg.isMasterFlag() == replicationMaster) {
                    response.setSuccess(true);
                    response.setTaskResult(cg);
                    return true;
                }
                LOG.error((Object)("Failed to check reverse volumeReplicationCG.cg (master)status is not excepted, excepted status: " + replicationMaster + ", current status : " + cg.isMasterFlag() + ", cg id: " + replicaCgId));
                return false;
            }
        });
        return response;
    }

    @Override
    public List<VolumeReplicationInfo> getRealtimeVolumeReplications(String regionUuid, String tokenId, String projUuid, Map<String, String> uriVariables) {
        if (VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)regionUuid)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<VolumeReplicationInfo> repInfolist = new ArrayList<VolumeReplicationInfo>();
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_LIST_VOLREPS_DETAILS_CG_REAL.getUri(), projId);
        String limit = String.valueOf(1000);
        if (VerifyUtil.isEmpty(uriVariables)) {
            uriVariables = new HashMap<String, String>();
        }
        uriVariables.put("limit", limit);
        int offset = 0;
        String respStr = null;
        while (true) {
            uriVariables.put("offset", String.valueOf(offset));
            respStr = ClientUtil.sendGetRequest(newUrlStr, uriVariables, tokenId, new int[0]);
            List<VolumeReplicationInfo> list = this.getVolumeRepliInfosFromRespStr(respStr);
            repInfolist.addAll(list);
            if (list.size() < 1000) break;
            offset += 1000;
        }
        return repInfolist;
    }

    @Override
    public AsyncTaskResponse openRing(String regionUuid, String tokenId, String projUuid, String ringID) {
        JSONObject ret = new JSONObject();
        ret.put((Object)"os-open-star", (Object)new JSONObject());
        String action = ret.toString();
        return this.sendRingAction(regionUuid, tokenId, projUuid, ringID, action);
    }

    @Override
    public AsyncTaskResponse closeRing(String regionUuid, String tokenId, String projUuid, String ringID, boolean singleClose) {
        String action = "{\"os-close-star\":{\"single_close\":" + singleClose + "}}";
        return this.sendRingAction(regionUuid, tokenId, projUuid, ringID, action);
    }

    private AsyncTaskResponse sendRingAction(String regionUuid, String tokenId, String projUuid, String ringID, String action) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)ringID)) {
            LOG.error((Object)"Parameter is empty, regionUuid:%s, projUuid:%s, ringID:%s", new Object[]{regionUuid, projUuid, ringID});
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.RING_ACTION.getUri(), projId, OpenStackCommonUtil.getIdFromUuid(ringID));
        String respStr = ClientUtil.sendPostRequest(newUrlStr, action, tokenId);
        LOG.debug((Object)"Send Ring Action(open or close ring). request str=%s,response str=%s", new Object[]{newUrlStr, respStr});
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (VerifyUtil.isEmpty((String)respStr)) {
            response.setSuccess(true);
            return response;
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        response.setSuccess(false);
        LOG.error((Object)("Send Ring Action(open or close ring) faild. request str=" + newUrlStr + ",response str=" + respStr));
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.error((Object)("Send Ring Action(open or close ring) faild.itemNotFound :" + ringID));
            response.setSuccess(false);
            response.setErrorCode("2117645");
        }
        return response;
    }

    @Override
    public AsyncTaskResponse deleteRing(String regionUuid, String tokenId, String projUuid, String ringId, boolean isForce, boolean isSingleDel) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)ringId)) {
            LOG.error((Object)"Parameter is empty, regionUuid:%s, projUuid:%s, ringID:%s", new Object[]{regionUuid, projUuid, ringId});
            throw new LegoCheckedException(1073947393L);
        }
        String message = this.getDelRingMessageBody(isForce, isSingleDel);
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_DELETE_RING.getUri(), projId, ringId);
        LOG.debug((Object)"Delete ring request str=%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, message, tokenId);
        LOG.debug((Object)"Delete ring reponse str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeleteRingResponse(regionUuid, tokenId, projUuid, ringId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        LOG.error((Object)("Failed to delete ring.bad Request deleteRing ringID: " + ringId + ", request str=" + newUrlStr + ", reponse str=" + respStr));
        response.setErrorCode("3145729");
        return response;
    }

    private String getDelRingMessageBody(boolean isForce, boolean isSingleDel) {
        JSONObject ret = new JSONObject();
        JSONObject bodyJson = new JSONObject();
        bodyJson.put((Object)"force", (Object)isForce);
        bodyJson.put((Object)"single_delete", (Object)isSingleDel);
        String key = "dr_star";
        ret.put((Object)key, (Object)bodyJson);
        return ret.toString();
    }

    private AsyncTaskResponse checkDeleteRingResponse(final String regionUuid, final String tokenId, final String projUuid, final String ringId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponseTimeout(ringId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VhaCsdrRingInfo ring = DrExtendManager.this.queryVolumeReplicationRing(regionUuid, tokenId, projUuid, ringId);
                if (null == ring) {
                    response.setSuccess(true);
                    return true;
                }
                if (!OpenstackEnumDefine.ReplicationStatusE.DELETING.getValue().equals(ring.getStatus())) {
                    LOG.error((Object)("Delete ring failed.ring status is not excepted, excepted status: deleting, current status : " + ring.getStatus() + ", ring id: " + ringId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                if (OpenstackEnumDefine.ReplicationStatusE.ERROR_DELETING.getValue().equals(ring.getStatus())) {
                    LOG.error((Object)("Delete ring failed, status : " + ring.getStatus() + ", ring id: " + ringId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public void updateReplication(String regionUuid, String tokenId, String projUuid, VolumeReplicationInfo updateRepInfo) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)updateRepInfo)) {
            LOG.error((Object)"Parameter is empty:regionUuid=%s,projUuid=%s,updateRepInfo=%s", new Object[]{regionUuid, projUuid, updateRepInfo});
            throw new LegoCheckedException(1073947393L);
        }
        String replicationId = OpenStackCommonUtil.getIdFromUuid(updateRepInfo.getId());
        String volumeId = OpenStackCommonUtil.getIdFromUuid(updateRepInfo.getVolumeId());
        if (VerifyUtil.isEmpty((String)replicationId) || VerifyUtil.isEmpty((String)volumeId)) {
            LOG.error((Object)"Parameter is empty:replicationId=%s,volumeId=%s", new Object[]{replicationId, volumeId});
            throw new LegoCheckedException(1073947393L);
        }
        VolumeReplicationInfo repInfo = this.queryVolumeReplication(regionUuid, tokenId, projUuid, replicationId);
        if (null == repInfo) {
            LOG.error((Object)"replication:%s not found", new Object[]{replicationId});
            throw new LegoCheckedException(2117645L);
        }
        if (volumeId.equals(repInfo.getVolumeId())) {
            LOG.info((Object)"replication:%s volume:%s is right", new Object[]{repInfo.getName(), repInfo.getVolumeId()});
            return;
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_QUERY_VOLREP.getUri(), projId, replicationId);
        JSONObject replicationJson = new JSONObject();
        replicationJson.put((Object)"volume_id", (Object)volumeId);
        JSONObject requestJson = new JSONObject();
        requestJson.put((Object)"replication", (Object)replicationJson);
        LOG.debug((Object)"UpdateReplicationVolId.request url=%s, body=%s", new Object[]{newUrlStr, requestJson.toString()});
        String respStr = ClientUtil.sendPutRequest(newUrlStr, requestJson.toString(), tokenId);
        LOG.debug((Object)"UpdateReplicationVolId success. reponse str=%s", new Object[]{respStr});
        repInfo = this.queryVolumeReplication(regionUuid, tokenId, projUuid, replicationId);
        if (null == repInfo) {
            LOG.error((Object)"replication:%s not found", new Object[]{replicationId});
            throw new LegoCheckedException(2117645L);
        }
        if (!volumeId.equals(repInfo.getVolumeId())) {
            LOG.error((Object)"replication:%s volume:%s is not modified", new Object[]{repInfo.getName(), repInfo.getVolumeId()});
            throw new LegoCheckedException(1073949697L, new String[]{replicationId});
        }
        LOG.info((Object)"replication:%s volume:%s is right", new Object[]{repInfo.getName(), repInfo.getVolumeId()});
    }

    @Override
    public AsyncTaskResponse reverseRing(String regionUuid, String tokenId, String projUuid, String ringID, String replicationCgId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)ringID)) {
            LOG.error((Object)"Parameter is empty:regionUuid=%s,projUuid=%s,ringID=%s", new Object[]{regionUuid, projUuid, ringID});
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.DR_DELETE_RING.getUri(), projId, ringID);
        LOG.debug((Object)"Reverse ring.request str=%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendPutRequest(newUrlStr, null, tokenId);
        LOG.debug((Object)"Reverse ring.respStr str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkReverseRingResponse(regionUuid, tokenId, projUuid, ringID, replicationCgId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.error((Object)"Failed to reverse ring.itemNotFound :%s, request str:%s", new Object[]{replicationCgId, newUrlStr});
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        return this.checkReverseRingResponse(regionUuid, tokenId, projUuid, ringID, replicationCgId);
    }

    private AsyncTaskResponse checkReverseRingResponse(final String regionUuid, final String tokenId, final String projUuid, final String ringID, final String replicaCgId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(replicaCgId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationCgInfo cg = DrExtendManager.this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicaCgId);
                if (null == cg) {
                    LOG.error((Object)"Failed to check reverse ring.ringId is %s, normal replicaCgId is %s", new Object[]{ringID, replicaCgId});
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(cg.getReplicationStatus())) {
                    response.setSuccess(true);
                    response.setTaskResult(cg);
                    return true;
                }
                response.setSuccess(false);
                response.setErrorCode(String.valueOf(1073949719L));
                response.setErrorParameter(new String[]{ringID});
                LOG.error((Object)"Failed to check reverse Ring.cg (master)status is not excepted, excepted status: standby, current replication status : %s, ring id: %s, checked cg id:%s", new Object[]{cg.getReplicationStatus(), ringID, replicaCgId});
                return false;
            }
        });
        return response;
    }
}

