/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.util;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.handler.OpenStackResponseHandler;
import com.huawei.ism.drm.openstack.adapter.manager.IKeystoreManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackProject;
import com.huawei.ism.drm.openstack.sdk.model.RegionIamInfo;
import com.huawei.ism.drm.openstack.sdk.model.RegionIamResponseInfo;
import com.huawei.ism.drm.openstack.sdk.msg.AuthenticateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.DomainInfo;
import com.huawei.ism.drm.openstack.sdk.msg.IAMIdentityInfo;
import com.huawei.ism.drm.openstack.sdk.msg.IAMScopeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.IdentityInfo;
import com.huawei.ism.drm.openstack.sdk.msg.IdentityRequestInfo;
import com.huawei.ism.drm.openstack.sdk.msg.IdentityResponseInfo;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.sdk.msg.PasswordInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ProjectInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ScopeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.TokenInfo;
import com.huawei.ism.drm.openstack.sdk.msg.UserInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CloudConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hc.core5.http.Header;

public class TokenUtil {
    private static final Log LOG = LogFactory.getInstance(TokenUtil.class);
    private static final String X_SUBJECT_TOKEN_KEY = "X-Subject-Token";
    private static final long EXPIRES_MILLSECONDS = 3600000L;
    private static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'";
    private static final int RESPONSE_TIME_OUT = 60000;
    private static final int UN_AHUTH = 401;
    private static final String REGION_IAM_URI = "/rest/serviceaccess/v3.0/relations";
    private static final int RETRY_COUNT = 3;
    private static final int IAM_REQUEST_INTERVAL = 3000;
    private static TokenUtil instance = new TokenUtil();
    private Map<String, Object> uuidConnectionLock = new ConcurrentHashMap<String, Object>();
    private Map<String, TokenInfo> tokenMap = new ConcurrentHashMap<String, TokenInfo>();
    private Map<String, Map<String, Object>> regionUuidConnLock = new ConcurrentHashMap<String, Map<String, Object>>();
    private Map<String, Map<String, TokenInfo>> regionProjectTokenMap = new ConcurrentHashMap<String, Map<String, TokenInfo>>();
    private Map<String, Object> regionConnLock = new ConcurrentHashMap<String, Object>();
    private Map<String, String> regionIamMap = new ConcurrentHashMap<String, String>();

    public static TokenUtil getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToken(String projectUuid) {
        if (VerifyUtil.isEmpty((String)projectUuid)) {
            LOG.error((Object)"Param is empty.");
            return;
        }
        String projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        Object object = this.getProjectTockenLock(projectId);
        synchronized (object) {
            this.tokenMap.remove(projectId);
        }
        Set<String> regionSet = this.regionProjectTokenMap.keySet();
        regionSet.forEach(regionId -> {
            Object object = this.getRegionUuidConnLock((String)regionId, projectId);
            synchronized (object) {
                Map<String, TokenInfo> projectTkMap = this.regionProjectTokenMap.get(regionId);
                if (projectTkMap == null) {
                    return;
                }
                projectTkMap.remove(projectId);
                if (projectTkMap.isEmpty()) {
                    this.regionProjectTokenMap.remove(regionId);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTokenByTokenId(String tokenId) {
        if (VerifyUtil.isEmpty((String)tokenId)) {
            LOG.error((Object)"Param is empty.");
            return;
        }
        String projectId = null;
        for (Map.Entry<String, TokenInfo> entry : this.tokenMap.entrySet()) {
            if (!tokenId.equals(entry.getValue().getId())) continue;
            projectId = entry.getKey();
            break;
        }
        if (!VerifyUtil.isEmpty(projectId)) {
            Object object = this.getProjectTockenLock(projectId);
            synchronized (object) {
                LOG.info((Object)"Remove global's token:projectId=%s", new Object[]{projectId});
                this.tokenMap.remove(projectId);
            }
            return;
        }
        LOG.info((Object)"Get projectId in Global failed, need more check.");
        String regionId = null;
        for (Map.Entry<String, Map<String, TokenInfo>> entry : this.regionProjectTokenMap.entrySet()) {
            Map<String, TokenInfo> tokenInfoMap = entry.getValue();
            for (Map.Entry<String, TokenInfo> tokenInfoEntry : tokenInfoMap.entrySet()) {
                if (!tokenId.equals(tokenInfoEntry.getValue().getId())) continue;
                projectId = tokenInfoEntry.getKey();
                regionId = entry.getKey();
                break;
            }
            if (VerifyUtil.isEmpty(regionId)) continue;
            break;
        }
        if (VerifyUtil.isEmpty((String)projectId)) {
            LOG.info((Object)"Get projectId in Region failed.");
            return;
        }
        Object object = this.getRegionUuidConnLock(regionId, projectId);
        synchronized (object) {
            LOG.info((Object)"Remove region's token:regionId=%s, projectId=%s", new Object[]{regionId, projectId});
            this.regionProjectTokenMap.get(regionId).remove(projectId);
            if (this.regionProjectTokenMap.get(regionId).isEmpty()) {
                this.regionProjectTokenMap.remove(regionId);
            }
        }
    }

    public String getTokenId(OpenstackInfo open, String projectUuid) {
        if (VerifyUtil.isEmpty((Object)open)) {
            LOG.error((Object)"Parmeter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)projectUuid)) {
            TokenInfo token = this.getTokenInfo(open, null);
            if (null == token || VerifyUtil.isEmpty((String)token.getId())) {
                LOG.error((Object)"Get token error.");
                throw new LegoCheckedException(1073947689L);
            }
            return token.getId();
        }
        String projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        TokenInfo token = this.getTokenInfo(open, projectId);
        if (token == null || VerifyUtil.isEmpty((String)token.getId())) {
            LOG.error((Object)"Get token error.");
            throw new LegoCheckedException(1073947689L);
        }
        return token.getId();
    }

    public String getTokenId(OpenstackInfo open, String regionUuid, String projectUuid) {
        if (VerifyUtil.isEmpty((Object)open) || VerifyUtil.isEmpty((String)regionUuid)) {
            LOG.error((Object)"Parmeter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String regionId = OpenStackCommonUtil.getIdFromUuid(regionUuid);
        if (VerifyUtil.isEmpty((String)projectUuid)) {
            TokenInfo token = this.getTokenInfo(open, regionUuid, null);
            if (token == null || VerifyUtil.isEmpty((String)token.getId())) {
                LOG.error((Object)"Get token error.");
                throw new LegoCheckedException(1073947689L);
            }
            return token.getId();
        }
        String projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        TokenInfo token = this.getTokenInfo(open, regionId, projectId);
        if (null == token || VerifyUtil.isEmpty((String)token.getId())) {
            LOG.error((Object)"Get token error.");
            throw new LegoCheckedException(1073947689L);
        }
        return token.getId();
    }

    public String getTokenId(String projectUuid) {
        if (VerifyUtil.isEmpty((String)projectUuid)) {
            LOG.error((Object)"Param is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        String projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projectUuid);
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)openstackUuid)) {
            LOG.error((Object)("Param is empty:projectUuid=" + projectUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        OpenstackInfo open = this.getOpenstackInfo(openstackUuid);
        return this.getTokenId(open, projectId);
    }

    public String getRegionTokenId(String regionUuid, String projectUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid)) {
            LOG.error((Object)"Param is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        String regionId = OpenStackCommonUtil.getIdFromUuid(regionUuid);
        String projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projectUuid);
        if (VerifyUtil.isEmpty((String)regionId) || VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)openstackUuid)) {
            String message = String.format(Locale.ENGLISH, "Param is empty:regionUuid=%s, projectUuid=%s", regionUuid, projectUuid);
            LOG.error((Object)message, 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        OpenstackInfo open = this.getOpenstackInfo(openstackUuid);
        return this.getTokenId(open, regionId, projectId);
    }

    private OpenstackInfo getOpenstackInfo(String openstackUuid) {
        FusionSphereOpenStack open = (FusionSphereOpenStack)CommonDAOLocator.getMoDao().getMoByUuid(openstackUuid, Boolean.valueOf(true));
        if (VerifyUtil.isEmpty((Object)open)) {
            LOG.error((Object)("Cant find openstack mo:openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        long moId = open.getMoId();
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend extend = neMgr.findByMoId(Long.valueOf(moId));
        if (VerifyUtil.isEmpty((Object)extend)) {
            LOG.error((Object)("Cant find openstack ne extend info :openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        Map paramMap = extend.getExtendParams();
        String isIam = (String)paramMap.get("authType");
        OpenstackInfo openInfo = new OpenstackInfo();
        openInfo.setIp(open.getIpAddress());
        openInfo.setPort((String)paramMap.get("port"));
        openInfo.setDomainName((String)paramMap.get("domain"));
        openInfo.setUser(extend.getNetworkUserName());
        openInfo.setPasswd(extend.getNetworkPassword());
        openInfo.setUseIAM("IAM".equals(isIam));
        openInfo.setUuid(openstackUuid);
        return openInfo;
    }

    private boolean checkToken(String projectId) {
        return this.checkToken(projectId, this.tokenMap);
    }

    private boolean checkToken(String projectId, Map<String, TokenInfo> tokenMap) {
        SimpleDateFormat formater = new SimpleDateFormat(DATE_PATTERN, Locale.ENGLISH);
        if (tokenMap.containsKey(projectId)) {
            TokenInfo token = tokenMap.get(projectId);
            if (null == token) {
                return false;
            }
            String expirtAt = token.getExpiresAt();
            try {
                long millseconds = formater.parse(expirtAt).getTime();
                long curMillseconds = Calendar.getInstance().getTimeInMillis();
                if (millseconds - curMillseconds > 3600000L) {
                    return true;
                }
            }
            catch (ParseException e) {
                LOG.error((Object)("Time format error:DATE=" + expirtAt));
                return false;
            }
        }
        return false;
    }

    private boolean checkToken(String regionId, String projectId) {
        if (!this.regionProjectTokenMap.containsKey(regionId)) {
            return false;
        }
        Map<String, TokenInfo> projectTokenMap = this.regionProjectTokenMap.get(regionId);
        if (!projectTokenMap.containsKey(projectId)) {
            return false;
        }
        return this.checkToken(projectId, projectTokenMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenInfo getTokenInfo(OpenstackInfo open, String projectId) {
        String ip = open.getIp();
        String port = open.getPort();
        if (null == projectId) {
            return this.getNewToken(open, null, ip, port);
        }
        Object object = this.getProjectTockenLock(projectId);
        synchronized (object) {
            if (this.checkToken(projectId)) {
                return this.tokenMap.get(projectId);
            }
            TokenInfo token = this.getNewToken(open, projectId, ip, port);
            if (null != token) {
                this.tokenMap.put(projectId, token);
            }
            return token;
        }
    }

    private boolean tryGetIamEndpoint(OpenstackInfo open, String regionId) {
        String iamEndpoint;
        if (this.regionIamMap.containsKey(regionId)) {
            return true;
        }
        try {
            iamEndpoint = this.getIamEndpoint(open, regionId);
        }
        catch (LegoCheckedException ex) {
            if (ex.getErrorCode() == 1073947395L) {
                LOG.error((Object)"GetIamEndpoint Failed. http status is 404. need try old method.");
                return false;
            }
            throw ex;
        }
        this.regionIamMap.put(regionId, iamEndpoint);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenInfo getTokenInfo(OpenstackInfo open, String regionId, String projectId) {
        String iamEndpoint = null;
        if (projectId == null) {
            Object object = this.getRegionConnLock(regionId);
            synchronized (object) {
                if (!this.tryGetIamEndpoint(open, regionId)) {
                    return this.getNewToken(open, null, open.getIp(), open.getPort());
                }
                iamEndpoint = this.regionIamMap.get(regionId);
            }
            String[] endpoint = iamEndpoint.split(":");
            open.setIp(endpoint[0]);
            open.setPort(endpoint[1]);
            return this.getNewToken(open, null, endpoint[0], endpoint[1]);
        }
        Object object = this.getRegionUuidConnLock(regionId, projectId);
        synchronized (object) {
            if (this.checkToken(regionId, projectId)) {
                return this.regionProjectTokenMap.get(regionId).get(projectId);
            }
            TokenInfo regionToken = null;
            Object object2 = this.getRegionConnLock(regionId);
            synchronized (object2) {
                if (this.tryGetIamEndpoint(open, regionId)) {
                    iamEndpoint = this.regionIamMap.get(regionId);
                } else {
                    regionToken = this.getNewToken(open, projectId, open.getIp(), open.getPort());
                }
            }
            if (regionToken == null && iamEndpoint != null) {
                String[] endpoint = iamEndpoint.split(":");
                open.setIp(endpoint[0]);
                open.setPort(endpoint[1]);
                regionToken = this.getNewToken(open, projectId, endpoint[0], endpoint[1]);
            }
            if (regionToken != null) {
                Map<String, TokenInfo> projectTkMap = this.regionProjectTokenMap.get(regionId);
                if (projectTkMap == null) {
                    projectTkMap = new ConcurrentHashMap<String, TokenInfo>();
                    this.regionProjectTokenMap.put(regionId, projectTkMap);
                }
                projectTkMap.put(projectId, regionToken);
            }
            return regionToken;
        }
    }

    private String getIamEndpoint(OpenstackInfo open, String regionId) {
        TokenInfo unscopedToken = this.getNewToken(open, null, open.getIp(), open.getPort());
        if (unscopedToken == null) {
            LOG.error((Object)"Fetch UnscopedToken failed.");
            throw new LegoCheckedException(0x300001L);
        }
        CloudConfig accessInfo = ((ICloudConfigService)ServiceLocator.getInstance().getService(ICloudConfigService.class)).getCloudConfigBy("oc");
        if (VerifyUtil.isEmpty((Object)accessInfo)) {
            LOG.error((Object)"AccessInfo is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String ocDomain = (String)accessInfo.getProps().get("oc_domain");
        String ocPort = (String)accessInfo.getProps().get("oc_port");
        RestClient client = new RestClient(ocDomain, NumberUtil.parseInteger((Object)ocPort).intValue(), null, null);
        String url = "/rest/serviceaccess/v3.0/relations?regionId=" + regionId;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("X-Auth-Token", unscopedToken.getId());
        ServiceResponse serviceResponse = TokenUtil.getServiceResponse(client, url, requestHeaders);
        RegionIamResponseInfo regionIamResponseInfo = JsonUtil.jsonToBean(serviceResponse.getResponseString(), RegionIamResponseInfo.class);
        if (regionIamResponseInfo == null || regionIamResponseInfo.getTotal() <= 0) {
            LOG.error((Object)"Query IAM endpoint result for regionId[%s] is empty.", new Object[]{regionId});
            throw new LegoCheckedException(0x300001L);
        }
        String iamEndpoint = ((RegionIamInfo)regionIamResponseInfo.getRecords().get(0)).getIamEndpoint();
        if (iamEndpoint == null) {
            LOG.error((Object)"Query IAM endpoint result for regionId[%s] is empty.", new Object[]{regionId});
            throw new LegoCheckedException(0x300001L);
        }
        return iamEndpoint;
    }

    private static ServiceResponse getServiceResponse(RestClient client, String url, Map<String, String> requestHeaders) {
        ServiceResponse serviceResponse = null;
        int count = 0;
        while (true) {
            block6: {
                try {
                    serviceResponse = client.getSupportXml(url, null, requestHeaders);
                    if (serviceResponse != null) {
                        break;
                    }
                }
                catch (LegoCheckedException ex) {
                    LOG.error((Object)"GetIamEndpoint failed, msg: %s", (Throwable)ex);
                    if (ex.getErrorCode() != 1073947395L && count < 3) break block6;
                    throw ex;
                }
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                LOG.error((Object)"Thread interrupted.");
            }
            LOG.info((Object)"Start retry IamEndpoint get request.");
            ++count;
        }
        return serviceResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenInfo getNewToken(OpenstackInfo open, String projectId, String ip, String port) {
        String url;
        char[] msg;
        RestClient client = new RestClient(ip, NumberUtil.parseInteger((Object)port).intValue(), null, null, (IResponseHandler)new OpenStackResponseHandler(), new String[0]);
        client.setTimeout(60000);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (open.isUseIAM()) {
            msg = this.getTokenReqBodyStrOfIAM(open, projectId);
            url = OpenstackEnumDefine.RequestUrl.IAM_TOKEN.getUri();
            if (!VerifyUtil.isEmpty((String)projectId)) {
                TokenInfo token = this.getIAMUnscopeToken(client, this.getTokenReqBodyStrOfIAM(open, null), url);
                if (null == token) {
                    LOG.error((Object)"GetIAMUnscopeToken return null.");
                    throw new LegoCheckedException(0x300001L);
                }
                requestHeaders.put("X-Auth-Token", token.getId());
            }
        } else {
            msg = this.getTokenReqBodyStrOfKeyStone(open, projectId);
            url = OpenstackEnumDefine.RequestUrl.IDENTITY_TOKEN.getUri();
        }
        try {
            ServiceResponse response = client.post(url, String.valueOf(msg), null, requestHeaders);
            TokenInfo tokenInfo = this.responseToTokenInfo(response);
            return tokenInfo;
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)("Get token failed." + ExceptionUtil.getErrorMessage((Throwable)exception)));
            if (exception.getErrorCode() == 401L) {
                throw new LegoCheckedException(1073947691L, (Throwable)exception);
            }
            if (exception.getErrorCode() == 1073947691L) {
                throw exception;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Get token failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        finally {
            TokenUtil.fillZero(msg);
        }
        return null;
    }

    private static void fillZero(char[] arr) {
        for (int i = 0; i < 3; ++i) {
            Arrays.fill(arr, '\u0000');
        }
    }

    private TokenInfo getIAMUnscopeToken(RestClient client, char[] msg, String url) {
        HashMap requestHeaders = new HashMap();
        try {
            ServiceResponse response = client.post(url, String.valueOf(msg), null, requestHeaders);
            return this.responseToTokenInfo(response);
        }
        catch (LegoCheckedException exception) {
            if (exception.getErrorCode() == 1073947691L) {
                throw exception;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Get token failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return null;
    }

    private TokenInfo responseToTokenInfo(ServiceResponse response) {
        Header[] headers = response.getResponseHeaders();
        if (response.getStatusCode() == 401) {
            throw new LegoCheckedException(1073947691L, "openstack get token failed.");
        }
        for (Header header : headers) {
            if (!X_SUBJECT_TOKEN_KEY.equals(header.getName())) continue;
            String tokenId = header.getValue();
            IdentityResponseInfo responseInfo = JsonUtil.jsonToBean(response.getResponseString(), IdentityResponseInfo.class);
            if (null == responseInfo) {
                LOG.error((Object)"Convert response info return null value");
                continue;
            }
            TokenInfo token = responseInfo.getToken();
            token.setId(tokenId);
            return token;
        }
        return null;
    }

    private synchronized Object getProjectTockenLock(String projectId) {
        if (!this.uuidConnectionLock.containsKey(projectId)) {
            Object obj = new Object();
            this.uuidConnectionLock.put(projectId, obj);
            return obj;
        }
        return this.uuidConnectionLock.get(projectId);
    }

    private synchronized Object getRegionConnLock(String regionId) {
        if (!this.regionConnLock.containsKey(regionId)) {
            Object obj = new Object();
            this.regionConnLock.put(regionId, obj);
            return obj;
        }
        return this.regionConnLock.get(regionId);
    }

    private synchronized Object getRegionUuidConnLock(String regionId, String projectId) {
        if (!this.regionUuidConnLock.containsKey(regionId)) {
            ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
            Object obj = new Object();
            map.put(projectId, obj);
            this.regionUuidConnLock.put(regionId, map);
            return obj;
        }
        Map<String, Object> map = this.regionUuidConnLock.get(regionId);
        if (!map.containsKey(projectId)) {
            Object obj = new Object();
            map.put(projectId, obj);
            return obj;
        }
        return this.regionUuidConnLock.get(regionId).get(projectId);
    }

    private char[] getTokenReqBodyStrOfKeyStone(OpenstackInfo open, String projectId) {
        DomainInfo domain = new DomainInfo();
        domain.setName(open.getDomainName());
        UserInfo user = new UserInfo();
        user.setDomain(domain);
        user.setName(open.getUser());
        user.setPassword(open.getPasswd());
        PasswordInfo passInfo = new PasswordInfo();
        passInfo.setUser(user);
        IdentityInfo identity = new IdentityInfo();
        identity.setPassword(passInfo);
        AuthenticateInfo auth = new AuthenticateInfo();
        auth.setIdentity(identity);
        if (!VerifyUtil.isEmpty((String)projectId)) {
            ProjectInfo projectInfo = new ProjectInfo();
            projectInfo.setId(projectId);
            ScopeInfo scope = new ScopeInfo();
            scope.setProject(projectInfo);
            auth.setScope(scope);
        }
        IdentityRequestInfo identityReq = new IdentityRequestInfo();
        identityReq.setAuth(auth);
        return JsonUtil.beanToJson(identityReq).toCharArray();
    }

    private char[] getTokenReqBodyStrOfIAM(OpenstackInfo open, String projectId) {
        AuthenticateInfo auth = new AuthenticateInfo();
        if (!VerifyUtil.isEmpty((String)projectId)) {
            IAMIdentityInfo.RestrictInfo restrictInfo = new IAMIdentityInfo.RestrictInfo();
            IAMIdentityInfo.AssumeRoleInfo assumeRoleInfo = new IAMIdentityInfo.AssumeRoleInfo();
            assumeRoleInfo.setRestrict(restrictInfo);
            IAMIdentityInfo identity = new IAMIdentityInfo();
            identity.setAssumeRoleInfo(assumeRoleInfo);
            OpenStackProject project = this.getProjectByPojectId(open, projectId);
            String domainId = project.getDomainId();
            assumeRoleInfo.setDomainId(domainId);
            ProjectInfo projectInfo = new ProjectInfo();
            projectInfo.setId(projectId);
            ScopeInfo scope = new ScopeInfo();
            scope.setProject(projectInfo);
            auth.setScope(scope);
            auth.setIdentity((IdentityInfo)identity);
        } else {
            DomainInfo domain = new DomainInfo();
            domain.setName(open.getDomainName());
            UserInfo user = new UserInfo();
            user.setDomain(domain);
            user.setName(open.getUser());
            user.setPassword(open.getPasswd());
            PasswordInfo passInfo = new PasswordInfo();
            passInfo.setUser(user);
            IdentityInfo identity = new IdentityInfo();
            identity.setPassword(passInfo);
            auth.setIdentity(identity);
            IAMScopeInfo scope = new IAMScopeInfo();
            scope.setDomain(domain);
            auth.setScope((ScopeInfo)scope);
        }
        IdentityRequestInfo identityReq = new IdentityRequestInfo();
        identityReq.setAuth(auth);
        return JsonUtil.beanToJson(identityReq).toCharArray();
    }

    private OpenStackProject getProjectByPojectId(OpenstackInfo open, String projectId) {
        if (VerifyUtil.isEmpty((String)projectId)) {
            LOG.error((Object)("Param is projectId=" + projectId));
            throw new LegoCheckedException(1073947393L);
        }
        String uuid = open.getUuid() + ":" + projectId;
        List list = CommonDAOLocator.getMoDao().find("from OpenStackProject where uuid = ? ", new Object[]{uuid});
        if (VerifyUtil.isEmpty((Collection)list)) {
            LOG.error((Object)("Param is projectId=" + projectId));
            String unscopedToken = this.getTokenId(open, null);
            IKeystoreManager keystoreMgr = ManagerFactory.getInstance().getKeystoreManagerByVersion(null, open.isUseIAM());
            List<OpenStackProject> openStackProjects = keystoreMgr.getProjects(open, unscopedToken);
            for (OpenStackProject openStackProject : openStackProjects) {
                if (!uuid.equals(openStackProject.getUuid())) continue;
                return openStackProject;
            }
            throw new LegoCheckedException(2117645L);
        }
        return (OpenStackProject)list.get(0);
    }

    public synchronized void clearAllTokenCache() {
        LOG.info((Object)"Clear all token cache.");
        this.tokenMap.clear();
        this.regionProjectTokenMap.clear();
        this.regionIamMap.clear();
    }
}

