/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.cert.checker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.huawei.ism.drm.cert.checker.HttpsConnectChecker;
import com.huawei.ism.drm.openstack.cert.checker.AbstractConnectionCheck;
import com.huawei.ism.drm.openstack.cert.checker.ApigConnectionCheck;
import com.huawei.ism.drm.openstack.cert.checker.ArbConnectionCheck;
import com.huawei.ism.drm.openstack.cert.checker.ConnectionStatus;
import com.huawei.ism.drm.openstack.cert.checker.IAMConnectionCheck;
import com.huawei.ism.drm.openstack.cert.checker.LogConnectionCheck;
import com.huawei.ism.drm.openstack.cert.checker.NovaConnectionCheck;
import com.huawei.ism.drm.openstack.cert.checker.OCConnectionCheck;
import com.huawei.ism.drm.openstack.cert.checker.SCConnectionCheck;
import com.huawei.ism.drm.openstack.cert.checker.SfsConnectionCheck;
import com.huawei.ism.drm.wcc.util.utils.FileUtils;
import com.huawei.ism.drm.wcc.util.utils.FileWatchService;
import com.huawei.ism.drm.wcc.util.utils.SysPropertiesUtils;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Service(name="httpsConnectCheckerImpl", desc="", interfaceClass=HttpsConnectChecker.class)
public class HttpsConnectCheckerImpl
implements HttpsConnectChecker {
    private static final Log LOG = LogFactory.getInstance(HttpsConnectCheckerImpl.class);
    private static final HttpsConnectCheckerImpl INSTANCE = new HttpsConnectCheckerImpl();
    private static String shellFlagFilePath = null;
    private static final List<AbstractConnectionCheck> CONNECTION_CHECKS = ImmutableList.of((Object)new ApigConnectionCheck(), (Object)new SfsConnectionCheck(), (Object)new IAMConnectionCheck(), (Object)new SCConnectionCheck(), (Object)new OCConnectionCheck(), (Object)new LogConnectionCheck(), (Object)new NovaConnectionCheck(), (Object)new ArbConnectionCheck());

    public static HttpsConnectCheckerImpl getInstance() {
        return INSTANCE;
    }

    public List<String> getConnectFailedServices(boolean isForceCheckCert) {
        LOG.info((Object)"Start to getConnectFailedServices, isForceCheckCert:%s", new Object[]{isForceCheckCert});
        List<String> httpsFailServiceNames = CONNECTION_CHECKS.stream().filter(connectionCheck -> !ConnectionStatus.CONNECTION_SUCCESS.equals((Object)connectionCheck.getConnectStatus(isForceCheckCert))).map(AbstractConnectionCheck::getServiceName).collect(Collectors.toList());
        String httpsFailServiceNamesStr = String.join((CharSequence)",", httpsFailServiceNames);
        HttpsConnectCheckerImpl.writeDataToFile(shellFlagFilePath, httpsFailServiceNamesStr);
        LOG.info((Object)"End to getConnectFailedServices.");
        return httpsFailServiceNames;
    }

    private static void writeDataToFile(String file, String sslFailServiceNamesStr) {
        File flagFile = new File(file);
        if (flagFile.isFile() && flagFile.length() == 0L) {
            String fileDate = "FailedHttpsServiceNames:" + sslFailServiceNamesStr;
            FileUtils.write((File)flagFile, (ByteBuffer)ByteBuffer.wrap(fileDate.getBytes(StandardCharsets.UTF_8)));
        }
    }

    private static void registerListeningTask(String runtimePath) {
        if (VerifyUtil.isEmpty((String)runtimePath)) {
            LOG.warn((Object)"Failed to registerListeningTask, cause runtimePath is empty.");
            return;
        }
        try {
            FileWatchService.registerTask((String)Paths.get(runtimePath, "/LegoRuntime/tmp").toString(), (String)"checkConnection.shell.flag", (List)Lists.newArrayList((Object[])new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE}), () -> HttpsConnectCheckerImpl.getInstance().getConnectFailedServices(Boolean.FALSE));
            shellFlagFilePath = Paths.get(runtimePath, "/LegoRuntime/tmp", "checkConnection.shell.flag").toString();
        }
        catch (IOException e) {
            LOG.error((Object)"HttpsConnectChecker init error.");
            throw new ExceptionInInitializerError("HttpsConnectChecker init error.");
        }
    }

    static {
        Optional runtimePathOptional = SysPropertiesUtils.getRuntimePath();
        HttpsConnectCheckerImpl.registerListeningTask(runtimePathOptional.orElse(null));
    }
}

