/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.cert.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.ism.drm.openstack.cert.checker.HttpsConnectCheckerImpl;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;

public class OpenStackHttpsConnectionCheckTask
extends AbstractBackTask {
    private static final Log LOG = LogFactory.getInstance(OpenStackHttpsConnectionCheckTask.class);

    public OpenStackHttpsConnectionCheckTask(List<CertificateSummary> certificateSummaries) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)"eReplication", (String)"ism.drm.https.check", (String)"System", (String)"https.check", (String)"", (String[])new String[0]), true);
    }

    protected void doWork() {
        List<String> httpsConnectFailServiceNames = HttpsConnectCheckerImpl.getInstance().getConnectFailedServices(Boolean.FALSE);
        if (!VerifyUtil.isEmpty(httpsConnectFailServiceNames)) {
            LOG.error((Object)"OpenStackHttpsConnectionCheckTask find connect failed service:%s.", new Object[]{httpsConnectFailServiceNames});
            throw new LegoCheckedException(1073947489L, new String[]{String.join((CharSequence)",", httpsConnectFailServiceNames)});
        }
    }
}

