/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.discovery.processor;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.base.util.MOUtil;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.discover.util.DiscoverUtil;
import com.huawei.ism.cbb.mediation.status.DefaultOnlineToOfflineStatus;
import com.huawei.ism.cbb.mediation.status.GlobalDeviceStatus;
import com.huawei.ism.cbb.mediation.status.Istatus;
import com.huawei.ism.drm.openstack.resource.authentication.CertificateUpdateThread;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.List;

public class SaveProcessor
implements IProcessor {
    private static final Log LOG = LogFactory.getInstance(SaveProcessor.class);

    public boolean process(AbstractContext context) {
        NeMgrProtocolExtend extend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
        FusionSphereOpenStack os = (FusionSphereOpenStack)context.getAttribute("OpenStackObj");
        String action = (String)context.getAttribute("DiscoveryType");
        if (null == os || null == extend) {
            return false;
        }
        os.setMainType("ism.drm.deviceType.fusionsphere.mainType");
        os.setSubType("ism.drm.deviceType.fusionsphereopenstack.subType");
        os.setProductModel("Dr_Openstack");
        HashMap result = new HashMap();
        try {
            IMoDao moDao = CommonDAOLocator.getMoDao();
            List removingMo = MOUtil.calRemovingMO((NetworkEntity)os, (IMoDao)moDao);
            moDao.clear();
            moDao.deleteMoWithoutMsg(removingMo);
            moDao.addMoAndSubMoEx((ManagedObject)os, result);
            if ("register".equals(action)) {
                INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
                NeMgrProtocolExtend existNe = neMgr.findByMoId(os.getMoId());
                if (null != existNe) {
                    existNe.setExtendParams(extend.getExtendParams());
                    existNe.setNetworkIpAddress(extend.getNetworkIpAddress());
                    existNe.setNetworkUserName(extend.getNetworkUserName());
                    existNe.setNetworkPassword(extend.getNetworkPassword());
                    neMgr.update(existNe);
                } else {
                    extend.setMoId(os.getMoId());
                    neMgr.save(extend);
                }
                Long userId = (Long)context.getAttribute("OperatorId");
                DiscoverUtil.grantUserNeAuthority((NetworkEntity)os, (Long)userId);
            } else {
                Istatus devStatus = GlobalDeviceStatus.getStatus((String)os.getUuid(), DefaultOnlineToOfflineStatus.class);
                devStatus.doAction((ManagedObject)os, 0);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("save openstack error:" + os.getIpAddress()), (long)-1L, null, (Log)LOG);
        }
        String isIam = (String)extend.getExtendParams().get("authType");
        if ("IAM".equals(isIam)) {
            CertificateUpdateThread thread = new CertificateUpdateThread();
            thread.setThreadName("CertificateUpdateThread");
            ExecutionService.submit((Runnable)((Object)thread));
        }
        return true;
    }

    public void postProcess(AbstractContext context) {
    }

    public void clean(AbstractContext context) {
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }
}

