/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.replica.builder;

import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.replica.builder.ArrayReplicationReplicaBuilder;
import com.huawei.ism.drm.openstack.protection.replica.builder.HyperMetroReplicationReplicaBuilder;
import com.huawei.ism.drm.openstack.protection.service.ConfigPhVmTask;
import com.huawei.ism.drm.openstack.protection.service.CreateRingTask;
import com.huawei.ism.drm.openstack.protection.service.CreateRingTaskResult;
import com.huawei.ism.drm.openstack.protection.service.ReattachVolumeTask;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;

public class VhaAsyncArrayReplicationReplicaBuilder
extends ArrayReplicationReplicaBuilder {
    private static final Log LOG = LogFactory.getInstance(VhaAsyncArrayReplicationReplicaBuilder.class);
    private HyperMetroReplicationReplicaBuilder hypermetroreplicationreplicabuilder = new HyperMetroReplicationReplicaBuilder();

    @Override
    public void buildReplica(ProtectGroup pg) {
        if (this.isCreateInstance(pg)) {
            this.createInstance(pg);
            return;
        }
        if (this.isAddServer(pg)) {
            this.addServerToInstance(pg);
            return;
        }
        if (this.isUpgrade(pg)) {
            this.upGradeInstance(pg);
            return;
        }
    }

    private void createInstance(ProtectGroup pg) {
        HashMap<String, PoReplicaInfo> poReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        HashMap<String, PoReplicaInfo> poHyperMetroReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        HashMap<String, PoReplicaPairInfo> newHyperMetroCreatePairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, PoReplicaInfo> poDRReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        Map<String, OpenStackVolume> uuidVolMap = this.getUuidVolMap(pg);
        HashMap<String, String> drVolTypeMap = new HashMap<String, String>();
        HashMap<String, String> drHyperMetroVolTypeMap = new HashMap<String, String>();
        HashMap<String, String> drRemoteHyperMetroVolTypeMap = new HashMap<String, String>();
        HashMap<String, List<ProtectObject>> needProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unNeedProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, PoReplicaPairInfo> protectedPairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, List<ProtectObject>> protectedVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unprotectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        try {
            LOG.info((Object)"Start to create protectgroup replica:pgName=%s", new Object[]{pg.getName()});
            this.checkVolume(pg, drVolTypeMap, drHyperMetroVolTypeMap);
            this.getPairInfoMap(pg, protectedPairInfoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
            if (!this.checkVolumeStatus(pg, protectedPairInfoMap)) {
                LOG.error((Object)("Check pg protectedPairInfoMap volume status fail : " + pg.getName()));
                throw new LegoCheckedException(1073948416L);
            }
            this.getAddedPoVolumeInfoMap(pg, protectedPairInfoMap, needProtectVolUuidPoMap, unNeedProtectVolUuidPoMap);
            LOG.info((Object)"First:creating vha_csdr/csha_csdr:create master replication,protectGroup name=%s,source volume uuids:%s,dr volume ids:%s,dr volume types:%s,replicationmode:%s,protectGroup name=%s", new Object[]{pg.getName(), uuidVolMap.keySet().toString(), drVolTypeMap.keySet().toString(), drVolTypeMap.values(), this.getReplicaModel(pg), pg.getName()});
            pg.getProps().put("replicationModel", "async");
            Map<String, PoReplicaPairInfo> newCreatePairInfoMap = this.protectVolumes(pg, uuidVolMap, drVolTypeMap, poReplicaInfoMap, needProtectVolUuidPoMap);
            pg.getProps().put("replicationModel", "hypermetro");
            Map<String, PoReplicaPairInfo> newCreateVolUuidToPairMap = this.protectVolumesForRing(pg, uuidVolMap, drHyperMetroVolTypeMap, poHyperMetroReplicaInfoMap, needProtectVolUuidPoMap, null);
            newHyperMetroCreatePairInfoMap.putAll(newCreateVolUuidToPairMap);
            this.saveHyperCGID(pg, poHyperMetroReplicaInfoMap);
            Set addPoSet = pg.getPolist();
            this.afterCreatePairForHyperMetro(pg, poHyperMetroReplicaInfoMap, addPoSet);
            LOG.info((Object)"Second:creating vha_csdr/csha_csdr:create master hypereplication,protectGroup name=%s,source volume uuids:%s,dr volume ids:%s,dr volume types:%s,replicationmode:%s,protectGroup name=%s", new Object[]{pg.getName(), uuidVolMap.keySet().toString(), drVolTypeMap.keySet().toString(), drVolTypeMap.values(), this.getReplicaModel(pg), pg.getName()});
            pg.getProps().put("replicationModel", "async");
            HashMap<String, String> drSUUIDToDrVolumeUUIDMap = new HashMap<String, String>();
            ArrayList<String> drRemoteHyperMetroVolUUID = new ArrayList<String>();
            this.getUsefulMapping(newHyperMetroCreatePairInfoMap, drRemoteHyperMetroVolUUID, drSUUIDToDrVolumeUUIDMap, drVolTypeMap, drRemoteHyperMetroVolTypeMap);
            Map<String, OpenStackVolume> drUUIDVolume = this.getUuidVolMap(pg, drRemoteHyperMetroVolUUID);
            HashMap<String, String> drHyperUUIDTDrUUID = new HashMap<String, String>();
            HashMap<String, String> drDRUUIDToHyperMetroUUID = new HashMap<String, String>();
            HashMap<String, List<ProtectObject>> needProtectDrVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
            HashMap<String, VolumeInfo> drHyperUUIDTDrVolumeInfo = new HashMap<String, VolumeInfo>();
            this.getDrHyperUuidToDrVolumeInfoMap(newCreatePairInfoMap, drHyperUUIDTDrUUID, drSUUIDToDrVolumeUUIDMap, needProtectVolUuidPoMap, needProtectDrVolUuidPoMap, drDRUUIDToHyperMetroUUID);
            String drProjUuid = (String)pg.getProps().get("drProjectId");
            String drRegionId = (String)pg.getProps().get("drRegionId");
            String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionId, drProjUuid);
            this.initHyperMetroUUIDToVolume(drHyperUUIDTDrUUID, drDRUUIDToHyperMetroUUID, drHyperUUIDTDrVolumeInfo, drProjUuid, tokenId, drRegionId);
            LOG.info((Object)"Third:creating vha_csdr:create standby replication,protectGroup name=%s, source volume uuids:%s,dr volume ids:%s,dr volume types:%s,replicationmode:%s,protectGroup name=%s", new Object[]{pg.getName(), drUUIDVolume.keySet().toString(), drRemoteHyperMetroVolTypeMap.keySet().toString(), drRemoteHyperMetroVolTypeMap.values(), this.getReplicaModel(pg), pg.getName()});
            this.protectVolumesForRing(pg, drUUIDVolume, drRemoteHyperMetroVolTypeMap, poDRReplicaInfoMap, needProtectDrVolUuidPoMap, drHyperUUIDTDrVolumeInfo);
            this.saveStandbyCGID(pg, poDRReplicaInfoMap);
            this.saveRemotePhInfo(poReplicaInfoMap, poDRReplicaInfoMap);
            this.createRingAndConfigPhVM(pg, poReplicaInfoMap, poHyperMetroReplicaInfoMap, poDRReplicaInfoMap, null, null);
        }
        catch (LegoCheckedException e) {
            this.mergeAndRollBack(poReplicaInfoMap, poDRReplicaInfoMap, poHyperMetroReplicaInfoMap, pg, protectedPairInfoMap);
            LOG.error((Object)("Build replica failed:protectGroup name=" + pg.getName()));
            throw e;
        }
        catch (Exception e) {
            this.mergeAndRollBack(poReplicaInfoMap, poDRReplicaInfoMap, poHyperMetroReplicaInfoMap, pg, protectedPairInfoMap);
            LOG.error((Object)("Build replica failed:protectGroup name=" + pg.getName()));
            ExceptionUtil.rethrowException((Throwable)e, (String)"build replica failed", (long)0x300001L, (String[])new String[0], (Log)LOG);
        }
        this.updateProp(pg, poReplicaInfoMap, uuidVolMap, drVolTypeMap, drHyperMetroVolTypeMap);
        this.updatePoPropForRing(pg, poHyperMetroReplicaInfoMap, uuidVolMap, poDRReplicaInfoMap);
        this.updateUnprotectVolumePoPropsInfo(pg);
        this.makePgReplica(pg);
        pg.getProps().remove("replicationModel");
        LOG.info((Object)"Build vha_csdr/csha_csdr replica succeed.protectGroup name=%s", new Object[]{pg.getName()});
    }

    private void addServerToInstance(ProtectGroup pg) {
        HashMap<String, PoReplicaInfo> poReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        HashMap<String, PoReplicaPairInfo> newCreatePairInfoMap = new HashMap();
        HashMap<String, PoReplicaInfo> poHyperMetroReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        HashMap<String, PoReplicaPairInfo> newHyperMetroCreatePairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, PoReplicaInfo> poDRReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        Map<String, OpenStackVolume> uuidVolMap = this.getUuidVolMap(pg);
        HashMap<String, String> drVolTypeMap = new HashMap<String, String>();
        HashMap<String, String> drHyperMetroVolTypeMap = new HashMap<String, String>();
        HashMap<String, String> drRemoteHyperMetroVolTypeMap = new HashMap<String, String>();
        HashMap<String, List<ProtectObject>> needProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unNeedProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, PoReplicaPairInfo> protectedPairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, List<ProtectObject>> protectedVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unprotectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, PoReplicaPairInfo> hyperMetroProtectedPairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, PoReplicaPairInfo> remoteProtectedPairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        try {
            Map<String, PoReplicaPairInfo> newVolUuidToCreatePairMap;
            LOG.info((Object)"Start to add protectgroup to instance:pgName=%s", new Object[]{pg.getName()});
            this.checkVolume(pg, drVolTypeMap, drHyperMetroVolTypeMap);
            this.getPairInfoMap(pg, protectedPairInfoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
            if (!this.checkVolumeStatus(pg, protectedPairInfoMap)) {
                LOG.error((Object)("Check pg protectedPairInfoMap volume status fail : " + pg.getName()));
                throw new LegoCheckedException(1073948416L);
            }
            this.getHyperMetroPairMap(pg, hyperMetroProtectedPairInfoMap, remoteProtectedPairInfoMap);
            this.getAddedPoVolumeInfoMap(pg, protectedPairInfoMap, needProtectVolUuidPoMap, unNeedProtectVolUuidPoMap);
            String replicaStatus = this.getActiveSideReplicaStatus(pg);
            if (!OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(replicaStatus)) {
                LOG.info((Object)"First:add protectgroup to instance:create master replication,protectGroup name=%s,source volume uuids:%s,dr volume ids:%s,dr volume types:%s,replicationmode:%s,protectGroup name=%s", new Object[]{pg.getName(), uuidVolMap.keySet().toString(), drVolTypeMap.keySet().toString(), drVolTypeMap.values(), this.getReplicaModel(pg), pg.getName()});
                pg.getProps().put("replicationModel", "async");
                newCreatePairInfoMap = this.protectVolumes(pg, uuidVolMap, drVolTypeMap, poReplicaInfoMap, needProtectVolUuidPoMap);
                this.dealShareVolume(pg, poReplicaInfoMap, newCreatePairInfoMap, protectedPairInfoMap, "replicationInfo", unNeedProtectVolUuidPoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
            }
            pg.getProps().put("replicationModel", "hypermetro");
            Map<String, PoReplicaPairInfo> newCreateVolUuidToPairMap = this.protectVolumesForRing(pg, uuidVolMap, drHyperMetroVolTypeMap, poHyperMetroReplicaInfoMap, needProtectVolUuidPoMap, null);
            newHyperMetroCreatePairInfoMap.putAll(newCreateVolUuidToPairMap);
            this.saveHyperCGID(pg, poHyperMetroReplicaInfoMap);
            this.dealShareVolume(pg, poHyperMetroReplicaInfoMap, newHyperMetroCreatePairInfoMap, hyperMetroProtectedPairInfoMap, "hypermetor_replicationInfo", unNeedProtectVolUuidPoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
            Set<ProtectObject> addPoSet = this.getWillAddPoSet(pg);
            this.afterCreatePairForHyperMetro(pg, poHyperMetroReplicaInfoMap, addPoSet);
            pg.getProps().put("replicationModel", "async");
            HashMap<String, String> drSUUIDToDrVolumeUUIDMap = new HashMap<String, String>();
            ArrayList<String> drRemoteHyperMetroVolUUID = new ArrayList<String>();
            this.getUsefulMapping(newHyperMetroCreatePairInfoMap, drRemoteHyperMetroVolUUID, drSUUIDToDrVolumeUUIDMap, drVolTypeMap, drRemoteHyperMetroVolTypeMap);
            Map<String, OpenStackVolume> drUUIDVolume = this.getUuidVolMap(pg, drRemoteHyperMetroVolUUID);
            HashMap<String, String> drHyperUUIDTDrUUID = new HashMap<String, String>();
            HashMap<String, String> drDRUUIDToHyperMetroUUID = new HashMap<String, String>();
            HashMap<String, List<ProtectObject>> needProtectDrVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
            HashMap<String, VolumeInfo> drHyperUUIDTDrVolumeInfo = new HashMap<String, VolumeInfo>();
            this.getDrHyperUuidToDrVolumeInfoMap(newCreatePairInfoMap, drHyperUUIDTDrUUID, drSUUIDToDrVolumeUUIDMap, needProtectVolUuidPoMap, needProtectDrVolUuidPoMap, drDRUUIDToHyperMetroUUID);
            String drProjUuid = (String)pg.getProps().get("drProjectId");
            String drRegionId = (String)pg.getProps().get("drRegionId");
            String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionId, drProjUuid);
            this.initHyperMetroUUIDToVolume(drHyperUUIDTDrUUID, drDRUUIDToHyperMetroUUID, drHyperUUIDTDrVolumeInfo, drProjUuid, tokenId, drRegionId);
            this.initHyperMetroUUIDToProtectObject(newHyperMetroCreatePairInfoMap, needProtectVolUuidPoMap, replicaStatus, needProtectDrVolUuidPoMap);
            LOG.info((Object)"Third:add protectgroup to instance:create standby replication,protectGroup name=%s, source volume uuids:%s, dr volume ids:%s,dr volume types:%s,replicationmode:%s,protectGroup name=%s", new Object[]{pg.getName(), drUUIDVolume.keySet().toString(), drRemoteHyperMetroVolTypeMap.keySet().toString(), drRemoteHyperMetroVolTypeMap.values(), this.getReplicaModel(pg), pg.getName()});
            String replicaKey = null;
            if (OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(replicaStatus)) {
                newVolUuidToCreatePairMap = this.protectVolumesForRing(pg, drUUIDVolume, drRemoteHyperMetroVolTypeMap, poDRReplicaInfoMap, needProtectDrVolUuidPoMap, null);
                replicaKey = "replicationInfo";
            } else {
                newVolUuidToCreatePairMap = this.protectVolumesForRing(pg, drUUIDVolume, drRemoteHyperMetroVolTypeMap, poDRReplicaInfoMap, needProtectDrVolUuidPoMap, drHyperUUIDTDrVolumeInfo);
                replicaKey = "remote_replicationInfo";
            }
            this.dealShareVolume(pg, poDRReplicaInfoMap, newVolUuidToCreatePairMap, remoteProtectedPairInfoMap, replicaKey, unNeedProtectVolUuidPoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
            this.saveRemotePhInfo(poReplicaInfoMap, poDRReplicaInfoMap);
            if (OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(replicaStatus)) {
                HashMap<String, VolumeInfo> srcUuidToRemoteVolume = new HashMap<String, VolumeInfo>();
                this.getSrcUuidToRemoteVolumeMap(newHyperMetroCreatePairInfoMap, newVolUuidToCreatePairMap, pg, srcUuidToRemoteVolume, tokenId, drProjUuid);
                newCreatePairInfoMap = this.protectVolumesForRing(pg, uuidVolMap, drVolTypeMap, poReplicaInfoMap, needProtectVolUuidPoMap, srcUuidToRemoteVolume);
                this.dealShareVolume(pg, poReplicaInfoMap, newCreatePairInfoMap, protectedPairInfoMap, "remote_replicationInfo", unNeedProtectVolUuidPoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
                this.saveRemotePhInfo(poReplicaInfoMap, poDRReplicaInfoMap);
            }
            this.createRingAndConfigPhVM(pg, poReplicaInfoMap, poHyperMetroReplicaInfoMap, poDRReplicaInfoMap, replicaStatus, null);
        }
        catch (LegoCheckedException e) {
            this.mergeAndRollBack(poReplicaInfoMap, poDRReplicaInfoMap, poHyperMetroReplicaInfoMap, pg, protectedPairInfoMap);
            LOG.error((Object)("Build replica failed:protectGroup name=" + pg.getName()));
            throw e;
        }
        catch (Exception e) {
            this.mergeAndRollBack(poReplicaInfoMap, poDRReplicaInfoMap, poHyperMetroReplicaInfoMap, pg, protectedPairInfoMap);
            LOG.error((Object)("Build replica failed:protectGroup name=" + pg.getName()));
            ExceptionUtil.rethrowException((Throwable)e, (String)"build replica failed", (long)0x300001L, (String[])new String[0], (Log)LOG);
        }
        this.updateProp(pg, poReplicaInfoMap, uuidVolMap, drVolTypeMap, drHyperMetroVolTypeMap);
        this.updatePoPropForRing(pg, poHyperMetroReplicaInfoMap, uuidVolMap, poDRReplicaInfoMap);
        this.updateUnprotectVolumePoPropsInfo(pg);
        this.makePgReplica(pg);
        pg.getProps().remove("replicationModel");
        LOG.info((Object)"Build vha_csdr replica succeed.protectGroup name=%s", new Object[]{pg.getName()});
    }

    private void upGradeInstance(ProtectGroup pg) {
        HashMap<String, PoReplicaInfo> poReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        Map<String, PoReplicaPairInfo> newCreatePairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, PoReplicaInfo> poHyperMetroReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        HashMap<String, PoReplicaPairInfo> newHyperMetroCreatePairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, PoReplicaInfo> poDRReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        Map<String, OpenStackVolume> uuidVolMap = this.getUuidVolMap(pg);
        HashMap<String, String> drVolTypeMap = new HashMap<String, String>();
        HashMap<String, String> drHyperMetroVolTypeMap = new HashMap<String, String>();
        HashMap<String, String> drRemoteHyperMetroVolTypeMap = new HashMap<String, String>();
        HashMap<String, List<ProtectObject>> needProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unNeedProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, PoReplicaPairInfo> protectedPairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, List<ProtectObject>> protectedVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unprotectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        try {
            LOG.info((Object)"Start to update protectgroup replica:pgName=%s", new Object[]{pg.getName()});
            this.checkVolume(pg, drVolTypeMap, drHyperMetroVolTypeMap);
            this.getPairInfoMap(pg, protectedPairInfoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
            if (!this.checkVolumeStatus(pg, protectedPairInfoMap)) {
                LOG.error((Object)("Check pg protectedPairInfoMap volume status fail : " + pg.getName()));
                throw new LegoCheckedException(1073948416L);
            }
            this.getAddedPoVolumeInfoMap(pg, protectedPairInfoMap, needProtectVolUuidPoMap, unNeedProtectVolUuidPoMap);
            String upgradeType = (String)pg.getProps().get("BEFORE_UPGRADE_TYPE");
            if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(upgradeType)) {
                this.updatePoReplicaInfoMap(pg, poReplicaInfoMap, newCreatePairInfoMap);
            } else {
                pg.getProps().put("replicationModel", "async");
                LOG.info((Object)"First:upgrading vha_csdr:create master replication,protectGroup name=%s,source volume uuids:%s,dr volume ids:%s,dr volume types:%s,replicationmode:%s,protectGroup name=%s", new Object[]{pg.getName(), uuidVolMap.keySet().toString(), drVolTypeMap.keySet().toString(), drVolTypeMap.values(), this.getReplicaModel(pg), pg.getName()});
                newCreatePairInfoMap = this.protectVolumes(pg, uuidVolMap, drVolTypeMap, poReplicaInfoMap, needProtectVolUuidPoMap);
            }
            this.createHyperMetroReplication(pg, poHyperMetroReplicaInfoMap, newHyperMetroCreatePairInfoMap, uuidVolMap, drHyperMetroVolTypeMap, needProtectVolUuidPoMap);
            Set addPoSet = pg.getPolist();
            this.afterCreatePairForHyperMetro(pg, poHyperMetroReplicaInfoMap, addPoSet);
            LOG.info((Object)"Second:upgrade vha_csdr:create master hypereplication,protectGroup name=%s,source volume uuids:%s, dr volume ids:%s,dr volume types:%s,replicationmode:%s,protectGroup name=%s", new Object[]{pg.getName(), uuidVolMap.keySet().toString(), drVolTypeMap.keySet().toString(), drVolTypeMap.values(), this.getReplicaModel(pg), pg.getName()});
            pg.getProps().put("replicationModel", "async");
            HashMap<String, String> drSUUIDToDrVolumeUUIDMap = new HashMap<String, String>();
            ArrayList<String> drRemoteHyperMetroVolUUID = new ArrayList<String>();
            this.getUsefulMapping(newHyperMetroCreatePairInfoMap, drRemoteHyperMetroVolUUID, drSUUIDToDrVolumeUUIDMap, drVolTypeMap, drRemoteHyperMetroVolTypeMap);
            Map<String, OpenStackVolume> drUUIDVolume = this.getUuidVolMap(pg, drRemoteHyperMetroVolUUID);
            HashMap<String, String> drHyperUUIDTDrUUID = new HashMap<String, String>();
            HashMap<String, String> drDRUUIDToHyperMetroUUID = new HashMap<String, String>();
            HashMap<String, List<ProtectObject>> needProtectDrVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
            HashMap<String, VolumeInfo> drHyperUUIDTDrVolumeInfo = new HashMap<String, VolumeInfo>();
            this.getDrHyperUuidToDrVolumeInfoMap(newCreatePairInfoMap, drHyperUUIDTDrUUID, drSUUIDToDrVolumeUUIDMap, needProtectVolUuidPoMap, needProtectDrVolUuidPoMap, drDRUUIDToHyperMetroUUID);
            String drProjUuid = (String)pg.getProps().get("drProjectId");
            String drRegionId = (String)pg.getProps().get("drRegionId");
            String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionId, drProjUuid);
            this.initHyperMetroUUIDToVolume(drHyperUUIDTDrUUID, drDRUUIDToHyperMetroUUID, drHyperUUIDTDrVolumeInfo, drProjUuid, tokenId, drRegionId);
            LOG.info((Object)"Third:upgrading vha_csdr:create standby replication,protectGroup name=%s,source volume uuids:%s, dr volume ids:%s,dr volume types:%s,replicationmode:%s,protectGroup name=%s", new Object[]{pg.getName(), drUUIDVolume.keySet().toString(), drRemoteHyperMetroVolTypeMap.keySet().toString(), drRemoteHyperMetroVolTypeMap.values(), this.getReplicaModel(pg), pg.getName()});
            this.protectVolumesForRing(pg, drUUIDVolume, drRemoteHyperMetroVolTypeMap, poDRReplicaInfoMap, needProtectDrVolUuidPoMap, drHyperUUIDTDrVolumeInfo);
            this.saveStandbyCGID(pg, poDRReplicaInfoMap);
            this.saveRemotePhInfo(poReplicaInfoMap, poDRReplicaInfoMap);
            this.createRingAndConfigPhVM(pg, poReplicaInfoMap, poHyperMetroReplicaInfoMap, poDRReplicaInfoMap, null, upgradeType);
        }
        catch (LegoCheckedException e) {
            this.mergeAndRollBack(poReplicaInfoMap, poDRReplicaInfoMap, poHyperMetroReplicaInfoMap, pg, protectedPairInfoMap);
            LOG.error((Object)("Build replica failed:protectGroup name=" + pg.getName()));
            throw e;
        }
        catch (Exception e) {
            this.mergeAndRollBack(poReplicaInfoMap, poDRReplicaInfoMap, poHyperMetroReplicaInfoMap, pg, protectedPairInfoMap);
            LOG.error((Object)("Build replica failed:protectGroup name=" + pg.getName()));
            ExceptionUtil.rethrowException((Throwable)e, (String)"build replica failed", (long)0x300001L, (String[])new String[0], (Log)LOG);
        }
        this.updateProp(pg, poReplicaInfoMap, uuidVolMap, drVolTypeMap, drHyperMetroVolTypeMap);
        this.updatePoPropForRing(pg, poHyperMetroReplicaInfoMap, uuidVolMap, poDRReplicaInfoMap);
        this.updateUnprotectVolumePoPropsInfo(pg);
        this.makePgReplica(pg);
        pg.getProps().remove("replicationModel");
        LOG.info((Object)"Build vha_csdr replica succeed.protectGroup name=%s", new Object[]{pg.getName()});
    }

    private boolean isAddServer(ProtectGroup pg) {
        return !VerifyUtil.isEmpty((Collection)pg.getReplicaList()) && VerifyUtil.isEmpty((String)((String)pg.getProps().get("BEFORE_UPGRADE_TYPE")));
    }

    private boolean isCreateInstance(ProtectGroup pg) {
        return VerifyUtil.isEmpty((Collection)pg.getReplicaList());
    }

    private boolean isUpgrade(ProtectGroup pg) {
        return !VerifyUtil.isEmpty((String)((String)pg.getProps().get("BEFORE_UPGRADE_TYPE")));
    }

    protected void saveHyperCGID(ProtectGroup pg, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap) {
        for (PoReplicaInfo poReplicaInfo : poHyperMetroReplicaInfoMap.values()) {
            pg.getProps().put("hyperProCgUuid", poReplicaInfo.getCgUuid());
            pg.getProps().put("hyperProdrCgUuid", poReplicaInfo.getDrCgUuid());
        }
    }

    protected void dealShareVolume(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, PoReplicaPairInfo> newCreatePairInfoMap, Map<String, PoReplicaPairInfo> protectedPairInfoMap, String replicaKey, Map<String, List<ProtectObject>> ... items) {
        Map<String, List<ProtectObject>> unNeedProtectVolUuidPoMap = items[0];
        Map<String, List<ProtectObject>> protectedVolUuidPoMap = items[1];
        Map<String, List<ProtectObject>> unprotectVolUuidPoMap = items[2];
        this.dealUnNeedProtectVolume(pg, unNeedProtectVolUuidPoMap, protectedPairInfoMap, protectedVolUuidPoMap, poReplicaInfoMap);
        this.dealUnProtectedVolume(unprotectVolUuidPoMap, newCreatePairInfoMap, replicaKey);
    }

    protected void initHyperMetroUUIDToProtectObject(Map<String, PoReplicaPairInfo> newHyperMetroCreatePairInfoMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap, String replicaStatus, Map<String, List<ProtectObject>> needProtectDrVolUuidPoMap) {
        if (OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(replicaStatus)) {
            for (PoReplicaPairInfo pairInfo : newHyperMetroCreatePairInfoMap.values()) {
                needProtectDrVolUuidPoMap.put(pairInfo.getDrVolumeUuid(), needProtectVolUuidPoMap.get(pairInfo.getVolumeUuid()));
            }
        }
    }

    protected void initHyperMetroUUIDToVolume(Map<String, String> drHyperUUIDTDrUUID, Map<String, String> drDRUUIDToHyperMetroUUID, Map<String, VolumeInfo> drHyperUUIDTDrVolumeInfo, String drProjUuid, String tokenId, String drRegionId) {
        CinderManager cinderMgr = new CinderManager();
        for (String drVolumeUUID : drHyperUUIDTDrUUID.values()) {
            VolumeInfo volInfo = cinderMgr.queryVolume(drRegionId, tokenId, drProjUuid, OpenStackCommonUtil.getIdFromUuid(drVolumeUUID));
            drHyperUUIDTDrVolumeInfo.put(drDRUUIDToHyperMetroUUID.get(drVolumeUUID), volInfo);
        }
    }

    protected void createRingAndConfigPhVM(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, Map<String, PoReplicaInfo> poDRReplicaInfoMap, String replicaStatus, String upgradeType) {
        if (this.isNeedCreateRing(pg, upgradeType)) {
            this.createRing(pg, poReplicaInfoMap, poHyperMetroReplicaInfoMap, poDRReplicaInfoMap);
        }
        if (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(upgradeType) && !OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(replicaStatus)) {
            LOG.info((Object)"Last:after config phvm ,protectGroup name=%s", new Object[]{pg.getName()});
            this.afterCreatePair(pg, poReplicaInfoMap);
        }
        if (OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(replicaStatus)) {
            LOG.info((Object)"Last:after config phvm ,protectGroup name=%s", new Object[]{pg.getName()});
            this.afterCreatePair(pg, poReplicaInfoMap);
        }
        this.saveRemotePhInfo(poReplicaInfoMap, poDRReplicaInfoMap);
        if (37 == pg.getTemplate().getType()) {
            this.updateStandbyReplicationProdVM(poHyperMetroReplicaInfoMap, poDRReplicaInfoMap);
        }
    }

    protected void updateStandbyReplicationProdVM(Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, Map<String, PoReplicaInfo> poDRReplicaInfoMap) {
        for (Map.Entry<String, PoReplicaInfo> entry : poHyperMetroReplicaInfoMap.entrySet()) {
            poDRReplicaInfoMap.get(entry.getKey()).setMoUuid(poHyperMetroReplicaInfoMap.get(entry.getKey()).getPhVmInfo().getVmUuid());
            poDRReplicaInfoMap.get(entry.getKey()).setVmName(poHyperMetroReplicaInfoMap.get(entry.getKey()).getPhVmInfo().getName());
        }
    }

    protected void saveStandbyCGID(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap) {
        for (PoReplicaInfo poReplicaInfo : poReplicaInfoMap.values()) {
            pg.getProps().put("hyperProRemoteCgUuid", poReplicaInfo.getCgUuid());
            pg.getProps().put("hyperProRemotedrCgUuid", poReplicaInfo.getDrCgUuid());
        }
    }

    protected void getHyperMetroPairMap(ProtectGroup pg, Map<String, PoReplicaPairInfo> hyperMetroProtectedPairInfoMap, Map<String, PoReplicaPairInfo> remoteProtectedPairInfoMap) {
        LOG.debug((Object)"Enter getHyperMetroPairMap pgname=%s", new Object[]{pg.getName()});
        HashMap<String, String> hyperUuidToSrcUuid = new HashMap<String, String>();
        for (ProtectObject po : pg.getPolist()) {
            PoReplicaInfo replicaInfo;
            String replicaInfoStr = (String)po.getProps().get("hypermetor_replicationInfo");
            if (VerifyUtil.isEmpty((String)replicaInfoStr) || null == (replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class))) continue;
            for (PoReplicaPairInfo pairInfo : replicaInfo.getPairInfos()) {
                String volumeUuid = pairInfo.getVolumeUuid();
                hyperUuidToSrcUuid.put(pairInfo.getDrVolumeUuid(), volumeUuid);
                if (OpenstackEnumDefine.VolProtectStatusE.UNPROTECTED.getStatus().equals(pairInfo.getVolumeStatus()) || hyperMetroProtectedPairInfoMap.keySet().contains(volumeUuid)) continue;
                hyperMetroProtectedPairInfoMap.put(volumeUuid, pairInfo);
            }
            PoReplicaInfo remoteReplicaInfo = (PoReplicaInfo)po.getProperty("remote_replicationInfo", PoReplicaInfo.class);
            if (null == remoteReplicaInfo) continue;
            for (PoReplicaPairInfo pairInfo : remoteReplicaInfo.getPairInfos()) {
                String hyperVolumeUuid = pairInfo.getVolumeUuid();
                String volumeUuid = (String)hyperUuidToSrcUuid.get(hyperVolumeUuid);
                if (OpenstackEnumDefine.VolProtectStatusE.UNPROTECTED.getStatus().equals(pairInfo.getVolumeStatus()) || remoteProtectedPairInfoMap.containsKey(volumeUuid)) continue;
                remoteProtectedPairInfoMap.put(volumeUuid, pairInfo);
            }
        }
        LOG.info((Object)"HyperMetroProtectedPairInfoMap:%s", new Object[]{hyperMetroProtectedPairInfoMap});
        LOG.info((Object)"RemoteProtectedPairInfoMap:%s", new Object[]{remoteProtectedPairInfoMap});
    }

    protected void getSrcUuidToRemoteVolumeMap(Map<String, PoReplicaPairInfo> newHyperMetroCreatePairInfoMap, Map<String, PoReplicaPairInfo> newVolUuidToCreatePairMap, ProtectGroup pg, Map<String, VolumeInfo> srcUuidToRemoteVolume, String tokenId, String drProjUuid) {
        HashMap<String, String> srcUudiToHyperUuid = new HashMap<String, String>();
        for (PoReplicaPairInfo poReplicaPairInfo : newHyperMetroCreatePairInfoMap.values()) {
            srcUudiToHyperUuid.put(poReplicaPairInfo.getVolumeUuid(), poReplicaPairInfo.getDrVolumeUuid());
        }
        HashMap<String, String> hyperUuidToRemoteUuid = new HashMap<String, String>();
        for (PoReplicaPairInfo tempPoReplicaPairInfo : newVolUuidToCreatePairMap.values()) {
            hyperUuidToRemoteUuid.put(tempPoReplicaPairInfo.getVolumeUuid(), tempPoReplicaPairInfo.getDrVolumeUuid());
        }
        String string = (String)pg.getProps().get("drRegionId");
        CinderManager cinderMgr = new CinderManager();
        for (Map.Entry entry : srcUudiToHyperUuid.entrySet()) {
            String srcUuid = (String)entry.getKey();
            String hyperUuid = (String)entry.getValue();
            String remoteUuid = (String)hyperUuidToRemoteUuid.get(hyperUuid);
            VolumeInfo remoteVol = cinderMgr.queryVolume(string, tokenId, drProjUuid, OpenStackCommonUtil.getIdFromUuid(remoteUuid));
            srcUuidToRemoteVolume.put(srcUuid, remoteVol);
        }
    }

    protected void getDrHyperUuidToDrVolumeInfoMap(Map<String, PoReplicaPairInfo> newCreatePairInfoMap, Map<String, String> drHyperUUIDTDrUUID, Map<String, String> drSUUIDToDrVolumeUUIDMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap, Map<String, List<ProtectObject>> needProtectDrVolUuidPoMap, Map<String, String> drDRUUIDToHyperMetroUUID) {
        for (PoReplicaPairInfo tempPoReplicaPairInfo : newCreatePairInfoMap.values()) {
            drHyperUUIDTDrUUID.put(drSUUIDToDrVolumeUUIDMap.get(tempPoReplicaPairInfo.getVolumeUuid()), tempPoReplicaPairInfo.getDrVolumeUuid());
            needProtectDrVolUuidPoMap.put(drSUUIDToDrVolumeUUIDMap.get(tempPoReplicaPairInfo.getVolumeUuid()), needProtectVolUuidPoMap.get(tempPoReplicaPairInfo.getVolumeUuid()));
            drDRUUIDToHyperMetroUUID.put(tempPoReplicaPairInfo.getDrVolumeUuid(), drSUUIDToDrVolumeUUIDMap.get(tempPoReplicaPairInfo.getVolumeUuid()));
        }
    }

    protected void getUsefulMapping(Map<String, PoReplicaPairInfo> newHyperMetroCreatePairInfoMap, List<String> drRemoteHyperMetroVolUUID, Map<String, String> drSUUIDToDrVolumeUUIDMap, Map<String, String> drVolTypeMap, Map<String, String> drRemoteHyperMetroVolTypeMap) {
        for (PoReplicaPairInfo tempPoReplicaPairInfo : newHyperMetroCreatePairInfoMap.values()) {
            drRemoteHyperMetroVolUUID.add(tempPoReplicaPairInfo.getDrVolumeUuid());
            drSUUIDToDrVolumeUUIDMap.put(tempPoReplicaPairInfo.getVolumeUuid(), tempPoReplicaPairInfo.getDrVolumeUuid());
            if (drVolTypeMap.get(tempPoReplicaPairInfo.getVolumeUuid()) != null) {
                drRemoteHyperMetroVolTypeMap.put(tempPoReplicaPairInfo.getDrVolumeUuid(), drVolTypeMap.get(tempPoReplicaPairInfo.getVolumeUuid()));
                continue;
            }
            LOG.error((Object)("Drvoltype is null, VolumeUuid=" + tempPoReplicaPairInfo.getVolumeUuid() + " , drVolTypes=" + drVolTypeMap.values()));
        }
    }

    protected void createHyperMetroReplication(ProtectGroup pg, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, Map<String, PoReplicaPairInfo> newHyperMetroCreatePairInfoMap, Map<String, OpenStackVolume> uuidVolMap, Map<String, String> drHyperMetroVolTypeMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap) {
        String upgradeType = (String)pg.getProps().get("BEFORE_UPGRADE_TYPE");
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue().equals(upgradeType)) {
            this.updatePoReplicaInfoMap(pg, poHyperMetroReplicaInfoMap, newHyperMetroCreatePairInfoMap);
        } else {
            pg.getProps().put("replicationModel", "hypermetro");
            Map<String, PoReplicaPairInfo> newCreateVolUuidToPairMap = this.protectVolumesForRing(pg, uuidVolMap, drHyperMetroVolTypeMap, poHyperMetroReplicaInfoMap, needProtectVolUuidPoMap, null);
            newHyperMetroCreatePairInfoMap.putAll(newCreateVolUuidToPairMap);
        }
        this.saveHyperCGID(pg, poHyperMetroReplicaInfoMap);
    }

    protected String getActiveSideReplicaStatus(ProtectGroup pg) {
        if ((34 == pg.getTemplate().getType() || 37 == pg.getTemplate().getType()) && !VerifyUtil.isEmpty((Collection)pg.getReplicaList()) && VerifyUtil.isEmpty((String)((String)pg.getProps().get("BEFORE_UPGRADE_TYPE")))) {
            String replicaStatus = OpenStackCommonUtil.getRealTimeCGReplicaStatus(pg);
            ArrayList<String> allowRepStatus = new ArrayList<String>();
            allowRepStatus.add(OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue());
            allowRepStatus.add(OpenstackEnumDefine.ReplicationRepStatusE.COPYING.getValue());
            allowRepStatus.add(OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue());
            if (!allowRepStatus.contains(replicaStatus)) {
                LOG.error((Object)("Add volume first cg replication error: replication status:" + replicaStatus + ", protectGroup name= " + pg.getName()));
                throw new LegoCheckedException(1073948462L);
            }
            LOG.info((Object)"Add po query repica status:%s, protectGroup name= %s", new Object[]{replicaStatus, pg.getName()});
            return replicaStatus;
        }
        return null;
    }

    protected boolean isNeedCreateRing(ProtectGroup pg, String upgradeType) {
        return VerifyUtil.isEmpty((Collection)pg.getReplicaList()) || !VerifyUtil.isEmpty((String)upgradeType);
    }

    protected void checkVolume(ProtectGroup pg, Map<String, String> drVolTypeMap, Map<String, String> drHyperMetroVolTypeMap) {
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Collection)pg.getPolist())) {
            LOG.error((Object)("Pg or polist is empty , protectGroup name=" + pg.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.checkDrVolTypeExist(pg, drVolTypeMap, drHyperMetroVolTypeMap)) {
            LOG.error((Object)("Drvoltype is empty,pgName=" + pg.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        LOG.debug((Object)"DrVolTypeMap:%s; drHyperMetroVolTypeMap:%s", new Object[]{drVolTypeMap, drHyperMetroVolTypeMap});
    }

    protected void updatePoReplicaInfoMap(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, PoReplicaPairInfo> newCreatePairInfoMap) {
        for (ProtectObject po : pg.getPolist()) {
            if (poReplicaInfoMap.containsKey(po.getUuid())) continue;
            String replicaInfoStr = (String)po.getProps().get("replicationInfo");
            PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
            if (null == replicaInfo) {
                LOG.error((Object)"Convert json failed:");
                continue;
            }
            poReplicaInfoMap.put(po.getUuid(), replicaInfo);
            ArrayList<PoReplicaPairInfo> protectedPairInfos = new ArrayList<PoReplicaPairInfo>();
            for (PoReplicaPairInfo info : replicaInfo.getPairInfos()) {
                if (OpenstackEnumDefine.VolProtectStatusE.UNPROTECTED.getStatus().equals(info.getVolumeStatus())) {
                    LOG.info((Object)"Volume %s is unprotected.", new Object[]{info.getVolumeUuid()});
                    continue;
                }
                protectedPairInfos.add(info);
                newCreatePairInfoMap.put(info.getVolumeUuid(), info);
            }
            replicaInfo.setPairInfos(protectedPairInfos);
        }
    }

    protected void mergeAndRollBack(Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, PoReplicaInfo> poDRReplicaInfoMap, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, ProtectGroup pg, Map<String, PoReplicaPairInfo> protectedPairInfoMap) {
        String beforeUpgradeType;
        boolean isUpgrade;
        if (this.isAddServer(pg)) {
            this.filterSharePoReplicaPairInfo(protectedPairInfoMap, poReplicaInfoMap, poHyperMetroReplicaInfoMap, poDRReplicaInfoMap);
        }
        boolean bl = isUpgrade = !VerifyUtil.isEmpty((String)(beforeUpgradeType = (String)pg.getProps().get("BEFORE_UPGRADE_TYPE")));
        if (!isUpgrade || ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue().equals(beforeUpgradeType)) {
            this.mergeShareVolume(poReplicaInfoMap);
        }
        this.mergeShareVolume(poDRReplicaInfoMap);
        if (!isUpgrade || ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(beforeUpgradeType)) {
            this.mergeShareVolume(poHyperMetroReplicaInfoMap);
        }
        this.startRollback(pg, poReplicaInfoMap, "hypermetorside", poDRReplicaInfoMap, poHyperMetroReplicaInfoMap);
    }

    protected void filterSharePoReplicaPairInfo(Map<String, PoReplicaPairInfo> protectedPairInfoMap, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, Map<String, PoReplicaInfo> poDRReplicaInfoMap) {
        for (String volUuid : protectedPairInfoMap.keySet()) {
            PoReplicaPairInfo pairInfo;
            Iterator iter;
            for (PoReplicaInfo poReplicaInfo : poReplicaInfoMap.values()) {
                Iterator iter2 = poReplicaInfo.getPairInfos().iterator();
                while (iter2.hasNext()) {
                    PoReplicaPairInfo pairInfo2 = (PoReplicaPairInfo)iter2.next();
                    if (!Objects.equals(pairInfo2.getVolumeUuid(), volUuid)) continue;
                    iter2.remove();
                }
            }
            HashMap<String, String> hyperUuidToSrcUuid = new HashMap<String, String>();
            for (PoReplicaInfo poReplicaInfo : poHyperMetroReplicaInfoMap.values()) {
                iter = poReplicaInfo.getPairInfos().iterator();
                while (iter.hasNext()) {
                    pairInfo = (PoReplicaPairInfo)iter.next();
                    hyperUuidToSrcUuid.put(pairInfo.getDrVolumeUuid(), pairInfo.getVolumeUuid());
                    if (!Objects.equals(pairInfo.getVolumeUuid(), volUuid)) continue;
                    iter.remove();
                }
            }
            for (PoReplicaInfo poReplicaInfo : poDRReplicaInfoMap.values()) {
                iter = poReplicaInfo.getPairInfos().iterator();
                while (iter.hasNext()) {
                    pairInfo = (PoReplicaPairInfo)iter.next();
                    String srcUuid = (String)hyperUuidToSrcUuid.get(pairInfo.getVolumeUuid());
                    if (!Objects.equals(srcUuid, volUuid)) continue;
                    iter.remove();
                }
            }
        }
    }

    protected void saveRemotePhInfo(Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, PoReplicaInfo> poDRReplicaInfoMap) {
        for (Map.Entry<String, PoReplicaInfo> entry : poReplicaInfoMap.entrySet()) {
            poDRReplicaInfoMap.get(entry.getKey()).setPhVmInfo(poReplicaInfoMap.get(entry.getKey()).getPhVmInfo());
        }
    }

    protected void createRing(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, Map<String, PoReplicaInfo> poDRReplicaInfoMap) {
        if (VerifyUtil.isEmpty(poReplicaInfoMap) && VerifyUtil.isEmpty(poHyperMetroReplicaInfoMap) && VerifyUtil.isEmpty(poDRReplicaInfoMap)) {
            return;
        }
        ArrayList<Callable<CreateRingTaskResult>> taskList = new ArrayList<Callable<CreateRingTaskResult>>();
        CreateRingTask createAtivetask = new CreateRingTask(this.getVolumeService(), pg, poReplicaInfoMap, "ring_active");
        taskList.add(createAtivetask);
        List<CreateRingTaskResult> createResultList = this.generateCreateRingTaskList(taskList);
        boolean result = VhaAsyncArrayReplicationReplicaBuilder.checkCreateRingResult(createResultList);
        if (!result) {
            LOG.error((Object)("Create active ring failed, protectGroup name=" + pg.getName()));
            throw new LegoCheckedException(1073948140L);
        }
        taskList.clear();
        CreateRingTask createHyperMetrotask = new CreateRingTask(this.getVolumeService(), pg, poHyperMetroReplicaInfoMap, "ring_hypermetor");
        taskList.add(createHyperMetrotask);
        CreateRingTask createStandbyMetortask = new CreateRingTask(this.getVolumeService(), pg, poDRReplicaInfoMap, "ring_standby");
        taskList.add(createStandbyMetortask);
        createResultList = this.generateCreateRingTaskList(taskList);
        result = VhaAsyncArrayReplicationReplicaBuilder.checkCreateRingResult(createResultList);
        if (!result) {
            LOG.error((Object)("Create hyperMetor and standby ring failed, protectGroup name=" + pg.getName()));
            throw new LegoCheckedException(1073948140L);
        }
    }

    protected List<CreateRingTaskResult> generateCreateRingTaskList(List<Callable<CreateRingTaskResult>> taskList) {
        int batchNum = LegoConfig.getInstance().getInt("batch.create.replicpair.size", () -> OpenStackCommonUtil.getNumFromResource("replication.oper.task.batch.num", 20));
        int timeout = OpenStackCommonUtil.getNumFromResource("replication.oper.task.timeout", 1800);
        LOG.info((Object)"Configuration of createRing Task task batch num=%s, timeout=%s, taskList size=%s", new Object[]{String.valueOf(batchNum), timeout, taskList.size()});
        return ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)timeout, (int)batchNum);
    }

    public static boolean checkCreateRingResult(List<CreateRingTaskResult> createResultList) {
        if (VerifyUtil.isEmpty(createResultList)) {
            LOG.debug((Object)"Enter checkCreateRingResult,createResultList is empty. ");
            return false;
        }
        boolean flag = true;
        for (CreateRingTaskResult result : createResultList) {
            if (result.isResultFlag()) continue;
            flag = false;
            break;
        }
        return flag;
    }

    protected Map<String, OpenStackVolume> getUuidVolMap(ProtectGroup pg, List<String> volUUIDList) {
        HashMap<String, OpenStackVolume> uuidVolMap = new HashMap<String, OpenStackVolume>();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        List volList = this.getVolumeService().queryVolumesByUuid(regionUuid, projUuid, volUUIDList, false);
        for (OpenStackVolume vol : volList) {
            uuidVolMap.put(vol.getUuid(), vol);
        }
        return uuidVolMap;
    }

    protected void afterCreatePairForHyperMetro(ProtectGroup pg, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, Set<ProtectObject> addPoSet) {
        ArrayList<Callable<PoReplicaInfo>> reattachTaskList = new ArrayList<Callable<PoReplicaInfo>>();
        ArrayList createVmTaskList = new ArrayList();
        for (ProtectObject po : addPoSet) {
            String poUuid = po.getUuid();
            PoReplicaInfo replicaInfo = poHyperMetroReplicaInfoMap.get(poUuid);
            if (VerifyUtil.isEmpty((Object)replicaInfo)) {
                LOG.error((Object)("After create hypermetro pair, reattach volume can't find protectObject replicationInfo,protectObject uuid=" + poUuid + ", protectGroup name=" + pg.getName()));
                continue;
            }
            ReattachVolumeTask task = new ReattachVolumeTask(replicaInfo);
            task.setIsHyperMetro(true);
            reattachTaskList.add(task);
            if (this.getType() != 37) continue;
            super.addTagToVm(replicaInfo);
            this.hypermetroreplicationreplicabuilder.addTagToVm(replicaInfo, "__type_csha");
            if (!OpenStackCommonUtil.isCurrentFCVersionHighThan63()) continue;
            String phvmId = (String)po.getProps().get("csha_occupied_vm");
            if (VerifyUtil.isEmpty((String)phvmId)) {
                LOG.error((Object)("Can't set phvmId, uuid=" + poUuid));
                continue;
            }
            createVmTaskList.add(new ConfigPhVmTask(replicaInfo, phvmId, ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue(), pg.getName()));
        }
        int batchNum = OpenStackCommonUtil.getNumFromResource("replication.oper.task.batch.num", 20);
        int timeout = OpenStackCommonUtil.getNumFromResource("replication.oper.task.timeout", 1800);
        super.reattach(reattachTaskList, batchNum, timeout);
        if (VerifyUtil.isEmpty(createVmTaskList)) {
            LOG.info((Object)"CreateVmTaskList is empty");
            return;
        }
        OpenStackCommonUtil.executeTask(createVmTaskList, ExecutionService.ExecuteType.FAILED_ABORT, true);
    }

    protected void updateProp(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, OpenStackVolume> uuidVolMap, Map<String, String> drVolTypeMap, Map<String, String> drHyperMetroVolTypeMap) {
        String aSrcVolTypeName = ((OpenStackVolume)CommonUtil.getFirstElement(uuidVolMap.values())).getVolType();
        String aDrVolTypeName = (String)CommonUtil.getFirstElement(drVolTypeMap.values());
        String aHyperMetroDrVolTypeName = (String)CommonUtil.getFirstElement(drHyperMetroVolTypeMap.values());
        this.updatePgProp(pg, aSrcVolTypeName, aDrVolTypeName, aHyperMetroDrVolTypeName);
        this.updatePoProp(pg, poReplicaInfoMap, uuidVolMap);
    }

    public int getType() {
        return 34;
    }

    @Override
    public String getReplicaModel(ProtectGroup protectGroup) {
        String replicationMode = (String)protectGroup.getProps().get("replicationModel");
        LOG.info((Object)"VhaAsyn replication builder get replicationmode=%s, protectGroup name=%s", new Object[]{replicationMode, protectGroup.getName()});
        return replicationMode;
    }

    @Override
    public int getProtectType() {
        return 2;
    }
}

