/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenStackVMActionEnum;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class AbStractPhVmTask {
    private static final Log LOG = LogFactory.getInstance(AbStractPhVmTask.class);
    private PoReplicaInfo replicaInfo;
    private String drRegionUuid;
    private String drProjectUuid;
    private String instanceType;
    private String protectGroupName;

    public PoReplicaInfo getReplicaInfo() {
        return this.replicaInfo;
    }

    public void setReplicaInfo(PoReplicaInfo replicaInfo) {
        this.replicaInfo = replicaInfo;
    }

    public String getDrRegionUuid() {
        return this.drRegionUuid;
    }

    public void setDrRegionUuid(String drRegionUuid) {
        this.drRegionUuid = drRegionUuid;
    }

    public String getDrProjectUuid() {
        return this.drProjectUuid;
    }

    public void setDrProjectUuid(String drProjectUuid) {
        this.drProjectUuid = drProjectUuid;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getProtectGroupName() {
        return this.protectGroupName;
    }

    public void setProtectGroupName(String protectGroupName) {
        this.protectGroupName = protectGroupName;
    }

    protected void lockVm(String vmUuid) {
        String tokenId;
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.drRegionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        AsyncTaskResponse response = novaMgr.lockVm(this.drRegionUuid, tokenId = TokenUtil.getInstance().getRegionTokenId(this.drRegionUuid, this.drProjectUuid), this.drProjectUuid, vmUuid);
        if (!response.isSuccess()) {
            LOG.error((Object)"Lock vm failed:vmuuid=%s", new Object[]{vmUuid});
            throw new LegoCheckedException(1073948108L);
        }
        novaMgr.addTagToVm(this.drRegionUuid, tokenId, this.drProjectUuid, vmUuid, "__type_dr");
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue().equals(this.getInstanceType()) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(this.getInstanceType())) {
            novaMgr.addTagToVm(this.drRegionUuid, tokenId, this.drProjectUuid, vmUuid, "__type_csha");
        }
    }

    protected void deletePorts(OpenStackVM vm) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.drRegionUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(this.drRegionUuid, this.drProjectUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        INeutronManager networkMgr = ManagerFactory.getInstance().getNeutronManager(openstackUuid);
        List phVmPortList = this.replicaInfo.getPhVmInfo().getPortIdList();
        LOG.info((Object)"Start delete ports.the size of port in PhVmInfo is:%s, vmId:%s, vmName=%s, protectGroup name=%s", new Object[]{phVmPortList.size(), vm.getUuid(), vm.getName(), this.getProtectGroupName()});
        Iterator iterator = phVmPortList.iterator();
        while (iterator.hasNext()) {
            String portId = (String)iterator.next();
            AsyncTaskResponse response = novaMgr.detachPortFromVM(portId, vm.getUuid(), this.drProjectUuid, this.drRegionUuid, tokenId);
            if (!response.isSuccess()) {
                LOG.error((Object)"Detach port failed:portId=%s, vmName=%s, vmId=%s, protectGroup name=%s", new Object[]{portId, vm.getName(), vm.getUuid(), this.getProtectGroupName()});
                throw new LegoCheckedException(1073948912L);
            }
            CommonUtil.sleep((long)3000L);
            response = networkMgr.deletePort(this.drRegionUuid, tokenId, portId);
            if (!response.isSuccess()) {
                LOG.info((Object)"Delete port failed:portId=%s, vmName=%s, vmId=%s, protectGroup name=%s", new Object[]{portId, vm.getName(), vm.getUuid(), this.getProtectGroupName()});
                continue;
            }
            iterator.remove();
        }
    }

    protected void deleteBootVolume(String vmUuid, String volumeId) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.drRegionUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(this.drRegionUuid, this.drProjectUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        AsyncTaskResponse detachResonse = novaMgr.detachVolFromVm(tokenId, this.drProjectUuid, this.drRegionUuid, vmUuid, "ECS", volumeId);
        if (!detachResonse.isSuccess()) {
            LOG.error((Object)"Detach boot volume failed:vmUuid=%s, volumeId=%s", new Object[]{vmUuid, volumeId});
            throw new LegoCheckedException(1073948107L);
        }
        ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        AsyncTaskResponse response = cinderMgr.deleteVolume(volumeId, this.drRegionUuid, tokenId, this.drProjectUuid);
        if (!response.isSuccess()) {
            LOG.error((Object)"Delete the temp boot volume failed:volumeId=%s", new Object[]{volumeId});
            return;
        }
        this.replicaInfo.getPhVmInfo().setBootVolumeUuid("");
    }

    protected void shutdownVm(String vmUuid) {
        String tokenId;
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.drRegionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        AsyncTaskResponse response = novaMgr.vmAction(vmUuid, this.drProjectUuid, this.drRegionUuid, tokenId = TokenUtil.getInstance().getRegionTokenId(this.drRegionUuid, this.drProjectUuid), OpenStackVMActionEnum.STOP);
        if (!response.isSuccess()) {
            LOG.error((Object)"Shutdown vm(%s) failed,errorCode is %s.", new Object[]{vmUuid, response.getErrorCode()});
            throw new LegoCheckedException(1073948363L);
        }
    }

    public static boolean isSwitchNetwork(String regionId) {
        List regions = CommonDAOLocator.getMoDao().getMoList(OpenStackRegion.class, "uuid", (Object)regionId);
        if (VerifyUtil.isEmpty((Collection)regions)) {
            LOG.error((Object)"Openstack region is not exist.regionId=%s", new Object[]{regionId});
            throw new LegoCheckedException(1073947393L);
        }
        return ((OpenStackRegion)CommonUtil.getFirstElement((Collection)regions)).getRegionConfig().getIsSwitchNetwork();
    }
}

