/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.openstack.tools.model.DelTagParam;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public class DelReplicationTask
implements Callable<PoReplicaPairInfo>,
Runnable {
    private static final Log LOG = LogFactory.getInstance(DelReplicationTask.class);
    public static final List<String> NO_ALLOWDELETE_STATUS = Collections.unmodifiableList(Arrays.asList(ServiceInstaceEnumDefine.ServiceInstanceStatusE.MAINTAIN.getValue(), ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_COMPLETED.getValue(), ServiceInstaceEnumDefine.ServiceInstanceStatusE.DISASTER_RECOVERY_FAILED.getValue(), ServiceInstaceEnumDefine.ServiceInstanceStatusE.PLANED_MIGRATION_FAILED.getValue(), ServiceInstaceEnumDefine.ServiceInstanceStatusE.PLANED_MIGRATION_COMPLETED.getValue(), ServiceInstaceEnumDefine.ServiceInstanceStatusE.REPROTECT_FAILED.getValue(), ServiceInstaceEnumDefine.ServiceInstanceStatusE.HOT_MIGRATION_FAILED.getValue()));
    private IVolumeService volumeService;
    private ProtectGroup pg;
    private final PoReplicaPairInfo pairInfo;
    private String replicationSide;
    private DelTagParam delTagParam = new DelTagParam();

    public DelReplicationTask(IVolumeService service, PoReplicaPairInfo pairInfo, ProtectGroup pg, String replicationSide) {
        this.pg = pg;
        this.volumeService = service;
        this.pairInfo = pairInfo;
        this.replicationSide = replicationSide;
    }

    @Override
    public PoReplicaPairInfo call() {
        this.run();
        return this.pairInfo;
    }

    @Override
    public void run() {
        String projId = (String)this.pg.getProps().get("projectId");
        String regionId = (String)this.pg.getProps().get("regionId");
        String drProjId = (String)this.pg.getProps().get("drProjectId");
        String drRegionId = (String)this.pg.getProps().get("drRegionId");
        boolean isHyperMetorSide = this.replicationSide != null && "hypermetorside".equals(this.replicationSide);
        boolean isReprotect = this.isReprotect(regionId);
        drProjId = isHyperMetorSide && isReprotect ? projId : drProjId;
        drRegionId = isHyperMetorSide && isReprotect ? regionId : drRegionId;
        projId = isHyperMetorSide && !isReprotect ? drProjId : projId;
        regionId = isHyperMetorSide && !isReprotect ? drRegionId : regionId;
        String splitFlag = (String)this.pg.getProps().get("PG_PROP_REPLICATION_SPLIT_KEY");
        String beforeStutas = (String)this.pg.getProps().get("before_delete_instance_status");
        LOG.debug((Object)"Delete replication pairInfo:%s,prodProjectId=%s,prodRegionId=%s,drProjectId=%s,drRegionId=%s,splitFlag=%s,instance Stutas=%s,isHyperMetorSide=%s,isReprotect=%s,protectGroup name=%s", new Object[]{this.pairInfo, projId, projId, drProjId, drRegionId, splitFlag, beforeStutas, isHyperMetorSide, isReprotect, this.pg.getName()});
        if (OpenstackEnumDefine.VolProtectStatusE.UNPROTECTED.getStatus().equals(this.pairInfo.getVolumeStatus())) {
            LOG.info((Object)"Delete replication. pairInfo:%s is unprotectd, protectGroup name=%s", new Object[]{this.pairInfo, this.pg.getName()});
            return;
        }
        try {
            this.deleteProdAndDrReplica(projId, regionId, drProjId, drRegionId, splitFlag);
            if (this.replicationSide != null && "standbyside".equals(this.replicationSide)) {
                LOG.info((Object)"Delete standby side and do not delete DR volume. replicationSide:%s,protectGroup name=%s", new Object[]{this.replicationSide, this.pg.getName()});
                return;
            }
            this.deleteVolumeMetadata(regionId, projId, drRegionId, drProjId);
            if (this.replicationSide != null && "activeside".equals(this.replicationSide) && !isReprotect) {
                LOG.info((Object)"ProtectGroup haved finished reprotected.Delete active side and do not delete DR volume. replicationSide:%s,protectGroup name=%s", new Object[]{this.replicationSide, this.pg.getName()});
                return;
            }
            this.delVolume(drProjId, drRegionId, isHyperMetorSide, isReprotect, splitFlag, beforeStutas);
            this.tryUnreverseAllVolume(beforeStutas, regionId, projId, drRegionId, drProjId);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Delete replication task execute failed,protectGroup name=%s, pairInfo=%s", new Object[]{this.pg.getName(), this.pairInfo});
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Delete replication task execute failed,protectGroup name=%s, pairInfo=%s", new Object[]{this.pg.getName(), this.pairInfo});
            ExceptionUtil.rethrowException((Throwable)e, (String)"task execute failed:", (long)1073948412L, (String[])new String[0], (Log)LOG);
        }
    }

    private void delVolume(String drProjId, String drRegionId, boolean isHyperMetorSide, boolean isReprotect, String splitFlag, String beforeStutas) {
        boolean isAllowStatus = this.checkIsAllowStatus(drProjId, drRegionId, beforeStutas);
        if (!VerifyUtil.isEmpty((String)this.pairInfo.getDrVolumeUuid()) && !Boolean.toString(true).equals(splitFlag) && isAllowStatus) {
            LOG.debug((Object)"Start delete disater volume.volume id=%s,protectGroup name=%s", new Object[]{this.pairInfo.getDrVolumeUuid(), this.pg.getName()});
            this.volumeService.delVolume(this.pairInfo.getDrVolumeUuid(), drRegionId, drProjId);
        }
        if (isHyperMetorSide && !VerifyUtil.isEmpty((String)this.pairInfo.getVolumeUuid()) && !Boolean.toString(true).equals(splitFlag) && isAllowStatus && !isReprotect) {
            VolumeInfo volumeInfo = this.volumeService.queryVolumeInfoByUuid(drRegionId, drProjId, this.pairInfo.getVolumeUuid());
            if (null != volumeInfo && !volumeInfo.isBootable()) {
                LOG.debug((Object)"ProtectGroup type is hyperMetro_replication.start delete hyperMetro productin volume.volume id=%s,protectGroup name=%s", new Object[]{this.pairInfo.getVolumeUuid(), this.pg.getName()});
                this.volumeService.delVolume(this.pairInfo.getVolumeUuid(), drRegionId, drProjId);
            } else {
                LOG.debug((Object)"Boot volume no need delte.volume id=%s,protectGroup name=%s", new Object[]{this.pairInfo.getVolumeUuid(), this.pg.getName()});
            }
        }
    }

    private boolean checkIsAllowStatus(String drProjId, String drRegionId, String beforeStutas) {
        VolumeInfo volumeInfo;
        String instanceType;
        boolean isAllowStatus;
        boolean bl = isAllowStatus = !NO_ALLOWDELETE_STATUS.contains(beforeStutas);
        if (isAllowStatus && (ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.isCurrent(instanceType = (String)this.pg.getProps().get("serviceInstanceType")) || (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.isCurrent(instanceType) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.isCurrent(instanceType)) && "activeside".equals(this.replicationSide)) && null != (volumeInfo = this.volumeService.queryVolumeInfoByUuid(drRegionId, drProjId, this.pairInfo.getDrVolumeUuid())) && volumeInfo.isBootable()) {
            LOG.debug((Object)"Boot volume no need delete.volume id=%s,protectGroup name=%s", new Object[]{this.pairInfo.getDrVolumeUuid(), this.pg.getName()});
            isAllowStatus = false;
        }
        return isAllowStatus;
    }

    private void deleteProdAndDrReplica(String projId, String regionId, String drProjId, String drRegionId, String splitFlag) {
        if (!VerifyUtil.isEmpty((String)this.pairInfo.getReplicaUuid())) {
            LOG.debug((Object)"Start delete production replication.replicationid=%s,protectGroup name=%s", new Object[]{this.pairInfo.getReplicaUuid(), this.pg.getName()});
            this.deleteReplica(projId, regionId, this.pairInfo.getReplicaUuid(), splitFlag);
        }
        if (!VerifyUtil.isEmpty((String)this.pairInfo.getDrReplicaUuid())) {
            LOG.debug((Object)"Start delete disaster replication.replicationid=%s,protectGroup name=%s", new Object[]{this.pairInfo.getDrReplicaUuid(), this.pg.getName()});
            this.deleteReplica(drProjId, drRegionId, this.pairInfo.getDrReplicaUuid(), splitFlag);
        }
    }

    private void deleteVolumeMetadata(String regionId, String projId, String drRegionId, String drProjId) {
        if (!VerifyUtil.isEmpty((String)this.pairInfo.getVolumeUuid()) && this.delTagParam.isDelPrdVol()) {
            LOG.debug((Object)"Start delete production volume metadata.volume id=%s,protectGroup name=%s", new Object[]{this.pairInfo.getVolumeUuid(), this.pg.getName()});
            this.volumeService.deleteVolMetadatas(regionId, projId, OpenStackCommonUtil.getIdFromUuid(this.pairInfo.getVolumeUuid()), "occupied_volume");
        }
        if (!VerifyUtil.isEmpty((String)this.pairInfo.getDrVolumeUuid()) && this.delTagParam.isDelPhVol()) {
            LOG.debug((Object)"Start delete disaster volume metadata.volume id=%s,protectGroup name=%s", new Object[]{this.pairInfo.getDrVolumeUuid(), this.pg.getName()});
            this.volumeService.deleteVolMetadatas(drRegionId, drProjId, OpenStackCommonUtil.getIdFromUuid(this.pairInfo.getDrVolumeUuid()), "occupied_volume");
        }
    }

    private boolean isReprotect(String regionId) {
        String originalRegionUuid = (String)this.pg.getProps().get("originalAvailableRegion");
        return regionId.equals(originalRegionUuid);
    }

    private void deleteReplica(String projId, String regionId, String replicaUuid, String splitFlag) {
        block2: {
            try {
                this.volumeService.delVolReplica(regionId, projId, replicaUuid, false, false);
            }
            catch (LegoCheckedException e) {
                if (Boolean.toString(true).equals(splitFlag)) break block2;
                throw e;
            }
        }
        LOG.info((Object)"Start single delete replication:replicaUuid=%s", new Object[]{replicaUuid});
        this.volumeService.delVolReplica(regionId, projId, replicaUuid, true, true);
    }

    private void tryUnreverseAllVolume(String beforeStutas, String regionId, String projId, String drRegionId, String drProjId) {
        if (!NO_ALLOWDELETE_STATUS.contains(beforeStutas)) {
            return;
        }
        if (!VerifyUtil.isEmpty((String)this.pairInfo.getVolumeUuid())) {
            LOG.debug((Object)"Start tryUnreverseVolume volume.volume id=%s,protectGroup name=%s", new Object[]{this.pairInfo.getVolumeUuid(), this.pg.getName()});
            this.tryUnreverseVolume(regionId, projId, OpenStackCommonUtil.getIdFromUuid(this.pairInfo.getVolumeUuid()));
        }
        if (!VerifyUtil.isEmpty((String)this.pairInfo.getDrVolumeUuid())) {
            LOG.debug((Object)"Start tryUnreverseVolume volume.volume id=%s,protectGroup name=%s", new Object[]{this.pairInfo.getDrVolumeUuid(), this.pg.getName()});
            this.tryUnreverseVolume(drRegionId, drProjId, OpenStackCommonUtil.getIdFromUuid(this.pairInfo.getDrVolumeUuid()));
        }
    }

    private void tryUnreverseVolume(String regionId, String projId, String volumeUuid) {
        try {
            VolumeInfo volumeInfo = this.volumeService.queryVolumeInfoByUuid(regionId, projId, volumeUuid);
            if (VerifyUtil.isEmpty((Object)volumeInfo)) {
                LOG.debug((Object)"No need unreverse volume:%s,protectGroup name=%s", new Object[]{volumeUuid, this.pg.getName()});
                return;
            }
            if (!OpenstackEnumDefine.VolumeStatusE.ATTACHING.getType().equals(volumeInfo.getStatus())) {
                LOG.debug((Object)"No need unreverse volume:%s,protectGroup name=%s", new Object[]{volumeUuid, this.pg.getName()});
                return;
            }
            this.volumeService.unreserveVolume(OpenStackCommonUtil.getIdFromUuid(volumeUuid), regionId, projId);
            this.volumeService.deleteVolMetadatas(regionId, projId, OpenStackCommonUtil.getIdFromUuid(volumeUuid), "occupied_volume");
        }
        catch (Exception e) {
            LOG.error((Object)"Error for tryUnreverseVolume volume:%s,protectGroup name=%s, erroMsg:%s", new Object[]{volumeUuid, this.pg.getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public IVolumeService getVolumeService() {
        return this.volumeService;
    }

    public void setVolumeService(IVolumeService volumeService) {
        this.volumeService = volumeService;
    }

    public ProtectGroup getPg() {
        return this.pg;
    }

    public void setPg(ProtectGroup pg) {
        this.pg = pg;
    }

    public PoReplicaPairInfo getPairInfo() {
        return this.pairInfo;
    }

    public void setDelTagParam(DelTagParam delTagParam) {
        this.delTagParam = delTagParam;
    }
}

