/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.precheck;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.PropsUtil;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.protection.service.AbStractPhVmTask;
import com.huawei.ism.drm.openstack.recovery.observer.RecoveryPlanOperateObserver;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapShotInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.process.IRecoveryPreChecker;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class HotMigrationRecoveryPreChecker
implements IRecoveryPreChecker {
    private static final Log LOGGER = LogFactory.getInstance(HotMigrationRecoveryPreChecker.class);

    public void check(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        Set protectGroups = plan.getProtectGroups();
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            LOGGER.warn((Object)"there is no protectgroup in recovery plan:%s", new Object[]{plan.getName()});
            return;
        }
        this.tryLockInstance(protectGroups, execType);
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION != execType && DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION != execType) {
            return;
        }
        for (ProtectGroup pg : protectGroups) {
            PolicyTemplate policyTemplate = pg.getTemplate();
            if (VerifyUtil.isEmpty((Object)policyTemplate) || !PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg)) continue;
            this.check(plan, execType, pg);
        }
    }

    private void tryLockInstance(Set<ProtectGroup> protectGroups, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        for (ProtectGroup pg : protectGroups) {
            PolicyTemplate policyTemplate = pg.getTemplate();
            if (!PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(policyTemplate.getType()) || this.noNeedPreCheckLock(pg, policyTemplate, execType)) continue;
            String instanceId = (String)pg.getProps().get("SERVICEINSTANCE_UUID");
            if (VerifyUtil.isEmpty((String)instanceId)) {
                LOGGER.info((Object)"Pg:%s instanceId is null", new Object[]{pg.getName()});
                continue;
            }
            ServiceInstanceHelper instanceHelper = ServiceInstanceHelper.getInstance();
            if (!instanceHelper.getLock(instanceId)) {
                LOGGER.error((Object)"Get instance(%s) lock faild.", new Object[]{instanceId});
                throw new LegoCheckedException(1073948693L);
            }
            instanceHelper.releaseLock(instanceId);
        }
    }

    private boolean noNeedPreCheckLock(ProtectGroup pg, PolicyTemplate policyTemplate, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        String regionUuid = pg.getProperty("regionId");
        if ((DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY == execType || DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT == execType) && RecoveryPlanOperateObserver.isAutoExe(OpenStackBasicUtil.getIdFromUuid(regionUuid))) {
            if (policyTemplate.getType() == 25) {
                return true;
            }
            if (policyTemplate.getType() == 37 && "REGION_TYPE_WITHIN".equals(pg.getProperty("RECOVERY_REGION_TYPE"))) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, ProtectGroup pg) {
        LOGGER.info((Object)"Start precheck recovery plan:%s", new Object[]{plan.getName()});
        ServiceInstanceHelper instanceHelper = ServiceInstanceHelper.getInstance();
        String instanceId = (String)pg.getProps().get("SERVICEINSTANCE_UUID");
        if (VerifyUtil.isEmpty((String)instanceId)) {
            LOGGER.info((Object)"Pg:%s instanceId is null", new Object[]{pg.getName()});
            return;
        }
        if (!instanceHelper.getLock(instanceId)) {
            LOGGER.error((Object)"Get instance(%s) lock faild.", new Object[]{instanceId});
            throw new LegoCheckedException(1073948693L);
        }
        long startTime = System.currentTimeMillis();
        try {
            OpenstackCache.run(() -> {
                if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION == execType) {
                    this.checkPlanedMotion(pg, plan);
                } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION == execType) {
                    this.checkHotMigration(pg, plan);
                }
                return true;
            });
            instanceHelper.releaseLock(instanceId);
        }
        catch (Throwable throwable) {
            instanceHelper.releaseLock(instanceId);
            long endTime = System.currentTimeMillis();
            LOGGER.info((Object)"hot migration precheck cost:%s ms", new Object[]{String.valueOf(endTime - startTime)});
            throw throwable;
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info((Object)"hot migration precheck cost:%s ms", new Object[]{String.valueOf(endTime - startTime)});
    }

    private void checkPlanedMotion(ProtectGroup pg, RecoveryPlan plan) {
        if (VerifyUtil.isEmpty((String)plan.getProperty("HOT_MIGRATION_VMS"))) {
            LOGGER.info((Object)"No need checkPlanedMotion, plan:%s", new Object[]{plan.getName()});
            return;
        }
        HashSet<String> vmUuidSet = new HashSet<String>();
        HashSet<String> prdVolumeUuIdSet = new HashSet<String>();
        HashSet<String> allVolumeUuIdSet = new HashSet<String>();
        this.fillSet(pg, vmUuidSet, prdVolumeUuIdSet, allVolumeUuIdSet);
        String regionUuId = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String drAzName = (String)pg.getProps().get("drZoneName");
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            drAzName = (String)pg.getProps().get("prod_region_drZoneName");
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuId, projUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        List<OpenStackVM> vmList = novaMgr.getVms(regionUuId, tokenId, projUuid);
        HashMap vmUuidMap = new HashMap();
        vmList.forEach(vm -> vmUuidMap.put(vm.getUuid(), vm));
        ArrayList<String> migratingNameList = new ArrayList<String>();
        boolean allInDrAz = true;
        HashSet<String> hotMigrationVms = new HashSet<String>();
        for (String vmUuid : vmUuidSet) {
            OpenStackVM openStackVM = (OpenStackVM)vmUuidMap.get(vmUuid);
            if (!VerifyUtil.isEmpty((Object)openStackVM)) {
                if (Integer.valueOf(OpenstackEnumDefine.VmStatusE.MIGRATING.getValue()).equals(openStackVM.getStatus())) {
                    migratingNameList.add(openStackVM.getName());
                }
                if (drAzName.equals(openStackVM.getAzName())) {
                    hotMigrationVms.add(vmUuid);
                    continue;
                }
                allInDrAz = false;
                continue;
            }
            LOGGER.error((Object)"Vm:%s not found.", new Object[]{vmUuid});
            throw new LegoCheckedException(2117645L, String.format(Locale.ROOT, "vm:%s not exist", vmUuid));
        }
        this.checkAndSetPlanProps(plan, drAzName, migratingNameList, allInDrAz, hotMigrationVms);
    }

    private void checkAndSetPlanProps(RecoveryPlan plan, String drAzName, List<String> migratingNameList, boolean allInDrAz, Set<String> hotMigrationVms) {
        if (!VerifyUtil.isEmpty(migratingNameList)) {
            LOGGER.error((Object)"Vm:%s is migrating.", new Object[]{migratingNameList.toString()});
            throw new LegoCheckedException(1073949704L, new String[]{migratingNameList.toString()});
        }
        if (allInDrAz) {
            LOGGER.error((Object)"All vm in dr az:%s", new Object[]{drAzName});
            throw new LegoCheckedException(1073949703L);
        }
        LOGGER.info((Object)"HotMigrationVms are %s", new Object[]{hotMigrationVms});
        if (!VerifyUtil.isEmpty(hotMigrationVms)) {
            plan.setProperty("HOT_MIGRATION_VMS", (Object)JsonUtil.beanToJson(hotMigrationVms));
        } else {
            plan.getProps().remove("HOT_MIGRATION_VMS");
        }
    }

    private void checkHotMigration(ProtectGroup pg, RecoveryPlan plan) {
        String regionUuId = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String instanceId = (String)pg.getProps().get("SERVICEINSTANCE_UUID");
        if (VerifyUtil.isEmpty((String)instanceId)) {
            LOGGER.info((Object)"Pg:%s instanceId is null", new Object[]{pg.getName()});
            return;
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        ServiceInstanceHelper.getInstance().checkServiceInstPoInfo(instance);
        boolean isSwitchNetwork = AbStractPhVmTask.isSwitchNetwork(regionUuId);
        if (!isSwitchNetwork) {
            LOGGER.error((Object)"Region:%s not open switchNetwork", new Object[]{regionUuId});
            throw new LegoCheckedException(1073949698L, new String[]{OpenStackCommonUtil.getIdFromUuid(regionUuId)});
        }
        HashSet<String> vmUuidSet = new HashSet<String>();
        HashSet<String> prdVolumeUuIdSet = new HashSet<String>();
        HashSet<String> allVolumeUuIdSet = new HashSet<String>();
        this.fillSet(pg, vmUuidSet, prdVolumeUuIdSet, allVolumeUuIdSet);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuId, projUuid);
        OpenstackCache.preloadVmAndVolumeAndSnapshot(pg.getProps());
        this.vmCheck(pg, regionUuId, projUuid, vmUuidSet, openstackUuid, tokenId);
        Map<String, OpenStackVolume> volumeUuidMap = this.volumeCheck(regionUuId, projUuid, prdVolumeUuIdSet);
        ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        List<VolumeSnapShotInfo> volSnapShotList = cinderMgr.queryVolumeSnapShots(regionUuId, tokenId, projUuid, null);
        this.snapshotCheck(allVolumeUuIdSet, volumeUuidMap, volSnapShotList);
        if (!VerifyUtil.isEmpty(vmUuidSet)) {
            LOGGER.info((Object)"HotMigrationVms are %s", new Object[]{vmUuidSet});
            String vmSetStr = JsonUtil.beanToJson(vmUuidSet);
            PropsUtil.insertOrUpdateProp((PropsUtil.PropModel)PropsUtil.PropModel.RECOVERYPLAN, (String)plan.getPlanId(), (String)"HOT_MIGRATION_VMS", (String)vmSetStr);
            plan.setProperty("HOT_MIGRATION_VMS", (Object)vmSetStr);
        } else {
            PropsUtil.deleteProp((PropsUtil.PropModel)PropsUtil.PropModel.RECOVERYPLAN, (String)plan.getPlanId(), (String)"HOT_MIGRATION_VMS");
            plan.getProps().remove("HOT_MIGRATION_VMS");
        }
    }

    private void fillSet(ProtectGroup pg, Set<String> vmUuidSet, Set<String> prdVolumeUuIdSet, Set<String> allVolumeUuIdSet) {
        for (ProtectObject po : pg.getPolist()) {
            vmUuidSet.add(po.getMoUuid());
            PoReplicaInfo poReplicaInfo = (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class);
            if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
                poReplicaInfo = (PoReplicaInfo)po.getProperty("hypermetor_replicationInfo", PoReplicaInfo.class);
            }
            if (VerifyUtil.isEmpty((Object)poReplicaInfo)) continue;
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                String volumeUuid = pairInfo.getVolumeUuid();
                String drVolumeUuid = pairInfo.getDrVolumeUuid();
                if (!VerifyUtil.isEmpty((String)volumeUuid)) {
                    prdVolumeUuIdSet.add(volumeUuid);
                    allVolumeUuIdSet.add(volumeUuid);
                }
                if (VerifyUtil.isEmpty((String)drVolumeUuid)) continue;
                allVolumeUuIdSet.add(drVolumeUuid);
            }
        }
    }

    private void vmCheck(ProtectGroup pg, String regionUuId, String projUuid, Set<String> vmUuidSet, String openstackUuid, String tokenId) {
        ArrayList<String> bmsNameList = new ArrayList<String>();
        for (ProtectObject po : pg.getPolist()) {
            if (!"BMS".equals(po.getProps().get("vm_type"))) continue;
            bmsNameList.add(po.getName());
        }
        if (!VerifyUtil.isEmpty(bmsNameList)) {
            LOGGER.error((Object)"vm:%s is BMS.", new Object[]{((Object)bmsNameList).toString()});
            throw new LegoCheckedException(1073949699L, new String[]{((Object)bmsNameList).toString()});
        }
        ArrayList notActiveNameList = new ArrayList();
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        List<OpenStackVM> vmList = novaMgr.getVms(regionUuId, tokenId, projUuid);
        HashMap vmUuidMap = new HashMap();
        vmList.forEach(vm -> vmUuidMap.put(vm.getUuid(), vm));
        vmUuidSet.forEach(vmUuid -> {
            OpenStackVM openStackVM = (OpenStackVM)vmUuidMap.get(vmUuid);
            if (VerifyUtil.isEmpty((Object)openStackVM)) {
                LOGGER.error((Object)"Vm:%s not found.", new Object[]{vmUuid});
                throw new LegoCheckedException(2117645L, String.format(Locale.ROOT, "vm:%s not exist", vmUuid));
            }
            if (OpenStackCommonUtil.isBareMetalServer(openStackVM)) {
                bmsNameList.add(openStackVM.getName());
            }
            if (!Integer.valueOf(OpenstackEnumDefine.VmStatusE.ACTIVE.getValue()).equals(openStackVM.getStatus())) {
                LOGGER.error((Object)"Vm:%s status:%s not active.", new Object[]{openStackVM.getName(), openStackVM.getStatus()});
                notActiveNameList.add(openStackVM.getName());
            }
        });
        if (!VerifyUtil.isEmpty(bmsNameList)) {
            LOGGER.error((Object)"Vm:%s is BMS.", new Object[]{((Object)bmsNameList).toString()});
            throw new LegoCheckedException(1073949699L, new String[]{((Object)bmsNameList).toString()});
        }
        if (!VerifyUtil.isEmpty(notActiveNameList)) {
            LOGGER.error((Object)"Vm:%s are not active.", new Object[]{((Object)notActiveNameList).toString()});
            throw new LegoCheckedException(1073949702L, new String[]{((Object)notActiveNameList).toString()});
        }
    }

    private Map<String, OpenStackVolume> volumeCheck(String regionUuId, String projUuid, Set<String> volumeUuIdSet) {
        ArrayList sharedVolumeList = new ArrayList();
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List volumeList = volumeService.queryVolumesByUuid(regionUuId, projUuid, new ArrayList<String>(volumeUuIdSet), false);
        HashMap<String, OpenStackVolume> volumeUuidMap = new HashMap<String, OpenStackVolume>();
        volumeList.forEach(volume -> volumeUuidMap.put(volume.getUuid(), (OpenStackVolume)volume));
        volumeUuIdSet.forEach(volumeUuId -> {
            OpenStackVolume volume = (OpenStackVolume)volumeUuidMap.get(volumeUuId);
            if (VerifyUtil.isEmpty((Object)volume)) {
                LOGGER.error((Object)"Volume:%s not found.", new Object[]{volumeUuId});
                throw new LegoCheckedException(2117645L, String.format(Locale.ROOT, "volume:%s not exist", volumeUuId));
            }
            if (Boolean.TRUE.equals(volume.getMulitattach())) {
                sharedVolumeList.add(volume.getName());
            }
        });
        if (!VerifyUtil.isEmpty(sharedVolumeList)) {
            LOGGER.error((Object)"Volume:%s is shared volume.", new Object[]{((Object)sharedVolumeList).toString()});
            throw new LegoCheckedException(1073949700L, new String[]{((Object)sharedVolumeList).toString()});
        }
        return volumeUuidMap;
    }

    private void snapshotCheck(Set<String> volumeUuIdSet, Map<String, OpenStackVolume> volumeUuidMap, List<VolumeSnapShotInfo> volSnapShotList) {
        ArrayList snapshotVolumeList = new ArrayList();
        HashMap volSnapShotMap = new HashMap();
        volSnapShotList.forEach(snapShot -> CommUtil.addToMap((Map)volSnapShotMap, (String)snapShot.getVolumeId(), (Object)snapShot));
        volumeUuIdSet.forEach(volumeUuId -> {
            String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuId);
            List snapShotInfoList = (List)volSnapShotMap.get(volumeId);
            if (!VerifyUtil.isEmpty((Collection)snapShotInfoList)) {
                String volumeName = volumeId;
                if (volumeUuidMap.containsKey(volumeUuId)) {
                    volumeName = ((OpenStackVolume)volumeUuidMap.get(volumeUuId)).getName();
                }
                snapshotVolumeList.add(volumeName);
                LOGGER.error((Object)"Volume:%s has %s snapshots.", new Object[]{volumeName, snapShotInfoList.size()});
            }
        });
        if (!VerifyUtil.isEmpty(snapshotVolumeList)) {
            LOGGER.error((Object)"Volume:%s has snapshots.", new Object[]{((Object)snapshotVolumeList).toString()});
            throw new LegoCheckedException(1073949701L, new String[]{((Object)snapshotVolumeList).toString()});
        }
    }
}

