/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class CreateLinkedCloneVolumeProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -778169540543462022L;
    private static final Log LOG = LogFactory.getInstance(CreateLinkedCloneVolumeProcessor.class);

    public CreateLinkedCloneVolumeProcessor() {
    }

    public CreateLinkedCloneVolumeProcessor(String drRegionUuid, String drProjUuid, String volSnapShotUuid, String drVolUuid) {
        this.addString("regionUuid", drRegionUuid);
        this.addString("projUuid", drProjUuid);
        this.addString("volSnapShotUuid", volSnapShotUuid);
        this.addString("volUuid", drVolUuid);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into CreateLinkedCloneVolumeProcessor");
        String drRegionUuid = this.getString("regionUuid");
        String drProjUuid = this.getString("projUuid");
        String volSnapShotUuid = this.getString("volSnapShotUuid");
        String drVolUuid = this.getString("volUuid");
        String drVolName = this.getString("volName");
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessNameParams(new String[]{drVolName});
            return true;
        }
        String drVolId = OpenStackCommonUtil.getIdFromUuid(drVolUuid);
        CinderManager cinderMgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        VolumeInfo volInfo = cinderMgr.queryVolume(drRegionUuid, tokenId, drProjUuid, drVolId);
        if (null == volInfo) {
            this.updateProcessNameParams(new String[]{drVolId});
            this.addString("volName", drVolId);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("Volume not in db" + drVolUuid));
            this.updateProcessDetail("lego.err.2117645", null);
            return false;
        }
        this.updateProcessNameParams(new String[]{volInfo.getName()});
        this.addString("volName", volInfo.getName());
        VolumeCreateInfo createVolume = this.generateCreateVolume(drProjUuid, volSnapShotUuid, volInfo);
        try {
            IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
            VolumeInfo linkVolInfo = volService.createVolume(volInfo.getVolumeDriverMetadata(), createVolume, drRegionUuid, drProjUuid, false);
            this.addString("linkedCloneVolId", linkVolInfo.getId());
            this.addString("linkedCloneVolName", linkVolInfo.getName());
            this.addString("bootable", String.valueOf(linkVolInfo.isBootable()));
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            LOG.info((Object)"Leave CreateLinkedCloneVolumeProcessor");
            return true;
        }
        catch (LegoCheckedException e) {
            if (!VerifyUtil.isEmpty((Object[])e.getParameters())) {
                LOG.error((Object)("Create linkedCloneVol failed, volume is already created:" + e.getParameters()[0]));
                this.addString("linkedCloneVolId", e.getParameters()[0]);
            }
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("Create linkedCloneVol failed, volume snapshot id is " + volSnapShotUuid), (Throwable)e);
            this.updateProcessDetail(e);
            return false;
        }
    }

    private VolumeCreateInfo generateCreateVolume(String drProjUuid, String volSnapShotUuid, VolumeInfo volInfo) {
        VolumeCreateInfo createVolume = new VolumeCreateInfo();
        JSONObject metaJson = new JSONObject();
        metaJson.put((Object)"full_clone", (Object)"0");
        createVolume.setMetadata(metaJson);
        createVolume.setSnapShotId(volSnapShotUuid);
        createVolume.setProjectId(drProjUuid);
        createVolume.setShareable(volInfo.getShareable());
        createVolume.setName("Rd_Snap_" + volInfo.getName());
        return createVolume;
    }

    protected String generateResultKey() {
        return null;
    }
}

