/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCleanVmTestNetWorkProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackConfigVmTestNetWorkProcessor;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class OpenStackCleanTestNetWorkProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7994597214295732857L;
    private static final Log LOG = LogFactory.getInstance(OpenStackCleanTestNetWorkProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackCleanTestNetWorkProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        ProtectGroup pg = context.getProtectGroup();
        String instanceId = (String)pg.getProps().get("SERVICEINSTANCE_UUID");
        if (!VerifyUtil.isEmpty((String)instanceId) && !OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            LOG.info((Object)"No need clean newwork because of it's instance.,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            return true;
        }
        this.generateSubProecssors();
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOG.info((Object)"No child processor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        ArrayList subProcessorList = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != this.getProcStatus()) {
            return false;
        }
        LOG.info((Object)"Leave OpenStackCleanTestNetWorkProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        return true;
    }

    private void generateSubProecssors() {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        List createProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()), OpenStackConfigVmTestNetWorkProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            return;
        }
        HashSet<OpenStackCleanVmTestNetWorkProcessor> subProcessors = new HashSet<OpenStackCleanVmTestNetWorkProcessor>();
        for (RecoveryProcessor configVmTestNetWorkProcessor : createProcessors) {
            OpenStackConfigVmTestNetWorkProcessor processor = (OpenStackConfigVmTestNetWorkProcessor)configVmTestNetWorkProcessor;
            String vmUuid = processor.getString("vmUuid");
            String drProjUuid = processor.getString("projUuid");
            String drRegionUuid = processor.getString("regionUuid");
            String testNetWorkUuids = processor.getString("testPortIds");
            String oldNetWorkUuids = processor.getString("oldPortIds");
            String vmName = processor.getString("vmName");
            OpenStackCleanVmTestNetWorkProcessor subProcessor = new OpenStackCleanVmTestNetWorkProcessor(drProjUuid, drRegionUuid, testNetWorkUuids, vmUuid, oldNetWorkUuids, vmName);
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.openstack.recovery.processor.OpenStackCleanTestNetWorkProcessor.des");
    }
}

