/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachOnePortSubProcessor;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPort;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class OpenStackClearOnePortSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6299366195786853993L;
    private static final Log LOG = LogFactory.getInstance(OpenStackDetachOnePortSubProcessor.class);

    public OpenStackClearOnePortSubProcessor() {
        LOG.debug((Object)"OpenStackDetachOnePortSubProcessor defautl constructor");
    }

    public OpenStackClearOnePortSubProcessor(String regionUuid, String projectUuid, String portId, String vmName, String vmUuid) {
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projectUuid);
        this.addString("portId", portId);
        this.addString("vmName", vmName);
        this.addString("vmUuid", vmUuid);
    }

    public void updateProcNameParams() {
        String portName = this.getString("portName");
        if (null == portName) {
            portName = this.getPortName();
        }
        this.updateProcessNameParams(new String[]{portName});
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String regionUuid = this.getString("regionUuid");
        String projectUuid = this.getString("projUuid");
        String vmName = this.getString("vmName");
        String portId = this.getString("portId");
        String vmUuid = this.getString("vmUuid");
        this.updateProcessNameParams(new String[]{this.getPortName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        try {
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
            novaMgr.forceDetachPortFromVM(portId, vmUuid, projectUuid, regionUuid, tokenId, true);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Clear port failed:vmName=" + vmName), (Throwable)e);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private String getPortName() {
        ProtectGroup pg = this.getContextRef().getProtectGroup();
        String regionUuid = (String)pg.getProps().get("drRegionId");
        String projectUuid = (String)pg.getProps().get("drProjectId");
        String portId = this.getString("portId");
        try {
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            INeutronManager neutronMgr = ManagerFactory.getInstance().getNeutronManager(openstackUuid);
            String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
            OpenStackPort port = neutronMgr.getPort(regionUuid, tokenId, portId);
            if (null != port && !VerifyUtil.isEmpty((String)port.getName())) {
                this.addString("portName", port.getName());
                return port.getName();
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Query port failed, portId=%s", new Object[]{portId});
        }
        return portId;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

