/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class OpenStackConfigPhVmToNormalVmSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6050745805347843003L;
    private static final Log LOG = LogFactory.getInstance(OpenStackConfigPhVmToNormalVmSubProcessor.class);

    public OpenStackConfigPhVmToNormalVmSubProcessor() {
    }

    public OpenStackConfigPhVmToNormalVmSubProcessor(String vmUuid, String vmName, String drRegionUuid, String drProjUuid) {
        this.addString("vmUuid", vmUuid);
        this.addString("regionUuid", drRegionUuid);
        this.addString("projUuid", drProjUuid);
        this.addString("vmName", vmName);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into SetPHVmToNormalVmProcessor");
        String vmUuid = this.getString("vmUuid");
        String drRegionUuid = this.getString("regionUuid");
        String drProjUuid = this.getString("projUuid");
        String vmName = this.getString("vmName");
        this.updateProcessNameParams(new String[]{vmName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        if (VerifyUtil.isEmpty((String)vmUuid)) {
            LOG.error((Object)"Placeholder vm isn't setted.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073947393", new String[0]);
            return false;
        }
        NovaManager novaMgr = new NovaManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        try {
            if (this.tryToExecute(vmUuid, drRegionUuid, drProjUuid, novaMgr, tokenId)) {
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            LOG.error((Object)"Set OpenstackVm from placehoder to normal failed");
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave SetPHVmToNormalVmProcessor");
        return true;
    }

    private boolean tryToExecute(String vmUuid, String drRegionUuid, String drProjUuid, NovaManager novaMgr, String tokenId) {
        AsyncTaskResponse response;
        OpenStackVM vm = novaMgr.getVm(drRegionUuid, tokenId, drProjUuid, vmUuid, new int[0]);
        if (null == vm) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("Placeholder vm(" + vmUuid + "doesn't exit."));
            this.updateProcessDetail("lego.err.1073948375", null);
            return true;
        }
        boolean isBmsServer = OpenStackCommonUtil.isBareMetalServer(vm);
        LOG.info((Object)"Config ph vm to normal vm, check if vm is bms: %s", new Object[]{isBmsServer});
        if (!isBmsServer && vm.getStatus().intValue() == OpenstackEnumDefine.VmStatusE.ACTIVE.getValue()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)"Placeholder vm(%s) already started.", new Object[]{vmUuid});
            this.updateProcessDetail("lego.err.1073948907", null);
            return true;
        }
        this.updateVmTag(vmUuid, drRegionUuid, drProjUuid, novaMgr, tokenId);
        if (!isBmsServer && !(response = novaMgr.unlockVm(drRegionUuid, tokenId, drProjUuid, vmUuid)).isSuccess()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
            LOG.error((Object)"Set OpenstackVm from placehoder to normal failed, errorcode is %s", new Object[]{response.getErrorCode()});
            return true;
        }
        return false;
    }

    private void updateVmTag(String vmUuid, String drRegionUuid, String drProjUuid, NovaManager novaMgr, String tokenId) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            try {
                novaMgr.deleteTagFromVm(drRegionUuid, tokenId, drProjUuid, vmUuid, "__type_dr");
                novaMgr.addTagToVm(drRegionUuid, tokenId, drProjUuid, vmUuid, "__type_pd");
            }
            catch (Exception e) {
                LOG.error((Object)("Update tag on vm (" + vmUuid + ") failed."), (Throwable)e);
            }
        }
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

