/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackConfigVmTestNetWorkProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;

public class OpenStackConfigTestNetWorkProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 4750227588753642060L;
    private static final Log LOG = LogFactory.getInstance(OpenStackConfigTestNetWorkProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackSetTestPortProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = OpenStackRecoveryTool.getRegionIdFromCshaCsdrProtectGroup(pg);
        String drProjUuid = OpenStackRecoveryTool.getProjectIdFromCshaCsdrProtectGroup(pg);
        String instanceId = (String)pg.getProps().get("SERVICEINSTANCE_UUID");
        if (!VerifyUtil.isEmpty((String)instanceId) && !OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            LOG.info((Object)"No need config network because of it's instance.,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            return true;
        }
        HashSet<OpenStackConfigVmTestNetWorkProcessor> subProcessors = new HashSet<OpenStackConfigVmTestNetWorkProcessor>();
        for (ProtectObject po : pg.getPolist()) {
            String phVmUuid = OpenStackRecoveryTool.getPhVmUuidFromCshaCsdrProtectGroup(context, pg, po);
            String phVmName = OpenStackRecoveryTool.getPhVmNameFromCshaCsdrProtectGroup(context, pg, po);
            String testNetWorkConfig = this.getTestNetWorkConfig(context, po.getUuid());
            OpenStackConfigVmTestNetWorkProcessor subProcessor = new OpenStackConfigVmTestNetWorkProcessor(drProjUuid, drRegionUuid, phVmUuid, phVmName, testNetWorkConfig);
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        ArrayList subProcessorList = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != this.getProcStatus()) {
            return false;
        }
        LOG.info((Object)"Leave OpenStackSetTestPortProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        return true;
    }

    private String getTestNetWorkConfig(RecoveryProcessorContext context, String poUuid) {
        for (RecoverySetting setting : context.getRecoveryPlan().getRecoverySettings()) {
            if (!"TESTNETWORKCONFIG".equals(setting.getName()) && !"interface_setting".equals(setting.getName()) || !poUuid.equals(setting.getOwnerId())) continue;
            JSONArray netWorkArray = JSONArray.fromObject((Object)setting.getValue());
            return netWorkArray.toString();
        }
        return "";
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.openstack.recovery.processor.OpenStackConfigTestNetWorkProcessor.des");
    }
}

