/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackConfigVmToPhVmSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -1147461967937008521L;
    private static final Log LOG = LogFactory.getInstance(OpenStackConfigVmToPhVmSubProcessor.class);

    public OpenStackConfigVmToPhVmSubProcessor() {
    }

    public OpenStackConfigVmToPhVmSubProcessor(String vmUuid, String vmName, String regionUuid, String projUuid) {
        this.addString("vmUuid", vmUuid);
        this.addString("vmName", vmName);
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projUuid);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackConfigVmToPhVmSubProcessor");
        String vmUuid = this.getString("vmUuid");
        String regionUuid = this.getString("regionUuid");
        String projUuid = this.getString("projUuid");
        String vmName = this.getString("vmName");
        this.updateProcessNameParams(new String[]{vmName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        NovaManager novaMgr = new NovaManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        try {
            AsyncTaskResponse lockResponse;
            OpenStackVM vm = novaMgr.getVm(regionUuid, tokenId, projUuid, vmUuid, new int[0]);
            if (vm == null) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.error((Object)("Vm(" + vmUuid + ") doesn't exit."));
                this.updateProcessDetail("lego.err.1073947394", null);
                return false;
            }
            if (!OpenStackCommonUtil.isBareMetalServer(vm) && !(lockResponse = novaMgr.lockVm(regionUuid, tokenId, projUuid, vmUuid)).isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.error((Object)"Lock vm failed, vmUuid is:%s", new Object[]{vmUuid});
                this.updateProcessDetail("lego.err.1073948108", null);
                return false;
            }
            this.updateVmTag(vmUuid, regionUuid, projUuid, novaMgr, tokenId);
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("Set PhVm failed, vmUuid is: " + this.getString("vmUuid")), (Throwable)e);
            this.updateProcessDetail(e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave OpenStackConfigVmToPhVmSubProcessor");
        return true;
    }

    private void updateVmTag(String vmUuid, String regionUuid, String projUuid, NovaManager novaMgr, String tokenId) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType()) {
            try {
                novaMgr.deleteTagFromVm(regionUuid, tokenId, projUuid, vmUuid, "__type_pd");
                novaMgr.addTagToVm(regionUuid, tokenId, projUuid, vmUuid, "__type_dr");
            }
            catch (Exception e) {
                LOG.error((Object)("Update tag on vm (" + vmUuid + ") failed."), (Throwable)e);
            }
        }
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateProcessName() {
        String processName = ((Object)((Object)this)).getClass().getName();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType()) {
            processName = "com.huawei.ism.drm.openstack.recovery.processor.OpenStackSetPhVm";
        }
        this.setProcName(processName);
    }
}

