/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackActiveVolSnapshotProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateLinkedCloneVolumeSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolCgProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolCgSnapshotProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolSnapshotProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackReserveVolumeProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackUnReserveVolumeProcessor;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OpenStackCreateLinkedCloneVolumeProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 1669329845204345345L;
    private static final Log LOG = LogFactory.getInstance(OpenStackCreateLinkedCloneVolumeProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackCreateLinkedCloneVolume,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr((String)context.getProtectGroup().getProps().get("drProjectId"));
            OpenstackInfo open = ManagerFactory.getInstance().getRegOpenstack(openstackUuid);
            if (null == open) {
                LOG.error((Object)"Openstack not found.");
                throw new LegoCheckedException(1073947394L);
            }
            LOG.info((Object)"Openstack version:%s", new Object[]{open.getVersion()});
            this.generateSubProcessors(open.getVersion());
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (null == recoveryTemplate) {
            LOG.error((Object)"RecoveryTemplate is null.");
            throw new LegoCheckedException(1073947394L);
        }
        recoveryTemplate.process(context);
        LOG.info((Object)"Leave OpenStackCreateLinkedCloneVolume, recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        this.calcProcessResultBySubProc();
        return DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus();
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateLinkedCloneVolumeProcessor.des");
    }

    private void generateSubProcessors(String version) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        HashSet<BaseRecoveryProcessor> subProcessors = new HashSet<BaseRecoveryProcessor>();
        OpenStackUnReserveVolumeProcessor unReserveVolProcessor = new OpenStackUnReserveVolumeProcessor();
        this.initProc((RecoveryProcessor)unReserveVolProcessor);
        subProcessors.add(unReserveVolProcessor);
        OpenStackCreateLinkedCloneVolumeSubProcessor createLinkedCloneVolProcessor = new OpenStackCreateLinkedCloneVolumeSubProcessor(version);
        this.initProc((RecoveryProcessor)createLinkedCloneVolProcessor);
        subProcessors.add(createLinkedCloneVolProcessor);
        OpenStackReserveVolumeProcessor reserveVolProcessor = new OpenStackReserveVolumeProcessor();
        this.initProc((RecoveryProcessor)reserveVolProcessor);
        subProcessors.add(reserveVolProcessor);
        if (VerifyUtil.isEmpty((String)version) || "6.0".equals(version)) {
            OpenStackCreateVolCgProcessor createVolCgProcessor = new OpenStackCreateVolCgProcessor();
            this.initProc((RecoveryProcessor)createVolCgProcessor);
            subProcessors.add(createVolCgProcessor);
            OpenStackCreateVolCgSnapshotProcessor createVolCgSnapShotProcessor = new OpenStackCreateVolCgSnapshotProcessor();
            this.initProc((RecoveryProcessor)createVolCgSnapShotProcessor);
            subProcessors.add(createVolCgSnapShotProcessor);
            unReserveVolProcessor.setNextProcessor((RecoveryProcessor)createVolCgProcessor);
            createVolCgProcessor.setNextProcessor((RecoveryProcessor)createVolCgSnapShotProcessor);
            createVolCgSnapShotProcessor.setNextProcessor((RecoveryProcessor)createLinkedCloneVolProcessor);
            createLinkedCloneVolProcessor.setPreviousProcessor((RecoveryProcessor)createVolCgSnapShotProcessor);
            createVolCgSnapShotProcessor.setPreviousProcessor((RecoveryProcessor)createVolCgProcessor);
            createVolCgProcessor.setPreviousProcessor((RecoveryProcessor)unReserveVolProcessor);
        } else {
            OpenStackCreateVolSnapshotProcessor createVolSnapshotProcessor = new OpenStackCreateVolSnapshotProcessor();
            this.initProc((RecoveryProcessor)createVolSnapshotProcessor);
            subProcessors.add(createVolSnapshotProcessor);
            OpenStackActiveVolSnapshotProcessor activeVolSnapShotProcessor = new OpenStackActiveVolSnapshotProcessor();
            this.initProc((RecoveryProcessor)activeVolSnapShotProcessor);
            subProcessors.add(activeVolSnapShotProcessor);
            unReserveVolProcessor.setNextProcessor((RecoveryProcessor)createVolSnapshotProcessor);
            createVolSnapshotProcessor.setNextProcessor((RecoveryProcessor)activeVolSnapShotProcessor);
            activeVolSnapShotProcessor.setNextProcessor((RecoveryProcessor)createLinkedCloneVolProcessor);
            createLinkedCloneVolProcessor.setPreviousProcessor((RecoveryProcessor)activeVolSnapShotProcessor);
            activeVolSnapShotProcessor.setPreviousProcessor((RecoveryProcessor)createVolSnapshotProcessor);
            createVolSnapshotProcessor.setPreviousProcessor((RecoveryProcessor)unReserveVolProcessor);
        }
        createLinkedCloneVolProcessor.setNextProcessor((RecoveryProcessor)reserveVolProcessor);
        reserveVolProcessor.setPreviousProcessor((RecoveryProcessor)createLinkedCloneVolProcessor);
        reserveVolProcessor.setNextProcessor(null);
        unReserveVolProcessor.setPreviousProcessor(null);
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }
}

