/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.CreateLinkedCloneVolumeProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolCgSnapshotProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolSnapshotProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapShotInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenStackCreateLinkedCloneVolumeSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -2154428928071112146L;
    private static final Log LOG = LogFactory.getInstance(OpenStackCreateLinkedCloneVolumeSubProcessor.class);

    public OpenStackCreateLinkedCloneVolumeSubProcessor() {
    }

    public OpenStackCreateLinkedCloneVolumeSubProcessor(String openstackVersion) {
        this.addString("openstackVersion", openstackVersion);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackCreateLinkedCloneVolumeSubProcessor");
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = OpenStackRecoveryTool.getRegionIdFromCshaCsdrProtectGroup(pg);
        String drProjUuid = OpenStackRecoveryTool.getProjectIdFromCshaCsdrProtectGroup(pg);
        String openStackId = drRegionUuid.split(":")[0];
        String version = this.getString("openstackVersion");
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        if ("6.1".equals(version)) {
            OpenStackCreateVolSnapshotProcessor createVolSnapshotProcessor = (OpenStackCreateVolSnapshotProcessor)this.getPreviousProcessor().getPreviousProcessor();
            if (!VerifyUtil.isEmpty((Object)((Object)createVolSnapshotProcessor)) && null != createVolSnapshotProcessor.getChildProc()) {
                LOG.info((Object)"Snapshots size:%s", new Object[]{String.valueOf(createVolSnapshotProcessor.getChildProc().size())});
                for (RecoveryProcessor subProcessor : createVolSnapshotProcessor.getChildProc()) {
                    String snapshotId = subProcessor.getString("volSnapShotUuid");
                    String volUuid = subProcessor.getString("volUuid");
                    CreateLinkedCloneVolumeProcessor processor = new CreateLinkedCloneVolumeProcessor(drRegionUuid, drProjUuid, snapshotId, volUuid);
                    this.initProc((RecoveryProcessor)processor);
                    subProcessors.add((RecoveryProcessor)processor);
                }
            }
        } else {
            this.executeWhenVersionLowerThan61(drRegionUuid, drProjUuid, openStackId, subProcessors);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        ArrayList subProcessorList = new ArrayList(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != this.getProcStatus()) {
            return false;
        }
        LOG.info((Object)"Leave OpenStackCreateLinkedCloneVolumeSubProcessor");
        return true;
    }

    private void executeWhenVersionLowerThan61(String drRegionUuid, String drProjUuid, String openStackId, Set<RecoveryProcessor> subProcessors) {
        CinderManager cinderMgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
        HashMap<String, String> filterProp = new HashMap<String, String>();
        OpenStackCreateVolCgSnapshotProcessor createVolCgSnapshotProcessor = (OpenStackCreateVolCgSnapshotProcessor)this.getPreviousProcessor();
        filterProp.put("cgsnapshot_id", createVolCgSnapshotProcessor.getString("volCgSnapShotId"));
        LOG.info((Object)"Cgsnapshot_id is:%s", new Object[]{createVolCgSnapshotProcessor.getString("volCgSnapShotId")});
        List<VolumeSnapShotInfo> volSnapShots = cinderMgr.queryVolumeSnapShots(drRegionUuid, tokenId, drProjUuid, filterProp);
        for (VolumeSnapShotInfo volSnapShot : volSnapShots) {
            CreateLinkedCloneVolumeProcessor subProcessor = new CreateLinkedCloneVolumeProcessor(drRegionUuid, drProjUuid, volSnapShot.getId(), openStackId + ":" + volSnapShot.getVolumeId());
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add((RecoveryProcessor)subProcessor);
        }
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

