/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolCgProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgSnapShotCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgSnapShotInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackCreateVolCgSnapshotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -349245366211801342L;
    private static final Log LOG = LogFactory.getInstance(OpenStackCreateVolCgSnapshotProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackCreateVolRepCgSnapshotProcessor");
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = OpenStackRecoveryTool.getRegionIdFromCshaCsdrProtectGroup(pg);
        String drProjUuid = OpenStackRecoveryTool.getProjectIdFromCshaCsdrProtectGroup(pg);
        this.addString("regionUuid", drRegionUuid);
        this.addString("projUuid", drProjUuid);
        try {
            String volCgId = this.getVolCgIdFromProcessor();
            CinderManager cinderMgr = new CinderManager();
            String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
            AsyncTaskResponse response = this.createVolCgSnapShot(drRegionUuid, drProjUuid, cinderMgr, tokenId, volCgId);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.error((Object)("Create volCgSnapShot failed." + response.getErrorCode()));
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("Create volCgSnapShot failed." + (Object)((Object)e)));
            this.updateProcessDetail(e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave OpenStackCreateVolRepCgSnapshotProcessor");
        return true;
    }

    private String getVolCgIdFromProcessor() {
        OpenStackCreateVolCgProcessor processor = (OpenStackCreateVolCgProcessor)this.getPreviousProcessor();
        return processor.getString("volCgUuid");
    }

    private AsyncTaskResponse createVolCgSnapShot(String drRegionUuid, String drProjUuid, CinderManager cinderMgr, String tokenId, String volCgId) {
        VolumeCgSnapShotCreateInfo createCgInfo = new VolumeCgSnapShotCreateInfo(volCgId);
        AsyncTaskResponse response = cinderMgr.createVolCgSnapShot(createCgInfo, drRegionUuid, tokenId, drProjUuid);
        if (response.getTaskResult() != null && response.getTaskResult() instanceof VolumeCgSnapShotInfo) {
            VolumeCgSnapShotInfo volRepSnapShot = (VolumeCgSnapShotInfo)response.getTaskResult();
            this.addString("volCgSnapShotId", volRepSnapShot.getId());
        }
        return response;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

