/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.msg.CreateVolumeSnapShotInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapShotInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;

public class OpenStackCreateVolSnapshotSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 565923070721728856L;
    private static final Log LOG = LogFactory.getInstance(OpenStackCreateVolSnapshotSubProcessor.class);

    public OpenStackCreateVolSnapshotSubProcessor() {
    }

    public OpenStackCreateVolSnapshotSubProcessor(String regionUuid, String projUuid, String volUuid, String volName) {
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projUuid);
        this.addString("volUuid", volUuid);
        this.addString("volName", volName);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOG.info((Object)"Enter into OpenStackCreateVolSnapshotSubProcessor");
        this.updateProcessNameParams(new String[]{this.getString("volName")});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        String drRegionUuid = this.getString("regionUuid");
        String drProjUuid = this.getString("projUuid");
        String drVolUuid = this.getString("volUuid");
        try {
            String tokenId = TokenUtil.getInstance().getRegionTokenId(drRegionUuid, drProjUuid);
            AsyncTaskResponse response = this.createVolSnapShot(drRegionUuid, drProjUuid, tokenId, drVolUuid);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                LOG.error((Object)("Create volSnapShot failed. volId: " + drVolUuid));
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            LOG.error((Object)("Create volSnapShot failed." + (Object)((Object)e)));
            this.updateProcessDetail(e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOG.info((Object)"Leave OpenStackCreateVolSnapshotSubProcessor");
        return true;
    }

    private AsyncTaskResponse createVolSnapShot(String drRegionUuid, String drProjUuid, String tokenId, String volUuid) {
        CinderManager cinderMgr = new CinderManager();
        CreateVolumeSnapShotInfo createCgInfo = new CreateVolumeSnapShotInfo();
        createCgInfo.setForce(Boolean.valueOf(true));
        String volId = OpenStackCommonUtil.getIdFromUuid(volUuid);
        createCgInfo.setVolumeId(volId);
        JSONObject metadata = new JSONObject();
        metadata.put((Object)"__system__enableActive", (Object)"false");
        createCgInfo.setMetadata(metadata);
        createCgInfo.setName("dr_snapshot_csdr_" + volId);
        LOG.info((Object)"Start create volume snapshot, volumeId:%s", new Object[]{volId});
        AsyncTaskResponse response = cinderMgr.createVolSnapshot(drRegionUuid, drProjUuid, tokenId, createCgInfo);
        if (response.getTaskResult() != null && response.getTaskResult() instanceof VolumeSnapShotInfo) {
            VolumeSnapShotInfo volSnapShot = (VolumeSnapShotInfo)response.getTaskResult();
            LOG.info((Object)"Create volume snapshot, volSnapShotId:%s", new Object[]{volSnapShot.getId()});
            this.addString("volSnapShotUuid", volSnapShot.getId());
            this.addString("volUuid", volUuid);
            this.addString("providerAuth", volSnapShot.getProviderAuth());
        }
        return response;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

