/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackAttachPortProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackClearPortProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachPortSubProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenStackReattachPortProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6717845830095338632L;
    private static final Log LOG = LogFactory.getInstance(OpenStackReattachPortProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessors();
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOG.debug((Object)"No ports need to reattach", 90160758786816L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()));
        executor.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void generateSubProcessors() {
        List detachPortSubProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()), OpenStackDetachPortSubProcessor.class);
        if (VerifyUtil.isEmpty((Collection)detachPortSubProcessors)) {
            LOG.info((Object)"End execute generateSubProcessors, cause detachPortSubProcessors is empty.");
            return;
        }
        HashSet<BaseRecoveryProcessor> subProcessors = new HashSet<BaseRecoveryProcessor>();
        OpenStackClearPortProcessor clearPortProcessor = new OpenStackClearPortProcessor();
        clearPortProcessor.setContextRef(this.getContextRef());
        this.initProc((RecoveryProcessor)clearPortProcessor);
        subProcessors.add(clearPortProcessor);
        OpenStackAttachPortProcessor attachPortProcessor = new OpenStackAttachPortProcessor();
        attachPortProcessor.setContextRef(this.getContextRef());
        this.initProc((RecoveryProcessor)attachPortProcessor);
        subProcessors.add(attachPortProcessor);
        clearPortProcessor.setPreviousProcessor(null);
        clearPortProcessor.setNextProcessor((RecoveryProcessor)attachPortProcessor);
        attachPortProcessor.setPreviousProcessor((RecoveryProcessor)clearPortProcessor);
        attachPortProcessor.setNextProcessor(null);
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected boolean calcProcessResultBySubProc() {
        LOG.debug((Object)"CalcProcessResultBySubProc start");
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

